/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.util.GridLongList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartitionTxUpdateCounterImpl
implements PartitionUpdateCounter {
    public static final int MAX_MISSED_UPDATES = 10000;
    private static final byte VERSION = 1;
    private TreeSet<Item> queue = new TreeSet();
    private final AtomicLong cntr = new AtomicLong();
    protected final AtomicLong reserveCntr = new AtomicLong();
    private boolean first = true;
    @Deprecated
    private long initCntr;

    @Override
    public void init(long initUpdCntr, @Nullable byte[] cntrUpdData) {
        this.cntr.set(initUpdCntr);
        this.initCntr = initUpdCntr;
        this.reserveCntr.set(this.initCntr);
        this.queue = this.fromBytes(cntrUpdData);
    }

    @Override
    public long initial() {
        return this.initCntr;
    }

    @Override
    public long get() {
        return this.cntr.get();
    }

    protected synchronized long highestAppliedCounter() {
        return this.queue.isEmpty() ? this.cntr.get() : this.queue.last().absolute();
    }

    @Override
    public long next() {
        long next = this.cntr.incrementAndGet();
        this.reserveCntr.set(next);
        return next;
    }

    @Override
    public synchronized void update(long val) throws IgniteCheckedException {
        long cur = this.get();
        long max = Math.max(val, cur);
        if (this.reserveCntr.get() < max) {
            this.reserveCntr.set(max);
        }
        if (val < cur) {
            return;
        }
        if (val < this.highestAppliedCounter()) {
            throw new IgniteCheckedException("Failed to update the counter [newVal=" + val + ", curState=" + this + ']');
        }
        this.cntr.set(val);
        if (this.first) {
            if (!this.queue.isEmpty()) {
                this.queue.clear();
            }
            this.first = false;
        }
    }

    @Override
    public synchronized boolean update(long start, long delta) {
        long cur = this.cntr.get();
        if (cur > start) {
            return false;
        }
        if (cur < start) {
            Item item;
            Item tmp;
            Item ref = tmp = new Item(start, delta);
            NavigableSet<Item> set = this.queue.headSet(tmp, false);
            if (!set.isEmpty()) {
                Item last = (Item)set.last();
                if (last.start + last.delta == start) {
                    tmp = last;
                    item = last;
                    item.delta = item.delta + delta;
                } else if (last.within(start) && last.within(start + delta - 1L)) {
                    return false;
                }
            }
            if (!(set = this.queue.tailSet(tmp, false)).isEmpty()) {
                Item first = (Item)set.first();
                if (tmp.start + tmp.delta == first.start) {
                    if (ref != tmp) {
                        item = tmp;
                        item.delta = item.delta + first.delta;
                        set.pollFirst();
                    } else {
                        tmp = first;
                        first.start = start;
                        item = first;
                        item.delta = item.delta + delta;
                    }
                }
            }
            if (tmp != ref) {
                return true;
            }
            return this.offer(new Item(start, delta));
        }
        while (true) {
            long next = start + delta;
            boolean res = this.cntr.compareAndSet(cur, next);
            assert (res);
            Item peek = this.peek();
            if (peek == null || peek.start != next) {
                return true;
            }
            Item item = this.poll();
            assert (peek == item);
            start = item.start;
            delta = item.delta;
            cur = next;
        }
    }

    @Override
    public void updateInitial(long start, long delta) {
        this.update(start, delta);
        this.initCntr = this.get();
        if (this.reserveCntr.get() < this.initCntr) {
            this.reserveCntr.set(this.initCntr);
        }
    }

    private Item poll() {
        return this.queue.pollFirst();
    }

    private Item peek() {
        return this.queue.isEmpty() ? null : this.queue.first();
    }

    private boolean offer(Item item) {
        if (this.queue.size() == 10000) {
            throw new IgniteException("Too many gaps [cntr=" + this + ']');
        }
        return this.queue.add(item);
    }

    @Override
    public synchronized GridLongList finalizeUpdateCounters() {
        Item item = this.poll();
        GridLongList gaps = null;
        while (item != null) {
            if (gaps == null) {
                gaps = new GridLongList((this.queue.size() + 1) * 2);
            }
            long start = this.cntr.get() + 1L;
            long end = item.start;
            gaps.add(start);
            gaps.add(end);
            this.cntr.set(item.start + item.delta);
            item = this.poll();
        }
        this.reserveCntr.set(this.get());
        return gaps;
    }

    @Override
    public synchronized long reserve(long delta) {
        long cntr = this.get();
        long reserved = this.reserveCntr.getAndAdd(delta);
        assert (reserved >= cntr) : "LWM after HWM: lwm=" + cntr + ", hwm=" + reserved;
        return reserved;
    }

    @Override
    public long next(long delta) {
        return this.cntr.getAndAdd(delta);
    }

    @Override
    public synchronized boolean sequential() {
        return this.gaps().isEmpty();
    }

    @Override
    @Nullable
    public synchronized byte[] getBytes() {
        if (this.queue.isEmpty()) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(1);
            int size = this.queue.size();
            dos.writeInt(size);
            for (Item item : this.queue) {
                dos.writeLong(item.start);
                dos.writeLong(item.delta);
            }
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    @Nullable
    private TreeSet<Item> fromBytes(@Nullable byte[] raw) {
        if (raw == null) {
            return new TreeSet<Item>();
        }
        TreeSet<Item> ret = new TreeSet<Item>();
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(raw);
            DataInputStream dis = new DataInputStream(bis);
            dis.readByte();
            int cnt = dis.readInt();
            while (cnt-- > 0) {
                ret.add(new Item(dis.readLong(), dis.readLong()));
            }
            return ret;
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private TreeSet<Item> gaps() {
        return this.queue;
    }

    @Override
    public synchronized void reset() {
        this.cntr.set(0L);
        this.reserveCntr.set(0L);
        this.queue = new TreeSet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionTxUpdateCounterImpl cntr = (PartitionTxUpdateCounterImpl)o;
        if (!this.queue.equals(cntr.queue)) {
            return false;
        }
        return this.cntr.get() == cntr.cntr.get();
    }

    @Override
    public long reserved() {
        return this.reserveCntr.get();
    }

    @Override
    public synchronized boolean empty() {
        return this.get() == 0L && this.sequential();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator<long[]> iterator() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "Counter [lwm=" + this.get() + ", holes=" + this.queue + ", maxApplied=" + this.highestAppliedCounter() + ", hwm=" + this.reserveCntr.get() + ']';
    }

    private static class Item
    implements Comparable<Item> {
        private long start;
        private long delta;

        private Item(long start, long delta) {
            this.start = start;
            this.delta = delta;
        }

        @Override
        public int compareTo(@NotNull Item o) {
            return Long.compare(this.start, o.start);
        }

        public String toString() {
            return "Item [start=" + this.start + ", delta=" + this.delta + ']';
        }

        public long start() {
            return this.start;
        }

        public long delta() {
            return this.delta;
        }

        public long absolute() {
            return this.start + this.delta;
        }

        public boolean within(long cntr) {
            return cntr - this.start < this.delta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.start != item.start) {
                return false;
            }
            return this.delta != item.delta;
        }
    }
}

