/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.UnregisteredClassException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEvictableEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.EntryGetWithTtlResult;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheAtomicVersionComparator;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheMvccEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateAtomicResult;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.ReaderArguments;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryListener;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateResult;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.ResultType;
import org.apache.ignite.internal.processors.cache.version.GridCacheLazyPlainVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheFilter;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.transactions.IgniteTxDuplicateKeyCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxSerializationCheckedException;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheMapEntry
extends GridMetadataAwareAdapter
implements GridCacheEntryEx {
    private static final byte IS_DELETED_MASK = 1;
    private static final byte IS_UNSWAPPED_MASK = 2;
    private static final byte IS_EVICT_DISABLED = 4;
    public static final GridCacheAtomicVersionComparator ATOMIC_VER_COMPARATOR = new GridCacheAtomicVersionComparator();
    private static final int SIZE_OVERHEAD = 137;
    protected static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static volatile IgniteLogger log;
    @GridToStringExclude
    protected final GridCacheContext<?, ?> cctx;
    @GridToStringInclude
    protected final KeyCacheObject key;
    @GridToStringInclude
    protected CacheObject val;
    @GridToStringInclude
    protected GridCacheVersion ver;
    @GridToStringInclude
    private final int hash;
    @GridToStringInclude
    private GridCacheEntryExtras extras;
    @GridToStringExclude
    private final ReentrantLock lock = new ReentrantLock();
    @GridToStringExclude
    private final ReadWriteLock listenerLock;
    @GridToStringInclude
    protected byte flags;

    protected GridCacheMapEntry(GridCacheContext<?, ?> cctx, KeyCacheObject key) {
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridCacheMapEntry.class);
        }
        key = (KeyCacheObject)cctx.kernalContext().cacheObjects().prepareForCache(key, cctx);
        assert (key != null);
        this.key = key;
        this.hash = key.hashCode();
        this.cctx = cctx;
        this.listenerLock = cctx.group().listenerLock();
        this.ver = cctx.shared().versions().startVersion();
    }

    protected void value(@Nullable CacheObject val) {
        assert (this.lock.isHeldByCurrentThread());
        this.val = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int memorySize() throws IgniteCheckedException {
        int extrasSize;
        byte[] kb;
        byte[] vb = null;
        this.lockEntry();
        try {
            this.key.prepareMarshal(this.cctx.cacheObjectContext());
            kb = this.key.valueBytes(this.cctx.cacheObjectContext());
            if (this.val != null) {
                this.val.prepareMarshal(this.cctx.cacheObjectContext());
                vb = this.val.valueBytes(this.cctx.cacheObjectContext());
            }
            extrasSize = this.extrasSize();
        }
        finally {
            this.unlockEntry();
        }
        return 137 + extrasSize + kb.length + (vb == null ? 1 : vb.length);
    }

    @Override
    public boolean isInternal() {
        return this.key.internal();
    }

    @Override
    public boolean isDht() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMvcc() {
        return this.cctx.mvccEnabled();
    }

    @Override
    public boolean isNear() {
        return false;
    }

    @Override
    public boolean isReplicated() {
        return false;
    }

    @Override
    public boolean detached() {
        return false;
    }

    @Override
    public <K, V> GridCacheContext<K, V> context() {
        return this.cctx;
    }

    @Override
    public boolean isNew() throws GridCacheEntryRemovedException {
        assert (this.lock.isHeldByCurrentThread());
        this.checkObsolete();
        return this.isStartVersion();
    }

    @Override
    public boolean isNewLocked() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            boolean bl = this.isStartVersion();
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    public boolean isStartVersion() {
        return this.cctx.shared().versions().isStartVersion(this.ver);
    }

    @Override
    public boolean valid(AffinityTopologyVersion topVer) {
        return true;
    }

    @Override
    public int partition() {
        return 0;
    }

    protected GridDhtLocalPartition localPartition() {
        return null;
    }

    @Override
    public boolean partitionValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GridCacheEntryInfo info() {
        GridCacheEntryInfo info = null;
        this.lockEntry();
        try {
            if (!this.obsolete()) {
                info = new GridCacheEntryInfo();
                info.key(this.key);
                info.cacheId(this.cctx.cacheId());
                long expireTime = this.expireTimeExtras();
                boolean expired = expireTime != 0L && expireTime <= U.currentTimeMillis();
                info.ttl(this.ttlExtras());
                info.expireTime(expireTime);
                info.version(this.ver);
                info.setNew(this.isStartVersion());
                info.setDeleted(this.deletedUnlocked());
                if (!expired) {
                    info.value(this.val);
                }
            }
        }
        finally {
            this.unlockEntry();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<GridCacheEntryInfo> allVersionsInfo() throws IgniteCheckedException {
        assert (this.cctx.mvccEnabled());
        this.lockEntry();
        try {
            if (this.obsolete()) {
                List<GridCacheEntryInfo> list = Collections.emptyList();
                return list;
            }
            GridCursor<CacheDataRow> cur = this.cctx.offheap().dataStore(this.localPartition()).mvccAllVersionsCursor(this.cctx, this.key, (Object)CacheDataRowAdapter.RowData.NO_KEY);
            ArrayList<GridCacheEntryInfo> res = new ArrayList<GridCacheEntryInfo>();
            while (cur.next()) {
                long expireTime;
                long ttl;
                byte newTxState;
                byte txState;
                CacheDataRow row = cur.get();
                GridCacheMvccEntryInfo info = new GridCacheMvccEntryInfo();
                info.key(this.key);
                info.value(row.value());
                info.cacheId(this.cctx.cacheId());
                info.version(row.version());
                info.setNew(false);
                info.setDeleted(false);
                byte by = txState = row.mvccTxState() != 0 ? row.mvccTxState() : MvccUtils.state(this.cctx, row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter());
                if (txState == 2) continue;
                info.mvccVersion(row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter());
                info.mvccTxState(txState);
                byte by2 = newTxState = row.newMvccTxState() != 0 ? row.newMvccTxState() : MvccUtils.state(this.cctx, row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter());
                if (newTxState != 2) {
                    info.newMvccVersion(row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter());
                    info.newMvccTxState(newTxState);
                }
                long l = ttl = (expireTime = row.expireTime()) == 0L ? 0L : expireTime - U.currentTimeMillis();
                if (ttl < 0L) {
                    ttl = 1L;
                }
                info.ttl(ttl);
                info.expireTime(expireTime);
                res.add(info);
            }
            ArrayList<GridCacheEntryInfo> arrayList = res;
            return arrayList;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public final CacheObject unswap() throws IgniteCheckedException, GridCacheEntryRemovedException {
        return this.unswap(true);
    }

    @Override
    public final CacheObject unswap(CacheDataRow row) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return (row = this.unswap(row, true)) != null ? row.value() : null;
    }

    @Override
    @Nullable
    public final CacheObject unswap(boolean needVal) throws IgniteCheckedException, GridCacheEntryRemovedException {
        CacheDataRow row = this.unswap(null, true);
        return row != null ? row.value() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected CacheDataRow unswap(@Nullable CacheDataRow row, boolean checkExpire) throws IgniteCheckedException, GridCacheEntryRemovedException {
        boolean obsolete = false;
        boolean deferred = false;
        GridCacheVersion ver0 = null;
        this.cctx.shared().database().checkpointReadLock();
        this.lockEntry();
        try {
            this.checkObsolete();
            if (this.isStartVersion() && (this.flags & 2) == 0) {
                assert (row == null || row.key() == this.key) : "Unexpected row key";
                CacheDataRow read = row == null ? this.cctx.offheap().read(this) : row;
                this.flags = (byte)(this.flags | 2);
                if (read != null) {
                    CacheObject val = read.value();
                    this.update(val, read.expireTime(), 0L, read.version(), false);
                    if (!checkExpire || read.expireTime() <= 0L || read.expireTime() > U.currentTimeMillis()) {
                        CacheDataRow cacheDataRow = read;
                        return cacheDataRow;
                    }
                    if (this.onExpired(this.val, null)) {
                        if (this.cctx.deferredDelete()) {
                            deferred = true;
                            ver0 = this.ver;
                        } else {
                            obsolete = true;
                        }
                    }
                }
            }
        }
        finally {
            this.unlockEntry();
            this.cctx.shared().database().checkpointReadUnlock();
        }
        if (obsolete) {
            this.onMarkedObsolete();
            this.cctx.cache().removeEntry(this);
        }
        if (deferred) {
            assert (ver0 != null);
            this.cctx.onDeferredDelete(this, ver0);
        }
        return null;
    }

    protected IgniteBiTuple<byte[], Byte> valueBytes0() {
        assert (this.lock.isHeldByCurrentThread());
        assert (this.val != null);
        try {
            byte[] bytes = this.val.valueBytes(this.cctx.cacheObjectContext());
            return new IgniteBiTuple<byte[], Byte>(bytes, this.val.cacheObjectType());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Nullable
    protected Object readThrough(@Nullable IgniteInternalTx tx, KeyCacheObject key, boolean reload, UUID subjId, String taskName) throws IgniteCheckedException {
        return this.cctx.store().load(tx, key);
    }

    @Override
    public final CacheObject innerGet(@Nullable GridCacheVersion ver, @Nullable IgniteInternalTx tx, boolean readThrough, boolean updateMetrics, boolean evt, UUID subjId, Object transformClo, String taskName, @Nullable IgniteCacheExpiryPolicy expirePlc, boolean keepBinary) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return (CacheObject)this.innerGet0(ver, tx, readThrough, evt, updateMetrics, subjId, transformClo, taskName, expirePlc, false, keepBinary, false, null);
    }

    @Override
    public EntryGetResult innerGetAndReserveForLoad(boolean updateMetrics, boolean evt, UUID subjId, String taskName, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean keepBinary, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return (EntryGetResult)this.innerGet0(null, null, false, evt, updateMetrics, subjId, null, taskName, expiryPlc, true, keepBinary, true, readerArgs);
    }

    @Override
    public EntryGetResult innerGetVersioned(@Nullable GridCacheVersion ver, IgniteInternalTx tx, boolean updateMetrics, boolean evt, UUID subjId, Object transformClo, String taskName, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean keepBinary, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return (EntryGetResult)this.innerGet0(ver, tx, false, evt, updateMetrics, subjId, transformClo, taskName, expiryPlc, true, keepBinary, false, readerArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object innerGet0(GridCacheVersion nextVer, IgniteInternalTx tx, boolean readThrough, boolean evt, boolean updateMetrics, UUID subjId, Object transformClo, String taskName, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean retVer, boolean keepBinary, boolean reserveForLoad, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        GridCacheVersion startVer;
        assert (!retVer || !readThrough);
        assert (!reserveForLoad || !readThrough);
        if (readThrough && !this.cctx.readThrough()) {
            readThrough = false;
        }
        GridCacheVersion resVer = null;
        boolean obsolete = false;
        boolean deferred = false;
        GridCacheVersion ver0 = null;
        Object res = null;
        this.lockEntry();
        try {
            CacheObject ret;
            CacheObject val;
            this.checkObsolete();
            boolean valid = this.valid(tx != null ? tx.topologyVersion() : this.cctx.affinity().affinityTopologyVersion());
            if (valid) {
                long expireTime;
                val = this.val;
                if (val == null && this.isStartVersion()) {
                    this.unswap(null, false);
                    val = this.val;
                }
                if (val != null && (expireTime = this.expireTimeExtras()) > 0L && expireTime < U.currentTimeMillis() && this.onExpired((CacheObject)this.cctx.unwrapTemporary(val), null)) {
                    val = null;
                    evt = false;
                    if (this.cctx.deferredDelete()) {
                        deferred = true;
                        ver0 = this.ver;
                    } else {
                        obsolete = true;
                    }
                }
            } else {
                val = null;
            }
            if ((ret = val) == null) {
                if (updateMetrics && this.cctx.statisticsEnabled()) {
                    this.cctx.cache().metrics0().onRead(false);
                }
            } else if (updateMetrics && this.cctx.statisticsEnabled()) {
                this.cctx.cache().metrics0().onRead(true);
            }
            if (evt && this.cctx.events().isRecordable(64)) {
                transformClo = EntryProcessorResourceInjectorProxy.unwrap(transformClo);
                GridCacheMvcc mvcc = this.mvccExtras();
                this.cctx.events().addEvent(this.partition(), this.key, tx, mvcc != null ? mvcc.anyOwner() : null, 64, ret, ret != null, ret, ret != null, subjId, transformClo != null ? transformClo.getClass().getName() : null, taskName, keepBinary);
                evt = false;
            }
            if (ret != null && expiryPlc != null) {
                this.updateTtl(expiryPlc);
            }
            if (retVer && resVer == null) {
                GridCacheVersion gridCacheVersion = resVer = this.isNear() && this.cctx.transactional() ? ((GridNearCacheEntry)this).dhtVersion() : this.ver;
                if (resVer == null) {
                    ret = null;
                }
            }
            startVer = this.ver;
            this.addReaderIfNeed(readerArgs);
            if (ret != null) {
                assert (!obsolete);
                assert (!deferred);
                res = retVer ? this.entryGetResult(ret, resVer, false) : ret;
            } else if (reserveForLoad && !obsolete) {
                boolean reserve;
                assert (!readThrough);
                assert (retVer);
                boolean bl = reserve = !this.evictionDisabled();
                if (reserve) {
                    this.flags = (byte)(this.flags | 4);
                }
                res = this.entryGetResult(null, resVer, reserve);
            }
        }
        finally {
            this.unlockEntry();
        }
        if (obsolete) {
            this.onMarkedObsolete();
            throw new GridCacheEntryRemovedException();
        }
        if (deferred) {
            this.cctx.onDeferredDelete(this, ver0);
        }
        if (res != null) {
            return res;
        }
        CacheObject ret = null;
        if (readThrough) {
            IgniteInternalTx tx0 = null;
            if (tx != null && tx.local()) {
                if (this.cctx.isReplicated() || this.cctx.isColocated() || tx.near()) {
                    tx0 = tx;
                } else if (tx.dht()) {
                    GridCacheVersion ver = tx.nearXidVersion();
                    tx0 = this.cctx.dht().near().context().tm().tx(ver);
                }
            }
            Object storeVal = this.readThrough(tx0, this.key, false, subjId, taskName);
            ret = this.cctx.toCacheObject(storeVal);
        }
        if (ret == null && !evt) {
            return null;
        }
        this.lockEntry();
        try {
            long ttl = this.ttlExtras();
            if (startVer.equals(this.ver)) {
                if (ret != null) {
                    ret = this.cctx.kernalContext().cacheObjects().prepareForCache(ret, this.cctx);
                    nextVer = nextVer != null ? nextVer : this.nextVersion();
                    long expTime = CU.toExpireTime(ttl);
                    this.storeValue(ret, expTime, nextVer);
                    this.update(ret, expTime, ttl, nextVer, true);
                    if (this.cctx.deferredDelete() && this.deletedUnlocked() && !this.isInternal() && !this.detached()) {
                        this.deletedUnlocked(false);
                    }
                    assert (readerArgs == null);
                }
                if (evt && this.cctx.events().isRecordable(64)) {
                    transformClo = EntryProcessorResourceInjectorProxy.unwrap(transformClo);
                    GridCacheMvcc mvcc = this.mvccExtras();
                    this.cctx.events().addEvent(this.partition(), this.key, tx, mvcc != null ? mvcc.anyOwner() : null, 64, ret, ret != null, null, false, subjId, transformClo != null ? transformClo.getClass().getName() : null, taskName, keepBinary);
                }
            }
        }
        finally {
            this.unlockEntry();
        }
        assert (ret == null || !retVer);
        return ret;
    }

    private EntryGetResult entryGetResult(CacheObject val, GridCacheVersion ver, boolean reserve) {
        return this.extras == null || this.extras.expireTime() == 0L ? new EntryGetResult(val, ver, reserve) : new EntryGetWithTtlResult(val, ver, reserve, this.rawExpireTime(), this.rawTtl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final CacheObject innerReload() throws IgniteCheckedException, GridCacheEntryRemovedException {
        boolean wasNew;
        GridCacheVersion startVer;
        CU.checkStore(this.cctx);
        this.lockEntry();
        try {
            this.checkObsolete();
            startVer = this.ver;
            wasNew = this.isNew();
        }
        finally {
            this.unlockEntry();
        }
        String taskName = this.cctx.kernalContext().job().currentTaskName();
        CacheObject ret = this.cctx.toCacheObject(this.readThrough(null, this.key, true, this.cctx.localNodeId(), taskName));
        boolean touch = false;
        try {
            block21: {
                this.ensureFreeSpace();
                this.lockEntry();
                long ttl = this.ttlExtras();
                GridCacheVersion nextVer = this.cctx.versions().nextForLoad(this.ver);
                if (wasNew && !this.isNew()) {
                    CacheObject cacheObject = ret;
                    return cacheObject;
                }
                if (!startVer.equals(this.ver)) break block21;
                long expTime = CU.toExpireTime(ttl);
                ret = this.cctx.kernalContext().cacheObjects().prepareForCache(ret, this.cctx);
                if (ret != null) {
                    this.storeValue(ret, expTime, nextVer);
                    if (this.cctx.deferredDelete() && !this.isInternal() && !this.detached() && this.deletedUnlocked()) {
                        this.deletedUnlocked(false);
                    }
                } else {
                    if (this.cctx.mvccEnabled()) {
                        this.cctx.offheap().mvccRemoveAll(this);
                    } else {
                        this.removeValue();
                    }
                    if (this.cctx.deferredDelete() && !this.isInternal() && !this.detached() && !this.deletedUnlocked()) {
                        this.deletedUnlocked(true);
                    }
                }
                this.update(ret, expTime, ttl, nextVer, true);
                touch = true;
                CacheObject cacheObject = ret;
                return cacheObject;
                finally {
                    this.unlockEntry();
                }
            }
            touch = true;
            CacheObject cacheObject = ret;
            return cacheObject;
        }
        finally {
            if (touch) {
                this.touch();
            }
        }
    }

    protected void recordNodeId(UUID nodeId, AffinityTopologyVersion topVer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCacheUpdateTxResult mvccSet(IgniteInternalTx tx, UUID affNodeId, CacheObject val, EntryProcessor entryProc, Object[] invokeArgs, long ttl0, AffinityTopologyVersion topVer, MvccSnapshot mvccVer, GridCacheOperation op, boolean needHistory, boolean noCreate, boolean needOldVal, CacheEntryPredicate filter, boolean retVal, boolean keepBinary) throws IgniteCheckedException, GridCacheEntryRemovedException {
        GridCacheUpdateTxResult updRes;
        MvccUpdateResult res;
        assert (tx != null);
        boolean valid = this.valid(tx.topologyVersion());
        boolean invoke = entryProc != null;
        WALPointer logPtr = null;
        this.ensureFreeSpace();
        this.lockEntry();
        try {
            long expireTime;
            this.checkObsolete();
            GridCacheVersion newVer = tx.writeVersion();
            assert (newVer != null) : "Failed to get write version for tx: " + tx;
            long ttl = ttl0;
            if (ttl == -1L) {
                ttl = this.ttlExtras();
                expireTime = this.expireTimeExtras();
            } else {
                expireTime = CU.toExpireTime(ttl);
            }
            assert (ttl >= 0L) : ttl;
            assert (expireTime >= 0L) : expireTime;
            val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
            assert (val != null || invoke);
            res = this.cctx.offheap().mvccUpdate(this, val, newVer, expireTime, mvccVer, tx.local(), needHistory, noCreate, needOldVal, filter, retVal, keepBinary, entryProc, invokeArgs);
            assert (res != null);
            assert (res.resultType() != ResultType.VERSION_FOUND || op == GridCacheOperation.CREATE && tx.local() || !tx.local());
            assert (res.resultType() != ResultType.PREV_NOT_NULL || op != GridCacheOperation.CREATE || tx.local());
            if (res.resultType() == ResultType.VERSION_MISMATCH) {
                throw GridCacheMapEntry.serializationError();
            }
            if (res.resultType() == ResultType.FILTERED) {
                GridCacheUpdateTxResult updRes2 = new GridCacheUpdateTxResult(invoke);
                assert (!invoke || res.invokeResult() != null);
                if (invoke) {
                    updRes2.invokeResult(res.invokeResult());
                }
                updRes2.filtered(true);
                if (retVal) {
                    updRes2.prevValue(res.oldValue());
                }
                GridCacheUpdateTxResult gridCacheUpdateTxResult = updRes2;
                return gridCacheUpdateTxResult;
            }
            if (noCreate && !invoke && res.resultType() == ResultType.PREV_NULL) {
                GridCacheUpdateTxResult updRes2 = new GridCacheUpdateTxResult(false);
                return updRes2;
            }
            if (res.resultType() == ResultType.LOCKED) {
                this.unlockEntry();
                MvccVersion lockVer = res.resultVersion();
                GridFutureAdapter<GridCacheUpdateTxResult> resFut = new GridFutureAdapter<GridCacheUpdateTxResult>();
                IgniteInternalFuture<Void> lockFut = this.cctx.kernalContext().coordinators().waitForLock(this.cctx, mvccVer, lockVer);
                lockFut.listen(new MvccUpdateLockListener(tx, this, affNodeId, topVer, val, ttl0, mvccVer, op, needHistory, noCreate, resFut, needOldVal, filter, retVal, keepBinary, entryProc, invokeArgs));
                GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false, resFut);
                return gridCacheUpdateTxResult;
            }
            if (op == GridCacheOperation.CREATE && tx.local() && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.VERSION_FOUND)) {
                throw new IgniteTxDuplicateKeyCheckedException("Duplicate key during INSERT [key=" + this.key + ']');
            }
            if (this.cctx.deferredDelete() && this.deletedUnlocked() && !this.detached()) {
                this.deletedUnlocked(false);
            }
            if (res.resultType() == ResultType.PREV_NULL) {
                TxCounters counters = tx.txCounters(true);
                if (MvccUtils.compareIgnoreOpCounter(res.resultVersion(), mvccVer) == 0) {
                    if (res.isKeyAbsentBefore()) {
                        counters.incrementUpdateCounter(this.cctx.cacheId(), this.partition());
                    }
                } else {
                    counters.incrementUpdateCounter(this.cctx.cacheId(), this.partition());
                }
                counters.accumulateSizeDelta(this.cctx.cacheId(), this.partition(), 1L);
            } else if (res.resultType() == ResultType.PREV_NOT_NULL && MvccUtils.compareIgnoreOpCounter(res.resultVersion(), mvccVer) != 0) {
                TxCounters counters = tx.txCounters(true);
                counters.incrementUpdateCounter(this.cctx.cacheId(), this.partition());
            } else if (res.resultType() == ResultType.REMOVED_NOT_NULL) {
                TxCounters counters = tx.txCounters(true);
                if (MvccUtils.compareIgnoreOpCounter(res.resultVersion(), mvccVer) == 0) {
                    if (res.isKeyAbsentBefore()) {
                        counters.decrementUpdateCounter(this.cctx.cacheId(), this.partition());
                    }
                } else {
                    counters.incrementUpdateCounter(this.cctx.cacheId(), this.partition());
                }
                counters.accumulateSizeDelta(this.cctx.cacheId(), this.partition(), -1L);
            }
            if (this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled()) {
                logPtr = this.cctx.shared().wal().log(new MvccDataRecord(new MvccDataEntry(this.cctx.cacheId(), this.key, val, res.resultType() == ResultType.PREV_NULL ? GridCacheOperation.CREATE : (res.resultType() == ResultType.REMOVED_NOT_NULL ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE), tx.nearXidVersion(), newVer, expireTime, this.key.partition(), 0L, mvccVer)));
            }
            this.update(val, expireTime, ttl, newVer, true);
            this.recordNodeId(affNodeId, topVer);
        }
        finally {
            if (this.lockedByCurrentThread()) {
                this.unlockEntry();
                this.cctx.evicts().touch(this);
            }
        }
        this.onUpdateFinished(0L);
        GridCacheUpdateTxResult gridCacheUpdateTxResult = updRes = valid ? new GridCacheUpdateTxResult(true, 0L, logPtr) : new GridCacheUpdateTxResult(false, logPtr);
        if (retVal && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.VERSION_FOUND)) {
            updRes.prevValue(res.oldValue());
        }
        if (needOldVal && MvccUtils.compareIgnoreOpCounter(res.resultVersion(), mvccVer) != 0 && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.REMOVED_NOT_NULL)) {
            updRes.oldValue(res.oldValue());
        }
        updRes.newValue(res.newValue());
        if (invoke && res.resultType() != ResultType.VERSION_FOUND) {
            assert (res.invokeResult() != null);
            updRes.invokeResult(res.invokeResult());
        }
        updRes.mvccHistory(res.history());
        return updRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCacheUpdateTxResult mvccRemove(IgniteInternalTx tx, UUID affNodeId, AffinityTopologyVersion topVer, MvccSnapshot mvccVer, boolean needHistory, boolean needOldVal, @Nullable CacheEntryPredicate filter, boolean retVal) throws IgniteCheckedException, GridCacheEntryRemovedException {
        GridCacheUpdateTxResult updRes;
        MvccUpdateResult res;
        assert (tx != null);
        assert (mvccVer != null);
        boolean valid = this.valid(tx.topologyVersion());
        WALPointer logPtr = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheVersion newVer = tx.writeVersion();
            assert (newVer != null) : "Failed to get write version for tx: " + tx;
            res = this.cctx.offheap().mvccRemove(this, mvccVer, tx.local(), needHistory, needOldVal, filter, retVal);
            assert (res != null);
            if (res.resultType() == ResultType.VERSION_MISMATCH) {
                throw GridCacheMapEntry.serializationError();
            }
            if (res.resultType() == ResultType.PREV_NULL) {
                GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false);
                return gridCacheUpdateTxResult;
            }
            if (res.resultType() == ResultType.FILTERED) {
                GridCacheUpdateTxResult updRes2 = new GridCacheUpdateTxResult(false);
                updRes2.filtered(true);
                GridCacheUpdateTxResult gridCacheUpdateTxResult = updRes2;
                return gridCacheUpdateTxResult;
            }
            if (res.resultType() == ResultType.LOCKED) {
                this.unlockEntry();
                MvccVersion lockVer = res.resultVersion();
                GridFutureAdapter<GridCacheUpdateTxResult> resFut = new GridFutureAdapter<GridCacheUpdateTxResult>();
                IgniteInternalFuture<Void> lockFut = this.cctx.kernalContext().coordinators().waitForLock(this.cctx, mvccVer, lockVer);
                lockFut.listen(new MvccRemoveLockListener(tx, this, affNodeId, topVer, mvccVer, needHistory, resFut, needOldVal, retVal, filter));
                GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false, resFut);
                return gridCacheUpdateTxResult;
            }
            if (this.cctx.deferredDelete() && this.deletedUnlocked() && !this.detached()) {
                this.deletedUnlocked(false);
            }
            if (res.resultType() == ResultType.PREV_NOT_NULL) {
                TxCounters counters = tx.txCounters(true);
                if (MvccUtils.compareIgnoreOpCounter(res.resultVersion(), mvccVer) == 0) {
                    if (res.isKeyAbsentBefore()) {
                        counters.decrementUpdateCounter(this.cctx.cacheId(), this.partition());
                    }
                } else {
                    counters.incrementUpdateCounter(this.cctx.cacheId(), this.partition());
                }
                counters.accumulateSizeDelta(this.cctx.cacheId(), this.partition(), -1L);
            }
            if (this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled()) {
                logPtr = this.logMvccUpdate(tx, null, 0L, 0L, mvccVer);
            }
            this.update(null, 0L, 0L, newVer, true);
            this.recordNodeId(affNodeId, topVer);
        }
        finally {
            if (this.lockedByCurrentThread()) {
                this.unlockEntry();
                this.cctx.evicts().touch(this);
            }
        }
        this.onUpdateFinished(0L);
        GridCacheUpdateTxResult gridCacheUpdateTxResult = updRes = valid ? new GridCacheUpdateTxResult(true, 0L, logPtr) : new GridCacheUpdateTxResult(false, logPtr);
        if (retVal && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.VERSION_FOUND)) {
            updRes.prevValue(res.oldValue());
        }
        if (needOldVal && MvccUtils.compareIgnoreOpCounter(res.resultVersion(), mvccVer) != 0 && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.REMOVED_NOT_NULL)) {
            updRes.oldValue(res.oldValue());
        }
        updRes.mvccHistory(res.history());
        return updRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheUpdateTxResult mvccLock(GridDhtTxLocalAdapter tx, MvccSnapshot mvccVer) throws GridCacheEntryRemovedException, IgniteCheckedException {
        assert (tx != null);
        assert (mvccVer != null);
        boolean valid = this.valid(tx.topologyVersion());
        WALPointer logPtr = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheVersion newVer = tx.writeVersion();
            assert (newVer != null) : "Failed to get write version for tx: " + tx;
            assert (tx.local());
            MvccUpdateResult res = this.cctx.offheap().mvccLock(this, mvccVer);
            assert (res != null);
            if (res.resultType() == ResultType.VERSION_MISMATCH) {
                throw GridCacheMapEntry.serializationError();
            }
            if (res.resultType() == ResultType.LOCKED) {
                this.unlockEntry();
                MvccVersion lockVer = res.resultVersion();
                GridFutureAdapter<GridCacheUpdateTxResult> resFut = new GridFutureAdapter<GridCacheUpdateTxResult>();
                IgniteInternalFuture<Void> lockFut = this.cctx.kernalContext().coordinators().waitForLock(this.cctx, mvccVer, lockVer);
                lockFut.listen(new MvccAcquireLockListener(tx, this, mvccVer, resFut));
                GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false, resFut);
                return gridCacheUpdateTxResult;
            }
        }
        finally {
            if (this.lockedByCurrentThread()) {
                this.unlockEntry();
                this.cctx.evicts().touch(this);
            }
        }
        this.onUpdateFinished(0L);
        return new GridCacheUpdateTxResult(valid, logPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCacheUpdateTxResult innerSet(@Nullable IgniteInternalTx tx, UUID evtNodeId, UUID affNodeId, CacheObject val, boolean writeThrough, boolean retval, long ttl, boolean evt, boolean metrics, boolean keepBinary, boolean oldValPresent, @Nullable CacheObject oldVal, AffinityTopologyVersion topVer, CacheEntryPredicate[] filter, GridDrType drType, long drExpireTime, @Nullable GridCacheVersion explicitVer, @Nullable UUID subjId, String taskName, @Nullable GridCacheVersion dhtVer, @Nullable Long updateCntr) throws IgniteCheckedException, GridCacheEntryRemovedException {
        long updateCntr0;
        CacheObject old;
        GridCacheVersion newVer;
        boolean valid = this.valid(tx != null ? tx.topologyVersion() : topVer);
        if (!this.cctx.isAll(this, filter)) {
            return new GridCacheUpdateTxResult(false);
        }
        boolean intercept = this.cctx.config().getInterceptor() != null;
        Object key0 = null;
        Object val0 = null;
        WALPointer logPtr = null;
        this.ensureFreeSpace();
        this.lockListenerReadLock();
        this.lockEntry();
        try {
            long expireTime;
            Map<UUID, CacheContinuousQueryListener> lsnrCol;
            this.checkObsolete();
            if (this.isNear()) {
                assert (dhtVer != null);
                if (!((GridNearCacheEntry)this).recordDhtVersion(dhtVer)) {
                    GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false, logPtr);
                    return gridCacheUpdateTxResult;
                }
            }
            assert (tx == null || !tx.local() && tx.onePhaseCommit() || tx.ownsLock(this)) : "Transaction does not own lock for update [entry=" + this + ", tx=" + tx + ']';
            boolean startVer = this.isStartVersion();
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> map = lsnrCol = this.notifyContinuousQueries() ? this.cctx.continuousQueries().updateListeners(internal, false) : null;
            if (startVer && (retval || intercept || lsnrCol != null)) {
                this.unswap(retval);
            }
            GridCacheVersion gridCacheVersion = explicitVer != null ? explicitVer : (newVer = tx == null ? this.nextVersion() : tx.writeVersion());
            assert (newVer != null) : "Failed to get write version for tx: " + tx;
            CacheObject cacheObject = old = oldValPresent ? oldVal : this.val;
            if (intercept) {
                boolean bl = intercept = !this.skipInterceptor(explicitVer);
            }
            if (intercept) {
                val0 = this.cctx.unwrapBinaryIfNeeded(val, keepBinary, false);
                CacheLazyEntry e = new CacheLazyEntry(this.cctx, this.key, old, keepBinary);
                key0 = e.key();
                Object interceptorVal = this.cctx.config().getInterceptor().onBeforePut(e, val0);
                if (interceptorVal == null) {
                    GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false, logPtr);
                    return gridCacheUpdateTxResult;
                }
                if (interceptorVal != val0) {
                    val0 = this.cctx.unwrapTemporary(interceptorVal);
                }
                val = this.cctx.toCacheObject(val0);
            }
            if (drExpireTime >= 0L) {
                assert (ttl >= 0L) : ttl;
                expireTime = drExpireTime;
            } else if (ttl == -1L) {
                ttl = this.ttlExtras();
                expireTime = this.expireTimeExtras();
            } else {
                expireTime = CU.toExpireTime(ttl);
            }
            assert (ttl >= 0L) : ttl;
            assert (expireTime >= 0L) : expireTime;
            val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
            assert (val != null);
            this.storeValue(val, expireTime, newVer);
            if (this.cctx.deferredDelete() && this.deletedUnlocked() && !this.isInternal() && !this.detached()) {
                this.deletedUnlocked(false);
            }
            updateCntr0 = this.nextPartitionCounter(tx, updateCntr);
            if (tx != null && this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled()) {
                logPtr = this.logTxUpdate(tx, val, expireTime, updateCntr0);
            }
            this.update(val, expireTime, ttl, newVer, true);
            this.drReplicate(drType, val, newVer, topVer);
            this.recordNodeId(affNodeId, topVer);
            if (metrics && this.cctx.statisticsEnabled()) {
                this.cctx.cache().metrics0().onWrite();
                T2<GridCacheOperation, CacheObject> entryProcRes = tx.entry(this.txKey()).entryProcessorCalculatedValue();
                if (entryProcRes != null && GridCacheOperation.UPDATE.equals(entryProcRes.get1())) {
                    this.cctx.cache().metrics0().onInvokeUpdate(old != null);
                }
            }
            if (evt && newVer != null && this.cctx.events().isRecordable(63)) {
                CacheObject evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, tx, null, newVer, 63, val, val != null, evtOld, evtOld != null || this.hasValueUnlocked(), subjId, null, taskName, keepBinary);
            }
            if (lsnrCol != null) {
                this.cctx.continuousQueries().onEntryUpdated(lsnrCol, this.key, val, old, internal, this.partition(), tx.local(), false, updateCntr0, null, topVer);
            }
        }
        finally {
            this.unlockEntry();
            this.unlockListenerReadLock();
        }
        this.onUpdateFinished(updateCntr0);
        if (log.isDebugEnabled()) {
            log.debug("Updated cache entry [val=" + val + ", old=" + old + ", entry=" + this + ']');
        }
        if (writeThrough) {
            this.cctx.store().put(tx, this.key, val, newVer);
        }
        if (intercept) {
            this.cctx.config().getInterceptor().onAfterPut(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, val, val0, keepBinary, updateCntr0));
        }
        return valid ? new GridCacheUpdateTxResult(true, updateCntr0, logPtr) : new GridCacheUpdateTxResult(false, logPtr);
    }

    protected Object keyValue(boolean cpy) {
        return this.key.value(this.cctx.cacheObjectContext(), cpy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCacheUpdateTxResult innerRemove(@Nullable IgniteInternalTx tx, UUID evtNodeId, UUID affNodeId, boolean retval, boolean evt, boolean metrics, boolean keepBinary, boolean oldValPresent, @Nullable CacheObject oldVal, AffinityTopologyVersion topVer, CacheEntryPredicate[] filter, GridDrType drType, @Nullable GridCacheVersion explicitVer, @Nullable UUID subjId, String taskName, @Nullable GridCacheVersion dhtVer, @Nullable Long updateCntr) throws IgniteCheckedException, GridCacheEntryRemovedException {
        boolean deferred;
        long updateCntr0;
        assert (this.cctx.transactional());
        boolean valid = this.valid(tx != null ? tx.topologyVersion() : topVer);
        if (!this.cctx.isAll(this, filter)) {
            return new GridCacheUpdateTxResult(false);
        }
        GridCacheVersion obsoleteVer = null;
        boolean intercept = this.cctx.config().getInterceptor() != null;
        IgniteBiTuple interceptRes = null;
        CacheLazyEntry entry0 = null;
        WALPointer logPtr = null;
        boolean marked = false;
        this.lockListenerReadLock();
        this.lockEntry();
        try {
            CacheObject old;
            Map<UUID, CacheContinuousQueryListener> lsnrCol;
            this.checkObsolete();
            if (this.isNear()) {
                assert (dhtVer != null);
                if (!((GridNearCacheEntry)this).recordDhtVersion(dhtVer)) {
                    GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false, logPtr);
                    return gridCacheUpdateTxResult;
                }
            }
            assert (tx == null || !tx.local() && tx.onePhaseCommit() || tx.ownsLock(this)) : "Transaction does not own lock for remove[entry=" + this + ", tx=" + tx + ']';
            boolean startVer = this.isStartVersion();
            GridCacheVersion newVer = explicitVer != null ? explicitVer : (tx == null ? this.nextVersion() : tx.writeVersion());
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> map = lsnrCol = this.notifyContinuousQueries() ? this.cctx.continuousQueries().updateListeners(internal, false) : null;
            if (startVer && (retval || intercept || lsnrCol != null)) {
                this.unswap();
            }
            CacheObject cacheObject = old = oldValPresent ? oldVal : this.val;
            if (intercept) {
                boolean bl = intercept = !this.skipInterceptor(explicitVer);
            }
            if (intercept) {
                entry0 = new CacheLazyEntry(this.cctx, this.key, old, keepBinary);
                interceptRes = this.cctx.config().getInterceptor().onBeforeRemove(entry0);
                if (this.cctx.cancelRemove(interceptRes)) {
                    CacheObject ret = this.cctx.toCacheObject(this.cctx.unwrapTemporary(interceptRes.get2()));
                    GridCacheUpdateTxResult gridCacheUpdateTxResult = new GridCacheUpdateTxResult(false, logPtr);
                    return gridCacheUpdateTxResult;
                }
            }
            this.removeValue();
            this.update(null, 0L, 0L, newVer, true);
            if (this.cctx.deferredDelete() && !this.detached() && !this.isInternal() && !this.deletedUnlocked()) {
                this.deletedUnlocked(true);
                if (tx != null) {
                    GridCacheMvcc mvcc = this.mvccExtras();
                    if (mvcc == null || mvcc.isEmpty(tx.xidVersion())) {
                        this.clearReaders();
                    } else {
                        List<GridCacheMvccCandidate> locs = mvcc.localCandidatesNoCopy(false);
                        GridCacheVersion txVer = tx.xidVersion();
                        UUID originatingNodeId = tx.originatingNodeId();
                        boolean hasOriginatingNodeId = false;
                        for (GridCacheMvccCandidate c : locs) {
                            if (c.reentry() || Objects.equals(c.version(), txVer) || !Objects.equals(c.otherNodeId(), originatingNodeId)) continue;
                            hasOriginatingNodeId = true;
                            break;
                        }
                        if (!hasOriginatingNodeId) {
                            this.clearReader(originatingNodeId);
                        }
                    }
                }
            }
            updateCntr0 = this.nextPartitionCounter(tx, updateCntr);
            if (tx != null && this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled()) {
                logPtr = this.logTxUpdate(tx, null, 0L, updateCntr0);
            }
            this.drReplicate(drType, null, newVer, topVer);
            if (metrics && this.cctx.statisticsEnabled()) {
                this.cctx.cache().metrics0().onRemove();
                T2<GridCacheOperation, CacheObject> entryProcRes = tx.entry(this.txKey()).entryProcessorCalculatedValue();
                if (entryProcRes != null && GridCacheOperation.DELETE.equals(entryProcRes.get1())) {
                    this.cctx.cache().metrics0().onInvokeRemove(old != null);
                }
            }
            if (tx == null) {
                obsoleteVer = newVer;
            } else if (this.lockedBy(tx.xidVersion())) {
                obsoleteVer = tx.xidVersion();
            } else if (log.isDebugEnabled()) {
                log.debug("Obsolete version was not set because lock was explicit: " + this);
            }
            if (evt && newVer != null && this.cctx.events().isRecordable(65)) {
                CacheObject evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, tx, null, newVer, 65, null, false, evtOld, evtOld != null || this.hasValueUnlocked(), subjId, null, taskName, keepBinary);
            }
            if (lsnrCol != null) {
                this.cctx.continuousQueries().onEntryUpdated(lsnrCol, this.key, null, old, internal, this.partition(), tx.local(), false, updateCntr0, null, topVer);
            }
            boolean bl = deferred = this.cctx.deferredDelete() && !this.detached() && !this.isInternal();
            if (intercept) {
                entry0.updateCounter(updateCntr0);
            }
            if (!deferred) {
                assert (newVer == this.ver);
                if (obsoleteVer == null || !(marked = this.markObsolete0(obsoleteVer, true, null))) {
                    if (log.isDebugEnabled()) {
                        log.debug("Entry could not be marked obsolete (it is still used): " + this);
                    }
                } else {
                    this.recordNodeId(affNodeId, topVer);
                    if (log.isDebugEnabled()) {
                        log.debug("Entry was marked obsolete: " + this);
                    }
                }
            }
        }
        finally {
            this.unlockEntry();
            this.unlockListenerReadLock();
        }
        if (marked) {
            assert (!deferred);
            this.onMarkedObsolete();
        }
        this.onUpdateFinished(updateCntr0);
        if (intercept) {
            this.cctx.config().getInterceptor().onAfterRemove(entry0);
        }
        if (valid) {
            return new GridCacheUpdateTxResult(true, updateCntr0, logPtr);
        }
        return new GridCacheUpdateTxResult(false, logPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridTuple3<Boolean, Object, EntryProcessorResult<Object>> innerUpdateLocal(GridCacheVersion ver, GridCacheOperation op, @Nullable Object writeObj, @Nullable Object[] invokeArgs, boolean writeThrough, boolean readThrough, boolean retval, boolean keepBinary, @Nullable ExpiryPolicy expiryPlc, boolean evt, boolean metrics, @Nullable CacheEntryPredicate[] filter, boolean intercept, @Nullable UUID subjId, String taskName, boolean transformOp) throws IgniteCheckedException, GridCacheEntryRemovedException {
        CacheObject old;
        assert (this.cctx.isLocal() && this.cctx.atomic());
        boolean res = true;
        IgniteBiTuple<Boolean, Object> interceptorRes = null;
        CacheInvokeResult invokeRes = null;
        this.lockListenerReadLock();
        this.lockEntry();
        try {
            CacheObject evtOld;
            GridTuple3 gridTuple3;
            CacheObject updated;
            boolean pass;
            boolean needVal;
            this.checkObsolete();
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> lsnrCol = this.cctx.continuousQueries().updateListeners(internal, false);
            boolean bl = needVal = retval || intercept || op == GridCacheOperation.TRANSFORM || !F.isEmpty(filter) || lsnrCol != null;
            if (this.isNew()) {
                this.unswap(null, false);
            }
            old = this.val;
            if (this.expireTimeExtras() > 0L && this.expireTimeExtras() < U.currentTimeMillis() && this.onExpired(this.val, null)) {
                assert (!this.deletedUnlocked());
                this.update(null, 0L, 0L, ver, true);
                old = null;
            }
            boolean readFromStore = false;
            Object old0 = null;
            if (readThrough && needVal && old == null && this.cctx.readThrough() && (op == GridCacheOperation.TRANSFORM || this.cctx.loadPreviousValue())) {
                old0 = this.readThrough(null, this.key, false, subjId, taskName);
                old = this.cctx.toCacheObject(old0);
                long ttl = 0L;
                long expireTime = 0L;
                if (expiryPlc != null && old != null) {
                    ttl = CU.toTtl(expiryPlc.getExpiryForCreation());
                    if (ttl == -2L) {
                        ttl = 1L;
                        expireTime = CU.expireTimeInPast();
                    } else if (ttl == -1L) {
                        ttl = 0L;
                    } else {
                        expireTime = CU.toExpireTime(ttl);
                    }
                }
                if ((old = this.cctx.kernalContext().cacheObjects().prepareForCache(old, this.cctx)) != null) {
                    this.storeValue(old, expireTime, ver);
                } else {
                    this.removeValue();
                }
                this.update(old, expireTime, ttl, ver, true);
            }
            if (metrics && this.cctx.statisticsEnabled() && needVal) {
                this.cctx.cache().metrics0().onRead(old != null);
            }
            if (!F.isEmpty(filter) && !(pass = this.cctx.isAllLocked(this, filter))) {
                if (expiryPlc != null && !readFromStore && !this.cctx.putIfAbsentFilter(filter) && this.hasValueUnlocked()) {
                    this.updateTtl(expiryPlc);
                }
                Object val = retval ? this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(CU.value(old, this.cctx, false), keepBinary, false) : null;
                T3<Boolean, Object, Object> expireTime = new T3<Boolean, Object, Object>(false, val, null);
                return expireTime;
            }
            String transformCloClsName = null;
            Object key0 = null;
            Object updated0 = null;
            if (op == GridCacheOperation.TRANSFORM) {
                transformCloClsName = EntryProcessorResourceInjectorProxy.unwrap(writeObj).getClass().getName();
                EntryProcessor entryProcessor = (EntryProcessor)writeObj;
                assert (entryProcessor != null);
                CacheInvokeEntry entry = new CacheInvokeEntry(this.key, old, this.version(), keepBinary, this);
                IgniteThread.onEntryProcessorEntered(false);
                try {
                    Object computed = entryProcessor.process(entry, invokeArgs);
                    transformOp = true;
                    if (entry.modified()) {
                        updated0 = this.cctx.unwrapTemporary(entry.getValue());
                        updated = this.cctx.toCacheObject(updated0);
                        this.cctx.validateKeyAndValue(this.key, updated);
                    } else {
                        updated = old;
                    }
                    key0 = entry.key();
                    invokeRes = computed != null ? CacheInvokeResult.fromResult(this.cctx.unwrapTemporary(computed)) : null;
                }
                catch (Exception e) {
                    updated = old;
                    invokeRes = CacheInvokeResult.fromError(e);
                }
                finally {
                    IgniteThread.onEntryProcessorLeft();
                }
                if (!entry.modified()) {
                    if (expiryPlc != null && !readFromStore && this.hasValueUnlocked()) {
                        this.updateTtl(expiryPlc);
                    }
                    this.updateMetrics(GridCacheOperation.READ, metrics, transformOp, old != null);
                    gridTuple3 = new GridTuple3(false, null, invokeRes);
                    return gridTuple3;
                }
            } else {
                updated = (CacheObject)writeObj;
            }
            GridCacheOperation gridCacheOperation = op = updated == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE;
            if (intercept) {
                GridTuple3<Boolean, Object, EntryProcessorResult<Object>> interceptorVal;
                CacheLazyEntry<Object, Object> e;
                if (op == GridCacheOperation.UPDATE) {
                    updated0 = this.value(updated0, updated, keepBinary, false);
                    e = new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, old, old0, keepBinary);
                    interceptorVal = this.cctx.config().getInterceptor().onBeforePut(e, updated0);
                    if (interceptorVal == null) {
                        gridTuple3 = new GridTuple3(false, this.cctx.unwrapTemporary(this.value(old0, old, keepBinary, false)), invokeRes);
                        return gridTuple3;
                    }
                    updated0 = this.cctx.unwrapTemporary(interceptorVal);
                    updated = this.cctx.toCacheObject(updated0);
                } else {
                    e = new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, old, old0, keepBinary);
                    interceptorRes = this.cctx.config().getInterceptor().onBeforeRemove(e);
                    if (this.cctx.cancelRemove(interceptorRes)) {
                        interceptorVal = new GridTuple3<Boolean, Object, EntryProcessorResult<Object>>(false, this.cctx.unwrapTemporary(interceptorRes.get2()), invokeRes);
                        return interceptorVal;
                    }
                }
                key0 = e.key();
                old0 = e.value();
            }
            boolean hadVal = this.hasValueUnlocked();
            long ttl = 0L;
            long expireTime = 0L;
            if (op == GridCacheOperation.UPDATE) {
                if (expiryPlc != null) {
                    ttl = CU.toTtl(hadVal ? expiryPlc.getExpiryForUpdate() : expiryPlc.getExpiryForCreation());
                    if (ttl == -1L) {
                        ttl = this.ttlExtras();
                        expireTime = this.expireTimeExtras();
                    } else if (ttl != -2L) {
                        expireTime = CU.toExpireTime(ttl);
                    }
                } else {
                    ttl = this.ttlExtras();
                    expireTime = this.expireTimeExtras();
                }
            }
            if (ttl == -2L) {
                op = GridCacheOperation.DELETE;
                transformOp = false;
            }
            if (op == GridCacheOperation.UPDATE) {
                updated = this.cctx.kernalContext().cacheObjects().prepareForCache(updated, this.cctx);
                if (writeThrough) {
                    this.cctx.store().put(null, this.key, updated, ver);
                }
                this.storeValue(updated, expireTime, ver);
                assert (ttl != -2L);
                this.update(updated, expireTime, ttl, ver, true);
                this.logUpdate(op, updated, ver, expireTime, 0L);
                if (evt) {
                    evtOld = null;
                    if (transformCloClsName != null && this.cctx.events().isRecordable(64)) {
                        evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, null, null, 64, evtOld, evtOld != null || hadVal, evtOld, evtOld != null || hadVal, subjId, transformCloClsName, taskName, keepBinary);
                    }
                    if (this.cctx.events().isRecordable(63)) {
                        if (evtOld == null) {
                            evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                        }
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, null, null, 63, updated, updated != null, evtOld, evtOld != null || hadVal, subjId, null, taskName, keepBinary);
                    }
                }
            } else {
                if (writeThrough) {
                    this.cctx.store().remove(null, this.key);
                }
                this.removeValue();
                this.update(null, 0L, 0L, ver, true);
                this.logUpdate(op, null, ver, 0L, 0L);
                if (evt) {
                    evtOld = null;
                    if (transformCloClsName != null && this.cctx.events().isRecordable(64)) {
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, null, null, 64, evtOld, evtOld != null || hadVal, evtOld, evtOld != null || hadVal, subjId, transformCloClsName, taskName, keepBinary);
                    }
                    if (this.cctx.events().isRecordable(65)) {
                        if (evtOld == null) {
                            evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                        }
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, null, null, 65, null, false, evtOld, evtOld != null || hadVal, subjId, null, taskName, keepBinary);
                    }
                }
                res = hadVal;
            }
            if (res) {
                this.updateMetrics(op, metrics, transformOp, old != null);
            } else if (op == GridCacheOperation.DELETE && transformOp) {
                this.cctx.cache().metrics0().onInvokeRemove(old != null);
            }
            if (lsnrCol != null) {
                long updateCntr = this.nextPartitionCounter(AffinityTopologyVersion.NONE, true, false, null);
                this.cctx.continuousQueries().onEntryUpdated(lsnrCol, this.key, this.val, old, internal, this.partition(), true, false, updateCntr, null, AffinityTopologyVersion.NONE);
                this.onUpdateFinished(updateCntr);
            }
            if (intercept) {
                if (op == GridCacheOperation.UPDATE) {
                    this.cctx.config().getInterceptor().onAfterPut(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, updated, updated0, keepBinary, 0L));
                } else {
                    this.cctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, old, old0, keepBinary, 0L));
                }
            }
        }
        finally {
            this.unlockEntry();
            this.unlockListenerReadLock();
        }
        return new GridTuple3<Boolean, Object, EntryProcessorResult<Object>>(res, this.cctx.unwrapTemporary(interceptorRes != null ? interceptorRes.get2() : this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(old, keepBinary, false)), invokeRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheUpdateAtomicResult innerUpdate(GridCacheVersion newVer, UUID evtNodeId, UUID affNodeId, GridCacheOperation op, @Nullable Object writeObj, @Nullable Object[] invokeArgs, boolean writeThrough, boolean readThrough, boolean retval, boolean keepBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean evt, boolean metrics, boolean primary, boolean verCheck, AffinityTopologyVersion topVer, @Nullable CacheEntryPredicate[] filter, GridDrType drType, long explicitTtl, long explicitExpireTime, @Nullable GridCacheVersion conflictVer, boolean conflictResolve, boolean intercept, @Nullable UUID subjId, String taskName, @Nullable CacheObject prevVal, @Nullable Long updateCntr, @Nullable GridDhtAtomicAbstractUpdateFuture fut, boolean transformOp) throws IgniteCheckedException, GridCacheEntryRemovedException, GridClosureException {
        AtomicCacheUpdateClosure c;
        assert (this.cctx.atomic() && !this.detached());
        if (!primary && !this.isNear()) {
            this.ensureFreeSpace();
        }
        this.lockListenerReadLock();
        this.lockEntry();
        try {
            boolean updateMetrics;
            this.checkObsolete();
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> lsnrs = this.cctx.continuousQueries().updateListeners(internal, false);
            boolean needVal = lsnrs != null || intercept || retval || op == GridCacheOperation.TRANSFORM || !F.isEmptyOrNulls(filter);
            boolean readFromStore = readThrough && needVal && this.cctx.readThrough() && (op == GridCacheOperation.TRANSFORM || this.cctx.loadPreviousValue());
            c = new AtomicCacheUpdateClosure(this, topVer, newVer, op, writeObj, invokeArgs, readFromStore, writeThrough, keepBinary, expiryPlc, primary, verCheck, filter, explicitTtl, explicitExpireTime, conflictVer, conflictResolve, intercept, updateCntr, this.cctx.disableTriggeringCacheInterceptorOnConflict());
            this.key.valueBytes(this.cctx.cacheObjectContext());
            if (this.isNear()) {
                CacheDataRowAdapter dataRow = this.val != null ? new CacheDataRowAdapter(this.key, this.val, this.ver, this.expireTimeExtras()) : null;
                c.call(dataRow);
            } else {
                this.cctx.offheap().invoke(this.cctx, this.key, this.localPartition(), c);
            }
            GridCacheUpdateAtomicResult updateRes = c.updateRes;
            assert (updateRes != null) : c;
            CacheObject oldVal = c.oldRow != null && !c.oldRowExpiredFlag ? c.oldRow.value() : null;
            CacheObject updateVal = null;
            GridCacheVersion updateVer = c.newVer;
            boolean bl = updateMetrics = metrics && this.cctx.statisticsEnabled();
            if (updateMetrics && updateRes.outcome().updateReadMetrics() && needVal) {
                this.cctx.cache().metrics0().onRead(oldVal != null);
            }
            if (updateMetrics && GridCacheUpdateAtomicResult.UpdateOutcome.INVOKE_NO_OP.equals((Object)updateRes.outcome()) && (transformOp || updateRes.transformed())) {
                this.cctx.cache().metrics0().onReadOnlyInvoke(oldVal != null);
            } else if (updateMetrics && GridCacheUpdateAtomicResult.UpdateOutcome.REMOVE_NO_VAL.equals((Object)updateRes.outcome()) && (transformOp || updateRes.transformed())) {
                this.cctx.cache().metrics0().onInvokeRemove(oldVal != null);
            }
            switch (updateRes.outcome()) {
                case VERSION_CHECK_FAILED: {
                    Object evtVal;
                    if (!this.cctx.isNear()) {
                        if (op == GridCacheOperation.TRANSFORM) {
                            EntryProcessor entryProcessor = (EntryProcessor)writeObj;
                            CacheInvokeEntry entry = new CacheInvokeEntry(this.key, prevVal, this.version(), keepBinary, this);
                            IgniteThread.onEntryProcessorEntered(true);
                            try {
                                entryProcessor.process(entry, invokeArgs);
                                evtVal = entry.modified() ? this.cctx.toCacheObject(this.cctx.unwrapTemporary(entry.getValue())) : prevVal;
                            }
                            catch (Exception ignore) {
                                evtVal = prevVal;
                            }
                            finally {
                                IgniteThread.onEntryProcessorLeft();
                            }
                        } else {
                            evtVal = (CacheObject)writeObj;
                        }
                        assert (!primary && updateCntr != null);
                        this.onUpdateFinished(updateCntr);
                        this.cctx.continuousQueries().onEntryUpdated(this.key, (CacheObject)evtVal, prevVal, this.isInternal() || !this.context().userCache(), this.partition(), primary, false, updateCntr, null, topVer);
                    }
                    evtVal = updateRes;
                    return evtVal;
                }
                case CONFLICT_USE_OLD: 
                case FILTER_FAILED: 
                case INVOKE_NO_OP: 
                case INTERCEPTOR_CANCEL: {
                    GridCacheUpdateAtomicResult evtVal = updateRes;
                    return evtVal;
                }
            }
            assert (updateRes.outcome() == GridCacheUpdateAtomicResult.UpdateOutcome.SUCCESS || updateRes.outcome() == GridCacheUpdateAtomicResult.UpdateOutcome.REMOVE_NO_VAL);
            CacheObject evtOld = null;
            if (evt && op == GridCacheOperation.TRANSFORM && this.cctx.events().isRecordable(64)) {
                assert (writeObj instanceof EntryProcessor) : writeObj;
                evtOld = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                Object transformClo = EntryProcessorResourceInjectorProxy.unwrap(writeObj);
                this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, null, null, updateVer, 64, evtOld, evtOld != null, evtOld, evtOld != null, subjId, transformClo.getClass().getName(), taskName, keepBinary);
            }
            if (c.op == GridCacheOperation.UPDATE) {
                updateVal = this.val;
                assert (updateVal != null) : c;
                this.drReplicate(drType, updateVal, updateVer, topVer);
                this.recordNodeId(affNodeId, topVer);
                if (evt && this.cctx.events().isRecordable(63)) {
                    if (evtOld == null) {
                        evtOld = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                    }
                    this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, null, null, updateVer, 63, updateVal, true, evtOld, evtOld != null, subjId, null, taskName, keepBinary);
                }
            } else {
                assert (c.op == GridCacheOperation.DELETE) : AtomicCacheUpdateClosure.access$400(c);
                this.clearReaders();
                this.drReplicate(drType, null, updateVer, topVer);
                this.recordNodeId(affNodeId, topVer);
                if (evt && this.cctx.events().isRecordable(65)) {
                    if (evtOld == null) {
                        evtOld = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                    }
                    this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, null, null, updateVer, 65, null, false, evtOld, evtOld != null, subjId, null, taskName, keepBinary);
                }
            }
            if (updateRes.success()) {
                this.updateMetrics(c.op, metrics, transformOp || updateRes.transformed(), oldVal != null);
            }
            if (lsnrs != null) {
                CacheObject evtVal = (CacheObject)this.cctx.unwrapTemporary(updateVal);
                CacheObject evtOldVal = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                this.cctx.continuousQueries().onEntryUpdated(lsnrs, this.key, evtVal, evtOldVal, internal, this.partition(), primary, false, c.updateRes.updateCounter(), fut, topVer);
            }
            if (intercept && c.wasIntercepted) {
                assert (c.op == GridCacheOperation.UPDATE || c.op == GridCacheOperation.DELETE) : AtomicCacheUpdateClosure.access$400(c);
                CacheLazyEntry<Object, Object> entry = new CacheLazyEntry<Object, Object>(this.cctx, this.key, null, c.op == GridCacheOperation.UPDATE ? updateVal : oldVal, null, keepBinary, c.updateRes.updateCounter());
                if (c.op == GridCacheOperation.UPDATE) {
                    this.cctx.config().getInterceptor().onAfterPut(entry);
                } else {
                    this.cctx.config().getInterceptor().onAfterRemove(entry);
                }
            }
        }
        finally {
            this.unlockEntry();
            this.unlockListenerReadLock();
        }
        this.onUpdateFinished(c.updateRes.updateCounter());
        return c.updateRes;
    }

    @Nullable
    private Object value(@Nullable Object val, @Nullable CacheObject cacheObj, boolean keepBinary, boolean cpy) {
        if (val != null) {
            return val;
        }
        return this.cctx.unwrapBinaryIfNeeded(cacheObj, keepBinary, cpy);
    }

    private static IgniteBiTuple<Long, Long> initialTtlAndExpireTime(IgniteCacheExpiryPolicy expiry) {
        long initExpireTime;
        assert (expiry != null);
        long initTtl = expiry.forCreate();
        if (initTtl == -2L) {
            initTtl = 1L;
            initExpireTime = CU.expireTimeInPast();
        } else if (initTtl == -1L) {
            initTtl = 0L;
            initExpireTime = 0L;
        } else {
            initExpireTime = CU.toExpireTime(initTtl);
        }
        return F.t(initTtl, initExpireTime);
    }

    private GridTuple3<Long, Long, Boolean> ttlAndExpireTime(IgniteCacheExpiryPolicy expiry, long ttl, long expireTime) {
        assert (!this.obsolete());
        boolean rmv = false;
        if (ttl == -1L && expiry != null) {
            long l = ttl = this.hasValueUnlocked() ? expiry.forUpdate() : expiry.forCreate();
        }
        if (ttl == -2L) {
            rmv = true;
            ttl = 0L;
        }
        if (ttl == -1L) {
            if (this.isStartVersion()) {
                ttl = 0L;
            } else {
                ttl = this.ttlExtras();
                expireTime = this.expireTimeExtras();
            }
        }
        if (expireTime == -1L) {
            expireTime = CU.toExpireTime(ttl);
        }
        return F.t(ttl, expireTime, rmv);
    }

    private void drReplicate(GridDrType drType, @Nullable CacheObject val, GridCacheVersion ver, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        if (this.cctx.isDrEnabled() && drType != GridDrType.DR_NONE && !this.isInternal()) {
            this.cctx.dr().replicate(this.key, val, this.rawTtl(), this.rawExpireTime(), ver.conflictVersion(), drType, topVer);
        }
    }

    protected boolean hasReaders() throws GridCacheEntryRemovedException {
        return false;
    }

    protected void clearReaders() {
    }

    protected void clearReader(UUID nodeId) throws GridCacheEntryRemovedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clear(GridCacheVersion ver, boolean readers) throws IgniteCheckedException {
        this.lockEntry();
        try {
            if (this.obsolete()) {
                boolean bl = false;
                return bl;
            }
            if (!this.hasReaders() || readers) {
                if (!this.markObsolete0(ver, true, null)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Entry could not be marked obsolete (it is still used): " + this);
                    }
                    boolean bl = false;
                    return bl;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Entry could not be marked obsolete (it still has readers): " + this);
                }
                boolean bl = false;
                return bl;
            }
            this.clearReaders();
            if (log.isTraceEnabled()) {
                log.trace("entry clear [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", val=" + this.val + ']');
            }
            if (this.cctx.mvccEnabled()) {
                this.cctx.offheap().mvccRemoveAll(this);
            } else {
                this.removeValue();
            }
        }
        finally {
            this.unlockEntry();
        }
        this.onMarkedObsolete();
        this.cctx.cache().removeEntry(this);
        return true;
    }

    @Override
    public GridCacheVersion obsoleteVersion() {
        this.lockEntry();
        try {
            GridCacheVersion gridCacheVersion = this.obsoleteVersionExtras();
            return gridCacheVersion;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public boolean markObsolete(GridCacheVersion ver) {
        boolean obsolete;
        this.lockEntry();
        try {
            obsolete = this.markObsolete0(ver, true, null);
        }
        finally {
            this.unlockEntry();
        }
        if (obsolete) {
            this.onMarkedObsolete();
        }
        return obsolete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markObsoleteIfEmpty(@Nullable GridCacheVersion obsoleteVer) throws IgniteCheckedException {
        boolean obsolete = false;
        boolean deferred = false;
        GridCacheVersion ver0 = null;
        this.lockEntry();
        try {
            if (this.obsoleteVersionExtras() != null) {
                boolean bl = false;
                return bl;
            }
            if (this.hasValueUnlocked()) {
                long expireTime = this.expireTimeExtras();
                if (expireTime > 0L && expireTime < U.currentTimeMillis()) {
                    if (obsoleteVer == null) {
                        obsoleteVer = this.nextVersion();
                    }
                    if (this.onExpired(this.val, obsoleteVer)) {
                        if (this.cctx.deferredDelete()) {
                            deferred = true;
                            ver0 = this.ver;
                        } else {
                            obsolete = true;
                        }
                    }
                }
            } else if (this.cctx.deferredDelete() && !this.isStartVersion() && !this.detached() && !this.isInternal()) {
                if (!this.deletedUnlocked()) {
                    this.update(null, 0L, 0L, this.ver, true);
                    this.deletedUnlocked(true);
                    deferred = true;
                    ver0 = this.ver;
                }
            } else {
                if (obsoleteVer == null) {
                    obsoleteVer = this.nextVersion();
                }
                obsolete = this.markObsolete0(obsoleteVer, true, null);
            }
        }
        finally {
            this.unlockEntry();
            if (obsolete) {
                this.onMarkedObsolete();
            }
            if (deferred) {
                this.cctx.onDeferredDelete(this, ver0);
            }
        }
        return obsolete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markObsoleteVersion(GridCacheVersion ver) {
        boolean marked;
        assert (this.cctx.deferredDelete());
        this.lockEntry();
        try {
            if (this.obsoleteVersionExtras() != null) {
                boolean bl = true;
                return bl;
            }
            if (!this.ver.equals(ver)) {
                boolean bl = false;
                return bl;
            }
            marked = this.markObsolete0(ver, true, null);
        }
        finally {
            this.unlockEntry();
        }
        if (marked) {
            this.onMarkedObsolete();
        }
        return marked;
    }

    protected boolean evictionDisabled() {
        return (this.flags & 4) != 0;
    }

    protected final boolean markObsolete0(GridCacheVersion ver, boolean clear, GridCacheObsoleteEntryExtras extras) {
        assert (this.lock.isHeldByCurrentThread());
        if (this.evictionDisabled()) {
            assert (!this.obsolete()) : this;
            return false;
        }
        GridCacheVersion obsoleteVer = this.obsoleteVersionExtras();
        if (ver != null) {
            if (obsoleteVer != null) {
                return true;
            }
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null || mvcc.isEmpty(ver)) {
                obsoleteVer = ver;
                this.obsoleteVersionExtras(obsoleteVer, extras);
                if (clear) {
                    this.value(null);
                }
                if (log.isTraceEnabled()) {
                    log.trace("markObsolete0 [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", clear=" + clear + ']');
                }
            }
            return obsoleteVer != null;
        }
        return obsoleteVer != null;
    }

    @Override
    public void onMarkedObsolete() {
    }

    @Override
    public final boolean obsolete() {
        this.lockEntry();
        try {
            boolean bl = this.obsoleteVersionExtras() != null;
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean obsolete(GridCacheVersion exclude) {
        this.lockEntry();
        try {
            GridCacheVersion obsoleteVer = this.obsoleteVersionExtras();
            boolean bl = obsoleteVer != null && !obsoleteVer.equals(exclude);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public boolean invalidate(GridCacheVersion newVer) throws IgniteCheckedException {
        this.lockEntry();
        try {
            assert (newVer != null);
            this.value(null);
            this.ver = newVer;
            this.flags = (byte)(this.flags & 0xFFFFFFFB);
            this.onInvalidate();
            boolean bl = this.obsoleteVersionExtras() != null;
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    protected void onInvalidate() {
    }

    protected final void update(@Nullable CacheObject val, long expireTime, long ttl, GridCacheVersion ver, boolean addTracked) {
        assert (ver != null);
        assert (this.lock.isHeldByCurrentThread());
        assert (ttl != -2L && ttl != -1L && ttl >= 0L) : ttl;
        boolean trackNear = addTracked && this.isNear() && this.cctx.config().isEagerTtl();
        long oldExpireTime = this.expireTimeExtras();
        if (trackNear && oldExpireTime != 0L && (expireTime != oldExpireTime || this.isStartVersion())) {
            this.cctx.ttl().removeTrackedEntry((GridNearCacheEntry)this);
        }
        this.value(val);
        this.ttlAndExpireTimeExtras(ttl, expireTime);
        this.ver = ver;
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        if (trackNear && expireTime != 0L && (expireTime != oldExpireTime || this.isStartVersion())) {
            this.cctx.ttl().addTrackedEntry((GridNearCacheEntry)this);
        }
    }

    private boolean notifyContinuousQueries() {
        return !this.isNear();
    }

    private void updateTtl(ExpiryPolicy expiryPlc) throws IgniteCheckedException, GridCacheEntryRemovedException {
        long ttl = CU.toTtl(expiryPlc.getExpiryForAccess());
        if (ttl != -1L) {
            this.updateTtl(ttl);
        }
    }

    private void updateTtl(IgniteCacheExpiryPolicy expiryPlc) throws GridCacheEntryRemovedException, IgniteCheckedException {
        long ttl = expiryPlc.forAccess();
        if (ttl != -1L) {
            this.updateTtl(ttl);
            expiryPlc.ttlUpdated(this.key(), this.version(), this.hasReaders() ? ((GridDhtCacheEntry)this).readers() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTtl(long ttl) throws IgniteCheckedException, GridCacheEntryRemovedException {
        long expireTime;
        assert (ttl >= 0L || ttl == -2L) : ttl;
        assert (this.lock.isHeldByCurrentThread());
        if (ttl == -2L) {
            ttl = 1L;
            expireTime = CU.expireTimeInPast();
        } else {
            expireTime = CU.toExpireTime(ttl);
        }
        this.ttlAndExpireTimeExtras(ttl, expireTime);
        this.cctx.shared().database().checkpointReadLock();
        try {
            this.storeValue(this.val, expireTime, this.ver);
        }
        finally {
            this.cctx.shared().database().checkpointReadUnlock();
        }
    }

    protected void checkObsolete() throws GridCacheEntryRemovedException {
        assert (this.lock.isHeldByCurrentThread());
        if (this.obsoleteVersionExtras() != null) {
            throw new GridCacheEntryRemovedException();
        }
    }

    @Override
    public KeyCacheObject key() {
        return this.key;
    }

    @Override
    public IgniteTxKey txKey() {
        return this.cctx.txKey(this.key);
    }

    @Override
    public GridCacheVersion version() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheVersion gridCacheVersion = this.ver;
            return gridCacheVersion;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSerializableReadVersion(GridCacheVersion serReadVer) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            if (!serReadVer.equals(this.ver)) {
                boolean empty;
                boolean bl = empty = this.isStartVersion() || this.deletedUnlocked();
                if (serReadVer.equals(IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER)) {
                    boolean bl2 = empty;
                    return bl2;
                }
                if (serReadVer.equals(IgniteTxEntry.SER_READ_NOT_EMPTY_VER)) {
                    boolean bl3 = !empty;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    int hash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CacheObject mvccPeek(boolean onheapOnly) throws GridCacheEntryRemovedException, IgniteCheckedException {
        if (onheapOnly) {
            return null;
        }
        this.lockEntry();
        try {
            this.checkObsolete();
            CacheDataRow row = this.cctx.offheap().mvccRead(this.cctx, this.key, MvccUtils.MVCC_MAX_SNAPSHOT);
            CacheObject cacheObject = row != null ? row.value() : null;
            return cacheObject;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public CacheObject peek(boolean heap, boolean offheap, AffinityTopologyVersion topVer, @Nullable IgniteCacheExpiryPolicy expiryPlc) throws GridCacheEntryRemovedException, IgniteCheckedException {
        assert (heap || offheap);
        boolean rmv = false;
        try {
            GridCacheVersion ver0;
            boolean deferred;
            this.lockEntry();
            try {
                this.checkObsolete();
                if (!this.valid(topVer)) {
                    CacheObject cacheObject = null;
                    return cacheObject;
                }
                if (this.val == null && offheap) {
                    this.unswap(null, false);
                }
                if (this.checkExpired()) {
                    if (!this.cctx.deferredDelete()) {
                        rmv = this.markObsolete0(this.cctx.versions().next(this.ver), true, null);
                        CacheObject cacheObject = null;
                        return cacheObject;
                    }
                } else {
                    CacheObject val = this.val;
                    if (val != null && expiryPlc != null) {
                        this.updateTtl(expiryPlc);
                    }
                    CacheObject cacheObject = val;
                    return cacheObject;
                }
                deferred = true;
                ver0 = this.ver;
            }
            finally {
                this.unlockEntry();
            }
            if (deferred) {
                assert (ver0 != null);
                this.cctx.onDeferredDelete(this, ver0);
            }
            CacheObject cacheObject = null;
            return cacheObject;
        }
        finally {
            if (rmv) {
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
            }
        }
    }

    @Override
    @Nullable
    public CacheObject peek() throws GridCacheEntryRemovedException, IgniteCheckedException {
        IgniteTxLocalAdapter tx = this.cctx.tm().localTx();
        AffinityTopologyVersion topVer = tx != null ? tx.topologyVersion() : this.cctx.affinity().affinityTopologyVersion();
        return this.peek(true, false, topVer, null);
    }

    private boolean checkExpired() throws IgniteCheckedException {
        long delta;
        assert (this.lock.isHeldByCurrentThread());
        long expireTime = this.expireTimeExtras();
        if (expireTime > 0L && (delta = expireTime - U.currentTimeMillis()) <= 0L) {
            if (this.cctx.mvccEnabled()) {
                this.cctx.offheap().mvccRemoveAll(this);
            } else {
                this.removeValue();
            }
            return true;
        }
        return false;
    }

    @Override
    public CacheObject rawGet() {
        this.lockEntry();
        try {
            CacheObject cacheObject = this.val;
            return cacheObject;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public final boolean hasValue() {
        this.lockEntry();
        try {
            boolean bl = this.hasValueUnlocked();
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    protected final boolean hasValueUnlocked() {
        assert (this.lock.isHeldByCurrentThread());
        return this.val != null;
    }

    private boolean isRemoteDrUpdate(@Nullable GridCacheVersion explicitVer) {
        return explicitVer != null && explicitVer.dataCenterId() != this.cctx.dr().dataCenterId();
    }

    private boolean skipInterceptor(@Nullable GridCacheVersion explicitVer) {
        return this.isRemoteDrUpdate(explicitVer) && this.cctx.disableTriggeringCacheInterceptorOnConflict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheObject rawPut(CacheObject val, long ttl) {
        this.lockEntry();
        try {
            CacheObject old = this.val;
            this.update(val, CU.toExpireTime(ttl), ttl, this.nextVersion(), true);
            CacheObject cacheObject = old;
            return cacheObject;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initialValue(CacheObject val, final GridCacheVersion ver, MvccVersion mvccVer, MvccVersion newMvccVer, byte mvccTxState, byte newMvccTxState, long ttl, long expireTime, final boolean preload, AffinityTopologyVersion topVer, GridDrType drType, boolean fromStore, CacheDataRow row) throws IgniteCheckedException, GridCacheEntryRemovedException {
        GridCacheVersion oldVer;
        boolean obsolete;
        boolean deferred;
        block36: {
            boolean bl;
            block37: {
                block38: {
                    long oldExpTime;
                    boolean update;
                    this.ensureFreeSpace();
                    deferred = false;
                    obsolete = false;
                    oldVer = null;
                    this.lockListenerReadLock();
                    this.lockEntry();
                    this.checkObsolete();
                    boolean walEnabled = !this.cctx.isNear() && this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled();
                    long expTime = expireTime < 0L ? CU.toExpireTime(ttl) : expireTime;
                    val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
                    boolean unswapped = (this.flags & 2) != 0;
                    IgnitePredicate<CacheDataRow> p = new IgnitePredicate<CacheDataRow>(){

                        @Override
                        public boolean apply(@Nullable CacheDataRow row) {
                            GridCacheVersion currentVer = row != null ? row.version() : GridCacheMapEntry.this.ver;
                            boolean isStartVer = GridCacheMapEntry.this.cctx.shared().versions().isStartVersion(currentVer);
                            boolean update0 = GridCacheMapEntry.this.cctx.group().persistenceEnabled() ? (!isStartVer ? (GridCacheMapEntry.this.cctx.atomic() ? ATOMIC_VER_COMPARATOR.compare(currentVer, ver) < 0 : currentVer.compareTo(ver) < 0) : true) : isStartVer;
                            return update0 |= !preload && GridCacheMapEntry.this.deletedUnlocked();
                        }
                    };
                    if (unswapped) {
                        update = p.apply(null);
                        if (update) {
                            oldExpTime = this.expireTimeUnlocked();
                            if (oldExpTime > 0L && oldExpTime < U.currentTimeMillis() && this.onExpired(this.val, null)) {
                                if (this.cctx.deferredDelete()) {
                                    deferred = true;
                                    oldVer = this.ver;
                                } else if (val == null) {
                                    obsolete = true;
                                }
                            }
                            if (this.cctx.mvccEnabled()) {
                                assert (!preload);
                                this.cctx.offheap().mvccInitialValue(this, val, ver, expTime, mvccVer, newMvccVer);
                            } else {
                                this.storeValue(val, expTime, ver, null, row);
                            }
                        }
                    } else if (this.cctx.mvccEnabled()) {
                        this.unswap(false);
                        update = p.apply(null);
                        if (update) {
                            long delta;
                            oldExpTime = this.expireTimeUnlocked();
                            long l = delta = oldExpTime == 0L ? 0L : oldExpTime - U.currentTimeMillis();
                            if (delta < 0L && this.onExpired(this.val, null)) {
                                if (this.cctx.deferredDelete()) {
                                    deferred = true;
                                    oldVer = this.ver;
                                } else if (val == null) {
                                    obsolete = true;
                                }
                            }
                            assert (!preload);
                            this.cctx.offheap().mvccInitialValue(this, val, ver, expTime, mvccVer, newMvccVer);
                        }
                    } else {
                        update = this.storeValue(val, expTime, ver, p, row);
                    }
                    if (!update) break block36;
                    this.update(val, expTime, ttl, ver, true);
                    boolean skipQryNtf = false;
                    if (val == null) {
                        skipQryNtf = true;
                        if (this.cctx.deferredDelete() && !this.deletedUnlocked() && !this.isInternal()) {
                            this.deletedUnlocked(true);
                        }
                    } else if (this.deletedUnlocked()) {
                        this.deletedUnlocked(false);
                    }
                    long updateCntr = 0L;
                    if (!preload) {
                        updateCntr = this.nextPartitionCounter(topVer, true, true, null);
                    }
                    if (walEnabled) {
                        if (this.cctx.mvccEnabled()) {
                            this.cctx.shared().wal().log(new MvccDataRecord(new MvccDataEntry(this.cctx.cacheId(), this.key, val, val == null ? GridCacheOperation.DELETE : GridCacheOperation.CREATE, null, ver, expireTime, this.partition(), updateCntr, mvccVer == null ? MvccUtils.INITIAL_VERSION : mvccVer)));
                        } else {
                            this.cctx.shared().wal().log(new DataRecord(new DataEntry(this.cctx.cacheId(), this.key, val, val == null ? GridCacheOperation.DELETE : GridCacheOperation.CREATE, null, ver, expireTime, this.partition(), updateCntr)));
                        }
                    }
                    this.drReplicate(drType, val, ver, topVer);
                    if (!skipQryNtf) {
                        this.cctx.continuousQueries().onEntryUpdated(this.key, val, null, this.isInternal() || !this.context().userCache(), this.partition(), true, preload, updateCntr, null, topVer);
                    }
                    this.onUpdateFinished(updateCntr);
                    if (!fromStore && this.cctx.store().isLocal() && val != null) {
                        this.cctx.store().put(null, this.key, val, ver);
                    }
                    bl = true;
                    this.unlockEntry();
                    this.unlockListenerReadLock();
                    if (obsolete) {
                        this.onMarkedObsolete();
                        this.cctx.cache().removeEntry(this);
                    }
                    if (!deferred) break block37;
                    if ($assertionsDisabled || oldVer != null) break block38;
                    throw new AssertionError();
                }
                this.cctx.onDeferredDelete(this, oldVer);
            }
            return bl;
        }
        try {
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockEntry();
            this.unlockListenerReadLock();
            if (obsolete) {
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
            }
            if (deferred) {
                assert (oldVer != null);
                this.cctx.onDeferredDelete(this, oldVer);
            }
        }
    }

    protected void onUpdateFinished(long cntr) {
    }

    protected long nextPartitionCounter(AffinityTopologyVersion topVer, boolean primary, boolean initial, @Nullable Long primaryCntr) {
        return 0L;
    }

    protected long nextPartitionCounter(IgniteInternalTx tx, @Nullable Long updateCntr) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCacheVersionedEntryEx versionedEntry(boolean keepBinary) throws IgniteCheckedException, GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            boolean isNew = this.isStartVersion();
            if (isNew) {
                this.unswap(null, false);
            }
            CacheObject val = this.val;
            GridCacheLazyPlainVersionedEntry gridCacheLazyPlainVersionedEntry = new GridCacheLazyPlainVersionedEntry(this.cctx, this.key, val, this.ttlExtras(), this.expireTimeExtras(), this.ver.conflictVersion(), isNew, keepBinary);
            return gridCacheLazyPlainVersionedEntry;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public void clearReserveForLoad(GridCacheVersion ver) {
        this.lockEntry();
        try {
            if (this.obsoleteVersionExtras() != null) {
                return;
            }
            if (ver.equals(this.ver)) {
                assert (this.evictionDisabled()) : this;
                this.flags = (byte)(this.flags & 0xFFFFFFFB);
            }
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryGetResult versionedValue(CacheObject val, GridCacheVersion curVer, GridCacheVersion newVer, @Nullable IgniteCacheExpiryPolicy loadExpiryPlc, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            this.addReaderIfNeed(readerArgs);
            if (curVer == null || curVer.equals(this.ver)) {
                if (val != this.val) {
                    long expTime;
                    long ttl;
                    GridCacheMvcc mvcc = this.mvccExtras();
                    if (mvcc != null && !mvcc.isEmpty(new GridCacheVersion[0])) {
                        EntryGetResult entryGetResult = this.entryGetResult(this.val, this.ver, false);
                        return entryGetResult;
                    }
                    if (newVer == null) {
                        newVer = this.cctx.versions().next();
                    }
                    if (loadExpiryPlc != null) {
                        IgniteBiTuple<Long, Long> initTtlAndExpireTime = GridCacheMapEntry.initialTtlAndExpireTime(loadExpiryPlc);
                        ttl = initTtlAndExpireTime.get1();
                        expTime = initTtlAndExpireTime.get2();
                    } else {
                        ttl = this.ttlExtras();
                        expTime = this.expireTimeExtras();
                    }
                    val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
                    if (val != null) {
                        this.storeValue(val, expTime, newVer);
                        if (this.deletedUnlocked()) {
                            this.deletedUnlocked(false);
                        }
                    }
                    this.update(val, expTime, ttl, newVer, true);
                    EntryGetResult entryGetResult = this.entryGetResult(val, newVer, false);
                    return entryGetResult;
                }
                assert (!this.evictionDisabled()) : this;
            }
            EntryGetResult entryGetResult = this.entryGetResult(this.val, this.ver, false);
            return entryGetResult;
        }
        finally {
            this.unlockEntry();
        }
    }

    private void addReaderIfNeed(@Nullable ReaderArguments readerArgs) {
        block5: {
            if (readerArgs != null) {
                assert (this instanceof GridDhtCacheEntry) : this;
                assert (this.lock.isHeldByCurrentThread());
                try {
                    ((GridDhtCacheEntry)this).addReader(readerArgs.reader(), readerArgs.messageId(), readerArgs.topologyVersion());
                }
                catch (GridCacheEntryRemovedException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError(this);
                }
            }
        }
    }

    private GridCacheVersion nextVersion() {
        return this.cctx.versions().next(this.ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLockCandidate(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.hasCandidate(ver);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLockCandidate(long threadId) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.localCandidate(threadId) != null;
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedByAny(GridCacheVersion ... exclude) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && !mvcc.isEmpty(exclude);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public boolean lockedByThread() throws GridCacheEntryRemovedException {
        return this.lockedByThread(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedLocally(GridCacheVersion lockVer) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isLocallyOwned(lockVer);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedByThread(long threadId, GridCacheVersion exclude) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isLocallyOwnedByThread(threadId, false, exclude);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedLocallyByIdOrThread(GridCacheVersion lockVer, long threadId) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isLocallyOwnedByIdOrThread(lockVer, threadId);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedByThread(long threadId) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isLocallyOwnedByThread(threadId, true, new GridCacheVersion[0]);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedBy(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isOwnedBy(ver);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedByThreadUnsafe(long threadId) {
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isLocallyOwnedByThread(threadId, true, new GridCacheVersion[0]);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedByUnsafe(GridCacheVersion ver) {
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isOwnedBy(ver);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockedLocallyUnsafe(GridCacheVersion lockVer) {
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.isLocallyOwned(lockVer);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLockCandidateUnsafe(GridCacheVersion ver) {
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            boolean bl = mvcc != null && mvcc.hasCandidate(ver);
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GridCacheMvccCandidate> localCandidates(GridCacheVersion ... exclude) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            List<GridCacheMvccCandidate> list = mvcc == null ? Collections.emptyList() : mvcc.localCandidates(exclude);
            return list;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public Collection<GridCacheMvccCandidate> remoteMvccSnapshot(GridCacheVersion ... exclude) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GridCacheMvccCandidate candidate(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = mvcc == null ? null : mvcc.candidate(ver);
            return gridCacheMvccCandidate;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheMvccCandidate localCandidate(long threadId) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = mvcc == null ? null : mvcc.localCandidate(threadId);
            return gridCacheMvccCandidate;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheMvccCandidate candidate(UUID nodeId, long threadId) throws GridCacheEntryRemovedException {
        boolean loc = this.cctx.nodeId().equals(nodeId);
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = mvcc == null ? null : (loc ? mvcc.localCandidate(threadId) : mvcc.remoteCandidate(nodeId, threadId));
            return gridCacheMvccCandidate;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public GridCacheMvccCandidate localOwner() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = mvcc == null ? null : mvcc.localOwner();
            return gridCacheMvccCandidate;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public long rawExpireTime() {
        this.lockEntry();
        try {
            long l = this.expireTimeExtras();
            return l;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public long expireTimeUnlocked() {
        assert (this.lock.isHeldByCurrentThread());
        return this.expireTimeExtras();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTtlExpired(GridCacheVersion obsoleteVer) throws GridCacheEntryRemovedException {
        assert (obsoleteVer != null);
        boolean obsolete = false;
        boolean deferred = false;
        GridCacheVersion ver0 = null;
        this.lockEntry();
        try {
            long expireTime;
            this.checkObsolete();
            if (this.isStartVersion()) {
                this.unswap(null, false);
            }
            if ((expireTime = this.expireTimeExtras()) <= 0L || expireTime > U.currentTimeMillis()) {
                boolean bl = false;
                return bl;
            }
            CacheObject expiredVal = this.val;
            if (expiredVal == null) {
                boolean bl = false;
                return bl;
            }
            if (this.onExpired(expiredVal, obsoleteVer)) {
                if (this.cctx.deferredDelete()) {
                    deferred = true;
                    ver0 = this.ver;
                } else {
                    obsolete = true;
                }
            }
            this.unlockEntry();
            if (obsolete) {
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
            }
            if (deferred) {
                assert (ver0 != null);
                this.cctx.onDeferredDelete(this, ver0);
            }
            if ((obsolete || deferred) && this.cctx.statisticsEnabled()) {
                this.cctx.cache().metrics0().onEvict();
            }
        }
        catch (NodeStoppingException ignore) {
            if (log.isDebugEnabled()) {
                log.warning("Node is stopping while removing expired value.", ignore);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to clean up expired cache entry: " + this, e);
        }
        finally {
            this.unlockEntry();
            if (obsolete) {
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
            }
            if (deferred) {
                assert (ver0 != null);
                this.cctx.onDeferredDelete(this, ver0);
            }
            if ((obsolete || deferred) && this.cctx.statisticsEnabled()) {
                this.cctx.cache().metrics0().onEvict();
            }
        }
        return true;
    }

    private boolean onExpired(CacheObject expiredVal, GridCacheVersion obsoleteVer) throws IgniteCheckedException {
        assert (expiredVal != null);
        boolean rmvd = false;
        if (this.mvccExtras() != null) {
            return false;
        }
        if (this.cctx.deferredDelete() && !this.detached() && !this.isInternal()) {
            if (!this.deletedUnlocked() && !this.isStartVersion()) {
                this.update(null, 0L, 0L, this.ver, true);
                this.deletedUnlocked(true);
                rmvd = true;
            }
        } else {
            if (obsoleteVer == null) {
                obsoleteVer = this.nextVersion();
            }
            if (this.markObsolete0(obsoleteVer, true, null)) {
                rmvd = true;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("onExpired clear [key=" + this.key + ", entry=" + System.identityHashCode(this) + ']');
        }
        if (this.cctx.mvccEnabled()) {
            this.cctx.offheap().mvccRemoveAll(this);
        } else {
            this.removeValue();
        }
        if (this.cctx.events().isRecordable(70)) {
            this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, 70, null, false, expiredVal, expiredVal != null, null, null, null, true);
        }
        this.cctx.continuousQueries().onEntryExpired(this, this.key, expiredVal);
        return rmvd;
    }

    @Override
    public long rawTtl() {
        this.lockEntry();
        try {
            long l = this.ttlExtras();
            return l;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long expireTime() throws GridCacheEntryRemovedException {
        long time;
        IgniteTxLocalAdapter tx = this.currentTx();
        if (tx != null && (time = tx.entryExpireTime(this.txKey())) > 0L) {
            return time;
        }
        this.lockEntry();
        try {
            this.checkObsolete();
            long l = this.expireTimeExtras();
            return l;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ttl() throws GridCacheEntryRemovedException {
        long entryTtl;
        IgniteTxLocalAdapter tx = this.currentTx();
        if (tx != null && (entryTtl = tx.entryTtl(this.txKey())) > 0L) {
            return entryTtl;
        }
        this.lockEntry();
        try {
            this.checkObsolete();
            long l = this.ttlExtras();
            return l;
        }
        finally {
            this.unlockEntry();
        }
    }

    private IgniteTxLocalAdapter currentTx() {
        return this.cctx.tm().localTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTtl(@Nullable GridCacheVersion ver, long ttl) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            if (this.hasValueUnlocked()) {
                try {
                    this.updateTtl(ttl);
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Failed to update TTL: " + e, e);
                }
            }
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public CacheObject valueBytes() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            CacheObject cacheObject = this.val;
            return cacheObject;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    @Nullable
    public CacheObject valueBytes(@Nullable GridCacheVersion ver) throws IgniteCheckedException, GridCacheEntryRemovedException {
        CacheObject val = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            if (ver == null || this.ver.equals(ver)) {
                val = this.val;
            }
        }
        finally {
            this.unlockEntry();
        }
        return val;
    }

    protected boolean storeValue(@Nullable CacheObject val, long expireTime, GridCacheVersion ver) throws IgniteCheckedException {
        return this.storeValue(val, expireTime, ver, null, null);
    }

    protected boolean storeValue(@Nullable CacheObject val, long expireTime, GridCacheVersion ver, @Nullable IgnitePredicate<CacheDataRow> predicate, @Nullable CacheDataRow row) throws IgniteCheckedException {
        assert (this.lock.isHeldByCurrentThread());
        assert (this.localPartition() == null || this.localPartition().state() != GridDhtPartitionState.RENTING) : this.localPartition();
        UpdateClosure closure = new UpdateClosure(this, val, ver, expireTime, predicate, row);
        this.cctx.offheap().invoke(this.cctx, this.key, this.localPartition(), closure);
        return closure.treeOp != IgniteTree.OperationType.NOOP;
    }

    protected void logUpdate(GridCacheOperation op, CacheObject val, GridCacheVersion writeVer, long expireTime, long updCntr) throws IgniteCheckedException {
        assert (this.cctx.atomic());
        try {
            if (this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled()) {
                this.cctx.shared().wal().log(new DataRecord(new DataEntry(this.cctx.cacheId(), this.key, val, op, null, writeVer, expireTime, this.partition(), updCntr)));
            }
        }
        catch (StorageException e) {
            throw new IgniteCheckedException("Failed to log ATOMIC cache update [key=" + this.key + ", op=" + (Object)((Object)op) + ", val=" + val + ']', e);
        }
    }

    protected WALPointer logTxUpdate(IgniteInternalTx tx, CacheObject val, long expireTime, long updCntr) throws IgniteCheckedException {
        assert (this.cctx.transactional() && !this.cctx.transactionalSnapshot());
        if (tx.local()) {
            GridCacheOperation op = val == null ? GridCacheOperation.DELETE : (this.val == null ? GridCacheOperation.CREATE : GridCacheOperation.UPDATE);
            return this.cctx.shared().wal().log(new DataRecord(new DataEntry(this.cctx.cacheId(), this.key, val, op, tx.nearXidVersion(), tx.writeVersion(), expireTime, this.key.partition(), updCntr)));
        }
        return null;
    }

    protected WALPointer logMvccUpdate(IgniteInternalTx tx, CacheObject val, long expireTime, long updCntr, MvccSnapshot mvccVer) throws IgniteCheckedException {
        assert (mvccVer != null);
        assert (this.cctx.transactionalSnapshot());
        if (tx.local()) {
            GridCacheOperation op = val == null ? GridCacheOperation.DELETE : (this.val == null ? GridCacheOperation.CREATE : GridCacheOperation.UPDATE);
            return this.cctx.shared().wal().log(new MvccDataRecord(new MvccDataEntry(this.cctx.cacheId(), this.key, val, op, tx.nearXidVersion(), tx.writeVersion(), expireTime, this.key.partition(), updCntr, mvccVer)));
        }
        return null;
    }

    protected void removeValue() throws IgniteCheckedException {
        assert (this.lock.isHeldByCurrentThread());
        this.cctx.offheap().remove(this.cctx, this.key, this.partition(), this.localPartition());
    }

    @Override
    public <K, V> Cache.Entry<K, V> wrap() {
        try {
            GridTuple<CacheObject> peek;
            GridNearTxLocal tx = this.cctx.tm().userTx();
            CacheObject val = tx != null ? ((peek = tx.peek(this.cctx, false, this.key)) == null ? this.rawGet() : peek.get()) : this.rawGet();
            return new CacheEntryImpl(this.key.value(this.cctx.cacheObjectContext(), false), CU.value(val, this.cctx, false), this.ver);
        }
        catch (GridCacheFilterFailedException ignored) {
            throw new IgniteException("Should never happen.");
        }
    }

    @Override
    public <K, V> Cache.Entry<K, V> wrapLazyValue(boolean keepBinary) {
        return new LazyValueEntry(this.key, keepBinary);
    }

    @Override
    @Nullable
    public CacheObject peekVisibleValue() {
        try {
            GridTuple<CacheObject> peek;
            GridNearTxLocal tx = this.cctx.tm().userTx();
            if (tx != null && (peek = tx.peek(this.cctx, false, this.key)) != null) {
                return peek.get();
            }
            if (this.detached()) {
                return this.rawGet();
            }
            while (true) {
                GridCacheEntryEx e;
                if ((e = this.cctx.cache().peekEx(this.key)) == null) {
                    return null;
                }
                try {
                    return e.peek();
                }
                catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                    continue;
                }
                catch (IgniteCheckedException ex) {
                    throw new IgniteException(ex);
                }
                break;
            }
        }
        catch (GridCacheFilterFailedException ignored) {
            throw new IgniteException("Should never happen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndex(SchemaIndexCacheFilter filter, SchemaIndexCacheVisitorClosure clo) throws IgniteCheckedException, GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            if (this.isInternal()) {
                return;
            }
            this.checkObsolete();
            CacheDataRow row = this.cctx.offheap().read(this);
            if (row != null && (filter == null || filter.apply(row))) {
                clo.apply(row);
            }
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public <K, V> EvictableEntry<K, V> wrapEviction() {
        return new CacheEvictableEntryImpl(this);
    }

    @Override
    public <K, V> CacheEntryImplEx<K, V> wrapVersioned() {
        this.lockEntry();
        try {
            CacheEntryImplEx cacheEntryImplEx = new CacheEntryImplEx(this.key.value(this.cctx.cacheObjectContext(), false), null, this.ver);
            return cacheEntryImplEx;
        }
        finally {
            this.unlockEntry();
        }
    }

    private void ensureFreeSpace() throws IgniteCheckedException {
        assert (!this.lock.isHeldByCurrentThread());
        this.cctx.shared().database().ensureFreeSpace(this.cctx.dataRegion());
    }

    private <K, V> CacheEntryImplEx<K, V> wrapVersionedWithValue() {
        this.lockEntry();
        try {
            Object val = this.val == null ? null : (Object)this.val.value(this.cctx.cacheObjectContext(), false);
            CacheEntryImplEx cacheEntryImplEx = new CacheEntryImplEx(this.key.value(this.cctx.cacheObjectContext(), false), val, this.ver);
            return cacheEntryImplEx;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evictInternal(GridCacheVersion obsoleteVer, @Nullable CacheEntryPredicate[] filter, boolean evictOffheap) throws IgniteCheckedException {
        block45: {
            boolean marked = false;
            try {
                block50: {
                    block49: {
                        if (F.isEmptyOrNulls(filter)) {
                            this.lockEntry();
                            try {
                                if (this.evictionDisabled()) {
                                    assert (!this.obsolete());
                                    boolean bl = false;
                                    return bl;
                                }
                                if (this.obsoleteVersionExtras() != null) {
                                    boolean bl = true;
                                    return bl;
                                }
                                if (this.cctx.deferredDelete() && this.deletedUnlocked()) {
                                    boolean bl = false;
                                    return bl;
                                }
                                if (!this.hasReaders() && this.markObsolete0(obsoleteVer, false, null)) {
                                    this.value(null);
                                    if (evictOffheap) {
                                        this.removeValue();
                                    }
                                    marked = true;
                                    boolean bl = true;
                                    return bl;
                                }
                                break block45;
                            }
                            finally {
                                this.unlockEntry();
                            }
                        }
                        while (true) {
                            GridCacheVersion v;
                            block48: {
                                block47: {
                                    this.lockEntry();
                                    try {
                                        v = this.ver;
                                    }
                                    finally {
                                        this.unlockEntry();
                                    }
                                    if (!this.cctx.isAll(this, filter)) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    this.lockEntry();
                                    if (!this.evictionDisabled()) break block47;
                                    assert (!this.obsolete());
                                    boolean bl = false;
                                    this.unlockEntry();
                                    return bl;
                                }
                                if (this.obsoleteVersionExtras() == null) break block48;
                                boolean bl = true;
                                this.unlockEntry();
                                return bl;
                            }
                            if (v.equals(this.ver)) break;
                            this.unlockEntry();
                            continue;
                            break;
                        }
                        try {
                            if (!this.cctx.deferredDelete() || !this.deletedUnlocked()) break block49;
                            boolean bl = false;
                            this.unlockEntry();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            try {
                                this.unlockEntry();
                                throw throwable;
                            }
                            catch (GridCacheEntryRemovedException ignore) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Got removed entry when evicting (will simply return): " + this);
                                }
                                boolean bl = true;
                                return bl;
                            }
                            finally {
                            }
                        }
                    }
                    if (this.hasReaders() || !this.markObsolete0(obsoleteVer, false, null)) break block50;
                    this.value(null);
                    if (evictOffheap) {
                        this.removeValue();
                    }
                    marked = true;
                    boolean bl = true;
                    this.unlockEntry();
                    return bl;
                }
                boolean bl = false;
                this.unlockEntry();
                return bl;
            }
            finally {
                if (marked) {
                    this.onMarkedObsolete();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean visitable(CacheEntryPredicate[] filter) {
        boolean rmv = false;
        try {
            this.lockEntry();
            try {
                if (this.obsoleteOrDeleted()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.checkExpired()) {
                    rmv = this.markObsolete0(this.cctx.versions().next(this.ver), true, null);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.unlockEntry();
            }
            if (filter != CU.empty0() && !this.cctx.isAll(this, filter)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IgniteCheckedException e) {
            U.error(log, "An exception was thrown while filter checking.", e);
            RuntimeException ex = e.getCause(RuntimeException.class);
            if (ex != null) {
                throw ex;
            }
            Error err = e.getCause(Error.class);
            if (err != null) {
                throw err;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (rmv) {
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
            }
        }
        IgniteTxLocalAdapter tx = this.cctx.tm().localTx();
        if (tx != null) {
            IgniteTxEntry e = tx.entry(this.txKey());
            boolean rmvd = e != null && e.op() == GridCacheOperation.DELETE;
            return !rmvd;
        }
        return true;
    }

    @Override
    public final boolean deleted() {
        if (!this.cctx.deferredDelete()) {
            return false;
        }
        this.lockEntry();
        try {
            boolean bl = this.deletedUnlocked();
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public final boolean obsoleteOrDeleted() {
        this.lockEntry();
        try {
            boolean bl = this.obsoleteVersionExtras() != null || this.cctx.deferredDelete() && (this.deletedUnlocked() || !this.hasValueUnlocked());
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    protected final boolean deletedUnlocked() {
        assert (this.lock.isHeldByCurrentThread());
        if (!this.cctx.deferredDelete()) {
            return false;
        }
        return (this.flags & 1) != 0;
    }

    protected final void deletedUnlocked(boolean deleted) {
        assert (this.lock.isHeldByCurrentThread());
        assert (this.cctx.deferredDelete());
        if (deleted) {
            assert (!this.deletedUnlocked()) : this;
            this.flags = (byte)(this.flags | 1);
            this.decrementMapPublicSize();
        } else {
            assert (this.deletedUnlocked()) : this;
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.incrementMapPublicSize();
        }
    }

    protected void incrementMapPublicSize() {
        GridDhtLocalPartition locPart = this.localPartition();
        if (locPart != null) {
            locPart.incrementPublicSize(null, this);
        } else {
            this.cctx.incrementPublicSize(this);
        }
    }

    protected void decrementMapPublicSize() {
        GridDhtLocalPartition locPart = this.localPartition();
        if (locPart != null) {
            locPart.decrementPublicSize(null, this);
        } else {
            this.cctx.decrementPublicSize(this);
        }
    }

    @Nullable
    protected final GridCacheMvcc mvccExtras() {
        return this.extras != null ? this.extras.mvcc() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<GridCacheMvccCandidate> mvccAllLocal() {
        this.lockEntry();
        try {
            GridCacheMvcc mvcc;
            GridCacheMvcc gridCacheMvcc = mvcc = this.extras != null ? this.extras.mvcc() : null;
            if (mvcc == null) {
                List<GridCacheMvccCandidate> list = null;
                return list;
            }
            List<GridCacheMvccCandidate> allLocs = mvcc.allLocal();
            if (allLocs == null || allLocs.isEmpty()) {
                List<GridCacheMvccCandidate> list = null;
                return list;
            }
            ArrayList<GridCacheMvccCandidate> locs = new ArrayList<GridCacheMvccCandidate>(allLocs.size());
            for (int i = 0; i < allLocs.size(); ++i) {
                GridCacheMvccCandidate loc = allLocs.get(i);
                if (loc.nearLocal()) continue;
                locs.add(loc);
            }
            ArrayList<GridCacheMvccCandidate> arrayList = locs.isEmpty() ? null : locs;
            return arrayList;
        }
        finally {
            this.unlockEntry();
        }
    }

    protected final void mvccExtras(@Nullable GridCacheMvcc mvcc) {
        this.extras = this.extras != null ? this.extras.mvcc(mvcc) : (mvcc != null ? new GridCacheMvccEntryExtras(mvcc) : null);
    }

    @Nullable
    protected final GridCacheVersion obsoleteVersionExtras() {
        return this.extras != null ? this.extras.obsoleteVersion() : null;
    }

    private void obsoleteVersionExtras(@Nullable GridCacheVersion obsoleteVer, GridCacheObsoleteEntryExtras ext) {
        this.extras = this.extras != null ? this.extras.obsoleteVersion(obsoleteVer) : (obsoleteVer != null ? (ext != null ? ext : new GridCacheObsoleteEntryExtras(obsoleteVer)) : null);
    }

    protected final void checkOwnerChanged(@Nullable CacheLockCandidates prevOwners, @Nullable CacheLockCandidates owners, CacheObject val) {
        this.checkOwnerChanged(prevOwners, owners, val, false);
    }

    protected final void checkOwnerChanged(@Nullable CacheLockCandidates prevOwners, @Nullable CacheLockCandidates owners, CacheObject val, boolean inThreadChain) {
        assert (!this.lock.isHeldByCurrentThread());
        if (prevOwners != null && owners == null) {
            this.cctx.mvcc().callback().onOwnerChanged(this, null);
            if (this.cctx.events().isRecordable(67)) {
                boolean hasVal = this.hasValue();
                GridCacheMvccCandidate cand = prevOwners.candidate(0);
                this.cctx.events().addEvent(this.partition(), this.key, cand.nodeId(), cand, 67, val, hasVal, val, hasVal, null, null, null, true);
            }
        }
        if (owners != null) {
            for (int i = 0; i < owners.size(); ++i) {
                boolean locked;
                GridCacheMvccCandidate owner = owners.candidate(i);
                boolean bl = locked = prevOwners == null || !prevOwners.hasCandidate(owner.version());
                if (!locked) continue;
                this.cctx.mvcc().callback().onOwnerChanged(this, owner);
                if (owner.local() && !inThreadChain) {
                    this.checkThreadChain(owner);
                }
                if (!this.cctx.events().isRecordable(66)) continue;
                boolean hasVal = this.hasValue();
                this.cctx.events().addEvent(this.partition(), this.key, owner.nodeId(), owner, 66, val, hasVal, val, hasVal, null, null, null, true);
            }
        }
    }

    protected abstract void checkThreadChain(GridCacheMvccCandidate var1);

    private void updateMetrics(GridCacheOperation op, boolean metrics, boolean transformed, boolean hasOldVal) {
        if (metrics && this.cctx.statisticsEnabled()) {
            if (op == GridCacheOperation.DELETE) {
                this.cctx.cache().metrics0().onRemove();
                if (transformed) {
                    this.cctx.cache().metrics0().onInvokeRemove(hasOldVal);
                }
            } else if (op == GridCacheOperation.READ && transformed) {
                this.cctx.cache().metrics0().onReadOnlyInvoke(hasOldVal);
            } else {
                this.cctx.cache().metrics0().onWrite();
                if (transformed) {
                    this.cctx.cache().metrics0().onInvokeUpdate(hasOldVal);
                }
            }
        }
    }

    public long ttlExtras() {
        return this.extras != null ? this.extras.ttl() : 0L;
    }

    public long expireTimeExtras() {
        return this.extras != null ? this.extras.expireTime() : 0L;
    }

    protected void ttlAndExpireTimeExtras(long ttl, long expireTime) {
        assert (ttl != -1L && ttl != -2L);
        this.extras = this.extras != null ? this.extras.ttlAndExpireTime(ttl, expireTime) : (expireTime != 0L ? new GridCacheTtlEntryExtras(ttl, expireTime) : null);
    }

    private int extrasSize() {
        return this.extras != null ? this.extras.size() : 0;
    }

    @Override
    public void txUnlock(IgniteInternalTx tx) throws GridCacheEntryRemovedException {
        this.removeLock(tx.xidVersion());
    }

    @Override
    public void onUnlock() {
    }

    @Override
    public void lockEntry() {
        this.lock.lock();
    }

    @Override
    public void unlockEntry() {
        this.lock.unlock();
    }

    private void lockListenerReadLock() {
        this.listenerLock.readLock().lock();
    }

    private void unlockListenerReadLock() {
        this.listenerLock.readLock().unlock();
    }

    @Override
    public boolean lockedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    @Override
    public void touch() {
        this.context().evicts().touch(this);
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        this.lockEntry();
        try {
            String string = S.toString(GridCacheMapEntry.class, this);
            return string;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheUpdateTxResult mvccUpdateRowsWithPreloadInfo(IgniteInternalTx tx, UUID affNodeId, AffinityTopologyVersion topVer, List<GridCacheEntryInfo> entries, GridCacheOperation op, MvccSnapshot mvccVer, IgniteUuid futId, int batchNum) throws IgniteCheckedException, GridCacheEntryRemovedException {
        assert (mvccVer != null && MvccUtils.mvccVersionIsValid(mvccVer.coordinatorVersion(), mvccVer.counter(), mvccVer.operationCounter()));
        assert (!F.isEmpty(entries));
        WALPointer logPtr = null;
        this.ensureFreeSpace();
        CacheObject val = null;
        CacheObject oldVal = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            boolean walEnabled = this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled();
            List walEntries = walEnabled ? new ArrayList(entries.size() + 1) : Collections.EMPTY_LIST;
            for (int i = 0; i < entries.size(); ++i) {
                GridCacheMvccEntryInfo info = (GridCacheMvccEntryInfo)entries.get(i);
                assert (info.mvccTxState() == 3 || MvccUtils.compare(info, mvccVer.coordinatorVersion(), mvccVer.counter()) == 0);
                assert (info.newMvccTxState() == 3 || MvccUtils.compareNewVersion(info, mvccVer.coordinatorVersion(), mvccVer.counter()) == 0 || info.newMvccCoordinatorVersion() == 0L);
                boolean added = this.cctx.offheap().mvccUpdateRowWithPreloadInfo(this, info.value(), info.version(), info.expireTime(), info.mvccVersion(), info.newMvccVersion(), info.mvccTxState(), info.newMvccTxState());
                if (walEnabled) {
                    walEntries.add(this.toMvccDataEntry(info, tx));
                }
                if (oldVal == null && MvccUtils.compare(info.mvccVersion(), mvccVer.coordinatorVersion(), mvccVer.counter()) != 0 && MvccUtils.compareNewVersion(info, mvccVer.coordinatorVersion(), mvccVer.counter()) == 0) {
                    oldVal = info.value();
                }
                if (!added) break;
            }
            GridCacheMvccEntryInfo last = (GridCacheMvccEntryInfo)entries.get(0);
            if (walEnabled) {
                Collections.reverse(walEntries);
            }
            if (op == GridCacheOperation.DELETE) {
                assert (MvccUtils.compareNewVersion(last, mvccVer) == 0);
                if (walEnabled) {
                    walEntries.add(new MvccDataEntry(this.cctx.cacheId(), this.key, null, GridCacheOperation.DELETE, tx.nearXidVersion(), last.version(), last.expireTime(), this.key.partition(), 0L, last.mvccVersion()));
                }
            } else {
                assert (last.newMvccCoordinatorVersion() == 0L);
                assert (MvccUtils.compare(last, mvccVer) == 0);
                val = last.value();
            }
            if (walEnabled) {
                logPtr = this.cctx.shared().wal().log(new MvccDataRecord(walEntries));
            }
        }
        finally {
            if (this.lockedByCurrentThread()) {
                this.unlockEntry();
                this.cctx.evicts().touch(this);
            }
        }
        GridCacheUpdateTxResult res = new GridCacheUpdateTxResult(true, logPtr);
        res.newValue(val);
        res.oldValue(oldVal);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mvccPreloadEntry(List<GridCacheMvccEntryInfo> entryHist) throws IgniteCheckedException, GridCacheEntryRemovedException {
        assert (!entryHist.isEmpty());
        WALPointer logPtr = null;
        this.ensureFreeSpace();
        boolean updated = false;
        this.lockEntry();
        try {
            this.checkObsolete();
            this.key.valueBytes(this.cctx.cacheObjectContext());
            if (this.cctx.offheap().mvccApplyHistoryIfAbsent(this, entryHist)) {
                updated = true;
                if (!this.cctx.isNear() && this.cctx.group().persistenceEnabled() && this.cctx.group().walEnabled()) {
                    MvccDataRecord rec;
                    if (entryHist.size() == 1) {
                        GridCacheMvccEntryInfo info = entryHist.get(0);
                        rec = new MvccDataRecord(this.toMvccDataEntry(info, null));
                    } else {
                        ArrayList<DataEntry> dataEntries = new ArrayList<DataEntry>(entryHist.size());
                        for (GridCacheMvccEntryInfo info : entryHist) {
                            dataEntries.add(this.toMvccDataEntry(info, null));
                        }
                        rec = new MvccDataRecord(dataEntries);
                    }
                    logPtr = this.cctx.shared().wal().log(rec);
                }
            }
        }
        finally {
            if (this.lockedByCurrentThread()) {
                this.unlockEntry();
                this.cctx.evicts().touch(this);
            }
        }
        if (logPtr != null) {
            this.cctx.shared().wal().flush(logPtr, false);
        }
        return updated;
    }

    @NotNull
    private MvccDataEntry toMvccDataEntry(@NotNull GridCacheMvccEntryInfo info, @Nullable IgniteInternalTx tx) {
        return new MvccDataEntry(this.cctx.cacheId(), this.key, info.value(), GridCacheOperation.CREATE, tx == null ? null : tx.nearXidVersion(), info.version(), info.expireTime(), this.key.partition(), 0L, info.mvccVersion());
    }

    private static IgniteTxSerializationCheckedException serializationError() {
        return new IgniteTxSerializationCheckedException("Cannot serialize transaction due to write conflict (transaction is marked for rollback)");
    }

    private static class AtomicCacheUpdateClosure
    implements IgniteCacheOffheapManager.OffheapInvokeClosure {
        private final GridCacheMapEntry entry;
        private final AffinityTopologyVersion topVer;
        private GridCacheVersion newVer;
        private GridCacheOperation op;
        private Object writeObj;
        private Object[] invokeArgs;
        private final boolean readThrough;
        private final boolean writeThrough;
        private final boolean keepBinary;
        private final IgniteCacheExpiryPolicy expiryPlc;
        private final boolean primary;
        private final boolean verCheck;
        private final CacheEntryPredicate[] filter;
        private final long explicitTtl;
        private final long explicitExpireTime;
        private GridCacheVersion conflictVer;
        private final boolean conflictResolve;
        private final boolean intercept;
        private final Long updateCntr;
        private final boolean skipInterceptorOnConflict;
        private GridCacheUpdateAtomicResult updateRes;
        private IgniteTree.OperationType treeOp;
        private CacheDataRow newRow;
        private CacheDataRow oldRow;
        private boolean oldRowExpiredFlag;
        private boolean wasIntercepted;

        AtomicCacheUpdateClosure(GridCacheMapEntry entry, AffinityTopologyVersion topVer, GridCacheVersion newVer, GridCacheOperation op, Object writeObj, Object[] invokeArgs, boolean readThrough, boolean writeThrough, boolean keepBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean primary, boolean verCheck, @Nullable CacheEntryPredicate[] filter, long explicitTtl, long explicitExpireTime, @Nullable GridCacheVersion conflictVer, boolean conflictResolve, boolean intercept, @Nullable Long updateCntr, boolean skipInterceptorOnConflict) {
            assert (op == GridCacheOperation.UPDATE || op == GridCacheOperation.DELETE || op == GridCacheOperation.TRANSFORM) : op;
            this.entry = entry;
            this.topVer = topVer;
            this.newVer = newVer;
            this.op = op;
            this.writeObj = writeObj;
            this.invokeArgs = invokeArgs;
            this.readThrough = readThrough;
            this.writeThrough = writeThrough;
            this.keepBinary = keepBinary;
            this.expiryPlc = expiryPlc;
            this.primary = primary;
            this.verCheck = verCheck;
            this.filter = filter;
            this.explicitTtl = explicitTtl;
            this.explicitExpireTime = explicitExpireTime;
            this.conflictVer = conflictVer;
            this.conflictResolve = conflictResolve;
            this.intercept = intercept;
            this.updateCntr = updateCntr;
            this.skipInterceptorOnConflict = skipInterceptorOnConflict;
            switch (op) {
                case UPDATE: {
                    this.treeOp = IgniteTree.OperationType.PUT;
                    break;
                }
                case DELETE: {
                    this.treeOp = IgniteTree.OperationType.REMOVE;
                }
            }
        }

        @Override
        @Nullable
        public CacheDataRow oldRow() {
            return this.oldRow;
        }

        @Override
        public CacheDataRow newRow() {
            return this.newRow;
        }

        @Override
        public IgniteTree.OperationType operationType() {
            return this.treeOp;
        }

        @Override
        public void call(@Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            boolean pass;
            CacheObject oldVal;
            assert (this.entry.isNear() || oldRow == null || oldRow.link() != 0L) : oldRow;
            GridCacheContext cctx = this.entry.context();
            CacheObject storeLoadedVal = null;
            this.oldRow = oldRow;
            if (oldRow != null) {
                oldRow.key(this.entry.key());
                this.entry.update(oldRow.value(), oldRow.expireTime(), 0L, oldRow.version(), false);
                if (this.checkRowExpired(oldRow)) {
                    this.oldRowExpiredFlag = true;
                    oldRow = null;
                }
            }
            CacheObject cacheObject = oldVal = oldRow != null ? oldRow.value() : null;
            if (oldVal == null && this.readThrough) {
                storeLoadedVal = cctx.toCacheObject(cctx.store().load(null, this.entry.key));
                if (storeLoadedVal != null) {
                    this.entry.val = oldVal = cctx.kernalContext().cacheObjects().prepareForCache(storeLoadedVal, cctx);
                    if (this.entry.deletedUnlocked()) {
                        this.entry.deletedUnlocked(false);
                    }
                }
            } else if (oldVal != null && this.entry.deletedUnlocked()) {
                this.entry.deletedUnlocked(false);
            }
            CacheInvokeEntry<Object, Object> invokeEntry = null;
            IgniteBiTuple<Object, Exception> invokeRes = null;
            boolean invoke = this.op == GridCacheOperation.TRANSFORM;
            boolean transformed = false;
            if (invoke) {
                invokeEntry = new CacheInvokeEntry<Object, Object>(this.entry.key, oldVal, this.entry.ver, this.keepBinary, this.entry);
                invokeRes = this.runEntryProcessor(invokeEntry);
                this.op = this.writeObj == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE;
                transformed = true;
            }
            CacheObject newVal = (CacheObject)this.writeObj;
            GridCacheVersionConflictContext<?, ?> conflictCtx = null;
            if (this.conflictResolve) {
                conflictCtx = this.resolveConflict(newVal, invokeRes);
                if (this.updateRes != null) {
                    assert (conflictCtx != null && conflictCtx.isUseOld()) : conflictCtx;
                    assert (this.treeOp == IgniteTree.OperationType.NOOP) : this.treeOp;
                    return;
                }
            }
            if (conflictCtx == null) {
                this.versionCheck(invokeRes);
                if (this.updateRes != null) {
                    assert (this.treeOp == IgniteTree.OperationType.NOOP) : this.treeOp;
                    return;
                }
            }
            if (!F.isEmptyOrNulls(this.filter) && !(pass = cctx.isAllLocked(this.entry, this.filter))) {
                this.initResultOnCancelUpdate(storeLoadedVal, !cctx.putIfAbsentFilter(this.filter));
                this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.FILTER_FAILED, oldVal, null, invokeRes, 0L, 0L, null, null, 0L, false);
                return;
            }
            if (invoke) {
                if (!invokeEntry.modified()) {
                    this.initResultOnCancelUpdate(storeLoadedVal, true);
                    this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.INVOKE_NO_OP, oldVal, null, invokeRes, 0L, 0L, null, null, 0L, true);
                    return;
                }
                if ((invokeRes == null || invokeRes.getValue() == null) && this.writeObj != null) {
                    try {
                        cctx.validateKeyAndValue(this.entry.key, (CacheObject)this.writeObj);
                    }
                    catch (Exception e) {
                        this.initResultOnCancelUpdate(null, true);
                        this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.INVOKE_NO_OP, oldVal, null, new IgniteBiTuple<Object, Exception>(null, e), 0L, 0L, null, null, 0L, false);
                        return;
                    }
                }
                GridCacheOperation gridCacheOperation = this.op = this.writeObj == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE;
            }
            if (this.conflictVer != null && this.conflictVer != this.newVer) {
                this.newVer = new GridCacheVersionEx(this.newVer.topologyVersion(), this.newVer.order(), this.newVer.nodeOrder(), this.newVer.dataCenterId(), this.conflictVer);
            }
            if (this.op == GridCacheOperation.UPDATE) {
                assert (this.writeObj != null);
                this.update(conflictCtx, invokeRes, storeLoadedVal != null, transformed);
            } else {
                assert (this.op == GridCacheOperation.DELETE && this.writeObj == null) : this.op;
                this.remove(conflictCtx, invokeRes, storeLoadedVal != null, transformed);
            }
            assert (this.updateRes != null && this.treeOp != null);
        }

        private boolean checkRowExpired(CacheDataRow row) throws IgniteCheckedException {
            assert (row != null);
            if (row.expireTime() <= 0L || row.expireTime() > U.currentTimeMillis()) {
                return false;
            }
            GridCacheContext cctx = this.entry.context();
            CacheObject expiredVal = row.value();
            if (cctx.deferredDelete() && !this.entry.detached() && !this.entry.isInternal()) {
                this.entry.update(null, 0L, 0L, this.entry.ver, true);
                if (!this.entry.deletedUnlocked()) {
                    this.entry.deletedUnlocked(true);
                }
            } else {
                this.entry.markObsolete0(cctx.versions().next(), true, null);
            }
            if (cctx.events().isRecordable(70)) {
                cctx.events().addEvent(this.entry.partition(), this.entry.key(), cctx.localNodeId(), null, 70, null, false, expiredVal, expiredVal != null, null, null, null, true);
            }
            cctx.continuousQueries().onEntryExpired(this.entry, this.entry.key(), expiredVal);
            return true;
        }

        private void initResultOnCancelUpdate(@Nullable CacheObject storeLoadedVal, boolean updateExpireTime) throws IgniteCheckedException {
            long ttl;
            boolean needUpdate = false;
            if (storeLoadedVal != null) {
                long initExpireTime;
                long initTtl;
                if (this.expiryPlc != null) {
                    IgniteBiTuple initTtlAndExpireTime = GridCacheMapEntry.initialTtlAndExpireTime(this.expiryPlc);
                    initTtl = (Long)initTtlAndExpireTime.get1();
                    initExpireTime = (Long)initTtlAndExpireTime.get2();
                } else {
                    initTtl = 0L;
                    initExpireTime = 0L;
                }
                this.entry.update(storeLoadedVal, initExpireTime, initTtl, this.entry.ver, true);
                needUpdate = true;
            } else if (updateExpireTime && this.expiryPlc != null && this.entry.val != null && (ttl = this.expiryPlc.forAccess()) != -1L) {
                long expireTime;
                if (ttl == -2L) {
                    ttl = 1L;
                    expireTime = CU.expireTimeInPast();
                } else {
                    expireTime = CU.toExpireTime(ttl);
                }
                if (this.entry.expireTimeExtras() != expireTime) {
                    this.entry.update(this.entry.val, expireTime, ttl, this.entry.ver, true);
                    this.expiryPlc.ttlUpdated(this.entry.key, this.entry.ver, null);
                    needUpdate = true;
                    storeLoadedVal = this.entry.val;
                }
            }
            if (needUpdate) {
                this.newRow = this.entry.localPartition().dataStore().createRow(this.entry.cctx, this.entry.key, storeLoadedVal, this.newVer, this.entry.expireTimeExtras(), this.oldRow);
                this.treeOp = IgniteTree.OperationType.PUT;
            } else {
                this.treeOp = IgniteTree.OperationType.NOOP;
            }
        }

        private void update(@Nullable GridCacheVersionConflictContext<?, ?> conflictCtx, @Nullable IgniteBiTuple<Object, Exception> invokeRes, boolean readFromStore, boolean transformed) throws IgniteCheckedException {
            long newExpireTime;
            long newSysExpireTime;
            long newSysTtl;
            long newTtl;
            GridCacheContext cctx = this.entry.context();
            CacheObject oldVal = this.entry.val;
            CacheObject updated = (CacheObject)this.writeObj;
            if (conflictCtx == null) {
                if (this.explicitTtl != -1L) {
                    assert (this.conflictVer == null || this.explicitExpireTime != -1L);
                    newSysTtl = newTtl = this.explicitTtl;
                    newSysExpireTime = this.explicitExpireTime;
                    newExpireTime = this.explicitExpireTime != -1L ? this.explicitExpireTime : CU.toExpireTime(this.explicitTtl);
                } else {
                    long l = this.expiryPlc == null ? -1L : (newSysTtl = this.entry.val != null ? this.expiryPlc.forUpdate() : this.expiryPlc.forCreate());
                    if (newSysTtl == -1L) {
                        newSysExpireTime = -1L;
                        newTtl = this.entry.ttlExtras();
                        newExpireTime = this.entry.expireTimeExtras();
                    } else {
                        if (newSysTtl == -2L) {
                            this.op = GridCacheOperation.DELETE;
                            this.writeObj = null;
                            this.remove(conflictCtx, invokeRes, readFromStore, false);
                            return;
                        }
                        newSysExpireTime = -1L;
                        newTtl = newSysTtl;
                        newExpireTime = CU.toExpireTime(newTtl);
                    }
                }
            } else {
                newSysTtl = newTtl = conflictCtx.ttl();
                newSysExpireTime = newExpireTime = conflictCtx.expireTime();
            }
            if (this.intercept && (this.conflictVer == null || !this.skipInterceptorOnConflict)) {
                Object updated0 = cctx.unwrapBinaryIfNeeded(updated, this.keepBinary, false);
                CacheLazyEntry<Object, Object> interceptEntry = new CacheLazyEntry<Object, Object>(cctx, this.entry.key, null, oldVal, null, this.keepBinary);
                Object interceptorVal = cctx.config().getInterceptor().onBeforePut(interceptEntry, updated0);
                this.wasIntercepted = true;
                if (interceptorVal == null) {
                    this.treeOp = IgniteTree.OperationType.NOOP;
                    this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.INTERCEPTOR_CANCEL, oldVal, null, invokeRes, 0L, 0L, null, null, 0L, false);
                    return;
                }
                if (interceptorVal != updated0) {
                    updated0 = cctx.unwrapTemporary(interceptorVal);
                    updated = cctx.toCacheObject(updated0);
                }
            }
            updated = cctx.kernalContext().cacheObjects().prepareForCache(updated, cctx);
            if (this.writeThrough) {
                cctx.store().put(null, this.entry.key, updated, this.newVer);
            }
            if (this.entry.val == null) {
                boolean new0 = this.entry.isStartVersion();
                assert (this.entry.deletedUnlocked() || new0 || this.entry.isInternal()) : "Invalid entry [entry=" + this.entry + ", locNodeId=" + cctx.localNodeId() + ']';
                if (!new0 && !this.entry.isInternal()) {
                    this.entry.deletedUnlocked(false);
                }
            } else assert (!this.entry.deletedUnlocked()) : "Invalid entry [entry=" + this + ", locNodeId=" + cctx.localNodeId() + ']';
            long updateCntr0 = this.entry.nextPartitionCounter(this.topVer, this.primary, false, this.updateCntr);
            this.entry.logUpdate(this.op, updated, this.newVer, newExpireTime, updateCntr0);
            if (!this.entry.isNear()) {
                this.newRow = this.entry.localPartition().dataStore().createRow(this.entry.cctx, this.entry.key, updated, this.newVer, newExpireTime, this.oldRow);
                this.treeOp = this.oldRow != null && this.oldRow.link() == this.newRow.link() ? IgniteTree.OperationType.NOOP : IgniteTree.OperationType.PUT;
            } else {
                this.treeOp = IgniteTree.OperationType.PUT;
            }
            this.entry.update(updated, newExpireTime, newTtl, this.newVer, true);
            if (this.entry.isNear()) {
                boolean updatedDht = ((GridNearCacheEntry)this.entry).recordDhtVersion(this.newVer);
                assert (updatedDht) : this;
            }
            this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.SUCCESS, oldVal, updated, invokeRes, newSysTtl, newSysExpireTime, null, conflictCtx, updateCntr0, transformed);
        }

        private void remove(@Nullable GridCacheVersionConflictContext<?, ?> conflictCtx, @Nullable IgniteBiTuple<Object, Exception> invokeRes, boolean readFromStore, boolean transformed) throws IgniteCheckedException {
            GridCacheUpdateAtomicResult.UpdateOutcome outcome;
            GridCacheContext cctx = this.entry.context();
            CacheObject oldVal = this.entry.val;
            IgniteBiTuple<Boolean, Object> interceptRes = null;
            if (this.intercept && (this.conflictVer == null || !this.skipInterceptorOnConflict)) {
                CacheLazyEntry<Object, Object> intercepEntry = new CacheLazyEntry<Object, Object>(cctx, this.entry.key, null, oldVal, null, this.keepBinary);
                interceptRes = cctx.config().getInterceptor().onBeforeRemove(intercepEntry);
                this.wasIntercepted = true;
                if (cctx.cancelRemove(interceptRes)) {
                    this.treeOp = IgniteTree.OperationType.NOOP;
                    this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.INTERCEPTOR_CANCEL, cctx.toCacheObject(cctx.unwrapTemporary(interceptRes.get2())), null, invokeRes, 0L, 0L, null, null, 0L, false);
                    return;
                }
            }
            if (this.writeThrough) {
                cctx.store().remove(null, this.entry.key);
            }
            long updateCntr0 = this.entry.nextPartitionCounter(this.topVer, this.primary, false, this.updateCntr);
            this.entry.logUpdate(this.op, null, this.newVer, 0L, updateCntr0);
            if (oldVal != null) {
                assert (!this.entry.deletedUnlocked());
                if (!this.entry.isInternal()) {
                    this.entry.deletedUnlocked(true);
                }
            } else {
                boolean new0 = this.entry.isStartVersion();
                assert (this.entry.deletedUnlocked() || new0 || this.entry.isInternal()) : "Invalid entry [entry=" + this + ", locNodeId=" + cctx.localNodeId() + ']';
                if (new0 && !this.entry.isInternal()) {
                    this.entry.deletedUnlocked(true);
                }
            }
            GridCacheVersion enqueueVer = this.newVer;
            this.entry.update(null, 0L, 0L, this.newVer, true);
            this.treeOp = this.oldRow == null || readFromStore ? IgniteTree.OperationType.NOOP : IgniteTree.OperationType.REMOVE;
            GridCacheUpdateAtomicResult.UpdateOutcome updateOutcome = outcome = oldVal != null ? GridCacheUpdateAtomicResult.UpdateOutcome.SUCCESS : GridCacheUpdateAtomicResult.UpdateOutcome.REMOVE_NO_VAL;
            if (interceptRes != null) {
                oldVal = cctx.toCacheObject(cctx.unwrapTemporary(interceptRes.get2()));
            }
            this.updateRes = new GridCacheUpdateAtomicResult(outcome, oldVal, null, invokeRes, -1L, -1L, enqueueVer, conflictCtx, updateCntr0, transformed);
        }

        private GridCacheVersionConflictContext<?, ?> resolveConflict(CacheObject newVal, @Nullable IgniteBiTuple<Object, Exception> invokeRes) throws IgniteCheckedException {
            GridCacheContext cctx = this.entry.context();
            if (cctx.conflictNeedResolve()) {
                GridCacheVersion oldConflictVer = this.entry.ver.conflictVersion();
                GridCacheLazyPlainVersionedEntry oldEntry = new GridCacheLazyPlainVersionedEntry(cctx, this.entry.key, this.entry.val, this.entry.ttlExtras(), this.entry.expireTimeExtras(), this.entry.ver.conflictVersion(), this.entry.isStartVersion(), this.keepBinary);
                GridTuple3 expiration = this.entry.ttlAndExpireTime(this.expiryPlc, this.explicitTtl, this.explicitExpireTime);
                GridCacheLazyPlainVersionedEntry newEntry = new GridCacheLazyPlainVersionedEntry(cctx, this.entry.key, newVal, (Long)expiration.get1(), (Long)expiration.get2(), this.conflictVer != null ? this.conflictVer : this.newVer, this.keepBinary);
                GridCacheVersionConflictContext conflictCtx = cctx.conflictResolve(oldEntry, newEntry, this.verCheck);
                assert (conflictCtx != null);
                if (conflictCtx.isUseOld()) {
                    GridCacheVersion newConflictVer;
                    GridCacheVersion gridCacheVersion = newConflictVer = this.conflictVer != null ? this.conflictVer : this.newVer;
                    if (!this.entry.isStartVersion() && this.verCheck && oldConflictVer.dataCenterId() == newConflictVer.dataCenterId() && ATOMIC_VER_COMPARATOR.compare(oldConflictVer, newConflictVer) == 0 && cctx.writeThrough() && this.primary) {
                        CacheObject val = this.entry.val;
                        if (val == null) {
                            assert (this.entry.deletedUnlocked());
                            cctx.store().remove(null, this.entry.key);
                        } else {
                            cctx.store().put(null, this.entry.key, val, this.entry.ver);
                        }
                    }
                    this.treeOp = IgniteTree.OperationType.NOOP;
                    this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.CONFLICT_USE_OLD, this.entry.val, null, invokeRes, 0L, 0L, null, null, 0L, false);
                } else {
                    if (conflictCtx.isMerge()) {
                        this.writeObj = cctx.toCacheObject(conflictCtx.mergeValue());
                        this.conflictVer = null;
                    } else assert (conflictCtx.isUseNew());
                    this.op = this.writeObj != null ? GridCacheOperation.UPDATE : GridCacheOperation.DELETE;
                }
                return conflictCtx;
            }
            this.conflictVer = null;
            return null;
        }

        private void versionCheck(@Nullable IgniteBiTuple<Object, Exception> invokeRes) throws IgniteCheckedException {
            GridCacheContext cctx = this.entry.context();
            if (this.verCheck) {
                if (!this.entry.isStartVersion() && ATOMIC_VER_COMPARATOR.compare(this.entry.ver, this.newVer) >= 0) {
                    if (ATOMIC_VER_COMPARATOR.compare(this.entry.ver, this.newVer) == 0 && cctx.writeThrough() && this.primary) {
                        CacheObject val;
                        if (log.isDebugEnabled()) {
                            log.debug("Received entry update with same version as current (will update store) [entry=" + this + ", newVer=" + this.newVer + ']');
                        }
                        if ((val = this.entry.val) == null) {
                            assert (this.entry.deletedUnlocked());
                            cctx.store().remove(null, this.entry.key);
                        } else {
                            cctx.store().put(null, this.entry.key, val, this.entry.ver);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Received entry update with smaller version than current (will ignore) [entry=" + this + ", newVer=" + this.newVer + ']');
                    }
                    this.treeOp = IgniteTree.OperationType.NOOP;
                    this.updateRes = new GridCacheUpdateAtomicResult(GridCacheUpdateAtomicResult.UpdateOutcome.VERSION_CHECK_FAILED, this.entry.val, null, invokeRes, 0L, 0L, null, null, 0L, false);
                }
            } else assert (this.entry.isStartVersion() || ATOMIC_VER_COMPARATOR.compare(this.entry.ver, this.newVer) <= 0) : "Invalid version for inner update [isNew=" + this.entry.isStartVersion() + ", entry=" + this.entry + ", newVer=" + this.newVer + ']';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IgniteBiTuple<Object, Exception> runEntryProcessor(CacheInvokeEntry<Object, Object> invokeEntry) {
            IgniteBiTuple<Object, Exception> igniteBiTuple;
            EntryProcessor entryProcessor = (EntryProcessor)this.writeObj;
            IgniteThread.onEntryProcessorEntered(true);
            try {
                Object computed = entryProcessor.process(invokeEntry, this.invokeArgs);
                if (invokeEntry.modified()) {
                    GridCacheContext cctx = this.entry.context();
                    this.writeObj = cctx.toCacheObject(cctx.unwrapTemporary(invokeEntry.getValue()));
                } else {
                    this.writeObj = invokeEntry.valObj;
                }
                if (computed != null) {
                    igniteBiTuple = new IgniteBiTuple(this.entry.cctx.unwrapTemporary(computed), null);
                    return igniteBiTuple;
                }
                igniteBiTuple = null;
                return igniteBiTuple;
            }
            catch (UnregisteredBinaryTypeException | UnregisteredClassException e) {
                throw e;
            }
            catch (Exception e) {
                this.writeObj = invokeEntry.valObj;
                igniteBiTuple = new IgniteBiTuple<Object, Exception>(null, e);
                return igniteBiTuple;
            }
            finally {
                IgniteThread.onEntryProcessorLeft();
            }
        }

        public String toString() {
            return S.toString(AtomicCacheUpdateClosure.class, this);
        }
    }

    private static class UpdateClosure
    implements IgniteCacheOffheapManager.OffheapInvokeClosure {
        private final GridCacheMapEntry entry;
        @Nullable
        private final CacheObject val;
        private final GridCacheVersion ver;
        private final long expireTime;
        @Nullable
        private final IgnitePredicate<CacheDataRow> predicate;
        private CacheDataRow newRow;
        private CacheDataRow oldRow;
        private IgniteTree.OperationType treeOp = IgniteTree.OperationType.PUT;

        UpdateClosure(GridCacheMapEntry entry, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, @Nullable IgnitePredicate<CacheDataRow> predicate, @Nullable CacheDataRow newRow) {
            this.entry = entry;
            this.val = val;
            this.ver = ver;
            this.expireTime = expireTime;
            this.predicate = predicate;
            this.newRow = newRow;
        }

        @Override
        public void call(@Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            if (oldRow != null) {
                oldRow.key(this.entry.key);
                oldRow = this.checkRowExpired(oldRow);
            }
            this.oldRow = oldRow;
            if (this.predicate != null && !this.predicate.apply(oldRow)) {
                this.treeOp = IgniteTree.OperationType.NOOP;
                return;
            }
            if (this.val != null) {
                if (this.newRow == null) {
                    this.newRow = this.entry.cctx.offheap().dataStore(this.entry.localPartition()).createRow(this.entry.cctx, this.entry.key, this.val, this.ver, this.expireTime, oldRow);
                }
                this.treeOp = oldRow != null && oldRow.link() == this.newRow.link() ? IgniteTree.OperationType.IN_PLACE : IgniteTree.OperationType.PUT;
            } else {
                this.treeOp = oldRow != null ? IgniteTree.OperationType.REMOVE : IgniteTree.OperationType.NOOP;
            }
        }

        @Override
        public CacheDataRow newRow() {
            return this.newRow;
        }

        @Override
        public IgniteTree.OperationType operationType() {
            return this.treeOp;
        }

        @Override
        @Nullable
        public CacheDataRow oldRow() {
            return this.oldRow;
        }

        private CacheDataRow checkRowExpired(CacheDataRow row) throws IgniteCheckedException {
            assert (row != null);
            if (row.expireTime() <= 0L || row.expireTime() > U.currentTimeMillis()) {
                return row;
            }
            GridCacheContext cctx = this.entry.context();
            CacheObject expiredVal = row.value();
            if (cctx.deferredDelete() && !this.entry.detached() && !this.entry.isInternal()) {
                this.entry.update(null, 0L, 0L, this.entry.ver, true);
                if (!this.entry.deletedUnlocked() && !this.entry.isStartVersion()) {
                    this.entry.deletedUnlocked(true);
                }
            } else {
                this.entry.markObsolete0(cctx.versions().next(), true, null);
            }
            if (cctx.events().isRecordable(70)) {
                cctx.events().addEvent(this.entry.partition(), this.entry.key(), cctx.localNodeId(), null, 70, null, false, expiredVal, expiredVal != null, null, null, null, true);
            }
            cctx.continuousQueries().onEntryExpired(this.entry, this.entry.key(), expiredVal);
            return null;
        }
    }

    private class LazyValueEntry<K, V>
    implements Cache.Entry<K, V> {
        private final KeyCacheObject key;
        private boolean keepBinary;

        private LazyValueEntry(KeyCacheObject key, boolean keepBinary) {
            this.key = key;
            this.keepBinary = keepBinary;
        }

        public K getKey() {
            return (K)GridCacheMapEntry.this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(this.key, this.keepBinary, true);
        }

        public V getValue() {
            return (V)GridCacheMapEntry.this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(GridCacheMapEntry.this.peekVisibleValue(), this.keepBinary, true);
        }

        public <T> T unwrap(Class<T> cls) {
            if (cls.isAssignableFrom(IgniteCache.class)) {
                return (T)GridCacheMapEntry.this.cctx.grid().cache(GridCacheMapEntry.this.cctx.name());
            }
            if (cls.isAssignableFrom(this.getClass())) {
                return (T)this;
            }
            if (cls.isAssignableFrom(EvictableEntry.class)) {
                return (T)GridCacheMapEntry.this.wrapEviction();
            }
            if (cls.isAssignableFrom(CacheEntryImplEx.class)) {
                return (T)(cls == CacheEntryImplEx.class ? GridCacheMapEntry.this.wrapVersioned() : GridCacheMapEntry.this.wrapVersionedWithValue());
            }
            if (cls.isAssignableFrom(GridCacheVersion.class)) {
                return (T)GridCacheMapEntry.this.ver;
            }
            if (cls.isAssignableFrom(GridCacheMapEntry.this.getClass())) {
                return (T)GridCacheMapEntry.this;
            }
            throw new IllegalArgumentException("Unwrapping to class is not supported: " + cls);
        }

        public String toString() {
            return "IteratorEntry [key=" + this.key + ']';
        }
    }

    private static class MvccUpdateLockListener
    implements IgniteInClosure<IgniteInternalFuture> {
        private static final long serialVersionUID = 8452738214760268397L;
        private final IgniteInternalTx tx;
        private final UUID affNodeId;
        private final AffinityTopologyVersion topVer;
        private final CacheObject val;
        private final long ttl;
        private final MvccSnapshot mvccVer;
        private final GridFutureAdapter<GridCacheUpdateTxResult> resFut;
        private GridCacheMapEntry entry;
        private GridCacheOperation op;
        private final boolean keepBinary;
        private final EntryProcessor entryProc;
        private final Object[] invokeArgs;
        private final CacheEntryPredicate filter;
        private final boolean needHistory;
        private final boolean noCreate;
        private final boolean needVal;
        private boolean needOldVal;

        MvccUpdateLockListener(IgniteInternalTx tx, GridCacheMapEntry entry, UUID affNodeId, AffinityTopologyVersion topVer, CacheObject val, long ttl, MvccSnapshot mvccVer, GridCacheOperation op, boolean needHistory, boolean noCreate, GridFutureAdapter<GridCacheUpdateTxResult> resFut, boolean needOldVal, CacheEntryPredicate filter, boolean needVal, boolean keepBinary, EntryProcessor entryProc, Object[] invokeArgs) {
            this.tx = tx;
            this.entry = entry;
            this.affNodeId = affNodeId;
            this.topVer = topVer;
            this.val = val;
            this.ttl = ttl;
            this.mvccVer = mvccVer;
            this.op = op;
            this.needHistory = needHistory;
            this.noCreate = noCreate;
            this.filter = filter;
            this.needVal = needVal;
            this.resFut = resFut;
            this.needOldVal = needOldVal;
            this.keepBinary = keepBinary;
            this.entryProc = entryProc;
            this.invokeArgs = invokeArgs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(IgniteInternalFuture lockFut) {
            GridCacheUpdateTxResult updRes;
            MvccUpdateResult res;
            boolean valid;
            WALPointer logPtr = null;
            GridCacheContext cctx = this.entry.context();
            GridCacheVersion newVer = this.tx.writeVersion();
            boolean invoke = this.entryProc != null;
            try {
                long expireTime;
                lockFut.get();
                this.entry.ensureFreeSpace();
                while (true) {
                    this.entry.lockEntry();
                    if (this.entry.obsoleteVersionExtras() == null) break;
                    this.entry.unlockEntry();
                    this.entry = (GridCacheMapEntry)cctx.cache().entryEx(this.entry.key());
                }
                valid = this.entry.valid(this.tx.topologyVersion());
                long ttl = this.ttl;
                if (ttl == -1L) {
                    ttl = this.entry.ttlExtras();
                    expireTime = this.entry.expireTimeExtras();
                } else {
                    expireTime = CU.toExpireTime(ttl);
                }
                assert (ttl >= 0L) : ttl;
                assert (expireTime >= 0L) : expireTime;
                cctx.shared().database().checkpointReadLock();
                try {
                    res = cctx.offheap().mvccUpdate(this.entry, this.val, newVer, expireTime, this.mvccVer, this.tx.local(), this.needHistory, this.noCreate, this.needOldVal, this.filter, this.needVal, this.keepBinary, this.entryProc, this.invokeArgs);
                }
                finally {
                    cctx.shared().database().checkpointReadUnlock();
                }
                assert (res != null);
                if (res.resultType() == ResultType.VERSION_MISMATCH) {
                    this.resFut.onDone(GridCacheMapEntry.serializationError());
                    return;
                }
                if (res.resultType() == ResultType.LOCKED) {
                    this.entry.unlockEntry();
                    cctx.kernalContext().coordinators().waitForLock(cctx, this.mvccVer, res.resultVersion()).listen(this);
                    return;
                }
                if (res.resultType() == ResultType.FILTERED) {
                    GridCacheUpdateTxResult updRes2 = new GridCacheUpdateTxResult(invoke);
                    if (invoke) {
                        assert (res.invokeResult() != null);
                        updRes2.invokeResult(res.invokeResult());
                    }
                    updRes2.filtered(true);
                    if (this.needVal) {
                        updRes2.prevValue(res.oldValue());
                    }
                    this.resFut.onDone(updRes2);
                    return;
                }
                if (this.op == GridCacheOperation.CREATE && this.tx.local() && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.VERSION_FOUND)) {
                    this.resFut.onDone(new IgniteTxDuplicateKeyCheckedException("Duplicate key during INSERT [key=" + this.entry.key() + ']'));
                    return;
                }
                if (cctx.deferredDelete() && this.entry.deletedUnlocked() && !this.entry.detached()) {
                    this.entry.deletedUnlocked(false);
                }
                if (res.resultType() == ResultType.PREV_NULL) {
                    TxCounters counters = this.tx.txCounters(true);
                    if (MvccUtils.compareIgnoreOpCounter(res.resultVersion(), this.mvccVer) == 0) {
                        if (res.isKeyAbsentBefore()) {
                            counters.incrementUpdateCounter(cctx.cacheId(), this.entry.partition());
                        }
                    } else {
                        counters.incrementUpdateCounter(cctx.cacheId(), this.entry.partition());
                    }
                    counters.accumulateSizeDelta(cctx.cacheId(), this.entry.partition(), 1L);
                } else if (res.resultType() == ResultType.PREV_NOT_NULL && MvccUtils.compareIgnoreOpCounter(res.resultVersion(), this.mvccVer) != 0) {
                    TxCounters counters = this.tx.txCounters(true);
                    counters.incrementUpdateCounter(cctx.cacheId(), this.entry.partition());
                } else if (res.resultType() == ResultType.REMOVED_NOT_NULL) {
                    TxCounters counters = this.tx.txCounters(true);
                    if (MvccUtils.compareIgnoreOpCounter(res.resultVersion(), this.mvccVer) == 0) {
                        if (res.isKeyAbsentBefore()) {
                            counters.decrementUpdateCounter(cctx.cacheId(), this.entry.partition());
                        }
                    } else {
                        counters.incrementUpdateCounter(cctx.cacheId(), this.entry.partition());
                    }
                    counters.accumulateSizeDelta(cctx.cacheId(), this.entry.partition(), -1L);
                }
                if (cctx.group().persistenceEnabled() && cctx.group().walEnabled()) {
                    logPtr = cctx.shared().wal().log(new MvccDataRecord(new MvccDataEntry(cctx.cacheId(), this.entry.key(), this.val, res.resultType() == ResultType.PREV_NULL ? GridCacheOperation.CREATE : (res.resultType() == ResultType.REMOVED_NOT_NULL ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE), this.tx.nearXidVersion(), newVer, expireTime, this.entry.key().partition(), 0L, this.mvccVer)));
                }
                this.entry.update(this.val, expireTime, ttl, newVer, true);
                this.entry.recordNodeId(this.affNodeId, this.topVer);
            }
            catch (IgniteCheckedException e) {
                this.resFut.onDone(e);
                return;
            }
            finally {
                if (this.entry.lockedByCurrentThread()) {
                    this.entry.unlockEntry();
                    cctx.evicts().touch(this.entry);
                }
            }
            this.entry.onUpdateFinished(0L);
            GridCacheUpdateTxResult gridCacheUpdateTxResult = updRes = valid ? new GridCacheUpdateTxResult(true, 0L, logPtr) : new GridCacheUpdateTxResult(false, logPtr);
            if (invoke) {
                assert (res.invokeResult() != null);
                updRes.invokeResult(res.invokeResult());
            }
            updRes.newValue(res.newValue());
            if (this.needOldVal && MvccUtils.compareIgnoreOpCounter(res.resultVersion(), this.mvccVer) != 0 && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.REMOVED_NOT_NULL)) {
                updRes.oldValue(res.oldValue());
            }
            updRes.mvccHistory(res.history());
            this.resFut.onDone(updRes);
        }
    }

    private static class MvccAcquireLockListener
    implements IgniteInClosure<IgniteInternalFuture> {
        private static final long serialVersionUID = -1578749008606139541L;
        private final IgniteInternalTx tx;
        private final MvccSnapshot mvccVer;
        private final GridFutureAdapter<GridCacheUpdateTxResult> resFut;
        private GridCacheMapEntry entry;

        MvccAcquireLockListener(IgniteInternalTx tx, GridCacheMapEntry entry, MvccSnapshot mvccVer, GridFutureAdapter<GridCacheUpdateTxResult> resFut) {
            this.tx = tx;
            this.entry = entry;
            this.mvccVer = mvccVer;
            this.resFut = resFut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(IgniteInternalFuture lockFut) {
            boolean valid;
            WALPointer logPtr = null;
            GridCacheContext cctx = this.entry.context();
            try {
                MvccUpdateResult res;
                lockFut.get();
                while (true) {
                    this.entry.lockEntry();
                    if (this.entry.obsoleteVersionExtras() == null) break;
                    this.entry.unlockEntry();
                    this.entry = (GridCacheMapEntry)cctx.cache().entryEx(this.entry.key());
                }
                valid = this.entry.valid(this.tx.topologyVersion());
                cctx.shared().database().checkpointReadLock();
                try {
                    res = cctx.offheap().mvccLock(this.entry, this.mvccVer);
                }
                finally {
                    cctx.shared().database().checkpointReadUnlock();
                }
                assert (res != null);
                if (res.resultType() == ResultType.VERSION_MISMATCH) {
                    this.resFut.onDone(GridCacheMapEntry.serializationError());
                    return;
                }
                if (res.resultType() == ResultType.LOCKED) {
                    this.entry.unlockEntry();
                    cctx.kernalContext().coordinators().waitForLock(cctx, this.mvccVer, res.resultVersion()).listen(this);
                    return;
                }
            }
            catch (IgniteCheckedException e) {
                this.resFut.onDone(e);
                return;
            }
            finally {
                if (this.entry.lockedByCurrentThread()) {
                    this.entry.unlockEntry();
                    cctx.evicts().touch(this.entry);
                }
            }
            this.entry.onUpdateFinished(0L);
            this.resFut.onDone(new GridCacheUpdateTxResult(valid, logPtr));
        }
    }

    private static class MvccRemoveLockListener
    implements IgniteInClosure<IgniteInternalFuture> {
        private static final long serialVersionUID = -1578749008606139541L;
        private final IgniteInternalTx tx;
        private final AffinityTopologyVersion topVer;
        private final UUID affNodeId;
        private final MvccSnapshot mvccVer;
        private final boolean needHistory;
        private final GridFutureAdapter<GridCacheUpdateTxResult> resFut;
        private final boolean needVal;
        private final CacheEntryPredicate filter;
        private GridCacheMapEntry entry;
        private IgniteUuid futId;
        private int batchNum;
        private final boolean needOldVal;

        MvccRemoveLockListener(IgniteInternalTx tx, GridCacheMapEntry entry, UUID affNodeId, AffinityTopologyVersion topVer, MvccSnapshot mvccVer, boolean needHistory, GridFutureAdapter<GridCacheUpdateTxResult> resFut, boolean needOldVal, boolean retVal, @Nullable CacheEntryPredicate filter) {
            this.tx = tx;
            this.entry = entry;
            this.topVer = topVer;
            this.affNodeId = affNodeId;
            this.mvccVer = mvccVer;
            this.needHistory = needHistory;
            this.resFut = resFut;
            this.needOldVal = needOldVal;
            this.needVal = retVal;
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(IgniteInternalFuture lockFut) {
            MvccUpdateResult res;
            boolean valid;
            WALPointer logPtr = null;
            GridCacheContext cctx = this.entry.context();
            GridCacheVersion newVer = this.tx.writeVersion();
            try {
                lockFut.get();
                while (true) {
                    this.entry.lockEntry();
                    if (this.entry.obsoleteVersionExtras() == null) break;
                    this.entry.unlockEntry();
                    this.entry = (GridCacheMapEntry)cctx.cache().entryEx(this.entry.key());
                }
                valid = this.entry.valid(this.tx.topologyVersion());
                boolean needOldVal = this.tx.txState().useMvccCaching(cctx.cacheId());
                cctx.shared().database().checkpointReadLock();
                try {
                    res = cctx.offheap().mvccRemove(this.entry, this.mvccVer, this.tx.local(), this.needHistory, needOldVal, this.filter, this.needVal);
                }
                finally {
                    cctx.shared().database().checkpointReadUnlock();
                }
                assert (res != null);
                if (res.resultType() == ResultType.VERSION_MISMATCH) {
                    this.resFut.onDone(GridCacheMapEntry.serializationError());
                    return;
                }
                if (res.resultType() == ResultType.PREV_NULL) {
                    this.resFut.onDone(new GridCacheUpdateTxResult(false));
                    return;
                }
                if (res.resultType() == ResultType.FILTERED) {
                    GridCacheUpdateTxResult updRes = new GridCacheUpdateTxResult(false);
                    updRes.filtered(true);
                    this.resFut.onDone(updRes);
                    return;
                }
                if (res.resultType() == ResultType.LOCKED) {
                    this.entry.unlockEntry();
                    IgniteInternalFuture<Void> lockFuture = cctx.kernalContext().coordinators().waitForLock(cctx, this.mvccVer, res.resultVersion());
                    lockFuture.listen(this);
                    return;
                }
                if (cctx.deferredDelete() && this.entry.deletedUnlocked() && !this.entry.detached()) {
                    this.entry.deletedUnlocked(false);
                }
                if (res.resultType() == ResultType.PREV_NOT_NULL) {
                    TxCounters counters = this.tx.txCounters(true);
                    if (MvccUtils.compareIgnoreOpCounter(res.resultVersion(), this.mvccVer) == 0) {
                        if (res.isKeyAbsentBefore()) {
                            counters.decrementUpdateCounter(cctx.cacheId(), this.entry.partition());
                        }
                    } else {
                        counters.incrementUpdateCounter(cctx.cacheId(), this.entry.partition());
                    }
                    counters.accumulateSizeDelta(cctx.cacheId(), this.entry.partition(), -1L);
                }
                if (cctx.group().persistenceEnabled() && cctx.group().walEnabled()) {
                    this.entry.logMvccUpdate(this.tx, null, 0L, 0L, this.mvccVer);
                }
                this.entry.update(null, 0L, 0L, newVer, true);
                this.entry.recordNodeId(this.affNodeId, this.topVer);
            }
            catch (IgniteCheckedException e) {
                this.resFut.onDone(e);
                return;
            }
            finally {
                if (this.entry.lockedByCurrentThread()) {
                    this.entry.unlockEntry();
                    cctx.evicts().touch(this.entry);
                }
            }
            this.entry.onUpdateFinished(0L);
            GridCacheUpdateTxResult updRes = valid ? new GridCacheUpdateTxResult(true, 0L, logPtr) : new GridCacheUpdateTxResult(false, logPtr);
            updRes.mvccHistory(res.history());
            if (this.needOldVal && MvccUtils.compareIgnoreOpCounter(res.resultVersion(), this.mvccVer) != 0 && (res.resultType() == ResultType.PREV_NOT_NULL || res.resultType() == ResultType.REMOVED_NOT_NULL)) {
                updRes.oldValue(res.oldValue());
            }
            this.resFut.onDone(updRes);
        }
    }
}

