/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageInitRootRecord
extends PageDeltaRecord {
    protected long rootId;

    public MetaPageInitRootRecord(int grpId, long pageId, long rootId) {
        super(grpId, pageId);
        assert (pageId != rootId);
        this.rootId = rootId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
        io.initRoot(pageAddr, this.rootId, pageMem.realPageSize(this.groupId()));
        io.setInlineSize(pageAddr, 0);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_META_PAGE_INIT_ROOT;
    }

    public long rootId() {
        return this.rootId;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageInitRootRecord.class, this, "super", super.toString());
    }
}

