/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.internal.binary.BinaryClassDescriptor;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryIdentityResolver;
import org.apache.ignite.internal.binary.BinaryInternalMapper;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryThreadLocalContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterHandles;
import org.apache.ignite.internal.binary.BinaryWriterSchemaHolder;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class BinaryWriterExImpl
implements BinaryWriter,
BinaryRawWriterEx,
ObjectOutput {
    private static final int LEN_INT = 4;
    private static final int INIT_CAP = 1024;
    private final BinaryContext ctx;
    private final BinaryOutputStream out;
    private final BinaryWriterSchemaHolder schema;
    private int typeId;
    private final int start;
    private int rawOffPos;
    private BinaryWriterHandles handles;
    private int schemaId = BinaryUtils.schemaInitialId();
    private int fieldCnt;
    private BinaryInternalMapper mapper;
    private boolean failIfUnregistered;

    public BinaryWriterExImpl(BinaryContext ctx) {
        this(ctx, BinaryThreadLocalContext.get());
    }

    public BinaryWriterExImpl(BinaryContext ctx, BinaryThreadLocalContext tlsCtx) {
        this(ctx, new BinaryHeapOutputStream(1024, tlsCtx.chunk()), tlsCtx.schemaHolder(), null);
    }

    public BinaryWriterExImpl(BinaryContext ctx, BinaryOutputStream out, BinaryWriterSchemaHolder schema, BinaryWriterHandles handles) {
        this.ctx = ctx;
        this.out = out;
        this.schema = schema;
        this.handles = handles;
        this.start = out.position();
    }

    public boolean failIfUnregistered() {
        return this.failIfUnregistered;
    }

    public void failIfUnregistered(boolean failIfUnregistered) {
        this.failIfUnregistered = failIfUnregistered;
    }

    public void typeId(int typeId) {
        this.typeId = typeId;
    }

    @Override
    public void close() {
        this.out.close();
    }

    void marshal(Object obj) throws BinaryObjectException {
        this.marshal(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void marshal(Object obj, boolean enableReplace) throws BinaryObjectException {
        String newName = this.ctx.configuration().getIgniteInstanceName();
        String oldName = IgniteUtils.setCurrentIgniteName(newName);
        try {
            this.marshal0(obj, enableReplace);
        }
        finally {
            IgniteUtils.restoreOldIgniteName(oldName, newName);
        }
    }

    private void marshal0(Object obj, boolean enableReplace) throws BinaryObjectException {
        assert (obj != null);
        Class<?> cls = obj.getClass();
        BinaryClassDescriptor desc = this.ctx.descriptorForClass(cls, false, this.failIfUnregistered);
        if (desc == null) {
            throw new BinaryObjectException("Object is not binary: [class=" + cls + ']');
        }
        if (desc.excluded()) {
            this.out.writeByte((byte)101);
            return;
        }
        if (desc.useOptimizedMarshaller()) {
            this.out.writeByte((byte)-2);
            try {
                byte[] arr = U.marshal(this.ctx.optimizedMarsh(), obj);
                this.writeInt(arr.length);
                this.write(arr);
            }
            catch (IgniteCheckedException e) {
                throw new BinaryObjectException("Failed to marshal object with optimized marshaller: " + obj, e);
            }
            return;
        }
        if (enableReplace && desc.isWriteReplace()) {
            Object replacedObj = desc.writeReplace(obj);
            if (replacedObj == null) {
                this.out.writeByte((byte)101);
                return;
            }
            this.marshal(replacedObj, false);
            return;
        }
        desc.write(obj, this);
    }

    public byte[] array() {
        return this.out.arrayCopy();
    }

    int position() {
        return this.out.position();
    }

    void position(int pos) {
        this.out.position(pos);
    }

    public void preWrite(@Nullable String clsName) {
        this.out.position(this.out.position() + 24);
        if (clsName != null) {
            this.doWriteString(clsName);
        }
    }

    public void postWrite(boolean userType, boolean registered) {
        int offset;
        int finalSchemaId;
        boolean useCompactFooter;
        short flags;
        if (userType) {
            if (this.ctx.isCompactFooter()) {
                flags = 33;
                useCompactFooter = true;
            } else {
                flags = 1;
                useCompactFooter = false;
            }
        } else {
            flags = 0;
            useCompactFooter = false;
        }
        if (this.fieldCnt != 0) {
            finalSchemaId = this.schemaId;
            offset = this.out.position() - this.start;
            flags = (short)(flags | 2);
            int offsetByteCnt = this.schema.write(this.out, this.fieldCnt, useCompactFooter);
            if (offsetByteCnt == 1) {
                flags = (short)(flags | 8);
            } else if (offsetByteCnt == 2) {
                flags = (short)(flags | 0x10);
            }
            if (this.rawOffPos != 0) {
                flags = (short)(flags | 4);
                this.out.writeInt(this.rawOffPos - this.start);
            }
        } else if (this.rawOffPos != 0) {
            finalSchemaId = 0;
            offset = this.rawOffPos - this.start;
            flags = (short)(flags | 4);
        } else {
            finalSchemaId = 0;
            offset = 0;
        }
        int retPos = this.out.position();
        this.out.unsafePosition(this.start);
        this.out.unsafeWriteByte((byte)103);
        this.out.unsafeWriteByte((byte)1);
        this.out.unsafeWriteShort(flags);
        this.out.unsafeWriteInt(registered ? this.typeId : 0);
        this.out.unsafePosition(this.start + 12);
        this.out.unsafeWriteInt(retPos - this.start);
        this.out.unsafeWriteInt(finalSchemaId);
        this.out.unsafeWriteInt(offset);
        this.out.unsafePosition(retPos);
    }

    public void postWriteHashCode(@Nullable String clsName) {
        int typeId = clsName == null ? this.typeId : this.ctx.typeId(clsName);
        BinaryIdentityResolver identity = this.ctx.identity(typeId);
        if (this.out.hasArray()) {
            byte[] data = this.out.array();
            BinaryObjectImpl obj = new BinaryObjectImpl(this.ctx, data, this.start);
            BinaryPrimitives.writeInt(data, this.start + 8, identity.hashCode(obj));
        } else {
            long ptr = this.out.rawOffheapPointer();
            assert (ptr != 0L);
            BinaryObjectOffheapImpl obj = new BinaryObjectOffheapImpl(this.ctx, ptr, this.start, this.out.capacity());
            BinaryPrimitives.writeInt(ptr, this.start + 8, identity.hashCode(obj));
        }
    }

    public void popSchema() {
        if (this.fieldCnt > 0) {
            this.schema.pop(this.fieldCnt);
        }
    }

    @Override
    public void write(byte[] val) {
        this.out.writeByteArray(val);
    }

    @Override
    public void write(byte[] val, int off, int len) {
        this.out.write(val, off, len);
    }

    public void doWriteDecimal(@Nullable BigDecimal val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            boolean negative;
            this.out.unsafeEnsure(9);
            this.out.unsafeWriteByte((byte)30);
            this.out.unsafeWriteInt(val.scale());
            BigInteger intVal = val.unscaledValue();
            boolean bl = negative = intVal.signum() == -1;
            if (negative) {
                intVal = intVal.negate();
            }
            byte[] vals = intVal.toByteArray();
            if (negative) {
                vals[0] = (byte)(vals[0] | 0xFFFFFF80);
            }
            this.out.unsafeWriteInt(vals.length);
            this.out.writeByteArray(vals);
        }
    }

    public void doWriteString(@Nullable String val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            byte[] strArr = BinaryUtils.USE_STR_SERIALIZATION_VER_2 ? BinaryUtils.strToUtf8Bytes(val) : val.getBytes(StandardCharsets.UTF_8);
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)9);
            this.out.unsafeWriteInt(strArr.length);
            this.out.writeByteArray(strArr);
        }
    }

    public void doWriteUuid(@Nullable UUID uuid) {
        if (uuid == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(17);
            this.out.unsafeWriteByte((byte)10);
            this.out.unsafeWriteLong(uuid.getMostSignificantBits());
            this.out.unsafeWriteLong(uuid.getLeastSignificantBits());
        }
    }

    public void doWriteDate(@Nullable Date date) {
        if (date == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(9);
            this.out.unsafeWriteByte((byte)11);
            this.out.unsafeWriteLong(date.getTime());
        }
    }

    public void doWriteTimestamp(@Nullable Timestamp ts) {
        if (ts == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(13);
            this.out.unsafeWriteByte((byte)33);
            this.out.unsafeWriteLong(ts.getTime());
            this.out.unsafeWriteInt(ts.getNanos() % 1000000);
        }
    }

    public void doWriteTime(@Nullable Time time) {
        if (time == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(9);
            this.out.unsafeWriteByte((byte)36);
            this.out.unsafeWriteLong(time.getTime());
        }
    }

    public void doWriteObject(@Nullable Object obj) throws BinaryObjectException {
        if (obj == null) {
            this.out.writeByte((byte)101);
        } else {
            BinaryWriterExImpl writer = new BinaryWriterExImpl(this.ctx, this.out, this.schema, this.handles());
            writer.failIfUnregistered(this.failIfUnregistered);
            writer.marshal(obj);
        }
    }

    void doWriteByteArray(@Nullable byte[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)12);
            this.out.unsafeWriteInt(val.length);
            this.out.writeByteArray(val);
        }
    }

    void doWriteShortArray(@Nullable short[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)13);
            this.out.unsafeWriteInt(val.length);
            this.out.writeShortArray(val);
        }
    }

    void doWriteIntArray(@Nullable int[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)14);
            this.out.unsafeWriteInt(val.length);
            this.out.writeIntArray(val);
        }
    }

    void doWriteLongArray(@Nullable long[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)15);
            this.out.unsafeWriteInt(val.length);
            this.out.writeLongArray(val);
        }
    }

    void doWriteFloatArray(@Nullable float[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)16);
            this.out.unsafeWriteInt(val.length);
            this.out.writeFloatArray(val);
        }
    }

    void doWriteDoubleArray(@Nullable double[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)17);
            this.out.unsafeWriteInt(val.length);
            this.out.writeDoubleArray(val);
        }
    }

    void doWriteCharArray(@Nullable char[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)18);
            this.out.unsafeWriteInt(val.length);
            this.out.writeCharArray(val);
        }
    }

    void doWriteBooleanArray(@Nullable boolean[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)19);
            this.out.unsafeWriteInt(val.length);
            this.out.writeBooleanArray(val);
        }
    }

    void doWriteDecimalArray(@Nullable BigDecimal[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)31);
            this.out.unsafeWriteInt(val.length);
            for (BigDecimal str : val) {
                this.doWriteDecimal(str);
            }
        }
    }

    void doWriteStringArray(@Nullable String[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)20);
            this.out.unsafeWriteInt(val.length);
            for (String str : val) {
                this.doWriteString(str);
            }
        }
    }

    void doWriteUuidArray(@Nullable UUID[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)21);
            this.out.unsafeWriteInt(val.length);
            for (UUID uuid : val) {
                this.doWriteUuid(uuid);
            }
        }
    }

    void doWriteDateArray(@Nullable Date[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)22);
            this.out.unsafeWriteInt(val.length);
            for (Date date : val) {
                this.doWriteDate(date);
            }
        }
    }

    void doWriteTimestampArray(@Nullable Timestamp[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)34);
            this.out.unsafeWriteInt(val.length);
            for (Timestamp ts : val) {
                this.doWriteTimestamp(ts);
            }
        }
    }

    void doWriteTimeArray(@Nullable Time[] val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)37);
            this.out.unsafeWriteInt(val.length);
            for (Time time : val) {
                this.doWriteTime(time);
            }
        }
    }

    void doWriteObjectArray(@Nullable Object[] val) throws BinaryObjectException {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            if (this.tryWriteAsHandle(val)) {
                return;
            }
            BinaryClassDescriptor desc = this.ctx.descriptorForClass(val.getClass().getComponentType(), false, this.failIfUnregistered);
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)23);
            if (desc.registered()) {
                this.out.unsafeWriteInt(desc.typeId());
            } else {
                this.out.unsafeWriteInt(0);
                this.doWriteString(val.getClass().getComponentType().getName());
            }
            this.out.writeInt(val.length);
            for (Object obj : val) {
                this.doWriteObject(obj);
            }
        }
    }

    void doWriteCollection(@Nullable Collection<?> col) throws BinaryObjectException {
        if (col == null) {
            this.out.writeByte((byte)101);
        } else {
            if (this.tryWriteAsHandle(col)) {
                return;
            }
            this.out.unsafeEnsure(6);
            this.out.unsafeWriteByte((byte)24);
            this.out.unsafeWriteInt(col.size());
            this.out.unsafeWriteByte(this.ctx.collectionType(col.getClass()));
            for (Object obj : col) {
                this.doWriteObject(obj);
            }
        }
    }

    void doWriteMap(@Nullable Map<?, ?> map) throws BinaryObjectException {
        if (map == null) {
            this.out.writeByte((byte)101);
        } else {
            if (this.tryWriteAsHandle(map)) {
                return;
            }
            this.out.unsafeEnsure(6);
            this.out.unsafeWriteByte((byte)25);
            this.out.unsafeWriteInt(map.size());
            this.out.unsafeWriteByte(this.ctx.mapType(map.getClass()));
            for (Map.Entry<?, ?> e : map.entrySet()) {
                this.doWriteObject(e.getKey());
                this.doWriteObject(e.getValue());
            }
        }
    }

    void doWriteEnum(@Nullable Enum<?> val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            BinaryClassDescriptor desc = this.ctx.descriptorForClass(val.getDeclaringClass(), false, this.failIfUnregistered);
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)28);
            if (desc.registered()) {
                this.out.unsafeWriteInt(desc.typeId());
            } else {
                this.out.unsafeWriteInt(0);
                this.doWriteString(val.getDeclaringClass().getName());
            }
            this.out.writeInt(val.ordinal());
        }
    }

    void doWriteBinaryEnum(BinaryEnumObjectImpl val) {
        assert (val != null);
        int typeId = val.typeId();
        if (typeId != 0) {
            this.out.unsafeEnsure(9);
            this.out.unsafeWriteByte((byte)38);
            this.out.unsafeWriteInt(typeId);
            this.out.unsafeWriteInt(val.enumOrdinal());
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)38);
            this.out.unsafeWriteInt(typeId);
            this.doWriteString(val.className());
            this.out.writeInt(val.enumOrdinal());
        }
    }

    void doWriteEnumArray(@Nullable Object[] val) {
        assert (val == null || val.getClass().getComponentType().isEnum());
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            BinaryClassDescriptor desc = this.ctx.descriptorForClass(val.getClass().getComponentType(), false, this.failIfUnregistered);
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)29);
            if (desc.registered()) {
                this.out.unsafeWriteInt(desc.typeId());
            } else {
                this.out.unsafeWriteInt(0);
                this.doWriteString(val.getClass().getComponentType().getName());
            }
            this.out.writeInt(val.length);
            for (Object o : val) {
                this.doWriteEnum((Enum)o);
            }
        }
    }

    void doWriteClass(@Nullable Class val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            BinaryClassDescriptor desc = this.ctx.descriptorForClass(val, false, this.failIfUnregistered);
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)32);
            if (desc.registered()) {
                this.out.unsafeWriteInt(desc.typeId());
            } else {
                this.out.unsafeWriteInt(0);
                this.doWriteString(val.getName());
            }
        }
    }

    public void doWriteProxy(Proxy proxy, Class<?>[] intfs) {
        if (proxy == null) {
            this.out.writeByte((byte)101);
        } else {
            this.out.unsafeEnsure(5);
            this.out.unsafeWriteByte((byte)35);
            this.out.unsafeWriteInt(intfs.length);
            for (Class<?> intf : intfs) {
                BinaryClassDescriptor desc = this.ctx.descriptorForClass(intf, false, this.failIfUnregistered);
                if (desc.registered()) {
                    this.out.writeInt(desc.typeId());
                    continue;
                }
                this.out.writeInt(0);
                this.doWriteString(intf.getName());
            }
            InvocationHandler ih = Proxy.getInvocationHandler(proxy);
            assert (ih != null);
            this.doWriteObject(ih);
        }
    }

    public void doWriteBinaryObject(@Nullable BinaryObjectImpl po) {
        if (po == null) {
            this.out.writeByte((byte)101);
        } else {
            byte[] poArr = po.array();
            this.out.unsafeEnsure(5 + poArr.length + 4);
            this.out.unsafeWriteByte((byte)27);
            this.out.unsafeWriteInt(poArr.length);
            this.out.writeByteArray(poArr);
            this.out.unsafeWriteInt(po.start());
        }
    }

    public void writeByteFieldPrimitive(byte val) {
        this.out.unsafeEnsure(2);
        this.out.unsafeWriteByte((byte)1);
        this.out.unsafeWriteByte(val);
    }

    void writeByteField(@Nullable Byte val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeByteFieldPrimitive(val);
        }
    }

    void writeClassField(@Nullable Class val) {
        this.doWriteClass(val);
    }

    public void writeShortFieldPrimitive(short val) {
        this.out.unsafeEnsure(3);
        this.out.unsafeWriteByte((byte)2);
        this.out.unsafeWriteShort(val);
    }

    void writeShortField(@Nullable Short val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeShortFieldPrimitive(val);
        }
    }

    public void writeIntFieldPrimitive(int val) {
        this.out.unsafeEnsure(5);
        this.out.unsafeWriteByte((byte)3);
        this.out.unsafeWriteInt(val);
    }

    void writeIntField(@Nullable Integer val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeIntFieldPrimitive(val);
        }
    }

    public void writeLongFieldPrimitive(long val) {
        this.out.unsafeEnsure(9);
        this.out.unsafeWriteByte((byte)4);
        this.out.unsafeWriteLong(val);
    }

    void writeLongField(@Nullable Long val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeLongFieldPrimitive(val);
        }
    }

    public void writeFloatFieldPrimitive(float val) {
        this.out.unsafeEnsure(5);
        this.out.unsafeWriteByte((byte)5);
        this.out.unsafeWriteFloat(val);
    }

    void writeFloatField(@Nullable Float val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeFloatFieldPrimitive(val.floatValue());
        }
    }

    public void writeDoubleFieldPrimitive(double val) {
        this.out.unsafeEnsure(9);
        this.out.unsafeWriteByte((byte)6);
        this.out.unsafeWriteDouble(val);
    }

    void writeDoubleField(@Nullable Double val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeDoubleFieldPrimitive(val);
        }
    }

    public void writeCharFieldPrimitive(char val) {
        this.out.unsafeEnsure(3);
        this.out.unsafeWriteByte((byte)7);
        this.out.unsafeWriteChar(val);
    }

    void writeCharField(@Nullable Character val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeCharFieldPrimitive(val.charValue());
        }
    }

    public void writeBooleanFieldPrimitive(boolean val) {
        this.out.unsafeEnsure(2);
        this.out.unsafeWriteByte((byte)8);
        this.out.unsafeWriteBoolean(val);
    }

    void writeBooleanField(@Nullable Boolean val) {
        if (val == null) {
            this.out.writeByte((byte)101);
        } else {
            this.writeBooleanFieldPrimitive(val);
        }
    }

    void writeDecimalField(@Nullable BigDecimal val) {
        this.doWriteDecimal(val);
    }

    void writeStringField(@Nullable String val) {
        this.doWriteString(val);
    }

    void writeUuidField(@Nullable UUID val) {
        this.doWriteUuid(val);
    }

    void writeDateField(@Nullable Date val) {
        this.doWriteDate(val);
    }

    void writeTimestampField(@Nullable Timestamp val) {
        this.doWriteTimestamp(val);
    }

    void writeTimeField(@Nullable Time val) {
        this.doWriteTime(val);
    }

    void writeObjectField(@Nullable Object obj) throws BinaryObjectException {
        this.doWriteObject(obj);
    }

    void writeByteArrayField(@Nullable byte[] val) {
        this.doWriteByteArray(val);
    }

    void writeShortArrayField(@Nullable short[] val) {
        this.doWriteShortArray(val);
    }

    void writeIntArrayField(@Nullable int[] val) {
        this.doWriteIntArray(val);
    }

    void writeLongArrayField(@Nullable long[] val) {
        this.doWriteLongArray(val);
    }

    void writeFloatArrayField(@Nullable float[] val) {
        this.doWriteFloatArray(val);
    }

    void writeDoubleArrayField(@Nullable double[] val) {
        this.doWriteDoubleArray(val);
    }

    void writeCharArrayField(@Nullable char[] val) {
        this.doWriteCharArray(val);
    }

    void writeBooleanArrayField(@Nullable boolean[] val) {
        this.doWriteBooleanArray(val);
    }

    void writeDecimalArrayField(@Nullable BigDecimal[] val) {
        this.doWriteDecimalArray(val);
    }

    void writeStringArrayField(@Nullable String[] val) {
        this.doWriteStringArray(val);
    }

    void writeUuidArrayField(@Nullable UUID[] val) {
        this.doWriteUuidArray(val);
    }

    void writeDateArrayField(@Nullable Date[] val) {
        this.doWriteDateArray(val);
    }

    void writeTimestampArrayField(@Nullable Timestamp[] val) {
        this.doWriteTimestampArray(val);
    }

    void writeTimeArrayField(@Nullable Time[] val) {
        this.doWriteTimeArray(val);
    }

    void writeObjectArrayField(@Nullable Object[] val) throws BinaryObjectException {
        this.doWriteObjectArray(val);
    }

    void writeCollectionField(@Nullable Collection<?> col) throws BinaryObjectException {
        this.doWriteCollection(col);
    }

    void writeMapField(@Nullable Map<?, ?> map) throws BinaryObjectException {
        this.doWriteMap(map);
    }

    void writeEnumField(@Nullable Enum<?> val) {
        this.doWriteEnum(val);
    }

    void writeEnumArrayField(@Nullable Object[] val) {
        this.doWriteEnumArray(val);
    }

    void writeBinaryObjectField(@Nullable BinaryObjectImpl po) throws BinaryObjectException {
        this.doWriteBinaryObject(po);
    }

    @Override
    public void writeByte(String fieldName, byte val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeByteField(val);
    }

    @Override
    public void writeByte(byte val) throws BinaryObjectException {
        this.out.writeByte(val);
    }

    @Override
    public void writeShort(String fieldName, short val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeShortField(val);
    }

    @Override
    public void writeShort(short val) throws BinaryObjectException {
        this.out.writeShort(val);
    }

    @Override
    public void writeInt(String fieldName, int val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeIntField(val);
    }

    @Override
    public void writeInt(int val) throws BinaryObjectException {
        this.out.writeInt(val);
    }

    @Override
    public void writeLong(String fieldName, long val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeLongField(val);
    }

    @Override
    public void writeLong(long val) throws BinaryObjectException {
        this.out.writeLong(val);
    }

    @Override
    public void writeFloat(String fieldName, float val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeFloatField(Float.valueOf(val));
    }

    @Override
    public void writeFloat(float val) throws BinaryObjectException {
        this.out.writeFloat(val);
    }

    @Override
    public void writeDouble(String fieldName, double val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeDoubleField(val);
    }

    @Override
    public void writeDouble(double val) throws BinaryObjectException {
        this.out.writeDouble(val);
    }

    @Override
    public void writeChar(String fieldName, char val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeCharField(Character.valueOf(val));
    }

    @Override
    public void writeChar(char val) throws BinaryObjectException {
        this.out.writeChar(val);
    }

    @Override
    public void writeBoolean(String fieldName, boolean val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeBooleanField(val);
    }

    @Override
    public void writeBoolean(boolean val) throws BinaryObjectException {
        this.out.writeBoolean(val);
    }

    @Override
    public void writeDecimal(String fieldName, @Nullable BigDecimal val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeDecimalField(val);
    }

    @Override
    public void writeDecimal(@Nullable BigDecimal val) throws BinaryObjectException {
        this.doWriteDecimal(val);
    }

    @Override
    public void writeString(String fieldName, @Nullable String val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeStringField(val);
    }

    @Override
    public void writeString(@Nullable String val) throws BinaryObjectException {
        this.doWriteString(val);
    }

    @Override
    public void writeUuid(String fieldName, @Nullable UUID val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeUuidField(val);
    }

    @Override
    public void writeUuid(@Nullable UUID val) throws BinaryObjectException {
        this.doWriteUuid(val);
    }

    @Override
    public void writeDate(String fieldName, @Nullable Date val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeDateField(val);
    }

    @Override
    public void writeDate(@Nullable Date val) throws BinaryObjectException {
        this.doWriteDate(val);
    }

    @Override
    public void writeTimestamp(String fieldName, @Nullable Timestamp val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeTimestampField(val);
    }

    @Override
    public void writeTimestamp(@Nullable Timestamp val) throws BinaryObjectException {
        this.doWriteTimestamp(val);
    }

    @Override
    public void writeTime(String fieldName, @Nullable Time val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeTimeField(val);
    }

    @Override
    public void writeTime(@Nullable Time val) throws BinaryObjectException {
        this.doWriteTime(val);
    }

    @Override
    public void writeObject(String fieldName, @Nullable Object obj) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeObjectField(obj);
    }

    @Override
    public void writeObject(@Nullable Object obj) throws BinaryObjectException {
        this.doWriteObject(obj);
    }

    @Override
    public void writeObjectDetached(@Nullable Object obj) throws BinaryObjectException {
        if (obj == null) {
            this.out.writeByte((byte)101);
        } else {
            BinaryWriterExImpl writer = new BinaryWriterExImpl(this.ctx, this.out, this.schema, null);
            writer.failIfUnregistered(this.failIfUnregistered);
            writer.marshal(obj);
        }
    }

    @Override
    public void writeByteArray(String fieldName, @Nullable byte[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeByteArrayField(val);
    }

    @Override
    public void writeByteArray(@Nullable byte[] val) throws BinaryObjectException {
        this.doWriteByteArray(val);
    }

    @Override
    public void writeShortArray(String fieldName, @Nullable short[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeShortArrayField(val);
    }

    @Override
    public void writeShortArray(@Nullable short[] val) throws BinaryObjectException {
        this.doWriteShortArray(val);
    }

    @Override
    public void writeIntArray(String fieldName, @Nullable int[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeIntArrayField(val);
    }

    @Override
    public void writeIntArray(@Nullable int[] val) throws BinaryObjectException {
        this.doWriteIntArray(val);
    }

    @Override
    public void writeLongArray(String fieldName, @Nullable long[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeLongArrayField(val);
    }

    @Override
    public void writeLongArray(@Nullable long[] val) throws BinaryObjectException {
        this.doWriteLongArray(val);
    }

    @Override
    public void writeFloatArray(String fieldName, @Nullable float[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeFloatArrayField(val);
    }

    @Override
    public void writeFloatArray(@Nullable float[] val) throws BinaryObjectException {
        this.doWriteFloatArray(val);
    }

    @Override
    public void writeDoubleArray(String fieldName, @Nullable double[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeDoubleArrayField(val);
    }

    @Override
    public void writeDoubleArray(@Nullable double[] val) throws BinaryObjectException {
        this.doWriteDoubleArray(val);
    }

    @Override
    public void writeCharArray(String fieldName, @Nullable char[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeCharArrayField(val);
    }

    @Override
    public void writeCharArray(@Nullable char[] val) throws BinaryObjectException {
        this.doWriteCharArray(val);
    }

    @Override
    public void writeBooleanArray(String fieldName, @Nullable boolean[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeBooleanArrayField(val);
    }

    @Override
    public void writeBooleanArray(@Nullable boolean[] val) throws BinaryObjectException {
        this.doWriteBooleanArray(val);
    }

    @Override
    public void writeDecimalArray(String fieldName, @Nullable BigDecimal[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeDecimalArrayField(val);
    }

    @Override
    public void writeDecimalArray(@Nullable BigDecimal[] val) throws BinaryObjectException {
        this.doWriteDecimalArray(val);
    }

    @Override
    public void writeStringArray(String fieldName, @Nullable String[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeStringArrayField(val);
    }

    @Override
    public void writeStringArray(@Nullable String[] val) throws BinaryObjectException {
        this.doWriteStringArray(val);
    }

    @Override
    public void writeUuidArray(String fieldName, @Nullable UUID[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeUuidArrayField(val);
    }

    @Override
    public void writeUuidArray(@Nullable UUID[] val) throws BinaryObjectException {
        this.doWriteUuidArray(val);
    }

    @Override
    public void writeDateArray(String fieldName, @Nullable Date[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeDateArrayField(val);
    }

    @Override
    public void writeDateArray(@Nullable Date[] val) throws BinaryObjectException {
        this.doWriteDateArray(val);
    }

    @Override
    public void writeTimestampArray(String fieldName, @Nullable Timestamp[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeTimestampArrayField(val);
    }

    @Override
    public void writeTimestampArray(@Nullable Timestamp[] val) throws BinaryObjectException {
        this.doWriteTimestampArray(val);
    }

    @Override
    public void writeTimeArray(String fieldName, @Nullable Time[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeTimeArrayField(val);
    }

    @Override
    public void writeTimeArray(@Nullable Time[] val) throws BinaryObjectException {
        this.doWriteTimeArray(val);
    }

    @Override
    public void writeObjectArray(String fieldName, @Nullable Object[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeObjectArrayField(val);
    }

    @Override
    public void writeObjectArray(@Nullable Object[] val) throws BinaryObjectException {
        this.doWriteObjectArray(val);
    }

    @Override
    public <T> void writeCollection(String fieldName, @Nullable Collection<T> col) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeCollectionField(col);
    }

    @Override
    public <T> void writeCollection(@Nullable Collection<T> col) throws BinaryObjectException {
        this.doWriteCollection(col);
    }

    @Override
    public <K, V> void writeMap(String fieldName, @Nullable Map<K, V> map) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeMapField(map);
    }

    @Override
    public <K, V> void writeMap(@Nullable Map<K, V> map) throws BinaryObjectException {
        this.doWriteMap(map);
    }

    @Override
    public <T extends Enum<?>> void writeEnum(String fieldName, T val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeEnumField(val);
    }

    @Override
    public <T extends Enum<?>> void writeEnum(T val) throws BinaryObjectException {
        this.doWriteEnum(val);
    }

    @Override
    public <T extends Enum<?>> void writeEnumArray(String fieldName, T[] val) throws BinaryObjectException {
        this.writeFieldId(fieldName);
        this.writeEnumArrayField(val);
    }

    @Override
    public <T extends Enum<?>> void writeEnumArray(T[] val) throws BinaryObjectException {
        this.doWriteEnumArray(val);
    }

    @Override
    public BinaryRawWriter rawWriter() {
        if (this.rawOffPos == 0) {
            this.rawOffPos = this.out.position();
        }
        return this;
    }

    @Override
    public BinaryOutputStream out() {
        return this.out;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.writeString(s);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte((byte)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort((short)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar((char)v);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.writeByte((byte)b);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public int reserveInt() {
        int pos = this.out.position();
        this.out.position(pos + 4);
        return pos;
    }

    @Override
    public void writeInt(int pos, int val) throws BinaryObjectException {
        this.out.writeInt(pos, val);
    }

    private void writeFieldId(String fieldName) throws BinaryObjectException {
        A.notNull(fieldName, "fieldName");
        if (this.rawOffPos != 0) {
            throw new BinaryObjectException("Individual field can't be written after raw writer is acquired.");
        }
        if (this.mapper == null) {
            this.mapper = this.ctx.userTypeMapper(this.typeId);
        }
        assert (this.mapper != null);
        int id = this.mapper.fieldId(this.typeId, fieldName);
        this.writeFieldId(id);
    }

    public void writeFieldId(int fieldId) {
        int fieldOff = this.out.position() - this.start;
        this.schemaId = BinaryUtils.updateSchemaId(this.schemaId, fieldId);
        this.schema.push(fieldId, fieldOff);
        ++this.fieldCnt;
    }

    public void writeFieldIdNoSchemaUpdate(int fieldId) {
        int fieldOff = this.out.position() - this.start;
        this.schema.push(fieldId, fieldOff);
        ++this.fieldCnt;
    }

    public void schemaId(int schemaId) {
        this.schemaId = schemaId;
    }

    public int schemaId() {
        return this.schemaId;
    }

    public BinarySchema currentSchema() {
        BinarySchema.Builder builder = BinarySchema.Builder.newBuilder();
        if (this.schema != null) {
            this.schema.build(builder, this.fieldCnt);
        }
        return builder.build();
    }

    private BinaryWriterHandles handles() {
        if (this.handles == null) {
            this.handles = new BinaryWriterHandles();
        }
        return this.handles;
    }

    boolean tryWriteAsHandle(Object obj) {
        assert (obj != null);
        int pos = this.out.position();
        BinaryWriterHandles handles0 = this.handles();
        int old = handles0.put(obj, pos);
        if (old == -1) {
            return false;
        }
        this.out.unsafeEnsure(5);
        this.out.unsafeWriteByte((byte)102);
        this.out.unsafeWriteInt(pos - old);
        return true;
    }

    public BinaryWriterExImpl newWriter(int typeId) {
        BinaryWriterExImpl res = new BinaryWriterExImpl(this.ctx, this.out, this.schema, this.handles());
        res.failIfUnregistered(this.failIfUnregistered);
        res.typeId(typeId);
        return res;
    }

    public BinaryContext context() {
        return this.ctx;
    }
}

