/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop;

import org.apache.ignite.compute.gridify.GridifyArgument;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridifyArgumentAdapter
implements GridifyArgument {
    private static final long serialVersionUID = 0L;
    private Class<?> cls;
    private String mtdName;
    private Class<?>[] types;
    private Object[] params;
    private Object target;

    public GridifyArgumentAdapter() {
    }

    public GridifyArgumentAdapter(GridifyArgument orig, Object ... newParams) {
        A.notNull(orig, "orig");
        this.cls = orig.getMethodClass();
        this.mtdName = orig.getMethodName();
        this.target = orig.getTarget();
        this.types = new Class[orig.getMethodParameterTypes().length];
        this.params = new Object[orig.getMethodParameters().length];
        System.arraycopy(orig.getMethodParameters(), 0, this.params, 0, this.params.length);
        System.arraycopy(orig.getMethodParameterTypes(), 0, this.types, 0, this.types.length);
        if (newParams.length > 0) {
            this.setMethodParameters(newParams);
        }
    }

    public GridifyArgumentAdapter(Class<?> cls, String mtdName, Class<?>[] types, Object[] params, Object target) {
        this.cls = cls;
        this.mtdName = mtdName;
        this.types = types;
        this.params = params;
        this.target = target;
    }

    @Override
    public Class<?> getMethodClass() {
        return this.cls;
    }

    @Override
    public String getMethodName() {
        return this.mtdName;
    }

    @Override
    public Class<?>[] getMethodParameterTypes() {
        return this.types;
    }

    @Override
    public Object[] getMethodParameters() {
        return this.params;
    }

    public void setMethodClass(Class<?> cls) {
        this.cls = cls;
    }

    public void setMethodName(String mtdName) {
        this.mtdName = mtdName;
    }

    public void setMethodParameterTypes(Class<?> ... types) {
        this.types = types;
    }

    public void updateMethodParameterType(Class<?> type, int index) {
        this.types[index] = type;
    }

    public void setMethodParameters(Object ... params) {
        this.params = params;
    }

    public void updateMethodParameter(Object param, int index) {
        this.params[index] = param;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        return S.toString(GridifyArgumentAdapter.class, this);
    }
}

