/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.Collections;
import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class AttributeNodeFilter
implements IgnitePredicate<ClusterNode> {
    private static final long serialVersionUID = 0L;
    private final Map<String, Object> attrs;

    public AttributeNodeFilter(String attrName, @Nullable Object attrVal) {
        A.notNull(attrName, "attrName");
        this.attrs = Collections.singletonMap(attrName, attrVal);
    }

    public AttributeNodeFilter(Map<String, Object> attrs) {
        A.notNull(attrs, "attrs");
        this.attrs = attrs;
    }

    @Override
    public boolean apply(ClusterNode node) {
        Map<String, Object> nodeAttrs = node.attributes();
        for (Map.Entry<String, Object> attr : this.attrs.entrySet()) {
            if (F.eq(nodeAttrs.get(attr.getKey()), attr.getValue())) continue;
            return false;
        }
        return true;
    }
}

