/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.igfs.IgfsProcessorAdapter;
import org.apache.ignite.internal.util.ipc.IpcServerEndpoint;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.cache.VisorCache;
import org.apache.ignite.internal.visor.cache.VisorMemoryMetrics;
import org.apache.ignite.internal.visor.compute.VisorComputeMonitoringHolder;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.igfs.VisorIgfs;
import org.apache.ignite.internal.visor.igfs.VisorIgfsEndpoint;
import org.apache.ignite.internal.visor.node.VisorAffinityTopologyVersion;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJobResult;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskArg;
import org.apache.ignite.internal.visor.node.VisorPersistenceMetrics;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteProductVersion;

public class VisorNodeDataCollectorJob
extends VisorJob<VisorNodeDataCollectorTaskArg, VisorNodeDataCollectorJobResult> {
    private static final long serialVersionUID = 0L;

    public VisorNodeDataCollectorJob(VisorNodeDataCollectorTaskArg arg, boolean debug) {
        super(arg, debug);
    }

    protected void events0(VisorNodeDataCollectorJobResult res, String evtOrderKey, String evtThrottleCntrKey, boolean all) {
        res.getEvents().addAll(VisorTaskUtils.collectEvents((Ignite)this.ignite, evtOrderKey, evtThrottleCntrKey, all, (IgniteClosure<Event, VisorGridEvent>)VisorTaskUtils.EVT_MAPPER));
    }

    protected void events(VisorNodeDataCollectorJobResult res, VisorNodeDataCollectorTaskArg arg) {
        try {
            if (VisorTaskUtils.checkExplicitTaskMonitoring(this.ignite)) {
                res.setTaskMonitoringEnabled(true);
            } else {
                res.setTaskMonitoringEnabled(arg.isTaskMonitoringEnabled());
                if (arg.isTaskMonitoringEnabled()) {
                    ConcurrentMap<String, VisorComputeMonitoringHolder> storage = this.ignite.cluster().nodeLocalMap();
                    VisorComputeMonitoringHolder holder = (VisorComputeMonitoringHolder)storage.get("VISOR_COMPUTE_MONITORING_KEY");
                    if (holder == null) {
                        VisorComputeMonitoringHolder holderNew = new VisorComputeMonitoringHolder();
                        VisorComputeMonitoringHolder holderOld = storage.putIfAbsent("VISOR_COMPUTE_MONITORING_KEY", holderNew);
                        holder = holderOld == null ? holderNew : holderOld;
                    }
                    holder.startCollect(this.ignite, arg.getEventsOrderKey());
                    res.setTaskMonitoringEnabled(this.ignite.allEventsUserRecordable(VisorTaskUtils.VISOR_TASK_EVTS));
                }
            }
            this.events0(res, arg.getEventsOrderKey(), arg.getEventsThrottleCounterKey(), arg.isTaskMonitoringEnabled());
        }
        catch (Exception e) {
            res.setEventsEx(new VisorExceptionWrapper(e));
        }
    }

    protected boolean compatibleWith(IgniteProductVersion ver) {
        for (ClusterNode node : this.ignite.cluster().nodes()) {
            if (node.version().compareToIgnoreTimestamp(ver) > 0) continue;
            return true;
        }
        return false;
    }

    protected void memoryMetrics(VisorNodeDataCollectorJobResult res) {
        try {
            List<VisorMemoryMetrics> memoryMetrics = res.getMemoryMetrics();
            if (this.ignite.cluster().active()) {
                for (DataRegionMetrics m : this.ignite.dataRegionMetrics()) {
                    memoryMetrics.add(new VisorMemoryMetrics(m));
                }
            }
        }
        catch (Exception e) {
            res.setMemoryMetricsEx(new VisorExceptionWrapper(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void caches(VisorNodeDataCollectorJobResult res, VisorNodeDataCollectorTaskArg arg) {
        try {
            IgniteConfiguration cfg = this.ignite.configuration();
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            Set<String> cacheGrps = arg.getCacheGroups();
            boolean all = F.isEmpty(cacheGrps);
            int partitions = 0;
            double total = 0.0;
            double ready = 0.0;
            List<VisorCache> resCaches = res.getCaches();
            boolean rebalanceInProgress = false;
            for (CacheGroupContext grp : cacheProc.cacheGroups()) {
                boolean first = true;
                for (GridCacheContext cache : grp.caches()) {
                    long start0 = U.currentTimeMillis();
                    String cacheName = cache.name();
                    try {
                        boolean addToRes;
                        GridCacheAdapter ca;
                        if (VisorTaskUtils.isProxyCache(this.ignite, cacheName) || VisorTaskUtils.isRestartingCache(this.ignite, cacheName) || (ca = cacheProc.internalCache(cacheName)) == null || !ca.context().started()) continue;
                        if (first) {
                            CacheMetrics cm = ca.localMetrics();
                            partitions += cm.getTotalPartitionsCount();
                            long keysTotal = cm.getEstimatedRebalancingKeys();
                            long keysReady = cm.getRebalancedKeys();
                            if (keysReady >= keysTotal) {
                                keysReady = Math.max(keysTotal - 1L, 0L);
                            }
                            total += (double)keysTotal;
                            ready += (double)keysReady;
                            if (!rebalanceInProgress && cm.getRebalancingPartitionsCount() > 0) {
                                rebalanceInProgress = true;
                            }
                            first = false;
                        }
                        if (!(addToRes = arg.getSystemCaches() || !GridCacheUtils.isSystemCache(cacheName) && !GridCacheUtils.isIgfsCache(cfg, cacheName)) || !all && !cacheGrps.contains(ca.configuration().getGroupName())) continue;
                        resCaches.add(new VisorCache(this.ignite, ca, arg.isCollectCacheMetrics()));
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        if (!this.debug || this.ignite.log() == null) continue;
                        this.ignite.log().error("Ignored cache: " + cacheName, e);
                    }
                    finally {
                        if (!this.debug) continue;
                        VisorTaskUtils.log(this.ignite.log(), "Collected cache: " + cacheName, this.getClass(), start0);
                    }
                }
            }
            if (partitions == 0) {
                res.setRebalance(-1.0);
            } else if (total == 0.0 && rebalanceInProgress) {
                res.setRebalance(0.01);
            } else {
                res.setRebalance(total > 0.0 && rebalanceInProgress ? Math.max(ready / total, 0.01) : 1.0);
            }
        }
        catch (Exception e) {
            res.setRebalance(-2.0);
            res.setCachesEx(new VisorExceptionWrapper(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void igfs(VisorNodeDataCollectorJobResult res) {
        try {
            IgfsProcessorAdapter igfsProc = this.ignite.context().igfs();
            for (IgniteFileSystem igfs : igfsProc.igfss()) {
                long start0 = U.currentTimeMillis();
                FileSystemConfiguration igfsCfg = igfs.configuration();
                if (VisorTaskUtils.isProxyCache(this.ignite, igfsCfg.getDataCacheConfiguration().getName()) || VisorTaskUtils.isProxyCache(this.ignite, igfsCfg.getMetaCacheConfiguration().getName())) continue;
                try {
                    Collection<IpcServerEndpoint> endPoints = igfsProc.endpoints(igfs.name());
                    if (endPoints != null) {
                        for (IpcServerEndpoint ep : endPoints) {
                            if (!ep.isManagement()) continue;
                            res.getIgfsEndpoints().add(new VisorIgfsEndpoint(igfs.name(), this.ignite.name(), ep.getHost(), ep.getPort()));
                        }
                    }
                    res.getIgfss().add(new VisorIgfs(igfs));
                }
                finally {
                    if (!this.debug) continue;
                    VisorTaskUtils.log(this.ignite.log(), "Collected IGFS: " + igfs.name(), this.getClass(), start0);
                }
            }
        }
        catch (Exception e) {
            res.setIgfssEx(new VisorExceptionWrapper(e));
        }
    }

    protected void persistenceMetrics(VisorNodeDataCollectorJobResult res) {
        try {
            res.setPersistenceMetrics(new VisorPersistenceMetrics(this.ignite.dataStorageMetrics()));
        }
        catch (Exception e) {
            res.setPersistenceMetricsEx(new VisorExceptionWrapper(e));
        }
    }

    @Override
    protected VisorNodeDataCollectorJobResult run(VisorNodeDataCollectorTaskArg arg) {
        return this.run(new VisorNodeDataCollectorJobResult(), arg);
    }

    protected VisorNodeDataCollectorJobResult run(VisorNodeDataCollectorJobResult res, VisorNodeDataCollectorTaskArg arg) {
        res.setGridName(this.ignite.name());
        GridCachePartitionExchangeManager exchange = this.ignite.context().cache().context().exchange();
        res.setReadyAffinityVersion(new VisorAffinityTopologyVersion(exchange.readyAffinityVersion()));
        res.setHasPendingExchange(exchange.hasPendingExchange());
        res.setTopologyVersion(this.ignite.cluster().topologyVersion());
        long start0 = U.currentTimeMillis();
        this.events(res, arg);
        if (this.debug) {
            start0 = VisorTaskUtils.log(this.ignite.log(), "Collected events", this.getClass(), start0);
        }
        this.memoryMetrics(res);
        if (this.debug) {
            start0 = VisorTaskUtils.log(this.ignite.log(), "Collected memory metrics", this.getClass(), start0);
        }
        if (this.ignite.cluster().active()) {
            this.caches(res, arg);
        }
        if (this.debug) {
            start0 = VisorTaskUtils.log(this.ignite.log(), "Collected caches", this.getClass(), start0);
        }
        this.igfs(res);
        if (this.debug) {
            start0 = VisorTaskUtils.log(this.ignite.log(), "Collected igfs", this.getClass(), start0);
        }
        this.persistenceMetrics(res);
        if (this.debug) {
            VisorTaskUtils.log(this.ignite.log(), "Collected persistence metrics", this.getClass(), start0);
        }
        res.setErrorCount(this.ignite.context().exceptionRegistry().errorCount());
        return res;
    }

    public String toString() {
        return S.toString(VisorNodeDataCollectorJob.class, this);
    }
}

