/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class IgniteSecurityProcessor
implements IgniteSecurity,
GridProcessor {
    public static final String ATTR_GRID_SEC_PROC_CLASS = "grid.security.processor.class";
    private final ThreadLocal<SecurityContext> curSecCtx = ThreadLocal.withInitial(this::localSecurityContext);
    private final GridKernalContext ctx;
    private final GridSecurityProcessor secPrc;
    private final JdkMarshaller marsh;
    private final Map<UUID, SecurityContext> secCtxs = new ConcurrentHashMap<UUID, SecurityContext>();

    public IgniteSecurityProcessor(GridKernalContext ctx, GridSecurityProcessor secPrc) {
        assert (ctx != null);
        assert (secPrc != null);
        this.ctx = ctx;
        this.secPrc = secPrc;
        this.marsh = MarshallerUtils.jdkMarshaller(ctx.igniteInstanceName());
    }

    @Override
    public OperationSecurityContext withContext(SecurityContext secCtx) {
        assert (secCtx != null);
        SecurityContext old = this.curSecCtx.get();
        this.curSecCtx.set(secCtx);
        return new OperationSecurityContext(this, old);
    }

    @Override
    public OperationSecurityContext withContext(UUID nodeId) {
        return this.withContext(this.secCtxs.computeIfAbsent(nodeId, uuid -> SecurityUtils.nodeSecurityContext(this.marsh, U.resolveClassLoader(this.ctx.config()), this.ctx.discovery().node((UUID)uuid))));
    }

    @Override
    public SecurityContext securityContext() {
        SecurityContext res = this.curSecCtx.get();
        assert (res != null);
        return res;
    }

    @Override
    public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) throws IgniteCheckedException {
        return this.secPrc.authenticateNode(node, cred);
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return this.secPrc.isGlobalNodeAuthentication();
    }

    @Override
    public SecurityContext authenticate(AuthenticationContext ctx) throws IgniteCheckedException {
        return this.secPrc.authenticate(ctx);
    }

    @Override
    public Collection<SecuritySubject> authenticatedSubjects() throws IgniteCheckedException {
        return this.secPrc.authenticatedSubjects();
    }

    @Override
    public SecuritySubject authenticatedSubject(UUID subjId) throws IgniteCheckedException {
        return this.secPrc.authenticatedSubject(subjId);
    }

    @Override
    public void onSessionExpired(UUID subjId) {
        this.secPrc.onSessionExpired(subjId);
    }

    @Override
    public void authorize(String name, SecurityPermission perm) throws SecurityException {
        SecurityContext secCtx = this.curSecCtx.get();
        assert (secCtx != null);
        this.secPrc.authorize(name, perm, secCtx);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute(ATTR_GRID_SEC_PROC_CLASS, this.secPrc.getClass().getName());
        this.secPrc.start();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.secPrc.stop(cancel);
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        this.ctx.event().addDiscoveryEventListener((evt, discoCache) -> this.secCtxs.remove(evt.eventNode().id()), 12, 11);
        this.secPrc.onKernalStart(active);
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.secPrc.onKernalStop(cancel);
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        this.secPrc.collectJoiningNodeData(dataBag);
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        this.secPrc.collectGridNodeData(dataBag);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        this.secPrc.onGridDataReceived(data);
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        this.secPrc.onJoiningNodeDataReceived(data);
    }

    @Override
    public void printMemoryStats() {
        this.secPrc.printMemoryStats();
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null ? res : this.secPrc.validateNode(node);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        IgniteNodeValidationResult res = this.validateSecProcClass(node);
        return res != null ? res : this.secPrc.validateNode(node, discoData);
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return this.secPrc.discoveryDataType();
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.secPrc.onDisconnected(reconnectFut);
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        return this.secPrc.onReconnected(clusterRestarted);
    }

    private SecurityContext localSecurityContext() {
        return SecurityUtils.nodeSecurityContext(this.marsh, U.resolveClassLoader(this.ctx.config()), this.ctx.discovery().localNode());
    }

    private IgniteNodeValidationResult validateSecProcClass(ClusterNode node) {
        String rmtCls = (String)node.attribute(ATTR_GRID_SEC_PROC_CLASS);
        String locCls = this.secPrc.getClass().getName();
        if (!F.eq(locCls, rmtCls)) {
            return new IgniteNodeValidationResult(node.id(), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", this.ctx.localNodeId(), node.id(), locCls, rmtCls), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", node.id(), this.ctx.localNodeId(), rmtCls, locCls));
        }
        return null;
    }
}

