/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcIndexMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaIndexesResult
extends JdbcResult {
    private List<JdbcIndexMeta> meta;

    JdbcMetaIndexesResult() {
        super((byte)9);
    }

    JdbcMetaIndexesResult(Collection<JdbcIndexMeta> meta) {
        super((byte)9);
        this.meta = new ArrayList<JdbcIndexMeta>(meta);
    }

    public List<JdbcIndexMeta> meta() {
        return this.meta;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        if (F.isEmpty(this.meta)) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.meta.size());
            for (JdbcIndexMeta m : this.meta) {
                m.writeBinary(writer, ver);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        int size = reader.readInt();
        if (size == 0) {
            this.meta = Collections.emptyList();
        } else {
            this.meta = new ArrayList<JdbcIndexMeta>(size);
            for (int i = 0; i < size; ++i) {
                JdbcIndexMeta m = new JdbcIndexMeta();
                m.readBinary(reader, ver);
                this.meta.add(m);
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaIndexesResult.class, this);
    }
}

