/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import java.util.NavigableMap;
import java.util.TreeMap;

class SegmentReservationStorage {
    private NavigableMap<Long, Integer> reserved = new TreeMap<Long, Integer>();

    SegmentReservationStorage() {
    }

    synchronized void reserve(long absIdx) {
        this.reserved.merge(absIdx, 1, (a, b) -> a + b);
    }

    synchronized boolean reserved(long absIdx) {
        return this.reserved.floorKey(absIdx) != null;
    }

    synchronized void release(long absIdx) {
        Integer cur = (Integer)this.reserved.get(absIdx);
        assert (cur != null && cur >= 1) : "cur=" + cur + ", absIdx=" + absIdx;
        if (cur == 1) {
            this.reserved.remove(absIdx);
        } else {
            this.reserved.put(absIdx, cur - 1);
        }
    }
}

