/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentObservable;

public class SegmentLockStorage
extends SegmentObservable {
    private Map<Long, Integer> locked = new ConcurrentHashMap<Long, Integer>();

    public boolean locked(long absIdx) {
        return this.locked.containsKey(absIdx);
    }

    boolean lockWorkSegment(long absIdx) {
        this.locked.compute(absIdx, (idx, count) -> count == null ? 1 : count + 1);
        return false;
    }

    void releaseWorkSegment(long absIdx) {
        this.locked.compute(absIdx, (idx, count) -> {
            assert (count != null && count >= 1) : "cur=" + count + ", absIdx=" + absIdx;
            return count == 1 ? null : Integer.valueOf(count - 1);
        });
        this.notifyObservers(absIdx);
    }
}

