/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.marshaller.optimized.OptimizedClassDescriptor;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerIdMapper;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.marshaller.MarshallerContext;

class OptimizedMarshallerUtils {
    static final long HASH_SET_MAP_OFF;
    static final byte JDK = -2;
    static final byte HANDLE = -1;
    static final byte NULL = 0;
    static final byte BYTE = 1;
    static final byte SHORT = 2;
    static final byte INT = 3;
    static final byte LONG = 4;
    static final byte FLOAT = 5;
    static final byte DOUBLE = 6;
    static final byte CHAR = 7;
    static final byte BOOLEAN = 8;
    static final byte BYTE_ARR = 9;
    static final byte SHORT_ARR = 10;
    static final byte INT_ARR = 11;
    static final byte LONG_ARR = 12;
    static final byte FLOAT_ARR = 13;
    static final byte DOUBLE_ARR = 14;
    static final byte CHAR_ARR = 15;
    static final byte BOOLEAN_ARR = 16;
    static final byte OBJ_ARR = 17;
    static final byte STR = 18;
    static final byte UUID = 19;
    static final byte PROPS = 20;
    static final byte ARRAY_LIST = 21;
    static final byte HASH_MAP = 22;
    static final byte HASH_SET = 23;
    static final byte LINKED_LIST = 24;
    static final byte LINKED_HASH_MAP = 25;
    static final byte LINKED_HASH_SET = 26;
    static final byte DATE = 27;
    static final byte CLS = 28;
    static final byte PROXY = 29;
    static final byte ENUM = 100;
    static final byte EXTERNALIZABLE = 101;
    static final byte SERIALIZABLE = 102;
    static final Charset UTF_8;

    private OptimizedMarshallerUtils() {
    }

    static OptimizedClassDescriptor classDescriptor(ConcurrentMap<Class, OptimizedClassDescriptor> clsMap, Class cls, MarshallerContext ctx, OptimizedMarshallerIdMapper mapper) throws IOException {
        OptimizedClassDescriptor desc = (OptimizedClassDescriptor)clsMap.get(cls);
        if (desc == null) {
            OptimizedClassDescriptor old;
            boolean registered;
            int typeId = OptimizedMarshallerUtils.resolveTypeId(cls.getName(), mapper);
            try {
                registered = ctx.registerClassName((byte)0, typeId, cls.getName(), false);
            }
            catch (Exception e) {
                throw new IOException("Failed to register class: " + cls.getName(), e);
            }
            desc = new OptimizedClassDescriptor(cls, registered ? typeId : 0, clsMap, ctx, mapper);
            if (registered && (old = clsMap.putIfAbsent(cls, desc)) != null) {
                desc = old;
            }
        }
        return desc;
    }

    private static int resolveTypeId(String clsName, OptimizedMarshallerIdMapper mapper) {
        int typeId;
        if (mapper != null) {
            typeId = mapper.typeId(clsName);
            if (typeId == 0) {
                typeId = clsName.hashCode();
            }
        } else {
            typeId = clsName.hashCode();
        }
        return typeId;
    }

    static OptimizedClassDescriptor classDescriptor(ConcurrentMap<Class, OptimizedClassDescriptor> clsMap, int typeId, ClassLoader ldr, MarshallerContext ctx, OptimizedMarshallerIdMapper mapper) throws IOException, ClassNotFoundException {
        OptimizedClassDescriptor old;
        Class cls;
        try {
            cls = ctx.getClass(typeId, ldr);
        }
        catch (IgniteCheckedException e) {
            throw new IOException("Failed to resolve class for ID: " + typeId, e);
        }
        OptimizedClassDescriptor desc = (OptimizedClassDescriptor)clsMap.get(cls);
        if (desc == null && (old = clsMap.putIfAbsent(cls, desc = new OptimizedClassDescriptor(cls, OptimizedMarshallerUtils.resolveTypeId(cls.getName(), mapper), clsMap, ctx, mapper))) != null) {
            desc = old;
        }
        return desc;
    }

    static short computeSerialVersionUid(Class cls, List<Field> fields) throws IOException {
        MessageDigest md;
        if (Serializable.class.isAssignableFrom(cls) && !Enum.class.isAssignableFrom(cls)) {
            try {
                int mod;
                Field field = cls.getDeclaredField("serialVersionUID");
                if (field.getType() == Long.TYPE && Modifier.isStatic(mod = field.getModifiers()) && Modifier.isFinal(mod)) {
                    field.setAccessible(true);
                    return (short)field.getLong(null);
                }
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            if (OptimizedMarshaller.USE_DFLT_SUID) {
                return (short)ObjectStreamClass.lookup(cls).getSerialVersionUID();
            }
        }
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to get digest for SHA.", e);
        }
        md.update(cls.getName().getBytes(UTF_8));
        if (!F.isEmpty(fields)) {
            for (int i = 0; i < fields.size(); ++i) {
                Field f = fields.get(i);
                md.update(f.getName().getBytes(UTF_8));
                md.update(f.getType().getName().getBytes(UTF_8));
            }
        }
        byte[] hashBytes = md.digest();
        long hash = 0L;
        for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
            hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
        }
        return (short)hash;
    }

    static byte getByte(Object obj, long off) {
        return GridUnsafe.getByteField(obj, off);
    }

    static void setByte(Object obj, long off, byte val) {
        GridUnsafe.putByteField(obj, off, val);
    }

    static short getShort(Object obj, long off) {
        return GridUnsafe.getShortField(obj, off);
    }

    static void setShort(Object obj, long off, short val) {
        GridUnsafe.putShortField(obj, off, val);
    }

    static int getInt(Object obj, long off) {
        return GridUnsafe.getIntField(obj, off);
    }

    static void setInt(Object obj, long off, int val) {
        GridUnsafe.putIntField(obj, off, val);
    }

    static long getLong(Object obj, long off) {
        return GridUnsafe.getLongField(obj, off);
    }

    static void setLong(Object obj, long off, long val) {
        GridUnsafe.putLongField(obj, off, val);
    }

    static float getFloat(Object obj, long off) {
        return GridUnsafe.getFloatField(obj, off);
    }

    static void setFloat(Object obj, long off, float val) {
        GridUnsafe.putFloatField(obj, off, val);
    }

    static double getDouble(Object obj, long off) {
        return GridUnsafe.getDoubleField(obj, off);
    }

    static void setDouble(Object obj, long off, double val) {
        GridUnsafe.putDoubleField(obj, off, val);
    }

    static char getChar(Object obj, long off) {
        return GridUnsafe.getCharField(obj, off);
    }

    static void setChar(Object obj, long off, char val) {
        GridUnsafe.putCharField(obj, off, val);
    }

    static boolean getBoolean(Object obj, long off) {
        return GridUnsafe.getBooleanField(obj, off);
    }

    static void setBoolean(Object obj, long off, boolean val) {
        GridUnsafe.putBooleanField(obj, off, val);
    }

    static Object getObject(Object obj, long off) {
        return GridUnsafe.getObjectField(obj, off);
    }

    static void setObject(Object obj, long off, Object val) {
        GridUnsafe.putObjectField(obj, off, val);
    }

    static {
        long mapOff;
        UTF_8 = Charset.forName("UTF-8");
        try {
            mapOff = GridUnsafe.objectFieldOffset(HashSet.class.getDeclaredField("map"));
        }
        catch (NoSuchFieldException ignored) {
            try {
                mapOff = GridUnsafe.objectFieldOffset(HashSet.class.getDeclaredField("backingMap"));
            }
            catch (NoSuchFieldException e2) {
                throw new IgniteException("Initialization failure.", e2);
            }
        }
        HASH_SET_MAP_OFF = mapOff;
    }
}

