/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

import static org.apache.ignite.IgniteJdbcDriver.CFG_URL_PREFIX;

/**
 * Connection test.
 */
public class JdbcConnectionReopenTest extends GridCommonAbstractTest {
    /**
     * @return Config URL to use in test.
     */
    private String configURL() {
        return "modules/clients/src/test/config/jdbc-config.xml";
    }

    /**
     * @throws Exception If failed.
     */
    public void testReopenSameInstanceName() throws Exception {
        String url = CFG_URL_PREFIX + configURL();

        try (Ignite ignite = IgnitionEx.start(configURL())) {
            try (Connection conn = DriverManager.getConnection(url)) {
                assertNotNull(conn);
            }
        }
    }
}
