/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.springdata.repository.IgniteRepository;
import org.apache.ignite.springdata.repository.config.Query;
import org.apache.ignite.springdata.repository.config.RepositoryConfig;
import org.apache.ignite.springdata.repository.query.IgniteQuery;
import org.apache.ignite.springdata.repository.query.IgniteQueryGenerator;
import org.apache.ignite.springdata.repository.query.IgniteRepositoryQuery;
import org.apache.ignite.springdata.repository.support.IgniteRepositoryImpl;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IgniteRepositoryFactory
extends RepositoryFactorySupport {
    private Ignite ignite;
    private final Map<Class<?>, String> repoToCache = new HashMap();

    public IgniteRepositoryFactory(Ignite ignite) {
        this.ignite = ignite;
    }

    public IgniteRepositoryFactory(IgniteConfiguration cfg) {
        this.ignite = Ignition.start((IgniteConfiguration)cfg);
    }

    public IgniteRepositoryFactory(String springCfgPath) {
        this.ignite = Ignition.start((String)springCfgPath);
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new AbstractEntityInformation<T, ID>(domainClass){

            public ID getId(T entity) {
                return null;
            }

            public Class<ID> getIdType() {
                return null;
            }
        };
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return IgniteRepositoryImpl.class;
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repoItf) {
        Assert.notNull(repoItf, (String)"Repository interface must be set.");
        Assert.isAssignable(IgniteRepository.class, repoItf, (String)"Repository must implement IgniteRepository interface.");
        RepositoryConfig annotation = repoItf.getAnnotation(RepositoryConfig.class);
        Assert.notNull((Object)annotation, (String)"Set a name of an Apache Ignite cache using @RepositoryConfig annotation to map this repository to the underlying cache.");
        Assert.hasText((String)annotation.cacheName(), (String)"Set a name of an Apache Ignite cache using @RepositoryConfig annotation to map this repository to the underlying cache.");
        this.repoToCache.put(repoItf, annotation.cacheName());
        return super.getRepositoryMetadata(repoItf);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.ignite.getOrCreateCache(this.repoToCache.get(metadata.getRepositoryInterface()))});
    }

    protected QueryLookupStrategy getQueryLookupStrategy(final QueryLookupStrategy.Key key, EvaluationContextProvider evaluationCtxProvider) {
        return new QueryLookupStrategy(){

            public RepositoryQuery resolveQuery(Method mtd, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
                Query annotation = mtd.getAnnotation(Query.class);
                if (annotation != null) {
                    String qryStr = annotation.value();
                    if (key != QueryLookupStrategy.Key.CREATE && StringUtils.hasText((String)qryStr)) {
                        return new IgniteRepositoryQuery(metadata, new IgniteQuery(qryStr, IgniteRepositoryFactory.this.isFieldQuery(qryStr), IgniteQueryGenerator.getOptions(mtd)), mtd, factory, IgniteRepositoryFactory.this.ignite.getOrCreateCache((String)IgniteRepositoryFactory.this.repoToCache.get(metadata.getRepositoryInterface())));
                    }
                }
                if (key == QueryLookupStrategy.Key.USE_DECLARED_QUERY) {
                    throw new IllegalStateException("To use QueryLookupStrategy.Key.USE_DECLARED_QUERY, pass a query string via org.apache.ignite.springdata.repository.config.Query annotation.");
                }
                return new IgniteRepositoryQuery(metadata, IgniteQueryGenerator.generateSql(mtd, metadata), mtd, factory, IgniteRepositoryFactory.this.ignite.getOrCreateCache((String)IgniteRepositoryFactory.this.repoToCache.get(metadata.getRepositoryInterface())));
            }
        };
    }

    private boolean isFieldQuery(String qry) {
        return qry.matches("^SELECT.*") && !qry.matches("^SELECT\\s+(?:\\w+\\.)?+\\*.*");
    }
}

