/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.ignite.IgniteException;

public class Utils {
    public static <T> T copy(T orig) {
        Object obj;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            obj = in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IgniteException("Couldn't copy the object.", (Throwable)e);
        }
        return (T)obj;
    }

    public static int[] selectKDistinct(int n, int k, Random rand) {
        int i;
        Random r = rand != null ? rand : new Random();
        int[] res = new int[k];
        for (i = 0; i < k; ++i) {
            res[i] = i;
        }
        while (i < n) {
            int j = r.nextInt(i + 1);
            if (j < k) {
                res[j] = i;
            }
            ++i;
        }
        return res;
    }

    public static int[] selectKDistinct(int n, int k) {
        return Utils.selectKDistinct(n, k, new Random());
    }
}

