/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree;

import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.tree.DecisionTree;
import org.apache.ignite.ml.tree.data.DecisionTreeData;
import org.apache.ignite.ml.tree.impurity.ImpurityMeasureCalculator;
import org.apache.ignite.ml.tree.impurity.mse.MSEImpurityMeasure;
import org.apache.ignite.ml.tree.impurity.mse.MSEImpurityMeasureCalculator;
import org.apache.ignite.ml.tree.impurity.util.StepFunctionCompressor;
import org.apache.ignite.ml.tree.leaf.MeanDecisionTreeLeafBuilder;

public class DecisionTreeRegressionTrainer
extends DecisionTree<MSEImpurityMeasure> {
    public DecisionTreeRegressionTrainer(int maxDeep, double minImpurityDecrease) {
        this(maxDeep, minImpurityDecrease, null);
    }

    public DecisionTreeRegressionTrainer(int maxDeep, double minImpurityDecrease, StepFunctionCompressor<MSEImpurityMeasure> compressor) {
        super(maxDeep, minImpurityDecrease, compressor, new MeanDecisionTreeLeafBuilder());
    }

    public DecisionTreeRegressionTrainer withUsingIdx(boolean usingIdx) {
        this.usingIdx = usingIdx;
        return this;
    }

    @Override
    protected ImpurityMeasureCalculator<MSEImpurityMeasure> getImpurityMeasureCalculator(Dataset<EmptyContext, DecisionTreeData> dataset) {
        return new MSEImpurityMeasureCalculator(this.usingIdx);
    }
}

