/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric;

import java.util.Iterator;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.metric.Metric;

public class Precision<L>
implements Metric<L> {
    private L clsLb;

    @Override
    public double score(Iterator<LabelPair<L>> it) {
        if (this.clsLb != null) {
            long tp = 0L;
            long fp = 0L;
            while (it.hasNext()) {
                LabelPair<L> e = it.next();
                L prediction = e.getPrediction();
                L truth = e.getTruth();
                if (!this.clsLb.equals(prediction)) continue;
                if (prediction.equals(truth)) {
                    ++tp;
                    continue;
                }
                ++fp;
            }
            long denominator = tp + fp;
            if (denominator == 0L) {
                return 1.0;
            }
            return (double)tp / (double)denominator;
        }
        return Double.NaN;
    }

    public Precision(L clsLb) {
        this.clsLb = clsLb;
    }
}

