/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.cursor;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.cursor.LabelPairCursor;
import org.jetbrains.annotations.NotNull;

public class LocalLabelPairCursor<L, K, V, T>
implements LabelPairCursor<L> {
    private final Map<K, V> upstreamMap;
    private final IgniteBiPredicate<K, V> filter;
    private final IgniteBiFunction<K, V, Vector> featureExtractor;
    private final IgniteBiFunction<K, V, L> lbExtractor;
    private final Model<Vector, L> mdl;

    public LocalLabelPairCursor(Map<K, V> upstreamMap, IgniteBiPredicate<K, V> filter, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor, Model<Vector, L> mdl) {
        this.upstreamMap = upstreamMap;
        this.filter = filter;
        this.featureExtractor = featureExtractor;
        this.lbExtractor = lbExtractor;
        this.mdl = mdl;
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public Iterator<LabelPair<L>> iterator() {
        return new TruthWithPredictionIterator(this.upstreamMap.entrySet().iterator());
    }

    private class TruthWithPredictionIterator
    implements Iterator<LabelPair<L>> {
        private final Iterator<Map.Entry<K, V>> iter;
        private Map.Entry<K, V> nextEntry;

        public TruthWithPredictionIterator(Iterator<Map.Entry<K, V>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.nextEntry != null;
        }

        @Override
        public LabelPair<L> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object key = this.nextEntry.getKey();
            Object val = this.nextEntry.getValue();
            Vector features = (Vector)LocalLabelPairCursor.this.featureExtractor.apply(key, val);
            Object lb = LocalLabelPairCursor.this.lbExtractor.apply(key, val);
            this.nextEntry = null;
            return new LabelPair(lb, LocalLabelPairCursor.this.mdl.apply(features));
        }

        private void findNext() {
            while (this.nextEntry == null && this.iter.hasNext()) {
                Map.Entry entry = this.iter.next();
                if (!LocalLabelPairCursor.this.filter.apply(entry.getKey(), entry.getValue())) continue;
                this.nextEntry = entry;
                break;
            }
        }
    }
}

