/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.impl;

import java.util.Map;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.matrix.impl.DenseMatrix;
import org.apache.ignite.ml.math.primitives.vector.AbstractVector;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;
import org.apache.ignite.ml.math.primitives.vector.storage.DenseVectorStorage;

public class DenseVector
extends AbstractVector {
    private VectorStorage mkStorage(int size) {
        return new DenseVectorStorage(size);
    }

    private VectorStorage mkStorage(double[] arr, boolean cp) {
        assert (arr != null);
        return new DenseVectorStorage(cp ? (double[])arr.clone() : arr);
    }

    public DenseVector(Map<String, Object> args) {
        assert (args != null);
        if (args.containsKey("size")) {
            this.setStorage(this.mkStorage((Integer)args.get("size")));
        } else if (args.containsKey("arr") && args.containsKey("copy")) {
            this.setStorage(this.mkStorage((double[])args.get("arr"), (Boolean)args.get("copy")));
        } else {
            throw new UnsupportedOperationException("Invalid constructor argument(s).");
        }
    }

    public DenseVector() {
    }

    public DenseVector(int size) {
        this.setStorage(this.mkStorage(size));
    }

    public DenseVector(double[] arr, boolean shallowCp) {
        this.setStorage(this.mkStorage(arr, shallowCp));
    }

    public DenseVector(double[] arr) {
        this(arr, false);
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return new DenseMatrix(rows, cols);
    }

    @Override
    public Vector like(int crd) {
        return new DenseVector(crd);
    }
}

