/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.primitive.builder.data;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.data.SimpleLabeledDatasetData;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class SimpleLabeledDatasetDataBuilder<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, SimpleLabeledDatasetData> {
    private static final long serialVersionUID = 3678784980215216039L;
    private final IgniteBiFunction<K, V, Vector> featureExtractor;
    private final IgniteBiFunction<K, V, double[]> lbExtractor;

    public SimpleLabeledDatasetDataBuilder(IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, double[]> lbExtractor) {
        this.featureExtractor = featureExtractor;
        this.lbExtractor = lbExtractor;
    }

    @Override
    public SimpleLabeledDatasetData build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        int featureCols = -1;
        int lbCols = -1;
        double[] features = null;
        double[] labels = null;
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            Vector featureRow = (Vector)this.featureExtractor.apply(entry.getKey(), entry.getValue());
            if (featureCols < 0) {
                featureCols = featureRow.size();
                features = new double[Math.toIntExact(upstreamDataSize * (long)featureCols)];
            } else assert (featureRow.size() == featureCols) : "Feature extractor must return exactly " + featureCols + " features";
            for (int i = 0; i < featureCols; ++i) {
                features[Math.toIntExact((long)((long)i * upstreamDataSize)) + ptr] = featureRow.get(i);
            }
            double[] lbRow = (double[])this.lbExtractor.apply(entry.getKey(), entry.getValue());
            if (lbCols < 0) {
                lbCols = lbRow.length;
                labels = new double[Math.toIntExact(upstreamDataSize * (long)lbCols)];
            }
            assert (lbRow.length == lbCols) : "Label extractor must return exactly " + lbCols + " labels";
            for (int i = 0; i < lbCols; ++i) {
                labels[Math.toIntExact((long)((long)i * upstreamDataSize)) + ptr] = lbRow[i];
            }
            ++ptr;
        }
        return new SimpleLabeledDatasetData(features, labels, Math.toIntExact(upstreamDataSize));
    }
}

