/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.local;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.impl.local.LocalDataset;
import org.apache.ignite.ml.math.functions.IgniteFunction;

public class LocalDatasetBuilder<K, V>
implements DatasetBuilder<K, V> {
    private final Map<K, V> upstreamMap;
    private final int partitions;
    private final IgniteBiPredicate<K, V> filter;

    public LocalDatasetBuilder(Map<K, V> upstreamMap, int partitions) {
        this(upstreamMap, (IgniteBiPredicate & Serializable)(a, b) -> true, partitions);
    }

    public LocalDatasetBuilder(Map<K, V> upstreamMap, IgniteBiPredicate<K, V> filter, int partitions) {
        this.upstreamMap = upstreamMap;
        this.filter = filter;
        this.partitions = partitions;
    }

    @Override
    public <C extends Serializable, D extends AutoCloseable> LocalDataset<C, D> build(PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        ArrayList ctxList = new ArrayList();
        ArrayList<Object> dataList = new ArrayList<Object>();
        HashMap filteredMap = new HashMap();
        this.upstreamMap.forEach((key, val) -> {
            if (this.filter.apply(key, val)) {
                filteredMap.put(key, val);
            }
        });
        int partSize = Math.max(1, filteredMap.size() / this.partitions);
        Iterator firstKeysIter = filteredMap.keySet().iterator();
        Iterator secondKeysIter = filteredMap.keySet().iterator();
        int ptr = 0;
        for (int part = 0; part < this.partitions; ++part) {
            int cnt = part == this.partitions - 1 ? filteredMap.size() - ptr : Math.min(partSize, filteredMap.size() - ptr);
            Object ctx = cnt > 0 ? (Object)partCtxBuilder.build(new IteratorWindow(firstKeysIter, k -> new UpstreamEntry(k, filteredMap.get(k)), cnt), cnt) : null;
            Object data = cnt > 0 ? (Object)partDataBuilder.build(new IteratorWindow(secondKeysIter, k -> new UpstreamEntry(k, filteredMap.get(k)), cnt), cnt, ctx) : null;
            ctxList.add(ctx);
            dataList.add(data);
            ptr += cnt;
        }
        return new LocalDataset(ctxList, dataList);
    }

    @Override
    public DatasetBuilder<K, V> withFilter(IgniteBiPredicate<K, V> filterToAdd) {
        return new LocalDatasetBuilder<K, V>(this.upstreamMap, (IgniteBiPredicate & Serializable)(e1, e2) -> this.filter.apply(e1, e2) && filterToAdd.apply(e1, e2), this.partitions);
    }

    private static class IteratorWindow<K, T>
    implements Iterator<T> {
        private final Iterator<K> delegate;
        private final IgniteFunction<K, T> map;
        private final int cnt;
        private int ptr;

        IteratorWindow(Iterator<K> delegate, IgniteFunction<K, T> map, int cnt) {
            this.delegate = delegate;
            this.map = map;
            this.cnt = cnt;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext() && this.ptr < this.cnt;
        }

        @Override
        public T next() {
            ++this.ptr;
            return (T)this.map.apply(this.delegate.next());
        }
    }
}

