/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.feature;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.ignite.ml.dataset.feature.DistributionComputer;
import org.apache.ignite.ml.dataset.feature.Histogram;
import org.apache.ignite.ml.math.functions.IgniteFunction;

public class ObjectHistogram<T>
implements Histogram<T, ObjectHistogram<T>>,
DistributionComputer {
    private static final long serialVersionUID = -2708731174031404487L;
    private final IgniteFunction<T, Integer> bucketMapping;
    private final IgniteFunction<T, Double> mappingToCntr;
    private final Map<Integer, Double> hist;

    public ObjectHistogram(IgniteFunction<T, Integer> bucketMapping, IgniteFunction<T, Double> mappingToCntr) {
        this.bucketMapping = bucketMapping;
        this.mappingToCntr = mappingToCntr;
        this.hist = new TreeMap<Integer, Double>(Integer::compareTo);
    }

    @Override
    public void addElement(T val) {
        Integer bucket = (Integer)this.bucketMapping.apply(val);
        Double cntrVal = (Double)this.mappingToCntr.apply(val);
        assert (cntrVal >= 0.0);
        Double bucketVal = this.hist.getOrDefault(bucket, 0.0);
        this.hist.put(bucket, bucketVal + cntrVal);
    }

    @Override
    public Set<Integer> buckets() {
        return this.hist.keySet();
    }

    @Override
    public Optional<Double> getValue(Integer bucketId) {
        return Optional.ofNullable(this.hist.get(bucketId));
    }

    @Override
    public TreeMap<Integer, Double> computeDistributionFunction() {
        TreeMap<Integer, Double> res = new TreeMap<Integer, Double>();
        double accum = 0.0;
        for (Integer bucket : this.hist.keySet()) {
            res.put(bucket, accum += this.hist.get(bucket).doubleValue());
        }
        return res;
    }

    @Override
    public ObjectHistogram<T> plus(ObjectHistogram<T> other) {
        ObjectHistogram<T> res = new ObjectHistogram<T>(this.bucketMapping, this.mappingToCntr);
        this.addTo(this.hist, res.hist);
        this.addTo(other.hist, res.hist);
        return res;
    }

    private void addTo(Map<Integer, Double> from, Map<Integer, Double> to) {
        from.forEach((bucket, value) -> {
            Double putVal = to.getOrDefault(bucket, 0.0);
            to.put((Integer)bucket, putVal + value);
        });
    }

    @Override
    public boolean isEqualTo(ObjectHistogram<T> other) {
        HashSet<Integer> totalBuckets = new HashSet<Integer>(this.buckets());
        totalBuckets.addAll(other.buckets());
        if (totalBuckets.size() != this.buckets().size()) {
            return false;
        }
        for (Integer bucketId : totalBuckets) {
            double rightVal;
            double leftVal = this.hist.get(bucketId);
            if (!(Math.abs(leftVal - (rightVal = other.hist.get(bucketId).doubleValue())) > 0.001)) continue;
            return false;
        }
        return true;
    }
}

