/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.composition;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.util.ModelTrace;

public class ModelOnFeaturesSubspace
implements Model<Vector, Double> {
    private final Map<Integer, Integer> featuresMapping;
    private final Model<Vector, Double> mdl;

    ModelOnFeaturesSubspace(Map<Integer, Integer> featuresMapping, Model<Vector, Double> mdl) {
        this.featuresMapping = Collections.unmodifiableMap(featuresMapping);
        this.mdl = mdl;
    }

    @Override
    public Double apply(Vector features) {
        double[] newFeatures = new double[this.featuresMapping.size()];
        this.featuresMapping.forEach((localId, featureVectorId) -> {
            newFeatures[localId.intValue()] = features.get((int)featureVectorId);
        });
        return (Double)this.mdl.apply(VectorUtils.of(newFeatures));
    }

    public Map<Integer, Integer> getFeaturesMapping() {
        return this.featuresMapping;
    }

    public Model<Vector, Double> getMdl() {
        return this.mdl;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean pretty) {
        String mappingStr = this.featuresMapping.entrySet().stream().map(e -> String.format("%d -> %d", e.getKey(), e.getValue())).collect(Collectors.joining(", ", "{", "}"));
        return ModelTrace.builder("ModelOnFeatureSubspace", pretty).addField("features mapping", mappingStr).addField("model", this.mdl.toString(false)).toString();
    }
}

