/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr[, isIgnoreNull]) - Returns the last value of `expr` for a group of rows.\n      If `isIgnoreNull` is true, returns only non-null values.\n  ")
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001F\u0011A\u0001T1ti*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000f!\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0006\u0001I1\"\u0004\t\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011A\u0003R3dY\u0006\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007CA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b!J|G-^2u!\tY\u0012%\u0003\u0002#9\ta1+\u001a:jC2L'0\u00192mK\"AA\u0005\u0001BK\u0002\u0013\u0005Q%A\u0003dQ&dG-F\u0001'!\t9r%\u0003\u0002)\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011)\u0002!\u0011#Q\u0001\n\u0019\naa\u00195jY\u0012\u0004\u0003\u0002\u0003\u0017\u0001\u0005+\u0007I\u0011A\u0013\u0002\u001f%<gn\u001c:f\u001dVdGn]#yaJD\u0001B\f\u0001\u0003\u0012\u0003\u0006IAJ\u0001\u0011S\u001etwN]3Ok2d7/\u0012=qe\u0002BQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtDc\u0001\u001a4iA\u00111\u0003\u0001\u0005\u0006I=\u0002\rA\n\u0005\u0006Y=\u0002\rA\n\u0005\u0006a\u0001!\tA\u000e\u000b\u0003e]BQ\u0001J\u001bA\u0002\u0019BQ!\u000f\u0001\u0005Bi\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002wA\u0019A\b\u0012\u0014\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!\u0011\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002D9\u00059\u0001/Y2lC\u001e,\u0017BA#G\u0005\r\u0019V-\u001d\u0006\u0003\u0007rAQ\u0001\u0013\u0001\u0005B%\u000b\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002\u0015B\u00111dS\u0005\u0003\u0019r\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005O\u0001!\u0015\r\u0011\"\u0011J\u00035!W\r^3s[&t\u0017n\u001d;jG\"A\u0001\u000b\u0001E\u0001B\u0003&!*\u0001\beKR,'/\\5oSN$\u0018n\u0019\u0011\t\u000bI\u0003A\u0011I*\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\"\tQ\u0001^=qKNL!!\u0017,\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQa\u0017\u0001\u0005Bq\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005i\u0006c\u0001\u001fE=B\u0011QkX\u0005\u0003AZ\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b\t\u0004A\u0011I2\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0004\u0002\u0011\u0005t\u0017\r\\=tSNL!!\u001b4\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDQa\u001b\u0001\u0005\n%\u000b1\"[4o_J,g*\u001e7mg\"AQ\u000e\u0001EC\u0002\u0013%a.\u0001\u0003mCN$X#A8\u0011\u0005]\u0001\u0018BA9\u0005\u0005I\tE\u000f\u001e:jEV$XMU3gKJ,gnY3\t\u0011M\u0004\u0001\u0012!Q!\n=\fQ\u0001\\1ti\u0002B\u0001\"\u001e\u0001\t\u0006\u0004%IA\\\u0001\tm\u0006dW/Z*fi\"Aq\u000f\u0001E\u0001B\u0003&q.A\u0005wC2,XmU3uA!A\u0011\u0010\u0001EC\u0002\u0013\u0005#0A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/F\u0001|!\raDi\u001c\u0005\t{\u0002A\t\u0011)Q\u0005w\u0006!\u0012mZ4Ck\u001a4WM]!uiJL'-\u001e;fg\u0002B\u0011b \u0001\t\u0006\u0004%\t%!\u0001\u0002\u001b%t\u0017\u000e^5bYZ\u000bG.^3t+\t\t\u0019\u0001\u0005\u0003=\t\u0006\u0015\u0001cA\f\u0002\b%\u0019\u0011\u0011\u0002\u0003\u0003\u000f1KG/\u001a:bY\"Q\u0011Q\u0002\u0001\t\u0002\u0003\u0006K!a\u0001\u0002\u001d%t\u0017\u000e^5bYZ\u000bG.^3tA!I\u0011\u0011\u0003\u0001\t\u0006\u0004%\tEO\u0001\u0012kB$\u0017\r^3FqB\u0014Xm]:j_:\u001c\b\"CA\u000b\u0001!\u0005\t\u0015)\u0003<\u0003I)\b\u000fZ1uK\u0016C\bO]3tg&|gn\u001d\u0011\t\u0013\u0005e\u0001\u0001#b\u0001\n\u0003R\u0014\u0001E7fe\u001e,W\t\u001f9sKN\u001c\u0018n\u001c8t\u0011%\ti\u0002\u0001E\u0001B\u0003&1(A\tnKJ<W-\u0012=qe\u0016\u001c8/[8og\u0002B\u0011\"!\t\u0001\u0011\u000b\u0007I\u0011\t8\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\n\u0003K\u0001\u0001\u0012!Q!\n=\f1#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0002Bq!!\u000b\u0001\t\u0003\nY#\u0001\u0005u_N#(/\u001b8h)\t\ti\u0003\u0005\u0003\u00020\u0005UbbA\u000e\u00022%\u0019\u00111\u0007\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!\u000f\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u0004\b\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007f\tAaY8qsR)!'!\u0011\u0002D!AA%a\u000f\u0011\u0002\u0003\u0007a\u0005\u0003\u0005-\u0003w\u0001\n\u00111\u0001'\u0011%\t9\u0005AI\u0001\n\u0003\tI%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-#f\u0001\u0014\u0002N-\u0012\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003%)hn\u00195fG.,GMC\u0002\u0002Zq\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti&a\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002J\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA3\u0001\u0005\u0005I\u0011IA4\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0014\u0001\u00026bm\u0006LA!a\u000e\u0002n!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00111P\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003{\u00022aGA@\u0013\r\t\t\t\b\u0002\u0004\u0013:$\b\"CAC\u0001\u0005\u0005I\u0011AAD\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!#\u0002\u0010B\u00191$a#\n\u0007\u00055EDA\u0002B]fD!\"!%\u0002\u0004\u0006\u0005\t\u0019AA?\u0003\rAH%\r\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0003b!a'\u0002\"\u0006%UBAAO\u0015\r\ty\nH\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAR\u0003;\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003O\u0003\u0011\u0011!C\u0001\u0003S\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u0015\u0006-\u0006BCAI\u0003K\u000b\t\u00111\u0001\u0002\n\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011W\u0001\u0007KF,\u0018\r\\:\u0015\u0007)\u000b\u0019\f\u0003\u0006\u0002\u0012\u00065\u0016\u0011!a\u0001\u0003\u0013Cs\u0001AA\\\u0003{\u000by\fE\u0002\u0018\u0003sK1!a/\u0005\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!1\u0002\u0003oQ\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(o\u0017\u0017!SNLuM\\8sK:+H\u000e\\/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA1\f7\u000f\u001e\u0011wC2,X\rI8gA\u0001,\u0007\u0010\u001d:aA\u0019|'\u000fI1!OJ|W\u000f\u001d\u0011pM\u0002\u0012xn^:/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0003-[:JO:|'/\u001a(vY2\u0004\u0007%[:!iJ,X\r\f\u0011sKR,(O\\:!_:d\u0017\u0010\t8p]6rW\u000f\u001c7!m\u0006dW/Z:/\u0015\u0001\u0002s!CAc\u0005\u0005\u0005\t\u0012AAd\u0003\u0011a\u0015m\u001d;\u0011\u0007M\tIM\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAf'\u0015\tI-!4!!\u001d\ty-!6'MIj!!!5\u000b\u0007\u0005MG$A\u0004sk:$\u0018.\\3\n\t\u0005]\u0017\u0011\u001b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002\u0019\u0002J\u0012\u0005\u00111\u001c\u000b\u0003\u0003\u000fD!\"!\u000b\u0002J\u0006\u0005IQIAp)\t\tI\u0007\u0003\u0006\u0002d\u0006%\u0017\u0011!CA\u0003K\fQ!\u00199qYf$RAMAt\u0003SDa\u0001JAq\u0001\u00041\u0003B\u0002\u0017\u0002b\u0002\u0007a\u0005\u0003\u0006\u0002n\u0006%\u0017\u0011!CA\u0003_\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002r\u0006u\b#B\u000e\u0002t\u0006]\u0018bAA{9\t1q\n\u001d;j_:\u0004RaGA}M\u0019J1!a?\u001d\u0005\u0019!V\u000f\u001d7fe!I\u0011q`Av\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\u0002\u0004B\u0003B\u0002\u0003\u0013\f\t\u0011\"\u0003\u0003\u0006\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u0001\u0005\u0003\u0002l\t%\u0011\u0002\u0002B\u0006\u0003[\u0012aa\u00142kK\u000e$\b")
public class Last
extends DeclarativeAggregate
implements ExpectsInputTypes {
    private final Expression child;
    private final Expression ignoreNullsExpr;
    private boolean deterministic;
    private AttributeReference last;
    private AttributeReference valueSet;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private AttributeReference evaluateExpression;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(Last last) {
        return Last$.MODULE$.unapply(last);
    }

    public static Function1<Tuple2<Expression, Expression>, Last> tupled() {
        return Last$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Last>> curried() {
        return Last$.MODULE$.curried();
    }

    private boolean deterministic$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.deterministic = false;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.deterministic;
        }
    }

    private AttributeReference last$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$5 = "last";
                DataType x$6 = this.child().dataType();
                boolean x$7 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$8 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$9 = AttributeReference$.MODULE$.apply$default$5(x$5, x$6, x$7, x$8);
                Option<String> x$10 = AttributeReference$.MODULE$.apply$default$6(x$5, x$6, x$7, x$8);
                this.last = new AttributeReference(x$5, x$6, x$7, x$8, x$9, x$10);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.last;
        }
    }

    private AttributeReference valueSet$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String x$11 = "valueSet";
                BooleanType$ x$12 = BooleanType$.MODULE$;
                boolean x$13 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$14 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$15 = AttributeReference$.MODULE$.apply$default$5(x$11, x$12, x$13, x$14);
                Option<String> x$16 = AttributeReference$.MODULE$.apply$default$6(x$11, x$12, x$13, x$14);
                this.valueSet = new AttributeReference(x$11, x$12, x$13, x$14, x$15, x$16);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.valueSet;
        }
    }

    private Seq aggBufferAttributes$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                AttributeReference attributeReference = this.last();
                AttributeReference attributeReference2 = this.valueSet();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.aggBufferAttributes;
        }
    }

    private Seq initialValues$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(null, this.child().dataType()), Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.initialValues;
        }
    }

    private Seq updateExpressions$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If(new IsNull(this.child()), this.last(), this.child()), new Or(this.valueSet(), new IsNotNull(this.child()))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.updateExpressions;
        }
    }

    private Seq mergeExpressions$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.mergeExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If(this.RichAttribute(this.valueSet()).right(), this.RichAttribute(this.last()).right(), this.RichAttribute(this.last()).left()), new Or(this.RichAttribute(this.valueSet()).right(), this.RichAttribute(this.valueSet()).left())}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            return this.mergeExpressions;
        }
    }

    private AttributeReference evaluateExpression$lzycompute() {
        Last last = this;
        synchronized (last) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.last();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
            return this.evaluateExpression;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression ignoreNullsExpr() {
        return this.ignoreNullsExpr;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.ignoreNullsExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public boolean deterministic() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.ignoreNullsExpr().foldable() ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The second argument of Last must be a boolean literal, but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ignoreNullsExpr().sql()}))));
    }

    private boolean ignoreNulls() {
        return BoxesRunTime.unboxToBoolean((Object)this.ignoreNullsExpr().eval(this.ignoreNullsExpr().eval$default$1()));
    }

    private AttributeReference last() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.last$lzycompute() : this.last;
    }

    private AttributeReference valueSet() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.valueSet$lzycompute() : this.valueSet;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    public Seq<Literal> initialValues() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"last(", ")", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.child(), this.ignoreNulls() ? " ignore nulls" : BoxedUnit.UNIT}));
    }

    public Last copy(Expression child, Expression ignoreNullsExpr) {
        return new Last(child, ignoreNullsExpr);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.ignoreNullsExpr();
    }

    @Override
    public String productPrefix() {
        return "Last";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.ignoreNullsExpr();
                break;
            }
            case 0: {
                expression = this.child();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Last;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Last)) return false;
        boolean bl = true;
        if (!bl) return false;
        Last last = (Last)x$1;
        Expression expression = this.child();
        Expression expression2 = last.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.ignoreNullsExpr();
        Expression expression4 = last.ignoreNullsExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!last.canEqual(this)) return false;
        return true;
    }

    public Last(Expression child, Expression ignoreNullsExpr) {
        this.child = child;
        this.ignoreNullsExpr = ignoreNullsExpr;
        ExpectsInputTypes$class.$init$(this);
    }

    public Last(Expression child) {
        this(child, Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$));
    }
}

