/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.domain.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.features.FirewallApi;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeyPairGenerator;

public final class CreateNodesWithGroupEncodedIntoNameThenAddToSet
extends org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    public static final String EXTERIOR_RANGE = "0.0.0.0/0";
    public static final String DEFAULT_INTERNAL_NETWORK_RANGE = "10.0.0.0/8";
    private final GoogleComputeEngineApi api;
    private final LoadingCache<NetworkAndAddressRange, Network> networkMap;
    private final Predicate<AtomicReference<Operation>> operationDone;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;
    private final SshKeyPairGenerator keyGenerator;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    CreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, GoogleComputeEngineApi api, Predicate<AtomicReference<Operation>> operationDone, LoadingCache<NetworkAndAddressRange, Network> networkMap, FirewallTagNamingConvention.Factory firewallTagNamingConvention, SshKeyPairGenerator keyGenerator) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = api;
        this.operationDone = operationDone;
        this.networkMap = networkMap;
        this.firewallTagNamingConvention = firewallTagNamingConvention;
        this.keyGenerator = keyGenerator;
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        String sharedResourceName = this.namingConvention.create().sharedNameForGroup(group);
        Template mutableTemplate = template.clone();
        GoogleComputeEngineTemplateOptions templateOptions = (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(mutableTemplate.getOptions()));
        assert (template.getOptions().equals((Object)templateOptions)) : "options didn't clone properly";
        Network network = this.getOrCreateNetwork(templateOptions, sharedResourceName);
        this.getOrCreateFirewalls(templateOptions, network, this.firewallTagNamingConvention.get(group));
        templateOptions.network(network.selfLink());
        templateOptions.userMetadata("jclouds-group", group);
        if (templateOptions.autoCreateKeyPair() && Strings.isNullOrEmpty((String)templateOptions.getPublicKey())) {
            this.logger.debug(">> creating default keypair...", new Object[0]);
            Map defaultKeys = (Map)this.keyGenerator.get();
            templateOptions.authorizePublicKey((String)defaultKeys.get("public"));
            templateOptions.overrideLoginPrivateKey((String)defaultKeys.get("private"));
        }
        if (templateOptions.getRunScript() != null && templateOptions.getLoginPrivateKey() == null) {
            this.logger.warn(">> A runScript has been configured but no SSH key has been provided. Authentication will delegate to the ssh-agent", new Object[0]);
        }
        return super.execute(group, count, mutableTemplate, goodNodes, badNodes, customizationResponses);
    }

    private Network getOrCreateNetwork(GoogleComputeEngineTemplateOptions templateOptions, String sharedResourceName) {
        String networkName = templateOptions.network() != null ? CreateNodesWithGroupEncodedIntoNameThenAddToSet.toName(templateOptions.network()) : sharedResourceName;
        return (Network)this.networkMap.getUnchecked((Object)NetworkAndAddressRange.create(networkName, DEFAULT_INTERNAL_NETWORK_RANGE, null));
    }

    private void getOrCreateFirewalls(GoogleComputeEngineTemplateOptions templateOptions, Network network, FirewallTagNamingConvention naming) {
        FirewallApi firewallApi = this.api.firewalls();
        ArrayList operations = Lists.newArrayList();
        int[] arr$ = templateOptions.getInboundPorts();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer port = arr$[i$];
            String name = naming.name(port);
            Firewall firewall = firewallApi.get(name);
            if (firewall != null) continue;
            ImmutableList ports = ImmutableList.of((Object)String.valueOf(port));
            ImmutableList rules = ImmutableList.of((Object)Firewall.Rule.create("tcp", (List<String>)ports), (Object)Firewall.Rule.create("udp", (List<String>)ports));
            FirewallOptions firewallOptions = new FirewallOptions().name(name).network(network.selfLink()).allowedRules((List<Firewall.Rule>)rules).sourceTags(templateOptions.getTags()).sourceRanges((Iterable<String>)ImmutableList.of((Object)DEFAULT_INTERNAL_NETWORK_RANGE, (Object)EXTERIOR_RANGE)).targetTags((List<String>)ImmutableList.of((Object)name));
            AtomicReference operation = Atomics.newReference((Object)firewallApi.createInNetwork(firewallOptions.name(), network.selfLink(), firewallOptions));
            operations.add(operation);
        }
        for (AtomicReference operation : operations) {
            this.operationDone.apply((Object)operation);
            Preconditions.checkState((((Operation)operation.get()).httpErrorStatusCode() == null ? 1 : 0) != 0, (String)"Could not insert firewall, operation failed %s", (Object[])new Object[]{operation});
        }
    }

    private static String toName(URI link) {
        String path = link.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

