/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.Atomics;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.crypto.Crypto;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.features.InstanceApi;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

public class ResetWindowsPassword
implements Function<Map<String, ?>, String> {
    private static final long EXPIRE_DURATION = 600000L;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final GoogleComputeEngineApi api;
    private final Crypto crypto;
    private final Predicate<AtomicReference<Operation>> operationDone;

    @Inject
    protected ResetWindowsPassword(GoogleComputeEngineApi api, Crypto crypto, Predicate<AtomicReference<Operation>> operationDone) {
        this.api = api;
        this.crypto = crypto;
        this.operationDone = operationDone;
    }

    public String apply(Map<String, ?> params) {
        String zone = (String)params.get("zone");
        AtomicReference instance = (AtomicReference)params.get("instance");
        String userName = (String)params.get("userName");
        String email = (String)params.get("email");
        KeyPair keys = this.crypto.rsaKeyPairGenerator().genKeyPair();
        this.logger.debug("Generating windows key for instance %s, by updating metadata", new Object[]{((Instance)instance.get()).name()});
        final InstanceApi instanceApi = this.api.instancesInZone(zone);
        Metadata metadata = ((Instance)instance.get()).metadata();
        try {
            metadata.put("windows-keys", new GsonBuilder().disableHtmlEscaping().create().toJson(this.extractKeyMetadata(keys, userName, email)));
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            Throwables.propagate((Throwable)e);
        }
        AtomicReference operation = Atomics.newReference((Object)instanceApi.setMetadata(((Instance)instance.get()).name(), metadata));
        this.operationDone.apply((Object)operation);
        if (((Operation)operation.get()).httpErrorStatusCode() != null) {
            this.logger.warn("Generating windows key for %s failed. Http Error Code: %d HttpError: %s", new Object[]{((Operation)operation.get()).targetId(), ((Operation)operation.get()).httpErrorStatusCode(), ((Operation)operation.get()).httpErrorMessage()});
        }
        try {
            final HashMap passwordDict = new HashMap();
            boolean passwordRetrieved = Predicates2.retry((Predicate)new Predicate<Instance>(){

                public boolean apply(Instance instance) {
                    String serialPortContents = instanceApi.getSerialPortOutput(instance.name(), 4).contents();
                    if (!serialPortContents.startsWith("{\"ready\":true")) {
                        return false;
                    }
                    String[] contentEntries = serialPortContents.split("\n");
                    passwordDict.clear();
                    passwordDict.putAll((Map)new Gson().fromJson(contentEntries[contentEntries.length - 1], Map.class));
                    passwordDict.put("passwordDictContentEntries", contentEntries[contentEntries.length - 1]);
                    return passwordDict.get("encryptedPassword") != null;
                }
            }, (long)600L, (long)30L, (TimeUnit)TimeUnit.SECONDS).apply(instance.get());
            if (passwordRetrieved) {
                return this.decryptPassword((String)Preconditions.checkNotNull(passwordDict.get("encryptedPassword"), (Object)"encryptedPassword shouldn't be null"), keys);
            }
            throw new IllegalStateException("encryptedPassword shouldn't be null: " + (String)passwordDict.get("passwordDictContentEntries"));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected String decryptPassword(String message, KeyPair keys) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        try {
            cipher = this.crypto.cipher("RSA/NONE/OAEPPadding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Problem finding cypher. Try adding bouncycastle dependency.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Problem finding cypher. Try adding bouncycastle dependency.", e);
        }
        cipher.init(2, keys.getPrivate());
        byte[] rawMessage = BaseEncoding.base64().decode((CharSequence)message);
        byte[] decryptedText = cipher.doFinal(rawMessage);
        return new String(decryptedText, Charset.forName("UTF-8"));
    }

    protected Map<String, String> extractKeyMetadata(KeyPair pair, String userName, String email) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory = this.crypto.rsaKeyFactory();
        RSAPublicKeySpec pubSpec = factory.getKeySpec(pair.getPublic(), RSAPublicKeySpec.class);
        BigInteger modulus = pubSpec.getModulus();
        BigInteger exponent = pubSpec.getPublicExponent();
        byte[] modulusArr = Arrays.copyOfRange(modulus.toByteArray(), 1, modulus.toByteArray().length);
        String modulusString = BaseEncoding.base64().encode(modulusArr).replaceAll("\n", "");
        String exponentString = BaseEncoding.base64().encode(exponent.toByteArray()).replaceAll("\n", "");
        Date expireDate = new Date(System.currentTimeMillis() + 600000L);
        SimpleDateFormat rfc3339Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        rfc3339Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        String expireString = rfc3339Format.format(expireDate);
        return ImmutableMap.builder().put((Object)"modulus", (Object)modulusString).put((Object)"exponent", (Object)exponentString).put((Object)"expireOn", (Object)expireString).put((Object)"userName", (Object)userName).put((Object)"email", (Object)email).build();
    }
}

