/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.session;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceController;
import org.apache.ignite.cache.store.cassandra.session.BatchLoaderAssistant;
import org.apache.ignite.cache.store.cassandra.session.CassandraSession;
import org.apache.ignite.lang.IgniteBiInClosure;

public class LoadCacheCustomQueryWorker<K, V>
implements Callable<Void> {
    private final CassandraSession ses;
    private final Statement stmt;
    private final PersistenceController ctrl;
    private final IgniteLogger log;
    private final IgniteBiInClosure<K, V> clo;

    public LoadCacheCustomQueryWorker(CassandraSession cassandraSession, String string, PersistenceController persistenceController, IgniteLogger igniteLogger, IgniteBiInClosure<K, V> igniteBiInClosure) {
        this(cassandraSession, (Statement)new SimpleStatement(string.trim().endsWith(";") ? string : string + ';'), persistenceController, igniteLogger, igniteBiInClosure);
    }

    public LoadCacheCustomQueryWorker(CassandraSession cassandraSession, Statement statement, PersistenceController persistenceController, IgniteLogger igniteLogger, IgniteBiInClosure<K, V> igniteBiInClosure) {
        this.ses = cassandraSession;
        this.stmt = statement;
        this.ctrl = persistenceController;
        this.log = igniteLogger;
        this.clo = igniteBiInClosure;
    }

    @Override
    public Void call() throws Exception {
        this.ses.execute(new BatchLoaderAssistant(){

            @Override
            public String operationName() {
                return "loadCache";
            }

            @Override
            public Statement getStatement() {
                return LoadCacheCustomQueryWorker.this.stmt;
            }

            @Override
            public void process(Row row) {
                Object object;
                Object object2;
                try {
                    object2 = LoadCacheCustomQueryWorker.this.ctrl.buildKeyObject(row);
                }
                catch (Throwable throwable) {
                    LoadCacheCustomQueryWorker.this.log.error("Failed to build Ignite key object from provided Cassandra row", throwable);
                    throw new IgniteException("Failed to build Ignite key object from provided Cassandra row", throwable);
                }
                try {
                    object = LoadCacheCustomQueryWorker.this.ctrl.buildValueObject(row);
                }
                catch (Throwable throwable) {
                    LoadCacheCustomQueryWorker.this.log.error("Failed to build Ignite value object from provided Cassandra row", throwable);
                    throw new IgniteException("Failed to build Ignite value object from provided Cassandra row", throwable);
                }
                LoadCacheCustomQueryWorker.this.clo.apply(object2, object);
            }
        });
        return null;
    }
}

