/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.apache.ignite.cache.store.cassandra.serializer.Serializer;
import org.apache.ignite.internal.util.typedef.internal.U;

public class JavaSerializer
implements Serializer {
    private static final int DFLT_BUFFER_SIZE = 4096;

    @Override
    public ByteBuffer serialize(Object object) {
        ByteBuffer byteBuffer;
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(4096);
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            try {
                throw new IllegalStateException("Failed to serialize object of the class '" + object.getClass().getName() + "'", iOException);
            }
            catch (Throwable throwable) {
                U.closeQuiet(objectOutputStream);
                U.closeQuiet((AutoCloseable)byteArrayOutputStream);
                throw throwable;
            }
        }
        U.closeQuiet((AutoCloseable)objectOutputStream);
        U.closeQuiet((AutoCloseable)byteArrayOutputStream);
        return byteBuffer;
    }

    @Override
    public Object deserialize(ByteBuffer byteBuffer) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                throw new IllegalStateException("Failed to deserialize object from byte stream", throwable);
            }
            catch (Throwable throwable2) {
                U.closeQuiet(objectInputStream);
                U.closeQuiet((AutoCloseable)byteArrayInputStream);
                throw throwable2;
            }
        }
        U.closeQuiet((AutoCloseable)objectInputStream);
        U.closeQuiet((AutoCloseable)byteArrayInputStream);
        return object;
    }
}

