/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.common.Program;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;

public class LocalExecutor
extends PlanExecutor {
    private static final boolean DEFAULT_OVERWRITE = false;
    private static final int DEFAULT_TASK_MANAGER_NUM_SLOTS = -1;
    private final Object lock = new Object();
    private LocalFlinkMiniCluster flink;
    private final Configuration configuration;
    private int taskManagerNumSlots = -1;
    private boolean defaultOverwriteFiles = false;

    public LocalExecutor() {
        this(null);
    }

    public LocalExecutor(Configuration conf) {
        this.configuration = conf != null ? conf : new Configuration();
    }

    public boolean isDefaultOverwriteFiles() {
        return this.defaultOverwriteFiles;
    }

    public void setDefaultOverwriteFiles(boolean defaultOverwriteFiles) {
        this.defaultOverwriteFiles = defaultOverwriteFiles;
    }

    public void setTaskManagerNumSlots(int taskManagerNumSlots) {
        this.taskManagerNumSlots = taskManagerNumSlots;
    }

    public int getTaskManagerNumSlots() {
        return this.taskManagerNumSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            Configuration configuration;
            if (this.flink == null) {
                configuration = this.createConfiguration();
                if (this.configuration != null) {
                    configuration.addAll(this.configuration);
                }
            } else {
                throw new IllegalStateException("The local executor was already started.");
            }
            this.flink = new LocalFlinkMiniCluster(configuration, true);
            this.flink.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.flink != null) {
                this.flink.stop();
                this.flink = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.flink != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecutionResult executePlan(Plan plan) throws Exception {
        if (plan == null) {
            throw new IllegalArgumentException("The plan may not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            JobExecutionResult jobExecutionResult;
            block11: {
                boolean shutDownAtEnd;
                if (this.flink == null) {
                    int maxParallelism;
                    shutDownAtEnd = true;
                    if (this.taskManagerNumSlots == -1 && (maxParallelism = plan.getMaximumParallelism()) > 0) {
                        this.taskManagerNumSlots = maxParallelism;
                    }
                    this.start();
                } else {
                    shutDownAtEnd = false;
                }
                try {
                    Configuration configuration = this.flink.configuration();
                    Optimizer pc = new Optimizer(new DataStatistics(), configuration);
                    OptimizedPlan op = pc.compile(plan);
                    JobGraphGenerator jgg = new JobGraphGenerator(configuration);
                    JobGraph jobGraph = jgg.compileJobGraph(op, plan.getJobId());
                    boolean sysoutPrint = this.isPrintingStatusDuringExecution();
                    jobExecutionResult = this.flink.submitJobAndWait(jobGraph, sysoutPrint);
                    if (!shutDownAtEnd) break block11;
                }
                catch (Throwable throwable) {
                    if (shutDownAtEnd) {
                        this.stop();
                    }
                    throw throwable;
                }
                this.stop();
            }
            return jobExecutionResult;
        }
    }

    public String getOptimizerPlanAsJSON(Plan plan) throws Exception {
        int parallelism = plan.getDefaultParallelism() == -1 ? 1 : plan.getDefaultParallelism();
        Optimizer pc = new Optimizer(new DataStatistics(), this.configuration);
        pc.setDefaultParallelism(parallelism);
        OptimizedPlan op = pc.compile(plan);
        return new PlanJSONDumpGenerator().getOptimizerPlanAsJSON(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession(JobID jobID) throws Exception {
        Class<LocalExecutor> clazz = LocalExecutor.class;
        synchronized (LocalExecutor.class) {
            LocalFlinkMiniCluster flink = this.flink;
            if (flink != null) {
                ActorGateway leaderGateway = flink.getLeaderGateway(AkkaUtils.getDefaultTimeoutAsFiniteDuration());
                leaderGateway.tell((Object)new JobManagerMessages.RemoveCachedJob(jobID));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private Configuration createConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setInteger("taskmanager.numberOfTaskSlots", this.getTaskManagerNumSlots());
        configuration.setBoolean("fs.overwrite-files", this.isDefaultOverwriteFiles());
        return configuration;
    }

    public static JobExecutionResult execute(Program pa, String ... args) throws Exception {
        return LocalExecutor.execute(pa.getPlan(args));
    }

    public static JobExecutionResult execute(Plan plan) throws Exception {
        return new LocalExecutor().executePlan(plan);
    }

    public static String optimizerPlanAsJSON(Plan plan) throws Exception {
        int parallelism = plan.getDefaultParallelism() == -1 ? 1 : plan.getDefaultParallelism();
        Optimizer pc = new Optimizer(new DataStatistics(), new Configuration());
        pc.setDefaultParallelism(parallelism);
        OptimizedPlan op = pc.compile(plan);
        return new PlanJSONDumpGenerator().getOptimizerPlanAsJSON(op);
    }

    public static String getPlanAsJSON(Plan plan) {
        List sinks = Optimizer.createPreOptimizedPlan((Plan)plan);
        return new PlanJSONDumpGenerator().getPactPlanAsJSON(sinks);
    }
}

