/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRow;

class H2IOUtils {
    private H2IOUtils() {
    }

    static void storeRow(GridH2Row row, long pageAddr, int off, boolean storeMvcc) {
        assert (row.link() != 0L);
        PageUtils.putLong((long)pageAddr, (int)off, (long)row.link());
        if (storeMvcc) {
            long mvccCrdVer = row.mvccCoordinatorVersion();
            long mvccCntr = row.mvccCounter();
            int mvccOpCntr = row.mvccOperationCounter();
            assert (MvccUtils.mvccVersionIsValid((long)mvccCrdVer, (long)mvccCntr, (int)mvccOpCntr));
            PageUtils.putLong((long)pageAddr, (int)(off + 8), (long)mvccCrdVer);
            PageUtils.putLong((long)pageAddr, (int)(off + 16), (long)mvccCntr);
            PageUtils.putInt((long)pageAddr, (int)(off + 24), (int)mvccOpCntr);
        }
    }

    static void store(long dstPageAddr, int dstOff, BPlusIO<GridH2SearchRow> srcIo, long srcPageAddr, int srcIdx, boolean storeMvcc) {
        H2RowLinkIO rowIo = (H2RowLinkIO)srcIo;
        long link = rowIo.getLink(srcPageAddr, srcIdx);
        PageUtils.putLong((long)dstPageAddr, (int)dstOff, (long)link);
        if (storeMvcc) {
            long mvccCrdVer = rowIo.getMvccCoordinatorVersion(srcPageAddr, srcIdx);
            long mvccCntr = rowIo.getMvccCounter(srcPageAddr, srcIdx);
            int mvccOpCntr = rowIo.getMvccOperationCounter(srcPageAddr, srcIdx);
            assert (MvccUtils.mvccVersionIsValid((long)mvccCrdVer, (long)mvccCntr, (int)mvccOpCntr));
            PageUtils.putLong((long)dstPageAddr, (int)(dstOff + 8), (long)mvccCrdVer);
            PageUtils.putLong((long)dstPageAddr, (int)(dstOff + 16), (long)mvccCntr);
            PageUtils.putInt((long)dstPageAddr, (int)(dstOff + 24), (int)mvccOpCntr);
        }
    }
}

