/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import org.apache.ignite.IgniteException;
import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Greatest;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IfNull;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NullIf;
import org.apache.spark.sql.catalyst.expressions.Nvl2;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class SystemExpressions$
implements SupportedExpressions {
    public static final SystemExpressions$ MODULE$;

    static {
        new SystemExpressions$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        Expression expression = expr;
        if (expression instanceof Coalesce) {
            Coalesce coalesce = (Coalesce)expression;
            Seq children2 = coalesce.children();
            return children2.forall(checkChild);
        }
        if (expression instanceof Greatest) {
            Greatest greatest = (Greatest)expression;
            Seq children3 = greatest.children();
            return children3.forall(checkChild);
        }
        if (expression instanceof IfNull) {
            IfNull ifNull = (IfNull)expression;
            Expression left = ifNull.left();
            Expression right = ifNull.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof Least) {
            Least least = (Least)expression;
            Seq children4 = least.children();
            return children4.forall(checkChild);
        }
        if (expression instanceof NullIf) {
            NullIf nullIf = (NullIf)expression;
            Expression left = nullIf.left();
            Expression right = nullIf.right();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
            return true;
        }
        if (expression instanceof Nvl2) {
            Nvl2 nvl2 = (Nvl2)expression;
            Expression expr1 = nvl2.expr1();
            Expression expr2 = nvl2.expr2();
            Expression expr3 = nvl2.expr3();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)expr1))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)expr2))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)expr3))) return false;
            return true;
        }
        if (!(expression instanceof If)) return false;
        If if_ = (If)expression;
        Expression predicate = if_.predicate();
        Expression trueValue = if_.trueValue();
        Expression falseValue = if_.falseValue();
        Expression expression2 = predicate;
        if (expression2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)expression2;
            Expression child = isNotNull.child();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)trueValue))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)falseValue))) return false;
            return true;
        }
        if (expression2 instanceof IsNull) {
            IsNull isNull = (IsNull)expression2;
            Expression child = isNull.child();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)trueValue))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)falseValue))) return false;
            return true;
        }
        if (!(expression2 instanceof EqualTo)) return false;
        EqualTo equalTo = (EqualTo)expression2;
        Expression left = equalTo.left();
        Expression right = equalTo.right();
        Expression expression3 = trueValue;
        if (!(expression3 instanceof Literal)) return false;
        Literal literal = (Literal)expression3;
        Object object = literal.value();
        if (object != null) return false;
        Expression expression4 = left;
        Expression expression5 = falseValue;
        if (expression4 == null ? expression5 != null : !expression4.equals(expression5)) {
            Expression expression6 = right;
            Expression expression7 = falseValue;
            if (expression6 == null) {
                if (expression7 != null) {
                    return false;
                }
            } else if (!expression6.equals(expression7)) return false;
        }
        if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left))) return false;
        if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        Some some;
        Expression expression = expr;
        if (expression instanceof Coalesce) {
            Coalesce coalesce = (Coalesce)expression;
            Seq children2 = coalesce.children();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COALESCE(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children2.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$1) {
                    return (String)this.childToString$1.apply((Object)x$1);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        }
        if (expression instanceof Greatest) {
            Greatest greatest = (Greatest)expression;
            Seq children3 = greatest.children();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GREATEST(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children3.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$2) {
                    return (String)this.childToString$1.apply((Object)x$2);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        }
        if (expression instanceof IfNull) {
            IfNull ifNull = (IfNull)expression;
            Expression left = ifNull.left();
            Expression right = ifNull.right();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        }
        if (expression instanceof Least) {
            Least least = (Least)expression;
            Seq children4 = least.children();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LEAST(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children4.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$3) {
                    return (String)this.childToString$1.apply((Object)x$3);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        }
        if (expression instanceof NullIf) {
            NullIf nullIf = (NullIf)expression;
            Expression left = nullIf.left();
            Expression right = nullIf.right();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NULLIF(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        }
        if (expression instanceof Nvl2) {
            Nvl2 nvl2 = (Nvl2)expression;
            Expression expr1 = nvl2.expr1();
            Expression expr2 = nvl2.expr2();
            Expression expr3 = nvl2.expr3();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NVL2(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)expr1), childToString.apply((Object)expr2), childToString.apply((Object)expr3)})));
        }
        if (!(expression instanceof If)) return None$.MODULE$;
        If if_ = (If)expression;
        Expression predicate = if_.predicate();
        Expression trueValue = if_.trueValue();
        Expression falseValue = if_.falseValue();
        Expression expression2 = predicate;
        if (expression2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)expression2;
            Expression child = isNotNull.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NVL2(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child), childToString.apply((Object)trueValue), childToString.apply((Object)falseValue)})));
            return some;
        } else if (expression2 instanceof IsNull) {
            IsNull isNull = (IsNull)expression2;
            Expression child = isNull.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NVL2(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child), childToString.apply((Object)falseValue), childToString.apply((Object)trueValue)})));
            return some;
        } else {
            Some some2;
            Some some3;
            Literal literal;
            Object object;
            if (!(expression2 instanceof EqualTo)) throw new IgniteException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expression not supported. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr})));
            EqualTo equalTo = (EqualTo)expression2;
            Expression left = equalTo.left();
            Expression right = equalTo.right();
            Expression expression3 = trueValue;
            if (!(expression3 instanceof Literal) || (object = (literal = (Literal)expression3).value()) != null) throw new IgniteException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expression not supported. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr})));
            Expression expression4 = left;
            Expression expression5 = falseValue;
            if (!(expression4 != null ? !expression4.equals(expression5) : expression5 != null)) {
                some3 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NULLIF(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
            } else {
                Expression expression6 = right;
                Expression expression7 = falseValue;
                if (expression6 != null ? !expression6.equals(expression7) : expression7 != null) throw new IgniteException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expression not supported. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr})));
                some3 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NULLIF(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)right), childToString.apply((Object)left)})));
            }
            some = some2 = some3;
        }
        return some;
    }

    private SystemExpressions$() {
        MODULE$ = this;
    }
}

