/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.spark.sql.catalyst.expressions.Ascii;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ConcatWs;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Lower;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace;
import org.apache.spark.sql.catalyst.expressions.SoundEx;
import org.apache.spark.sql.catalyst.expressions.StringInstr;
import org.apache.spark.sql.catalyst.expressions.StringLPad;
import org.apache.spark.sql.catalyst.expressions.StringLocate;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import org.apache.spark.sql.catalyst.expressions.StringRepeat;
import org.apache.spark.sql.catalyst.expressions.StringSpace;
import org.apache.spark.sql.catalyst.expressions.StringTranslate;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Upper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class StringExpressions$
implements SupportedExpressions {
    public static final StringExpressions$ MODULE$;

    static {
        new StringExpressions$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        boolean bl = false;
        StringTrimLeft stringTrimLeft = null;
        boolean bl2 = false;
        StringTrimRight stringTrimRight = null;
        boolean bl3 = false;
        StringTrim stringTrim = null;
        boolean bl4 = false;
        Substring substring = null;
        Expression expression = expr;
        if (expression instanceof Ascii) {
            Ascii ascii = (Ascii)expression;
            Expression child = ascii.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof Length) {
            Length length = (Length)expression;
            Expression child = length.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof Concat) {
            Concat concat = (Concat)expression;
            Seq children2 = concat.children();
            return children2.forall(checkChild);
        }
        if (expression instanceof ConcatWs) {
            ConcatWs concatWs = (ConcatWs)expression;
            Seq children3 = concatWs.children();
            return children3.forall(checkChild);
        }
        if (expression instanceof StringInstr) {
            StringInstr stringInstr = (StringInstr)expression;
            Expression str = stringInstr.str();
            Expression substr = stringInstr.substr();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)substr))) return false;
            return true;
        }
        if (expression instanceof Lower) {
            Lower lower = (Lower)expression;
            Expression child = lower.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof Upper) {
            Upper upper = (Upper)expression;
            Expression child = upper.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof StringLocate) {
            StringLocate stringLocate = (StringLocate)expression;
            Expression substr = stringLocate.substr();
            Expression str = stringLocate.str();
            Expression start = stringLocate.start();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)substr))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)start))) return false;
            return true;
        }
        if (expression instanceof StringLPad) {
            StringLPad stringLPad = (StringLPad)expression;
            Expression str = stringLPad.str();
            Expression len = stringLPad.len();
            Expression pad = stringLPad.pad();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pad))) return false;
            return true;
        }
        if (expression instanceof StringRPad) {
            StringRPad stringRPad = (StringRPad)expression;
            Expression str = stringRPad.str();
            Expression len = stringRPad.len();
            Expression pad = stringRPad.pad();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pad))) return false;
            return true;
        }
        if (expression instanceof StringTrimLeft) {
            bl = true;
            stringTrimLeft = (StringTrimLeft)expression;
            Expression child = stringTrimLeft.srcStr();
            Option option = stringTrimLeft.trimStr();
            if (None$.MODULE$.equals(option)) {
                return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
            }
        }
        if (expression instanceof StringTrimRight) {
            bl2 = true;
            stringTrimRight = (StringTrimRight)expression;
            Expression child = stringTrimRight.srcStr();
            Option option = stringTrimRight.trimStr();
            if (None$.MODULE$.equals(option)) {
                return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
            }
        }
        if (expression instanceof StringTrim) {
            bl3 = true;
            stringTrim = (StringTrim)expression;
            Expression child = stringTrim.srcStr();
            Option option = stringTrim.trimStr();
            if (None$.MODULE$.equals(option)) {
                return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
            }
        }
        if (bl) {
            Expression child = stringTrimLeft.srcStr();
            Option option = stringTrimLeft.trimStr();
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression trimStr = (Expression)some.x();
                if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child))) return false;
                if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)trimStr))) return false;
                return true;
            }
        }
        if (bl2) {
            Expression child = stringTrimRight.srcStr();
            Option option = stringTrimRight.trimStr();
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression trimStr = (Expression)some.x();
                if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child))) return false;
                if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)trimStr))) return false;
                return true;
            }
        }
        if (bl3) {
            Expression child = stringTrim.srcStr();
            Option option = stringTrim.trimStr();
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression trimStr = (Expression)some.x();
                if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child))) return false;
                if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)trimStr))) return false;
                return true;
            }
        }
        if (expression instanceof RegExpReplace) {
            RegExpReplace regExpReplace = (RegExpReplace)expression;
            Expression subject = regExpReplace.subject();
            Expression regexp = regExpReplace.regexp();
            Expression rep = regExpReplace.rep();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)subject))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)regexp))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)rep))) return false;
            return true;
        }
        if (expression instanceof StringRepeat) {
            StringRepeat stringRepeat = (StringRepeat)expression;
            Expression str = stringRepeat.str();
            Expression times = stringRepeat.times();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)times))) return false;
            return true;
        }
        if (expression instanceof SoundEx) {
            SoundEx soundEx = (SoundEx)expression;
            Expression child = soundEx.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof StringSpace) {
            StringSpace stringSpace = (StringSpace)expression;
            Expression child = stringSpace.child();
            return BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        }
        if (expression instanceof Substring) {
            bl4 = true;
            substring = (Substring)expression;
            Expression str = substring.str();
            Expression pos = substring.pos();
            Expression len = substring.len();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pos))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len))) return false;
            return true;
        }
        if (bl4) {
            Expression str = substring.str();
            Expression pos = substring.pos();
            Expression len = substring.len();
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)pos))) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)len))) return false;
            return true;
        }
        if (!(expression instanceof StringTranslate)) return false;
        StringTranslate stringTranslate = (StringTranslate)expression;
        Expression str = stringTranslate.srcExpr();
        Expression strMatch = stringTranslate.matchingExpr();
        Expression strReplace = stringTranslate.replaceExpr();
        if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)str))) return false;
        if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)strMatch))) return false;
        if (!BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)strReplace))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        boolean bl = false;
        StringTrimLeft stringTrimLeft = null;
        boolean bl2 = false;
        StringTrimRight stringTrimRight = null;
        boolean bl3 = false;
        StringTrim stringTrim = null;
        Expression expression = expr;
        if (expression instanceof Ascii) {
            Ascii ascii = (Ascii)expression;
            Expression child = ascii.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ASCII(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        }
        if (expression instanceof Length) {
            Length length = (Length)expression;
            Expression child = length.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(LENGTH(", ") AS INTEGER)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        }
        if (expression instanceof Concat) {
            Concat concat = (Concat)expression;
            Seq children2 = concat.children();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONCAT(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children2.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$1) {
                    return (String)this.childToString$1.apply((Object)x$1);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        }
        if (expression instanceof ConcatWs) {
            ConcatWs concatWs = (ConcatWs)expression;
            Seq children3 = concatWs.children();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONCAT_WS(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children3.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$2) {
                    return (String)this.childToString$1.apply((Object)x$2);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        }
        if (expression instanceof StringInstr) {
            StringInstr stringInstr = (StringInstr)expression;
            Expression str = stringInstr.str();
            Expression substr = stringInstr.substr();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POSITION(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)substr), childToString.apply((Object)str)})));
        }
        if (expression instanceof Lower) {
            Lower lower = (Lower)expression;
            Expression child = lower.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOWER(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        }
        if (expression instanceof Upper) {
            Upper upper = (Upper)expression;
            Expression child = upper.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPPER(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        }
        if (expression instanceof StringLocate) {
            StringLocate stringLocate = (StringLocate)expression;
            Expression substr = stringLocate.substr();
            Expression str = stringLocate.str();
            Expression start = stringLocate.start();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOCATE(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)substr), childToString.apply((Object)str), childToString.apply((Object)start)})));
        }
        if (expression instanceof StringLPad) {
            StringLPad stringLPad = (StringLPad)expression;
            Expression str = stringLPad.str();
            Expression len = stringLPad.len();
            Expression pad = stringLPad.pad();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LPAD(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)len), childToString.apply((Object)pad)})));
        }
        if (expression instanceof StringRPad) {
            StringRPad stringRPad = (StringRPad)expression;
            Expression str = stringRPad.str();
            Expression len = stringRPad.len();
            Expression pad = stringRPad.pad();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RPAD(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)len), childToString.apply((Object)pad)})));
        }
        if (expression instanceof StringTrimLeft) {
            bl = true;
            stringTrimLeft = (StringTrimLeft)expression;
            Expression child = stringTrimLeft.srcStr();
            Option option = stringTrimLeft.trimStr();
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LTRIM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
            }
        }
        if (expression instanceof StringTrimRight) {
            bl2 = true;
            stringTrimRight = (StringTrimRight)expression;
            Expression child = stringTrimRight.srcStr();
            Option option = stringTrimRight.trimStr();
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RTRIM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
            }
        }
        if (expression instanceof StringTrim) {
            bl3 = true;
            stringTrim = (StringTrim)expression;
            Expression child = stringTrim.srcStr();
            Option option = stringTrim.trimStr();
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRIM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
            }
        }
        if (bl) {
            Expression child = stringTrimLeft.srcStr();
            Option option = stringTrimLeft.trimStr();
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression trimStr = (Expression)some.x();
                return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LTRIM(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child), childToString.apply((Object)trimStr)})));
            }
        }
        if (bl2) {
            Expression child = stringTrimRight.srcStr();
            Option option = stringTrimRight.trimStr();
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression trimStr = (Expression)some.x();
                return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RTRIM(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child), childToString.apply((Object)trimStr)})));
            }
        }
        if (bl3) {
            Expression child = stringTrim.srcStr();
            Option option = stringTrim.trimStr();
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression trimStr = (Expression)some.x();
                return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRIM(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child), childToString.apply((Object)trimStr)})));
            }
        }
        if (expression instanceof RegExpReplace) {
            RegExpReplace regExpReplace = (RegExpReplace)expression;
            Expression subject = regExpReplace.subject();
            Expression regexp = regExpReplace.regexp();
            Expression rep = regExpReplace.rep();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REGEXP_REPLACE(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)subject), childToString.apply((Object)regexp), childToString.apply((Object)rep)})));
        }
        if (expression instanceof StringRepeat) {
            StringRepeat stringRepeat = (StringRepeat)expression;
            Expression str = stringRepeat.str();
            Expression times = stringRepeat.times();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REPEAT(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)times)})));
        }
        if (expression instanceof SoundEx) {
            SoundEx soundEx = (SoundEx)expression;
            Expression child = soundEx.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SOUND_EX(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        }
        if (expression instanceof StringSpace) {
            StringSpace stringSpace = (StringSpace)expression;
            Expression child = stringSpace.child();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPACE(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        }
        if (expression instanceof Substring) {
            Substring substring = (Substring)expression;
            Expression str = substring.str();
            Expression pos = substring.pos();
            Expression len = substring.len();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUBSTR(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)pos), childToString.apply((Object)len)})));
        }
        if (!(expression instanceof StringTranslate)) return None$.MODULE$;
        StringTranslate stringTranslate = (StringTranslate)expression;
        Expression str = stringTranslate.srcExpr();
        Expression strMatch = stringTranslate.matchingExpr();
        Expression strReplace = stringTranslate.replaceExpr();
        return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRANSLATE(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)str), childToString.apply((Object)strMatch), childToString.apply((Object)strReplace)})));
    }

    private StringExpressions$() {
        MODULE$ = this;
    }
}

