/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.util.nio.GridNioMetricsListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.extensions.communication.Message;

public class TcpCommunicationMetricsListener
implements GridNioMetricsListener {
    private static final Callable<LongHolder> HOLDER_FACTORY = new Callable<LongHolder>(){

        @Override
        public LongHolder call() {
            return new LongHolder();
        }
    };
    private final LongAdder rcvdBytesCnt = new LongAdder();
    private final LongAdder sentBytesCnt = new LongAdder();
    private final Set<ThreadMetrics> allMetrics = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ThreadLocal<ThreadMetrics> threadMetrics = new ThreadLocal<ThreadMetrics>(){

        @Override
        protected ThreadMetrics initialValue() {
            ThreadMetrics metrics = new ThreadMetrics();
            TcpCommunicationMetricsListener.this.allMetrics.add(metrics);
            return metrics;
        }
    };
    private final Object msgTypMapMux = new Object();
    private volatile Map<Short, String> msgTypMap;

    @Override
    public void onBytesSent(int bytesCnt) {
        this.sentBytesCnt.add(bytesCnt);
    }

    @Override
    public void onBytesReceived(int bytesCnt) {
        this.rcvdBytesCnt.add(bytesCnt);
    }

    public void onMessageSent(Message msg, UUID nodeId) {
        assert (msg != null);
        assert (nodeId != null);
        if (msg instanceof GridIoMessage) {
            msg = ((GridIoMessage)msg).message();
            this.updateMessageTypeMap(msg);
            ThreadMetrics metrics = this.threadMetrics.get();
            metrics.onMessageSent(msg, nodeId);
        }
    }

    public void onMessageReceived(Message msg, UUID nodeId) {
        assert (msg != null);
        assert (nodeId != null);
        if (msg instanceof GridIoMessage) {
            msg = ((GridIoMessage)msg).message();
            this.updateMessageTypeMap(msg);
            ThreadMetrics metrics = this.threadMetrics.get();
            metrics.onMessageReceived(msg, nodeId);
        }
    }

    public int sentMessagesCount() {
        long res = 0L;
        for (ThreadMetrics metrics : this.allMetrics) {
            res += metrics.sentMsgsCnt;
        }
        int res0 = (int)res;
        if (res0 < 0) {
            res0 = Integer.MAX_VALUE;
        }
        return res0;
    }

    public long sentBytesCount() {
        return this.sentBytesCnt.longValue();
    }

    public int receivedMessagesCount() {
        long res = 0L;
        for (ThreadMetrics metrics : this.allMetrics) {
            res += metrics.rcvdMsgsCnt;
        }
        int res0 = (int)res;
        if (res0 < 0) {
            res0 = Integer.MAX_VALUE;
        }
        return res0;
    }

    public long receivedBytesCount() {
        return this.rcvdBytesCnt.longValue();
    }

    public Map<String, Long> receivedMessagesByType() {
        HashMap<Short, Long> res = new HashMap<Short, Long>();
        for (ThreadMetrics metrics : this.allMetrics) {
            this.addMetrics(res, metrics.rcvdMsgsCntByType);
        }
        return this.convertMessageTypes(res);
    }

    private Map<String, Long> convertMessageTypes(Map<Short, Long> input) {
        HashMap<String, Long> res = new HashMap<String, Long>(input.size());
        Map<Short, String> msgTypMap0 = this.msgTypMap;
        if (msgTypMap0 != null) {
            for (Map.Entry<Short, Long> inputEntry : input.entrySet()) {
                String typeName = msgTypMap0.get(inputEntry.getKey());
                if (typeName == null) continue;
                res.put(typeName, inputEntry.getValue());
            }
        }
        return res;
    }

    public Map<UUID, Long> receivedMessagesByNode() {
        HashMap<UUID, Long> res = new HashMap<UUID, Long>();
        for (ThreadMetrics metrics : this.allMetrics) {
            this.addMetrics(res, metrics.rcvdMsgsCntByNode);
        }
        return res;
    }

    public Map<String, Long> sentMessagesByType() {
        HashMap<Short, Long> res = new HashMap<Short, Long>();
        for (ThreadMetrics metrics : this.allMetrics) {
            this.addMetrics(res, metrics.sentMsgsCntByType);
        }
        return this.convertMessageTypes(res);
    }

    public Map<UUID, Long> sentMessagesByNode() {
        HashMap<UUID, Long> res = new HashMap<UUID, Long>();
        for (ThreadMetrics metrics : this.allMetrics) {
            this.addMetrics(res, metrics.sentMsgsCntByNode);
        }
        return res;
    }

    public void resetMetrics() {
        for (ThreadMetrics metrics : this.allMetrics) {
            metrics.reset();
        }
    }

    private <T> void addMetrics(Map<T, Long> total, Map<T, LongHolder> current) {
        for (Map.Entry<T, LongHolder> entry : current.entrySet()) {
            T key = entry.getKey();
            long val = entry.getValue().val;
            Long prevVal = total.get(key);
            total.put(key, prevVal == null ? val : prevVal + val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageTypeMap(Message msg) {
        short typeId = msg.directType();
        Map<Short, String> msgTypMap0 = this.msgTypMap;
        if (msgTypMap0 == null || !msgTypMap0.containsKey(typeId)) {
            Object object = this.msgTypMapMux;
            synchronized (object) {
                if (this.msgTypMap == null) {
                    msgTypMap0 = new HashMap<Short, String>();
                    msgTypMap0.put(typeId, msg.getClass().getName());
                    this.msgTypMap = msgTypMap0;
                } else if (!this.msgTypMap.containsKey(typeId)) {
                    msgTypMap0 = new HashMap<Short, String>(this.msgTypMap);
                    msgTypMap0.put(typeId, msg.getClass().getName());
                    this.msgTypMap = msgTypMap0;
                }
            }
        }
    }

    private static class ThreadMetrics {
        private long rcvdMsgsCnt;
        private long sentMsgsCnt;
        private final HashMap<Short, LongHolder> rcvdMsgsCntByType = new HashMap();
        private final HashMap<UUID, LongHolder> rcvdMsgsCntByNode = new HashMap();
        private final HashMap<Short, LongHolder> sentMsgsCntByType = new HashMap();
        private final HashMap<UUID, LongHolder> sentMsgsCntByNode = new HashMap();

        private ThreadMetrics() {
        }

        private void onMessageSent(Message msg, UUID nodeId) {
            ++this.sentMsgsCnt;
            LongHolder cntByType = (LongHolder)((Object)F.addIfAbsent(this.sentMsgsCntByType, Short.valueOf(msg.directType()), HOLDER_FACTORY));
            LongHolder cntByNode = (LongHolder)((Object)F.addIfAbsent(this.sentMsgsCntByNode, nodeId, HOLDER_FACTORY));
            assert (cntByType != null);
            assert (cntByNode != null);
            cntByType.increment();
            cntByNode.increment();
        }

        private void onMessageReceived(Message msg, UUID nodeId) {
            ++this.rcvdMsgsCnt;
            LongHolder cntByType = (LongHolder)((Object)F.addIfAbsent(this.rcvdMsgsCntByType, Short.valueOf(msg.directType()), HOLDER_FACTORY));
            LongHolder cntByNode = (LongHolder)((Object)F.addIfAbsent(this.rcvdMsgsCntByNode, nodeId, HOLDER_FACTORY));
            assert (cntByType != null);
            assert (cntByNode != null);
            cntByType.increment();
            cntByNode.increment();
        }

        private void reset() {
            this.rcvdMsgsCnt = 0L;
            this.sentMsgsCnt = 0L;
            this.sentMsgsCntByType.clear();
            this.sentMsgsCntByNode.clear();
            this.rcvdMsgsCntByType.clear();
            this.rcvdMsgsCntByNode.clear();
        }
    }

    private static class LongHolder {
        private long val;

        private LongHolder() {
        }

        private void increment() {
            ++this.val;
        }
    }
}

