/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorAtomicConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int seqReserveSize;
    private CacheMode cacheMode;
    private int backups;

    public VisorAtomicConfiguration() {
    }

    public VisorAtomicConfiguration(AtomicConfiguration src) {
        this.seqReserveSize = src.getAtomicSequenceReserveSize();
        this.cacheMode = src.getCacheMode();
        this.backups = src.getBackups();
    }

    public int getAtomicSequenceReserveSize() {
        return this.seqReserveSize;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public int getBackups() {
        return this.backups;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.seqReserveSize);
        U.writeEnum(out, this.cacheMode);
        out.writeInt(this.backups);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.seqReserveSize = in.readInt();
        this.cacheMode = CacheMode.fromOrdinal(in.readByte());
        this.backups = in.readInt();
    }

    public String toString() {
        return S.toString(VisorAtomicConfiguration.class, this);
    }
}

