/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.string;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisAppendCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.APPEND);
    private static final int VAL_POS = 2;

    public GridRedisAppendCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd) {
        super(log, hnd);
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        if (msg.messageSize() < 3) {
            throw new GridRedisGenericException("Wrong syntax");
        }
        GridRestCacheRequest appendReq = new GridRestCacheRequest();
        GridRestCacheRequest getReq = new GridRestCacheRequest();
        String val = msg.aux(2);
        appendReq.clientId(msg.clientId());
        appendReq.key(msg.key());
        appendReq.value(val);
        appendReq.command(GridRestCommand.CACHE_APPEND);
        appendReq.cacheName(msg.cacheName());
        Object resp = this.hnd.handle(appendReq).getResponse();
        if (resp != null && !((Boolean)resp).booleanValue()) {
            GridRestCacheRequest setReq = new GridRestCacheRequest();
            setReq.clientId(msg.clientId());
            setReq.key(msg.key());
            setReq.value(val);
            setReq.command(GridRestCommand.CACHE_PUT);
            setReq.cacheName(msg.cacheName());
            this.hnd.handle(setReq);
        }
        getReq.clientId(msg.clientId());
        getReq.key(msg.key());
        getReq.command(GridRestCommand.CACHE_GET);
        getReq.cacheName(msg.cacheName());
        return getReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        if (restRes.getResponse() == null) {
            return GridRedisProtocolParser.nil();
        }
        if (restRes.getResponse() instanceof String) {
            int resLen = ((String)restRes.getResponse()).length();
            return GridRedisProtocolParser.toInteger(String.valueOf(resLen));
        }
        return GridRedisProtocolParser.toTypeError("Operation against a key holding the wrong kind of value");
    }
}

