/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class SqlClientContext
implements AutoCloseable {
    private final GridKernalContext ctx;
    private final boolean distributedJoins;
    private final boolean enforceJoinOrder;
    private final boolean collocated;
    private final boolean replicatedOnly;
    private final boolean lazy;
    private final boolean skipReducerOnUpdate;
    private final Object mux = new Object();
    private boolean streamAllowOverwrite;
    private int streamNodeParOps;
    private int streamNodeBufSize;
    private long streamFlushTimeout;
    private boolean streamOrdered;
    private volatile Map<String, IgniteDataStreamer<?, ?>> streamers;
    private IgniteThread orderedBatchThread;
    private Factory<GridWorker> orderedBatchWorkerFactory;
    private long totalProcessedOrderedReqs;
    private final IgniteLogger log;

    public SqlClientContext(GridKernalContext ctx, Factory<GridWorker> orderedBatchWorkerFactory, boolean distributedJoins, boolean enforceJoinOrder, boolean collocated, boolean replicatedOnly, boolean lazy, boolean skipReducerOnUpdate) {
        this.ctx = ctx;
        this.orderedBatchWorkerFactory = orderedBatchWorkerFactory;
        this.distributedJoins = distributedJoins;
        this.enforceJoinOrder = enforceJoinOrder;
        this.collocated = collocated;
        this.replicatedOnly = replicatedOnly;
        this.lazy = lazy;
        this.skipReducerOnUpdate = skipReducerOnUpdate;
        this.log = ctx.log(SqlClientContext.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableStreaming(boolean allowOverwrite, long flushFreq, int perNodeBufSize, int perNodeParOps, boolean ordered) {
        Object object = this.mux;
        synchronized (object) {
            if (this.isStream()) {
                return;
            }
            this.streamers = new HashMap();
            this.streamAllowOverwrite = allowOverwrite;
            this.streamFlushTimeout = flushFreq;
            this.streamNodeBufSize = perNodeBufSize;
            this.streamNodeParOps = perNodeParOps;
            this.streamOrdered = ordered;
            if (ordered) {
                this.orderedBatchThread = new IgniteThread((GridWorker)this.orderedBatchWorkerFactory.create());
                this.orderedBatchThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableStreaming() {
        Object object = this.mux;
        synchronized (object) {
            if (!this.isStream()) {
                return;
            }
            Iterator<IgniteDataStreamer<?, ?>> it = this.streamers.values().iterator();
            while (it.hasNext()) {
                IgniteDataStreamer<?, ?> streamer = it.next();
                U.close(streamer, this.log);
                it.remove();
            }
            this.streamers = null;
            this.orderedBatchThread = null;
        }
    }

    public boolean isCollocated() {
        return this.collocated;
    }

    public boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    public boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean isReplicatedOnly() {
        return this.replicatedOnly;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean isSkipReducerOnUpdate() {
        return this.skipReducerOnUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStream() {
        Object object = this.mux;
        synchronized (object) {
            return this.streamers != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamOrdered() {
        Object object = this.mux;
        synchronized (object) {
            return this.streamOrdered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteDataStreamer<?, ?> streamerForCache(String cacheName) {
        Object object = this.mux;
        synchronized (object) {
            if (this.streamers == null) {
                return null;
            }
            IgniteDataStreamer<Object, Object> res = this.streamers.get(cacheName);
            if (res != null) {
                return res;
            }
            res = this.ctx.grid().dataStreamer(cacheName);
            res.autoFlushFrequency(this.streamFlushTimeout);
            res.allowOverwrite(this.streamAllowOverwrite);
            if (this.streamNodeBufSize > 0) {
                res.perNodeBufferSize(this.streamNodeBufSize);
            }
            if (this.streamNodeParOps > 0) {
                res.perNodeParallelOperations(this.streamNodeParOps);
            }
            this.streamers.put(cacheName, res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTotalProcessedOrderedRequests(long total) {
        Object object = this.mux;
        synchronized (object) {
            while (this.totalProcessedOrderedReqs < total) {
                try {
                    this.mux.wait();
                }
                catch (InterruptedException e) {
                    throw new IgniteException("Waiting for end of processing the last batch is interrupted", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderedRequestProcessed() {
        Object object = this.mux;
        synchronized (object) {
            ++this.totalProcessedOrderedReqs;
            this.mux.notify();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.streamers == null) {
            return;
        }
        for (IgniteDataStreamer<?, ?> s : this.streamers.values()) {
            U.close(s, this.log);
        }
    }
}

