/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.typedef.internal.S;

public class OdbcColumnMeta {
    private final String schemaName;
    private final String tableName;
    public final String columnName;
    private final Class<?> dataType;
    public final int precision;
    public final int scale;
    private final ClientListenerProtocolVersion ver;

    public OdbcColumnMeta(String schemaName, String tableName, String columnName, Class<?> dataType, int precision, int scale, ClientListenerProtocolVersion ver) {
        this.schemaName = OdbcUtils.addQuotationMarksIfNeeded(schemaName);
        this.tableName = tableName;
        this.columnName = columnName;
        this.dataType = dataType;
        this.precision = precision;
        this.scale = scale;
        this.ver = ver;
    }

    public OdbcColumnMeta(GridQueryFieldMetadata info, ClientListenerProtocolVersion ver) {
        Class<Object> type;
        this.schemaName = OdbcUtils.addQuotationMarksIfNeeded(info.schemaName());
        this.tableName = info.typeName();
        this.columnName = info.fieldName();
        this.precision = info.precision();
        this.scale = info.scale();
        this.ver = ver;
        try {
            type = Class.forName(info.fieldTypeName());
        }
        catch (Exception ignored) {
            type = Object.class;
        }
        this.dataType = type;
    }

    public int hashCode() {
        int hash = this.schemaName.hashCode();
        hash = 31 * hash + this.tableName.hashCode();
        hash = 31 * hash + this.columnName.hashCode();
        hash = 31 * hash + this.dataType.hashCode();
        hash = 31 * hash + Integer.hashCode(this.precision);
        hash = 31 * hash + Integer.hashCode(this.scale);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof OdbcColumnMeta) {
            OdbcColumnMeta other = (OdbcColumnMeta)o;
            return this == other || this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName) && this.columnName.equals(other.columnName) && this.dataType.equals(other.dataType) && this.precision == other.precision && this.scale == other.scale;
        }
        return false;
    }

    public void write(BinaryRawWriter writer) {
        writer.writeString(this.schemaName);
        writer.writeString(this.tableName);
        writer.writeString(this.columnName);
        byte typeId = BinaryUtils.typeByClass(this.dataType);
        writer.writeByte(typeId);
        if (this.ver.compareTo(OdbcConnectionContext.VER_2_7_0) >= 0) {
            writer.writeInt(this.precision);
            writer.writeInt(this.scale);
        }
    }

    public String toString() {
        return S.toString(OdbcColumnMeta.class, this);
    }
}

