/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.nio.GridNioServerListenerAdapter;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ClientListenerNioListener
extends GridNioServerListenerAdapter<byte[]> {
    public static final byte ODBC_CLIENT = 0;
    public static final byte JDBC_CLIENT = 1;
    public static final byte THIN_CLIENT = 2;
    public static final int CONN_CTX_HANDSHAKE_PASSED = GridNioSessionMetaKey.nextUniqueKey();
    public static final int MAX_HANDSHAKE_MSG_SIZE = 128;
    static final int CONN_CTX_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private static AtomicInteger nextConnId = new AtomicInteger(1);
    private final GridSpinBusyLock busyLock;
    private final GridKernalContext ctx;
    private final int maxCursors;
    private final IgniteLogger log;
    private ClientConnectorConfiguration cliConnCfg;

    public ClientListenerNioListener(GridKernalContext ctx, GridSpinBusyLock busyLock, ClientConnectorConfiguration cliConnCfg) {
        assert (cliConnCfg != null);
        this.ctx = ctx;
        this.busyLock = busyLock;
        this.maxCursors = cliConnCfg.getMaxOpenCursorsPerConnection();
        this.cliConnCfg = cliConnCfg;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public void onConnected(GridNioSession ses) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Client connected: " + ses.remoteAddress());
        }
    }

    @Override
    public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
        ClientListenerConnectionContext connCtx = (ClientListenerConnectionContext)ses.meta(CONN_CTX_META_KEY);
        if (connCtx != null) {
            connCtx.onDisconnected();
        }
        if (this.log.isDebugEnabled()) {
            if (e == null) {
                this.log.debug("Client disconnected: " + ses.remoteAddress());
            } else {
                this.log.debug("Client disconnected due to an error [addr=" + ses.remoteAddress() + ", err=" + e + ']');
            }
        }
    }

    @Override
    public void onMessage(GridNioSession ses, byte[] msg) {
        ClientListenerRequest req;
        assert (msg != null);
        ClientListenerConnectionContext connCtx = (ClientListenerConnectionContext)ses.meta(CONN_CTX_META_KEY);
        if (connCtx == null) {
            this.onHandshake(ses, msg);
            return;
        }
        ClientListenerMessageParser parser = connCtx.parser();
        ClientListenerRequestHandler handler = connCtx.handler();
        try {
            req = parser.decode(msg);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to parse client request.", e);
            ses.close();
            return;
        }
        assert (req != null);
        try {
            ClientListenerResponse resp;
            long startTime = 0L;
            if (this.log.isDebugEnabled()) {
                startTime = System.nanoTime();
                this.log.debug("Client request received [reqId=" + req.requestId() + ", addr=" + ses.remoteAddress() + ", req=" + req + ']');
            }
            if ((resp = handler.handle(req)) != null) {
                if (this.log.isDebugEnabled()) {
                    long dur = (System.nanoTime() - startTime) / 1000L;
                    this.log.debug("Client request processed [reqId=" + req.requestId() + ", dur(mcs)=" + dur + ", resp=" + resp.status() + ']');
                }
                byte[] outMsg = parser.encode(resp);
                ses.send(outMsg);
            }
        }
        catch (Exception e) {
            U.error(this.log, "Failed to process client request [req=" + req + ']', e);
            ses.send(parser.encode(handler.handleException(e, req)));
        }
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) {
        ses.close();
    }

    private void onHandshake(GridNioSession ses, byte[] msg) {
        BinaryWriterExImpl writer;
        block6: {
            BinaryHeapInputStream stream = new BinaryHeapInputStream(msg);
            BinaryReaderExImpl reader = new BinaryReaderExImpl(null, stream, null, true);
            byte cmd = reader.readByte();
            if (cmd != 1) {
                U.warn(this.log, "Unexpected client request (will close session): " + ses.remoteAddress());
                ses.close();
                return;
            }
            short verMajor = reader.readShort();
            short verMinor = reader.readShort();
            short verMaintenance = reader.readShort();
            ClientListenerProtocolVersion ver = ClientListenerProtocolVersion.create(verMajor, verMinor, verMaintenance);
            writer = new BinaryWriterExImpl(null, new BinaryHeapOutputStream(8), null, null);
            byte clientType = reader.readByte();
            ClientListenerConnectionContext connCtx = null;
            try {
                connCtx = this.prepareContext(ses, clientType);
                this.ensureClientPermissions(clientType);
                if (!connCtx.isVersionSupported(ver)) {
                    throw new IgniteCheckedException("Unsupported version.");
                }
                connCtx.initializeFromHandshake(ver, reader);
                ses.addMeta(CONN_CTX_META_KEY, connCtx);
                connCtx.handler().writeHandshake(writer);
                ses.addMeta(CONN_CTX_HANDSHAKE_PASSED, true);
            }
            catch (IgniteAccessControlException authEx) {
                writer.writeBoolean(false);
                writer.writeShort((short)0);
                writer.writeShort((short)0);
                writer.writeShort((short)0);
                writer.doWriteString(authEx.getMessage());
                if (ver.compareTo(ClientConnectionContext.VER_1_1_0) >= 0) {
                    writer.writeInt(2000);
                }
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Error during handshake [rmtAddr=" + ses.remoteAddress() + ", msg=" + e.getMessage() + ']');
                ClientListenerProtocolVersion currVer = connCtx == null ? ClientListenerProtocolVersion.create(0, 0, 0) : connCtx.currentVersion();
                writer.writeBoolean(false);
                writer.writeShort(currVer.major());
                writer.writeShort(currVer.minor());
                writer.writeShort(currVer.maintenance());
                writer.doWriteString(e.getMessage());
                if (ver.compareTo(ClientConnectionContext.VER_1_1_0) < 0) break block6;
                writer.writeInt(1);
            }
        }
        ses.send(writer.array());
    }

    private ClientListenerConnectionContext prepareContext(GridNioSession ses, byte clientType) throws IgniteCheckedException {
        long connId = this.nextConnectionId();
        switch (clientType) {
            case 0: {
                return new OdbcConnectionContext(this.ctx, ses, this.busyLock, connId, this.maxCursors);
            }
            case 1: {
                return new JdbcConnectionContext(this.ctx, ses, this.busyLock, connId, this.maxCursors);
            }
            case 2: {
                return new ClientConnectionContext(this.ctx, connId, this.maxCursors);
            }
        }
        throw new IgniteCheckedException("Unknown client type: " + clientType);
    }

    private long nextConnectionId() {
        return (this.ctx.discovery().localNode().order() << 32) + (long)nextConnId.getAndIncrement();
    }

    private void ensureClientPermissions(byte clientType) throws IgniteCheckedException {
        switch (clientType) {
            case 0: {
                if (this.cliConnCfg.isOdbcEnabled()) break;
                throw new IgniteCheckedException("ODBC connection is not allowed, see ClientConnectorConfiguration.odbcEnabled.");
            }
            case 1: {
                if (this.cliConnCfg.isJdbcEnabled()) break;
                throw new IgniteCheckedException("JDBC connection is not allowed, see ClientConnectorConfiguration.jdbcEnabled.");
            }
            case 2: {
                if (this.cliConnCfg.isThinClientEnabled()) break;
                throw new IgniteCheckedException("Thin client connection is not allowed, see ClientConnectorConfiguration.thinClientEnabled.");
            }
            default: {
                throw new IgniteCheckedException("Unknown client type: " + clientType);
            }
        }
    }
}

