/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.jetbrains.annotations.Nullable;

public abstract class ClientListenerAbstractConnectionContext
implements ClientListenerConnectionContext {
    protected final GridKernalContext ctx;
    private SecurityContext secCtx;
    private long connId;
    private AuthorizationContext authCtx;

    protected ClientListenerAbstractConnectionContext(GridKernalContext ctx, long connId) {
        this.ctx = ctx;
        this.connId = connId;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    @Nullable
    public SecurityContext securityContext() {
        return this.secCtx;
    }

    @Override
    @Nullable
    public AuthorizationContext authorizationContext() {
        return this.authCtx;
    }

    @Override
    public long connectionId() {
        return this.connId;
    }

    protected AuthorizationContext authenticate(String user, String pwd) throws IgniteCheckedException {
        if (this.ctx.security().enabled()) {
            this.authCtx = this.authenticateExternal(user, pwd).authorizationContext();
        } else if (this.ctx.authentication().enabled()) {
            if (F.isEmpty(user)) {
                throw new IgniteAccessControlException("Unauthenticated sessions are prohibited.");
            }
            this.authCtx = this.ctx.authentication().authenticate(user, pwd);
            if (this.authCtx == null) {
                throw new IgniteAccessControlException("Unknown authentication error.");
            }
        } else {
            this.authCtx = null;
        }
        return this.authCtx;
    }

    private AuthenticationContext authenticateExternal(String user, String pwd) throws IgniteCheckedException {
        SecurityCredentials cred = new SecurityCredentials(user, pwd);
        AuthenticationContext authCtx = new AuthenticationContext();
        authCtx.subjectType(SecuritySubjectType.REMOTE_CLIENT);
        authCtx.subjectId(UUID.randomUUID());
        authCtx.nodeAttributes(Collections.emptyMap());
        authCtx.credentials(cred);
        this.secCtx = this.ctx.security().authenticate(authCtx);
        if (this.secCtx == null) {
            throw new IgniteAccessControlException(String.format("The user name or password is incorrect [userName=%s]", user));
        }
        return authCtx;
    }
}

