/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueueHeader
implements GridCacheInternal,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id;
    private long head;
    private long tail;
    private int cap;
    private boolean collocated;
    @GridToStringInclude
    private Set<Long> rmvIdxs;

    public GridCacheQueueHeader() {
    }

    public GridCacheQueueHeader(IgniteUuid id, int cap, boolean collocated, long head, long tail, @Nullable Set<Long> rmvIdxs) {
        assert (id != null);
        assert (head <= tail);
        this.id = id;
        this.cap = cap;
        this.collocated = collocated;
        this.head = head;
        this.tail = tail;
        this.rmvIdxs = rmvIdxs;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public int capacity() {
        return this.cap;
    }

    public boolean collocated() {
        return this.collocated;
    }

    public long head() {
        return this.head;
    }

    public long tail() {
        return this.tail;
    }

    public boolean bounded() {
        return this.cap < Integer.MAX_VALUE;
    }

    public boolean empty() {
        return this.head == this.tail;
    }

    public boolean full() {
        return this.bounded() && this.size() == this.capacity();
    }

    public int size() {
        int rmvSize = F.isEmpty(this.removedIndexes()) ? 0 : this.removedIndexes().size();
        int size = (int)(this.tail() - this.head() - (long)rmvSize);
        assert (size >= 0) : size;
        return size;
    }

    @Nullable
    public Set<Long> removedIndexes() {
        return this.rmvIdxs;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.id);
        out.writeInt(this.cap);
        out.writeBoolean(this.collocated);
        out.writeLong(this.head);
        out.writeLong(this.tail);
        out.writeBoolean(this.rmvIdxs != null);
        if (this.rmvIdxs != null) {
            out.writeInt(this.rmvIdxs.size());
            for (Long idx : this.rmvIdxs) {
                out.writeLong(idx);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readGridUuid(in);
        this.cap = in.readInt();
        this.collocated = in.readBoolean();
        this.head = in.readLong();
        this.tail = in.readLong();
        if (in.readBoolean()) {
            int size = in.readInt();
            this.rmvIdxs = new HashSet<Long>();
            for (int i = 0; i < size; ++i) {
                this.rmvIdxs.add(in.readLong());
            }
        }
    }

    public String toString() {
        return S.toString(GridCacheQueueHeader.class, this);
    }
}

