/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.CacheQueryEntryEvent;
import org.apache.ignite.cache.query.ContinuousQueryWithTransformer;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryBatchAck;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEntry;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEvent;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandlerV2;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandlerV3;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryListener;
import org.apache.ignite.internal.processors.cache.query.continuous.CounterSkipContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.StripedCompositeReadWriteLock;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteAsyncCallback;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class CacheContinuousQueryManager
extends GridCacheManagerAdapter {
    private static final byte CREATED_FLAG = 1;
    private static final byte UPDATED_FLAG = 2;
    private static final byte REMOVED_FLAG = 4;
    private static final byte EXPIRED_FLAG = 8;
    private static final long BACKUP_ACK_FREQ = 5000L;
    private final ConcurrentMap<UUID, CacheContinuousQueryListener> lsnrs = new ConcurrentHashMap<UUID, CacheContinuousQueryListener>();
    private final AtomicInteger lsnrCnt = new AtomicInteger();
    private final ConcurrentMap<UUID, CacheContinuousQueryListener> intLsnrs = new ConcurrentHashMap<UUID, CacheContinuousQueryListener>();
    private final AtomicInteger intLsnrCnt = new AtomicInteger();
    private final AtomicLong seq = new AtomicLong();
    private final ConcurrentMap<CacheEntryListenerConfiguration, JCacheQuery> jCacheLsnrs = new ConcurrentHashMap<CacheEntryListenerConfiguration, JCacheQuery>();
    private String topicPrefix;
    private final StripedCompositeReadWriteLock listenerLock = new StripedCompositeReadWriteLock(Runtime.getRuntime().availableProcessors());
    private GridTimeoutProcessor.CancelableTask cancelableTask;

    @Override
    protected void stop0(boolean cancel, boolean destroy) {
        if (this.cancelableTask != null) {
            this.cancelableTask.close();
            this.cancelableTask = null;
        }
    }

    protected GridTimeoutProcessor.CancelableTask getCancelableTask() {
        return this.cancelableTask;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        this.topicPrefix = "CONTINUOUS_QUERY" + (this.cctx.name() == null ? "" : "_" + this.cctx.name());
        if (this.cctx.affinityNode()) {
            this.cctx.io().addCacheHandler(this.cctx.cacheId(), CacheContinuousQueryBatchAck.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, CacheContinuousQueryBatchAck>(){

                @Override
                public void apply(UUID uuid, CacheContinuousQueryBatchAck msg) {
                    CacheContinuousQueryListener lsnr = (CacheContinuousQueryListener)CacheContinuousQueryManager.this.lsnrs.get(msg.routineId());
                    if (lsnr != null) {
                        lsnr.cleanupBackupQueue(msg.updateCntrs());
                    }
                }
            });
            this.cancelableTask = this.cctx.time().schedule(new BackupCleaner(this.lsnrs, this.cctx.kernalContext()), 5000L, 5000L);
        }
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        Iterable cfgs = this.cctx.config().getCacheEntryListenerConfigurations();
        if (cfgs != null) {
            for (CacheEntryListenerConfiguration cfg : cfgs) {
                this.executeJCacheQuery(cfg, true, false);
            }
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        super.onKernalStop0(cancel);
        for (JCacheQuery lsnr : this.jCacheLsnrs.values()) {
            try {
                lsnr.cancel();
            }
            catch (IgniteCheckedException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failed to stop JCache entry listener: " + e.getMessage());
            }
        }
    }

    public Lock getListenerReadLock() {
        return this.listenerLock.readLock();
    }

    public boolean notifyContinuousQueries(@Nullable IgniteInternalTx tx) {
        return this.cctx.isLocal() || this.cctx.isReplicated() || !this.cctx.isNear() && (tx == null || !tx.onePhaseCommit() || tx.local());
    }

    private void skipUpdateEvent(Map<UUID, CacheContinuousQueryListener> lsnrs, KeyCacheObject key, int partId, long updCntr, boolean primary, AffinityTopologyVersion topVer) {
        assert (lsnrs != null);
        for (CacheContinuousQueryListener lsnr : lsnrs.values()) {
            CacheContinuousQueryEntry e0 = new CacheContinuousQueryEntry(this.cctx.cacheId(), EventType.UPDATED, key, null, null, lsnr.keepBinary(), partId, updCntr, topVer, 0);
            CacheContinuousQueryEvent evt = new CacheContinuousQueryEvent(this.cctx.kernalContext().cache().jcache(this.cctx.name()), this.cctx, e0);
            lsnr.skipUpdateEvent(evt, topVer, primary);
        }
    }

    @Nullable
    public CounterSkipContext skipUpdateCounter(@Nullable CounterSkipContext skipCtx, int part, long cntr, AffinityTopologyVersion topVer, boolean primary) {
        for (CacheContinuousQueryListener lsnr : this.lsnrs.values()) {
            skipCtx = lsnr.skipUpdateCounter(this.cctx, skipCtx, part, cntr, topVer, primary);
        }
        return skipCtx;
    }

    @Nullable
    public Map<UUID, CacheContinuousQueryListener> updateListeners(boolean internal, boolean preload) {
        if (preload && !internal) {
            return null;
        }
        ConcurrentMap<UUID, CacheContinuousQueryListener> lsnrCol = internal ? (this.intLsnrCnt.get() > 0 ? this.intLsnrs : null) : (this.lsnrCnt.get() > 0 ? this.lsnrs : null);
        return F.isEmpty(lsnrCol) ? null : lsnrCol;
    }

    public void onEntryUpdated(KeyCacheObject key, CacheObject newVal, CacheObject oldVal, boolean internal, int partId, boolean primary, boolean preload, long updateCntr, @Nullable GridDhtAtomicAbstractUpdateFuture fut, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        Map<UUID, CacheContinuousQueryListener> lsnrCol = this.updateListeners(internal, preload);
        if (lsnrCol != null) {
            this.onEntryUpdated(lsnrCol, key, newVal, oldVal, internal, partId, primary, preload, updateCntr, fut, topVer);
        }
    }

    public void onEntryUpdated(Map<UUID, CacheContinuousQueryListener> lsnrCol, KeyCacheObject key, CacheObject newVal, CacheObject oldVal, boolean internal, int partId, boolean primary, boolean preload, long updateCntr, @Nullable GridDhtAtomicAbstractUpdateFuture fut, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        boolean hasOldVal;
        assert (key != null);
        assert (lsnrCol != null);
        boolean hasNewVal = newVal != null;
        boolean bl = hasOldVal = oldVal != null;
        if (!hasNewVal && !hasOldVal) {
            this.skipUpdateEvent(lsnrCol, key, partId, updateCntr, primary, topVer);
            return;
        }
        EventType evtType = !hasNewVal ? EventType.REMOVED : (!hasOldVal ? EventType.CREATED : EventType.UPDATED);
        boolean initialized = false;
        boolean recordIgniteEvt = primary && !internal && this.cctx.events().isRecordable(97);
        for (CacheContinuousQueryListener lsnr : lsnrCol.values()) {
            if (preload && !lsnr.notifyExisting()) continue;
            if (!initialized) {
                if (lsnr.oldValueRequired() && (oldVal = (CacheObject)this.cctx.unwrapTemporary(oldVal)) != null) {
                    oldVal.finishUnmarshal(this.cctx.cacheObjectContext(), this.cctx.deploy().globalLoader());
                }
                if (newVal != null) {
                    newVal.finishUnmarshal(this.cctx.cacheObjectContext(), this.cctx.deploy().globalLoader());
                }
                initialized = true;
            }
            CacheContinuousQueryEntry e0 = new CacheContinuousQueryEntry(this.cctx.cacheId(), evtType, key, !internal && evtType == EventType.REMOVED && lsnr.oldValueRequired() ? oldVal : newVal, lsnr.oldValueRequired() ? oldVal : null, lsnr.keepBinary(), partId, updateCntr, topVer, 0);
            IgniteCacheProxyImpl<?, ?> jcache = this.cctx.kernalContext().cache().jcacheProxy(this.cctx.name(), true);
            assert (jcache != null) : "Failed to get cache proxy [name=" + this.cctx.name() + ", locStart=" + this.cctx.startTopologyVersion() + ", locNode=" + this.cctx.localNode() + ", stopping=" + this.cctx.kernalContext().isStopping();
            CacheContinuousQueryEvent evt = new CacheContinuousQueryEvent(jcache, this.cctx, e0);
            lsnr.onEntryUpdated(evt, primary, recordIgniteEvt, fut);
        }
    }

    public void onEntryExpired(GridCacheEntryEx e, KeyCacheObject key, CacheObject oldVal) throws IgniteCheckedException {
        ConcurrentMap<UUID, CacheContinuousQueryListener> lsnrCol;
        assert (e != null);
        assert (key != null);
        if (e.isInternal()) {
            return;
        }
        ConcurrentMap<UUID, CacheContinuousQueryListener> concurrentMap = lsnrCol = this.lsnrCnt.get() > 0 ? this.lsnrs : null;
        if (F.isEmpty(lsnrCol)) {
            return;
        }
        boolean primary = this.cctx.affinity().primaryByPartition(this.cctx.localNode(), e.partition(), AffinityTopologyVersion.NONE);
        if (this.cctx.isReplicated() || primary) {
            boolean recordIgniteEvt = this.cctx.events().isRecordable(97);
            boolean initialized = false;
            for (CacheContinuousQueryListener lsnr : lsnrCol.values()) {
                if (!initialized) {
                    if (lsnr.oldValueRequired()) {
                        oldVal = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                    }
                    if (oldVal != null) {
                        oldVal.finishUnmarshal(this.cctx.cacheObjectContext(), this.cctx.deploy().globalLoader());
                    }
                    initialized = true;
                }
                CacheContinuousQueryEntry e0 = new CacheContinuousQueryEntry(this.cctx.cacheId(), EventType.EXPIRED, key, lsnr.oldValueRequired() ? oldVal : null, lsnr.oldValueRequired() ? oldVal : null, lsnr.keepBinary(), e.partition(), -1L, null, 0);
                CacheContinuousQueryEvent evt = new CacheContinuousQueryEvent(this.cctx.kernalContext().cache().jcache(this.cctx.name()), this.cctx, e0);
                lsnr.onEntryUpdated(evt, primary, recordIgniteEvt, null);
            }
        }
    }

    public UUID executeQuery(final @Nullable CacheEntryUpdatedListener locLsnr, final @Nullable ContinuousQueryWithTransformer.EventListener locTransLsnr, final @Nullable CacheEntryEventSerializableFilter rmtFilter, final @Nullable Factory<? extends CacheEntryEventFilter> rmtFilterFactory, final @Nullable Factory<? extends IgniteClosure> rmtTransFactory, int bufSize, long timeInterval, boolean autoUnsubscribe, boolean loc, boolean keepBinary, final boolean includeExpired) throws IgniteCheckedException {
        IgniteOutClosure<CacheContinuousQueryHandler> clsr = rmtTransFactory != null ? new IgniteOutClosure<CacheContinuousQueryHandler>(){

            @Override
            public CacheContinuousQueryHandler apply() {
                assert (locTransLsnr != null);
                return new CacheContinuousQueryHandlerV3(CacheContinuousQueryManager.this.cctx.name(), GridTopic.TOPIC_CACHE.topic(CacheContinuousQueryManager.this.topicPrefix, CacheContinuousQueryManager.this.cctx.localNodeId(), CacheContinuousQueryManager.this.seq.getAndIncrement()), locTransLsnr, rmtFilterFactory, rmtTransFactory, true, false, !includeExpired, false);
            }
        } : (rmtFilterFactory != null ? new IgniteOutClosure<CacheContinuousQueryHandler>(){

            @Override
            public CacheContinuousQueryHandler apply() {
                assert (locLsnr != null);
                return new CacheContinuousQueryHandlerV2(CacheContinuousQueryManager.this.cctx.name(), GridTopic.TOPIC_CACHE.topic(CacheContinuousQueryManager.this.topicPrefix, CacheContinuousQueryManager.this.cctx.localNodeId(), CacheContinuousQueryManager.this.seq.getAndIncrement()), locLsnr, rmtFilterFactory, true, false, !includeExpired, false, null);
            }
        } : new IgniteOutClosure<CacheContinuousQueryHandler>(){

            @Override
            public CacheContinuousQueryHandler apply() {
                assert (locLsnr != null);
                assert (locTransLsnr == null);
                return new CacheContinuousQueryHandler(CacheContinuousQueryManager.this.cctx.name(), GridTopic.TOPIC_CACHE.topic(CacheContinuousQueryManager.this.topicPrefix, CacheContinuousQueryManager.this.cctx.localNodeId(), CacheContinuousQueryManager.this.seq.getAndIncrement()), locLsnr, rmtFilter, true, false, !includeExpired, false);
            }
        });
        return this.executeQuery0(locLsnr, clsr, bufSize, timeInterval, autoUnsubscribe, false, false, loc, keepBinary, false);
    }

    public UUID executeInternalQuery(final CacheEntryUpdatedListener<?, ?> locLsnr, final CacheEntryEventSerializableFilter rmtFilter, boolean loc, boolean notifyExisting, final boolean ignoreClassNotFound, final boolean sync) throws IgniteCheckedException {
        return this.executeQuery0(locLsnr, new IgniteOutClosure<CacheContinuousQueryHandler>(){

            @Override
            public CacheContinuousQueryHandler apply() {
                return new CacheContinuousQueryHandler(CacheContinuousQueryManager.this.cctx.name(), GridTopic.TOPIC_CACHE.topic(CacheContinuousQueryManager.this.topicPrefix, CacheContinuousQueryManager.this.cctx.localNodeId(), CacheContinuousQueryManager.this.seq.getAndIncrement()), locLsnr, rmtFilter, true, sync, true, ignoreClassNotFound);
            }
        }, 1, 0L, true, true, notifyExisting, loc, false, false);
    }

    public void cancelInternalQuery(UUID routineId) {
        block2: {
            try {
                this.cctx.kernalContext().continuous().stopRoutine(routineId).get();
            }
            catch (IgniteCheckedException | IgniteException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("Failed to stop internal continuous query: " + e.getMessage());
            }
        }
    }

    public void executeJCacheQuery(CacheEntryListenerConfiguration cfg, boolean onStart, boolean keepBinary) throws IgniteCheckedException {
        JCacheQuery lsnr = new JCacheQuery(cfg, onStart, keepBinary);
        JCacheQuery old = this.jCacheLsnrs.putIfAbsent(cfg, lsnr);
        if (old != null) {
            throw new IllegalArgumentException("Listener is already registered for configuration: " + cfg);
        }
        try {
            lsnr.execute();
        }
        catch (IgniteCheckedException e) {
            this.cancelJCacheQuery(cfg);
            throw e;
        }
    }

    public void cancelJCacheQuery(CacheEntryListenerConfiguration cfg) throws IgniteCheckedException {
        JCacheQuery lsnr = (JCacheQuery)this.jCacheLsnrs.remove(cfg);
        if (lsnr != null) {
            lsnr.cancel();
        }
    }

    public void flushBackupQueue(AffinityTopologyVersion topVer) {
        for (CacheContinuousQueryListener lsnr : this.lsnrs.values()) {
            lsnr.flushBackupQueue(this.cctx.kernalContext(), topVer);
        }
    }

    public void onPartitionEvicted(int part) {
        for (CacheContinuousQueryListener lsnr : this.lsnrs.values()) {
            lsnr.onPartitionEvicted(part);
        }
        for (CacheContinuousQueryListener lsnr : this.intLsnrs.values()) {
            lsnr.onPartitionEvicted(part);
        }
    }

    private UUID executeQuery0(CacheEntryUpdatedListener locLsnr, IgniteOutClosure<CacheContinuousQueryHandler> clsr, int bufSize, long timeInterval, boolean autoUnsubscribe, boolean internal, boolean notifyExisting, boolean loc, final boolean keepBinary, boolean onStart) throws IgniteCheckedException {
        IgnitePredicate<ClusterNode> pred;
        this.cctx.checkSecurity(SecurityPermission.CACHE_READ);
        int taskNameHash = !internal && this.cctx.kernalContext().security().enabled() ? this.cctx.kernalContext().job().currentTaskNameHash() : 0;
        boolean skipPrimaryCheck = loc && this.cctx.config().getCacheMode() == CacheMode.REPLICATED && this.cctx.affinityNode();
        final CacheContinuousQueryHandler hnd = clsr.apply();
        hnd.taskNameHash(taskNameHash);
        hnd.skipPrimaryCheck(skipPrimaryCheck);
        hnd.notifyExisting(notifyExisting);
        hnd.internal(internal);
        hnd.keepBinary(keepBinary);
        hnd.localCache(this.cctx.isLocal());
        IgnitePredicate<ClusterNode> ignitePredicate = pred = loc || this.cctx.config().getCacheMode() == CacheMode.LOCAL ? F.nodeForNodeId(this.cctx.localNodeId()) : this.cctx.group().nodeFilter();
        assert (pred != null) : this.cctx.config();
        UUID id = null;
        try {
            id = this.cctx.kernalContext().continuous().startRoutine(hnd, internal && loc, bufSize, timeInterval, autoUnsubscribe, pred).get();
            if (hnd.isQuery() && this.cctx.userCache() && !onStart) {
                hnd.waitTopologyFuture(this.cctx.kernalContext());
            }
        }
        catch (NodeStoppingException e) {
            throw new NodeStoppingException(e);
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to start continuous query.", e);
            if (id != null) {
                this.cctx.kernalContext().continuous().stopRoutine(id);
            }
            throw new IgniteCheckedException("Failed to start continuous query.", e);
        }
        if (notifyExisting) {
            assert (locLsnr != null) : "Local listener can't be null if notification for existing entries are enabled";
            final GridIterator<CacheDataRow> it = this.cctx.offheap().cacheIterator(this.cctx.cacheId(), true, true, AffinityTopologyVersion.NONE, null);
            locLsnr.onUpdated((Iterable)new Iterable<CacheEntryEvent>(){

                @Override
                public Iterator<CacheEntryEvent> iterator() {
                    return new Iterator<CacheEntryEvent>(){
                        private CacheContinuousQueryEvent next;
                        {
                            this.advance();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public CacheEntryEvent next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            CacheContinuousQueryEvent next0 = this.next;
                            this.advance();
                            return next0;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private void advance() {
                            this.next = null;
                            while (this.next == null && it.hasNext()) {
                                CacheDataRow e = (CacheDataRow)it.next();
                                CacheContinuousQueryEntry entry = new CacheContinuousQueryEntry(CacheContinuousQueryManager.this.cctx.cacheId(), EventType.CREATED, e.key(), e.value(), null, keepBinary, 0, -1L, null, 0);
                                this.next = new CacheContinuousQueryEvent(CacheContinuousQueryManager.this.cctx.kernalContext().cache().jcache(CacheContinuousQueryManager.this.cctx.name()), CacheContinuousQueryManager.this.cctx, entry);
                                if (hnd.getEventFilter() == null || hnd.getEventFilter().evaluate((CacheEntryEvent)this.next)) continue;
                                this.next = null;
                            }
                        }
                    };
                }
            });
        }
        return id;
    }

    public Iterable<CacheEntryEvent<?, ?>> existingEntries(boolean keepBinary, final CacheEntryEventFilter filter) throws IgniteCheckedException {
        final Iterator it = this.cctx.cache().igniteIterator(keepBinary);
        final IgniteCacheProxy cache = this.cctx.kernalContext().cache().jcache(this.cctx.name());
        return new Iterable<CacheEntryEvent<?, ?>>(){

            @Override
            public Iterator<CacheEntryEvent<?, ?>> iterator() {
                return new Iterator<CacheEntryEvent<?, ?>>(){
                    private CacheQueryEntryEvent<?, ?> next;
                    {
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public CacheEntryEvent<?, ?> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        CacheQueryEntryEvent<?, ?> next0 = this.next;
                        this.advance();
                        return next0;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void advance() {
                        this.next = null;
                        while (this.next == null && it.hasNext()) {
                            Cache.Entry e = (Cache.Entry)it.next();
                            this.next = new CacheEntryEventImpl(cache, EventType.CREATED, e.getKey(), e.getValue());
                            if (filter == null || filter.evaluate(this.next)) continue;
                            this.next = null;
                        }
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridContinuousHandler.RegisterStatus registerListener(UUID lsnrId, CacheContinuousQueryListener lsnr, boolean internal) {
        boolean added;
        if (internal) {
            boolean bl = added = this.intLsnrs.putIfAbsent(lsnrId, lsnr) == null;
            if (added) {
                this.intLsnrCnt.incrementAndGet();
            }
        } else {
            this.listenerLock.writeLock().lock();
            try {
                if (this.lsnrCnt.get() == 0 && this.cctx.group().sharedGroup() && !this.cctx.isLocal()) {
                    this.cctx.group().addCacheWithContinuousQuery(this.cctx);
                }
                boolean bl = added = this.lsnrs.putIfAbsent(lsnrId, lsnr) == null;
                if (added) {
                    this.lsnrCnt.incrementAndGet();
                }
            }
            finally {
                this.listenerLock.writeLock().unlock();
            }
            if (added) {
                lsnr.onExecution();
            }
        }
        return added ? GridContinuousHandler.RegisterStatus.REGISTERED : GridContinuousHandler.RegisterStatus.NOT_REGISTERED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterListener(boolean internal, UUID id) {
        if (internal) {
            CacheContinuousQueryListener lsnr = (CacheContinuousQueryListener)this.intLsnrs.remove(id);
            if (lsnr != null) {
                this.intLsnrCnt.decrementAndGet();
                lsnr.onUnregister();
            }
        } else {
            CacheContinuousQueryListener lsnr;
            this.listenerLock.writeLock().lock();
            try {
                lsnr = (CacheContinuousQueryListener)this.lsnrs.remove(id);
                if (lsnr != null) {
                    int cnt = this.lsnrCnt.decrementAndGet();
                    if (this.cctx.group().sharedGroup() && cnt == 0 && !this.cctx.isLocal()) {
                        this.cctx.group().removeCacheWithContinuousQuery(this.cctx);
                    }
                }
            }
            finally {
                this.listenerLock.writeLock().unlock();
            }
            if (lsnr != null) {
                lsnr.onUnregister();
            }
        }
    }

    public static class CacheEntryEventImpl
    extends CacheQueryEntryEvent {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude(sensitive=true)
        private Object key;
        @GridToStringInclude(sensitive=true)
        private Object val;

        public CacheEntryEventImpl(Cache src, EventType evtType, Object key, Object val) {
            super(src, evtType);
            this.key = key;
            this.val = val;
        }

        @Override
        public long getPartitionUpdateCounter() {
            return 0L;
        }

        public Object getOldValue() {
            return null;
        }

        public boolean isOldValueAvailable() {
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public Object unwrap(Class cls) {
            if (cls.isAssignableFrom(((Object)((Object)this)).getClass())) {
                return cls.cast((Object)this);
            }
            throw new IllegalArgumentException("Unwrapping to class is not supported: " + cls);
        }

        public String toString() {
            return S.toString(CacheEntryEventImpl.class, this);
        }
    }

    private static final class BackupCleaner
    implements Runnable {
        private final Map<UUID, CacheContinuousQueryListener> lsnrs;
        private final GridKernalContext ctx;

        public BackupCleaner(Map<UUID, CacheContinuousQueryListener> lsnrs, GridKernalContext ctx) {
            this.lsnrs = lsnrs;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            for (CacheContinuousQueryListener lsnr : this.lsnrs.values()) {
                lsnr.acknowledgeBackupOnTimeout(this.ctx);
            }
        }
    }

    protected static class JCacheQueryRemoteFilter
    implements CacheEntryEventSerializableFilter,
    Externalizable {
        private static final long serialVersionUID = 0L;
        protected CacheEntryEventFilter impl;
        private byte types;
        @LoggerResource
        private IgniteLogger log;

        public JCacheQueryRemoteFilter() {
        }

        JCacheQueryRemoteFilter(@Nullable CacheEntryEventFilter impl2, byte types) {
            assert (types != 0);
            this.impl = impl2;
            this.types = types;
        }

        public boolean evaluate(CacheEntryEvent evt) {
            try {
                return (this.types & this.flag(evt.getEventType())) != 0 && (this.impl == null || this.impl.evaluate(evt));
            }
            catch (Exception e) {
                U.error(this.log, "CacheEntryEventFilter failed: " + e);
                return true;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.impl);
            out.writeByte(this.types);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.impl = (CacheEntryEventFilter)in.readObject();
            this.types = in.readByte();
        }

        protected boolean async() {
            return U.hasAnnotation(this.impl, IgniteAsyncCallback.class);
        }

        private byte flag(EventType evtType) {
            switch (evtType) {
                case CREATED: {
                    return 1;
                }
                case UPDATED: {
                    return 2;
                }
                case REMOVED: {
                    return 4;
                }
                case EXPIRED: {
                    return 8;
                }
            }
            throw new IllegalStateException("Unknown type: " + evtType);
        }
    }

    static class JCacheQueryLocalListener<K, V>
    implements CacheEntryUpdatedListener<K, V>,
    Closeable {
        final CacheEntryListener<K, V> impl;
        private final IgniteLogger log;

        JCacheQueryLocalListener(CacheEntryListener<K, V> impl2, IgniteLogger log) {
            assert (impl2 != null);
            assert (log != null);
            this.impl = impl2;
            this.log = log;
        }

        public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> evts) {
            for (CacheEntryEvent<K, V> cacheEntryEvent : evts) {
                try {
                    switch (cacheEntryEvent.getEventType()) {
                        case CREATED: {
                            assert (this.impl instanceof CacheEntryCreatedListener) : cacheEntryEvent;
                            ((CacheEntryCreatedListener)this.impl).onCreated(this.singleton(cacheEntryEvent));
                            break;
                        }
                        case UPDATED: {
                            assert (this.impl instanceof CacheEntryUpdatedListener) : cacheEntryEvent;
                            ((CacheEntryUpdatedListener)this.impl).onUpdated(this.singleton(cacheEntryEvent));
                            break;
                        }
                        case REMOVED: {
                            assert (this.impl instanceof CacheEntryRemovedListener) : cacheEntryEvent;
                            ((CacheEntryRemovedListener)this.impl).onRemoved(this.singleton(cacheEntryEvent));
                            break;
                        }
                        case EXPIRED: {
                            assert (this.impl instanceof CacheEntryExpiredListener) : cacheEntryEvent;
                            ((CacheEntryExpiredListener)this.impl).onExpired(this.singleton(cacheEntryEvent));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown type: " + cacheEntryEvent.getEventType());
                        }
                    }
                }
                catch (Exception e) {
                    U.error(this.log, "CacheEntryListener failed: " + e);
                }
            }
        }

        private Iterable<CacheEntryEvent<? extends K, ? extends V>> singleton(CacheEntryEvent<? extends K, ? extends V> evt) {
            assert (evt instanceof CacheContinuousQueryEvent);
            ArrayList<CacheEntryEvent<K, V>> evts = new ArrayList<CacheEntryEvent<K, V>>(1);
            evts.add(evt);
            return evts;
        }

        protected boolean async() {
            return U.hasAnnotation(this.impl, IgniteAsyncCallback.class);
        }

        @Override
        public void close() throws IOException {
            if (this.impl instanceof Closeable) {
                U.closeQuiet((Closeable)this.impl);
            }
        }
    }

    private class JCacheQuery {
        private final CacheEntryListenerConfiguration cfg;
        private final boolean onStart;
        private final boolean keepBinary;
        private volatile UUID routineId;
        private volatile JCacheQueryLocalListener locLsnr;

        private JCacheQuery(CacheEntryListenerConfiguration cfg, boolean onStart, boolean keepBinary) {
            this.cfg = cfg;
            this.onStart = onStart;
            this.keepBinary = keepBinary;
        }

        void execute() throws IgniteCheckedException {
            CacheEntryListener locLsnrImpl;
            if (!this.onStart) {
                CacheContinuousQueryManager.this.cctx.config().addCacheEntryListenerConfiguration(this.cfg);
            }
            if ((locLsnrImpl = (CacheEntryListener)this.cfg.getCacheEntryListenerFactory().create()) == null) {
                throw new IgniteCheckedException("Local CacheEntryListener is mandatory and can't be null.");
            }
            byte types = 0;
            types = (byte)(types | (locLsnrImpl instanceof CacheEntryCreatedListener ? 1 : 0));
            types = (byte)(types | (locLsnrImpl instanceof CacheEntryUpdatedListener ? 2 : 0));
            types = (byte)(types | (locLsnrImpl instanceof CacheEntryRemovedListener ? 4 : 0));
            if ((types = (byte)(types | (locLsnrImpl instanceof CacheEntryExpiredListener ? 8 : 0))) == 0) {
                throw new IgniteCheckedException("Listener must implement one of CacheEntryListener sub-interfaces.");
            }
            final byte types0 = types;
            this.locLsnr = new JCacheQueryLocalListener(locLsnrImpl, CacheContinuousQueryManager.this.log);
            this.routineId = CacheContinuousQueryManager.this.executeQuery0(this.locLsnr, new IgniteOutClosure<CacheContinuousQueryHandler>(){

                @Override
                public CacheContinuousQueryHandler apply() {
                    CacheContinuousQueryHandler hnd;
                    Factory rmtFilterFactory = JCacheQuery.this.cfg.getCacheEntryEventFilterFactory();
                    if (rmtFilterFactory != null) {
                        hnd = new CacheContinuousQueryHandlerV2(CacheContinuousQueryManager.this.cctx.name(), GridTopic.TOPIC_CACHE.topic(CacheContinuousQueryManager.this.topicPrefix, CacheContinuousQueryManager.this.cctx.localNodeId(), CacheContinuousQueryManager.this.seq.getAndIncrement()), JCacheQuery.this.locLsnr, rmtFilterFactory, JCacheQuery.this.cfg.isOldValueRequired(), JCacheQuery.this.cfg.isSynchronous(), false, false, types0);
                    } else {
                        CacheEntryEventFilter filter = null;
                        if (rmtFilterFactory != null && !((filter = (CacheEntryEventFilter)rmtFilterFactory.create()) instanceof Serializable)) {
                            throw new IgniteException("Topology has nodes of the old versions. In this case EntryEventFilter must implement java.io.Serializable interface. Filter: " + filter);
                        }
                        JCacheQueryRemoteFilter jCacheFilter = new JCacheQueryRemoteFilter(filter, types0);
                        hnd = new CacheContinuousQueryHandler(CacheContinuousQueryManager.this.cctx.name(), GridTopic.TOPIC_CACHE.topic(CacheContinuousQueryManager.this.topicPrefix, CacheContinuousQueryManager.this.cctx.localNodeId(), CacheContinuousQueryManager.this.seq.getAndIncrement()), JCacheQuery.this.locLsnr, jCacheFilter, JCacheQuery.this.cfg.isOldValueRequired(), JCacheQuery.this.cfg.isSynchronous(), false, false);
                    }
                    return hnd;
                }
            }, 1, 0L, true, false, false, false, this.keepBinary, this.onStart);
        }

        void cancel() throws IgniteCheckedException {
            UUID routineId0 = this.routineId;
            if (routineId0 != null) {
                CacheContinuousQueryManager.this.cctx.kernalContext().continuous().stopRoutine(routineId0).get();
            }
            CacheContinuousQueryManager.this.cctx.config().removeCacheEntryListenerConfiguration(this.cfg);
            U.closeQuiet(this.locLsnr);
        }
    }
}

