/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.ExchangeContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccLongList;
import org.apache.ignite.internal.processors.cache.mvcc.MvccPreviousCoordinatorQueries;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessor;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotResponseListener;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.VacuumMetrics;
import org.apache.ignite.internal.processors.cache.mvcc.VacuumMetricsReducer;
import org.apache.ignite.internal.processors.cache.mvcc.VacuumTask;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccAckRequestQueryCntr;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccAckRequestQueryId;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccAckRequestTx;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccAckRequestTxAndQueryCntr;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccAckRequestTxAndQueryId;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccActiveQueriesMessage;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccFutureResponse;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccMessage;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccQuerySnapshotRequest;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccRecoveryFinishedMessage;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccSnapshotResponse;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccTxSnapshotRequest;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccWaitTxsRequest;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxKey;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLog;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccLinkAwareSearchRow;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridCompoundIdentityFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MvccProcessorImpl
extends GridProcessorAdapter
implements MvccProcessor,
DatabaseLifecycleListener {
    private static final IgniteProductVersion MVCC_SUPPORTED_SINCE = IgniteProductVersion.fromString("2.7.0");
    private static final Waiter LOCAL_TRANSACTION_MARKER = new LocalTransactionMarker();
    private static final IgniteInternalTx DUMMY_TX = new GridNearTxLocal();
    private static IgniteClosure<Collection<ClusterNode>, ClusterNode> crdC;
    private long crdVer;
    private volatile MvccCoordinator curCrd;
    private volatile MvccCoordinator assignedCrd;
    private TxLog txLog;
    private List<GridWorker> vacuumWorkers;
    private BlockingQueue<VacuumTask> cleanupQueue;
    private final Object mux = new Object();
    private final GridAtomicLong futIdCntr = new GridAtomicLong(0L);
    private final GridAtomicLong mvccCntr = new GridAtomicLong(3L);
    private final GridAtomicLong committedCntr = new GridAtomicLong(1L);
    private final Map<Long, ActiveTx> activeTxs = new HashMap<Long, ActiveTx>();
    private final Map<Long, MvccQueryTracker> activeTrackers = new ConcurrentHashMap<Long, MvccQueryTracker>();
    private final Map<UUID, Map<Long, MvccSnapshotResponseListener>> snapLsnrs = new ConcurrentHashMap<UUID, Map<Long, MvccSnapshotResponseListener>>();
    private final Map<Long, WaitAckFuture> ackFuts = new ConcurrentHashMap<Long, WaitAckFuture>();
    private final Map<Long, GridFutureAdapter> waitTxFuts = new ConcurrentHashMap<Long, GridFutureAdapter>();
    private final Map<TxKey, Waiter> waitMap = new ConcurrentHashMap<TxKey, Waiter>();
    private final ActiveQueries activeQueries = new ActiveQueries();
    private final MvccPreviousCoordinatorQueries prevCrdQueries = new MvccPreviousCoordinatorQueries();
    private final GridFutureAdapter<Void> initFut = new GridFutureAdapter();
    private volatile boolean mvccEnabled;
    private volatile boolean mvccSupported = true;
    private final ConcurrentHashMap<UUID, RecoveryBallotBox> recoveryBallotBoxes = new ConcurrentHashMap();

    static void coordinatorAssignClosure(IgniteClosure<Collection<ClusterNode>, ClusterNode> crdC) {
        MvccProcessorImpl.crdC = crdC;
    }

    public MvccProcessorImpl(GridKernalContext ctx) {
        super(ctx);
        ctx.internalSubscriptionProcessor().registerDatabaseListener(this);
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.event().addLocalEventListener(new CacheCoordinatorNodeFailListener(), 12, 11);
        this.ctx.io().addMessageListener(GridTopic.TOPIC_CACHE_COORDINATOR, (GridMessageListener)new CoordinatorMessageListener());
    }

    @Override
    public boolean mvccEnabled() {
        return this.mvccEnabled;
    }

    @Override
    public void preProcessCacheConfiguration(CacheConfiguration ccfg) {
        if (ccfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            if (!this.mvccSupported) {
                throw new IgniteException("Cannot start MVCC transactional cache. MVCC is unsupported by the cluster.");
            }
            this.mvccEnabled = true;
        }
    }

    @Override
    public void validateCacheConfiguration(CacheConfiguration ccfg) {
        if (ccfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            if (!this.mvccSupported) {
                throw new IgniteException("Cannot start MVCC transactional cache. MVCC is unsupported by the cluster.");
            }
            this.mvccEnabled = true;
        }
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        if (this.mvccEnabled && node.version().compareToIgnoreTimestamp(MVCC_SUPPORTED_SINCE) < 0) {
            String errMsg = "Failed to add node to topology. MVCC is enabled on the cluster, but the node doesn't support MVCC [nodeId=" + node.id() + ']';
            return new IgniteNodeValidationResult(node.id(), errMsg, errMsg);
        }
        return null;
    }

    @Override
    public void ensureStarted() throws IgniteCheckedException {
        if (!this.ctx.clientNode()) {
            assert (this.mvccEnabled && this.mvccSupported);
            if (this.txLog == null) {
                this.txLog = new TxLog(this.ctx, this.ctx.cache().context().database());
            }
            this.startVacuumWorkers();
            if (this.log.isInfoEnabled()) {
                this.log.info("Mvcc processor started.");
            }
        }
    }

    @Override
    public void beforeStop(IgniteCacheDatabaseSharedManager mgr) {
        this.stopVacuumWorkers();
        this.txLog = null;
    }

    @Override
    public void onInitDataRegions(IgniteCacheDatabaseSharedManager mgr) throws IgniteCheckedException {
        DataStorageConfiguration dscfg = this.dataStorageConfiguration();
        mgr.addDataRegion(dscfg, this.createTxLogRegion(dscfg), CU.isPersistenceEnabled(this.ctx.config()));
    }

    @Override
    public void afterInitialise(IgniteCacheDatabaseSharedManager mgr) {
    }

    @Override
    public void beforeMemoryRestore(IgniteCacheDatabaseSharedManager mgr) throws IgniteCheckedException {
        assert (CU.isPersistenceEnabled(this.ctx.config()));
        assert (this.txLog == null);
        this.ctx.cache().context().pageStore().initialize(TxLog.TX_LOG_CACHE_ID, 1, "TxLog", mgr.dataRegion("TxLog").memoryMetrics());
        boolean hasMvccCaches = this.ctx.cache().cacheGroups().stream().filter(CacheGroupContext::persistenceEnabled).anyMatch(g -> g.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
        if (hasMvccCaches) {
            this.txLog = new TxLog(this.ctx, mgr);
            this.mvccEnabled = true;
        }
    }

    @Override
    public void afterMemoryRestore(IgniteCacheDatabaseSharedManager mgr) {
    }

    @Override
    public void onDiscoveryEvent(int evtType, Collection<ClusterNode> nodes, long topVer, @Nullable DiscoveryCustomMessage customMsg) {
        if (evtType == 13) {
            return;
        }
        if (evtType == 18) {
            this.checkMvccCacheStarted(customMsg);
        } else {
            this.assignMvccCoordinator(evtType, nodes, topVer);
        }
    }

    @Override
    public void onExchangeStart(MvccCoordinator mvccCrd, ExchangeContext exchCtx, ClusterNode exchCrd) {
        if (!exchCtx.newMvccCoordinator()) {
            return;
        }
        GridLongList activeQryTrackers = this.collectActiveQueryTrackers();
        exchCtx.addActiveQueries(this.ctx.localNodeId(), activeQryTrackers);
        if (exchCrd == null || !mvccCrd.nodeId().equals(exchCrd.id())) {
            try {
                this.sendMessage(mvccCrd.nodeId(), new MvccActiveQueriesMessage(activeQryTrackers));
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send active queries to mvcc coordinator: " + e);
            }
        }
    }

    @Override
    public void onExchangeDone(boolean newCrd, DiscoCache discoCache, Map<UUID, GridLongList> activeQueries) {
        if (!newCrd) {
            if (this.curCrd != null && this.ctx.localNodeId().equals(this.curCrd.nodeId()) && discoCache != null) {
                this.cleanupOrphanedServerTransactions(discoCache.serverNodes());
            }
            return;
        }
        this.ctx.cache().context().tm().rollbackMvccTxOnCoordinatorChange();
        if (this.ctx.localNodeId().equals(this.curCrd.nodeId())) {
            assert (this.ctx.localNodeId().equals(this.curCrd.nodeId()));
            MvccCoordinator crd = discoCache.mvccCoordinator();
            assert (crd != null);
            if (this.crdVer == crd.coordinatorVersion()) {
                return;
            }
            this.crdVer = crd.coordinatorVersion();
            if (this.log.isInfoEnabled()) {
                this.log.info("Initialize local node as mvcc coordinator [node=" + this.ctx.localNodeId() + ", crdVer=" + this.crdVer + ']');
            }
            this.prevCrdQueries.init(activeQueries, F.view(discoCache.allNodes(), this::supportsMvcc), this.ctx.discovery());
            this.initFut.onDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupOrphanedServerTransactions(Collection<ClusterNode> liveSrvs) {
        Set ids = liveSrvs.stream().map(ClusterNode::id).collect(Collectors.toSet());
        ArrayList<Long> forRmv = new ArrayList<Long>();
        MvccProcessorImpl mvccProcessorImpl = this;
        synchronized (mvccProcessorImpl) {
            for (Map.Entry<Long, ActiveTx> entry : this.activeTxs.entrySet()) {
                ActiveTx activeTx = entry.getValue();
                if (activeTx.getClass() != ActiveServerTx.class || ids.contains(activeTx.nearNodeId)) continue;
                forRmv.add(entry.getKey());
            }
        }
        for (Long txCntr : forRmv) {
            this.onTxDone(txCntr, true);
        }
    }

    @Override
    public void processClientActiveQueries(UUID nodeId, @Nullable GridLongList activeQueries) {
        this.prevCrdQueries.addNodeActiveQueries(nodeId, activeQueries);
    }

    @Override
    @Nullable
    public MvccCoordinator currentCoordinator() {
        return this.currentCoordinator(AffinityTopologyVersion.NONE);
    }

    @Override
    @Nullable
    public MvccCoordinator currentCoordinator(AffinityTopologyVersion topVer) {
        MvccCoordinator crd = this.curCrd;
        assert (crd == null || topVer == AffinityTopologyVersion.NONE || crd.topologyVersion().compareTo(topVer) <= 0) : "Invalid coordinator [crd=" + crd + ", topVer=" + topVer + ']';
        return crd;
    }

    @Override
    @Nullable
    public MvccCoordinator assignedCoordinator() {
        return this.assignedCrd;
    }

    @Override
    public UUID currentCoordinatorId() {
        MvccCoordinator curCrd = this.curCrd;
        return curCrd != null ? curCrd.nodeId() : null;
    }

    @Override
    public void updateCoordinator(MvccCoordinator curCrd) {
        this.curCrd = curCrd;
    }

    @Override
    public byte state(MvccVersion ver) throws IgniteCheckedException {
        return this.state(ver.coordinatorVersion(), ver.counter());
    }

    @Override
    public byte state(long crdVer, long cntr) throws IgniteCheckedException {
        assert (this.txLog != null && this.mvccEnabled);
        return this.txLog.get(crdVer, cntr);
    }

    @Override
    public void updateState(MvccVersion ver, byte state) throws IgniteCheckedException {
        this.updateState(ver, state, true);
    }

    @Override
    public void updateState(MvccVersion ver, byte state, boolean primary) throws IgniteCheckedException {
        Waiter waiter;
        assert (this.txLog != null && this.mvccEnabled);
        TxKey key = new TxKey(ver.coordinatorVersion(), ver.counter());
        this.txLog.put(key, state, primary);
        if (primary && (state == 2 || state == 3) && (waiter = this.waitMap.remove(key)) != null) {
            waiter.run(this.ctx);
        }
    }

    @Override
    public void registerLocalTransaction(long crd, long cntr) {
        Waiter old = this.waitMap.putIfAbsent(new TxKey(crd, cntr), LOCAL_TRANSACTION_MARKER);
        assert (old == null || old.hasLocalTransaction());
    }

    @Override
    public boolean hasLocalTransaction(long crd, long cntr) {
        Waiter waiter = this.waitMap.get(new TxKey(crd, cntr));
        return waiter != null && waiter.hasLocalTransaction();
    }

    @Override
    public IgniteInternalFuture<Void> waitFor(GridCacheContext cctx, MvccVersion locked) throws IgniteCheckedException {
        TxKey key = new TxKey(locked.coordinatorVersion(), locked.counter());
        LockFuture fut = new LockFuture(cctx.ioPolicy());
        Waiter waiter = this.waitMap.merge(key, fut, Waiter::concat);
        byte state = this.txLog.get(key);
        if (!(state != 2 && state != 3 || waiter.hasLocalTransaction() || (waiter = this.waitMap.remove(key)) == null)) {
            waiter.run(this.ctx);
        }
        return fut;
    }

    @Override
    public void addQueryTracker(MvccQueryTracker tracker) {
        assert (tracker.id() != -1L);
        MvccQueryTracker tr = this.activeTrackers.put(tracker.id(), tracker);
        assert (tr == null);
    }

    @Override
    public void removeQueryTracker(Long id) {
        this.activeTrackers.remove(id);
    }

    @Override
    public MvccSnapshot tryRequestSnapshotLocal() throws ClusterTopologyCheckedException {
        return this.tryRequestSnapshotLocal(null);
    }

    @Override
    public MvccSnapshot tryRequestSnapshotLocal(@Nullable IgniteInternalTx tx) throws ClusterTopologyCheckedException {
        AffinityTopologyVersion topVer;
        MvccCoordinator crd = this.currentCoordinator();
        if (crd == null) {
            throw MvccUtils.noCoordinatorError();
        }
        if (tx != null && (topVer = this.ctx.cache().context().lockedTopologyVersion(null)) != null && topVer.compareTo(crd.topologyVersion()) < 0) {
            throw new ClusterTopologyCheckedException("Mvcc coordinator is outdated for the locked topology version. [crd=" + crd + ", tx=" + tx + ']');
        }
        if (!this.ctx.localNodeId().equals(crd.nodeId()) || !this.initFut.isDone()) {
            return null;
        }
        if (tx != null) {
            return this.assignTxSnapshot(0L, this.ctx.localNodeId(), false);
        }
        return this.activeQueries.assignQueryCounter(this.ctx.localNodeId(), 0L);
    }

    @Override
    public IgniteInternalFuture<MvccSnapshot> requestSnapshotAsync(IgniteInternalTx tx) {
        MvccSnapshotFuture fut = new MvccSnapshotFuture();
        this.requestSnapshotAsync(tx, fut);
        return fut;
    }

    @Override
    public void requestSnapshotAsync(MvccSnapshotResponseListener lsnr) {
        this.requestSnapshotAsync(null, lsnr);
    }

    @Override
    public void requestSnapshotAsync(final IgniteInternalTx tx, final MvccSnapshotResponseListener lsnr) {
        block10: {
            Map map0;
            AffinityTopologyVersion topVer;
            MvccCoordinator crd = this.currentCoordinator();
            if (crd == null) {
                lsnr.onError(MvccUtils.noCoordinatorError());
                return;
            }
            if (tx != null && (topVer = this.ctx.cache().context().lockedTopologyVersion(null)) != null && topVer.compareTo(crd.topologyVersion()) < 0) {
                lsnr.onError(new ClusterTopologyCheckedException("Mvcc coordinator is outdated for the locked topology version. [crd=" + crd + ", tx=" + tx + ']'));
                return;
            }
            if (this.ctx.localNodeId().equals(crd.nodeId())) {
                if (!this.initFut.isDone()) {
                    this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Void>>)new IgniteInClosure<IgniteInternalFuture>(){

                        @Override
                        public void apply(IgniteInternalFuture fut) {
                            MvccProcessorImpl.this.requestSnapshotAsync(tx, lsnr);
                        }
                    });
                } else if (tx != null) {
                    lsnr.onResponse(this.assignTxSnapshot(0L, this.ctx.localNodeId(), false));
                } else {
                    lsnr.onResponse(this.activeQueries.assignQueryCounter(this.ctx.localNodeId(), 0L));
                }
                return;
            }
            UUID nodeId = crd.nodeId();
            long id = this.futIdCntr.incrementAndGet();
            Map map = this.snapLsnrs.get(nodeId);
            if (map == null && (map0 = (Map)this.snapLsnrs.putIfAbsent(nodeId, map = new ConcurrentHashMap<Long, MvccSnapshotResponseListener>())) != null) {
                map = map0;
            }
            map.put(id, (MvccSnapshotResponseListener)lsnr);
            try {
                this.sendMessage(nodeId, tx != null ? new MvccTxSnapshotRequest(id) : new MvccQuerySnapshotRequest(id));
            }
            catch (IgniteCheckedException e) {
                if (map.remove(id) == null) break block10;
                lsnr.onError(e);
            }
        }
    }

    @Override
    public IgniteInternalFuture<Void> ackTxCommit(MvccSnapshot updateVer) {
        return this.ackTxCommit(updateVer, null, 0L);
    }

    @Override
    public IgniteInternalFuture<Void> ackTxCommit(MvccVersion updateVer, MvccSnapshot readSnapshot, long qryId) {
        assert (updateVer != null);
        MvccCoordinator crd = this.curCrd;
        if (updateVer.coordinatorVersion() == crd.coordinatorVersion()) {
            return this.sendTxCommit(crd, this.createTxAckMessage(this.futIdCntr.incrementAndGet(), updateVer, readSnapshot, qryId));
        }
        if (readSnapshot != null) {
            this.ackQueryDone(readSnapshot, qryId);
        }
        return new GridFinishedFuture<Void>();
    }

    @Override
    public void ackTxRollback(MvccVersion updateVer) {
        assert (updateVer != null);
        MvccCoordinator crd = this.curCrd;
        if (crd.coordinatorVersion() != updateVer.coordinatorVersion()) {
            return;
        }
        MvccAckRequestTx msg = this.createTxAckMessage(-1L, updateVer, null, 0L);
        msg.skipResponse(true);
        try {
            this.sendMessage(crd.nodeId(), msg);
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send tx rollback ack, node left [msg=" + msg + ", node=" + crd.nodeId() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send tx rollback ack [msg=" + msg + ", node=" + crd.nodeId() + ']', e);
        }
    }

    @Override
    public void ackTxRollback(MvccVersion updateVer, MvccSnapshot readSnapshot, long qryTrackerId) {
        assert (updateVer != null);
        MvccCoordinator crd = this.curCrd;
        if (crd.coordinatorVersion() != updateVer.coordinatorVersion()) {
            if (readSnapshot != null) {
                this.ackQueryDone(readSnapshot, qryTrackerId);
            }
            return;
        }
        MvccAckRequestTx msg = this.createTxAckMessage(-1L, updateVer, readSnapshot, qryTrackerId);
        msg.skipResponse(true);
        try {
            this.sendMessage(crd.nodeId(), msg);
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send tx rollback ack, node left [msg=" + msg + ", node=" + crd.nodeId() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send tx rollback ack [msg=" + msg + ", node=" + crd.nodeId() + ']', e);
        }
    }

    @Override
    public void ackQueryDone(MvccSnapshot snapshot, long qryId) {
        assert (snapshot != null);
        MvccCoordinator crd = this.currentCoordinator();
        if (crd == null || crd.coordinatorVersion() == snapshot.coordinatorVersion() && this.sendQueryDone(crd, new MvccAckRequestQueryCntr(this.queryTrackCounter(snapshot)))) {
            return;
        }
        MvccAckRequestQueryId msg = new MvccAckRequestQueryId(qryId);
        while (!this.sendQueryDone(crd = this.currentCoordinator(), msg)) {
        }
    }

    @Override
    public IgniteInternalFuture<Void> waitTxsFuture(UUID crdId, GridLongList txs) {
        WaitAckFuture fut;
        block5: {
            assert (crdId != null);
            assert (txs != null && !txs.isEmpty());
            fut = new WaitAckFuture(this.futIdCntr.incrementAndGet(), crdId, false);
            this.ackFuts.put(fut.id, fut);
            try {
                this.sendMessage(crdId, new MvccWaitTxsRequest(fut.id, txs));
            }
            catch (IgniteCheckedException e) {
                if (this.ackFuts.remove(fut.id) == null) break block5;
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onDone();
                }
                fut.onDone(e);
            }
        }
        return fut;
    }

    @Override
    public void dumpDebugInfo(IgniteLogger log, @Nullable IgniteDiagnosticPrepareContext diagCtx) {
        boolean first = true;
        for (Map<Long, MvccSnapshotResponseListener> map : this.snapLsnrs.values()) {
            if (first) {
                U.warn(log, "Pending mvcc listener: ");
                first = false;
            }
            for (MvccSnapshotResponseListener lsnr : map.values()) {
                U.warn(log, ">>> " + lsnr.toString());
            }
        }
        first = true;
        for (WaitAckFuture waitAckFut : this.ackFuts.values()) {
            if (first) {
                U.warn(log, "Pending mvcc wait ack futures: ");
                first = false;
            }
            U.warn(log, ">>> " + waitAckFut.toString());
        }
    }

    void removeUntil(MvccVersion ver) throws IgniteCheckedException {
        this.txLog.removeUntil(ver.coordinatorVersion(), ver.counter());
    }

    private DataRegionConfiguration createTxLogRegion(DataStorageConfiguration dscfg) {
        DataRegionConfiguration cfg = new DataRegionConfiguration();
        cfg.setName("TxLog");
        cfg.setInitialSize(dscfg.getSystemRegionInitialSize());
        cfg.setMaxSize(dscfg.getSystemRegionMaxSize());
        cfg.setPersistenceEnabled(CU.isPersistenceEnabled(dscfg));
        return cfg;
    }

    private DataStorageConfiguration dataStorageConfiguration() {
        return this.ctx.config().getDataStorageConfiguration();
    }

    private void assignMvccCoordinator(int evtType, Collection<ClusterNode> nodes, long topVer) {
        MvccCoordinator crd;
        block5: {
            ClusterNode crdNode;
            block7: {
                block6: {
                    block4: {
                        this.checkMvccSupported(nodes);
                        if (evtType != 14 && evtType != 16) break block4;
                        crd = null;
                        break block5;
                    }
                    crd = this.assignedCrd;
                    if (crd != null && (evtType != 12 && evtType != 11 || F.nodeIds(nodes).contains(crd.nodeId()))) break block5;
                    crdNode = null;
                    if (crdC == null) break block6;
                    crdNode = crdC.apply(nodes);
                    if (!this.log.isInfoEnabled()) break block7;
                    this.log.info("Assigned coordinator using test closure: " + crd);
                    break block7;
                }
                for (ClusterNode node : nodes) {
                    if (node.isClient() || !this.supportsMvcc(node)) continue;
                    crdNode = node;
                    break;
                }
            }
            MvccCoordinator mvccCoordinator = crd = crdNode != null ? new MvccCoordinator(crdNode.id(), this.coordinatorVersion(crdNode), new AffinityTopologyVersion(topVer, 0)) : null;
            if (this.log.isInfoEnabled() && crd != null) {
                this.log.info("Assigned mvcc coordinator [crd=" + crd + ", crdNode=" + crdNode + ']');
            } else if (crd == null) {
                U.warn(this.log, "New mvcc coordinator was not assigned [topVer=" + topVer + ']');
            }
        }
        this.assignedCrd = crd;
    }

    private long coordinatorVersion(ClusterNode crdNode) {
        return crdNode.order() + this.ctx.discovery().gridStartTime();
    }

    private void checkMvccSupported(Collection<ClusterNode> nodes) {
        if (this.mvccEnabled) {
            assert (this.mvccSupported);
            return;
        }
        boolean res = true;
        boolean was = this.mvccSupported;
        for (ClusterNode node : nodes) {
            if (this.supportsMvcc(node)) continue;
            res = false;
            break;
        }
        if (was != res) {
            this.mvccSupported = res;
        }
    }

    private boolean supportsMvcc(ClusterNode node) {
        return node.version().compareToIgnoreTimestamp(MVCC_SUPPORTED_SINCE) >= 0;
    }

    private void checkMvccCacheStarted(@Nullable DiscoveryCustomMessage customMsg) {
        assert (customMsg != null);
        if (!this.mvccEnabled && customMsg instanceof DynamicCacheChangeBatch) {
            for (DynamicCacheChangeRequest req : ((DynamicCacheChangeBatch)customMsg).requests()) {
                CacheConfiguration ccfg = req.startCacheConfiguration();
                if (ccfg == null || ccfg.getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
                assert (this.mvccSupported);
                this.mvccEnabled = true;
            }
        }
    }

    private GridLongList collectActiveQueryTrackers() {
        assert (this.curCrd != null);
        GridLongList activeQryTrackers = new GridLongList();
        for (MvccQueryTracker tracker : this.activeTrackers.values()) {
            long trackerId = tracker.onMvccCoordinatorChange(this.curCrd);
            if (trackerId == -1L) continue;
            activeQryTrackers.add(trackerId);
        }
        return activeQryTrackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MvccSnapshotResponse assignTxSnapshot(long futId, UUID nearId, boolean client) {
        long cleanup;
        long tracking;
        long ver;
        assert (this.initFut.isDone());
        assert (this.crdVer != 0L);
        assert (this.ctx.localNodeId().equals(this.currentCoordinatorId()));
        MvccSnapshotResponse res = new MvccSnapshotResponse();
        MvccProcessorImpl mvccProcessorImpl = this;
        synchronized (mvccProcessorImpl) {
            boolean add;
            tracking = ver = this.mvccCntr.incrementAndGet();
            cleanup = this.committedCntr.get() + 1L;
            for (Map.Entry<Long, ActiveTx> entry : this.activeTxs.entrySet()) {
                cleanup = Math.min(entry.getValue().tracking, cleanup);
                tracking = Math.min(entry.getKey(), tracking);
                res.addTx(entry.getKey());
            }
            ActiveTx activeTx = client ? new ActiveTx(tracking, nearId) : new ActiveServerTx(tracking, nearId);
            boolean bl = add = this.activeTxs.put(ver, activeTx) == null;
            assert (add) : ver;
        }
        long minQry = this.activeQueries.minimalQueryCounter();
        if (minQry != -1L) {
            cleanup = Math.min(cleanup, minQry);
        }
        cleanup = this.prevCrdQueries.previousQueriesDone() ? cleanup - 1L : 0L;
        res.init(futId, this.crdVer, ver, 1, cleanup, tracking);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTxDone(Long txCntr, boolean increaseCommittedCntr) {
        assert (this.initFut.isDone());
        MvccProcessorImpl mvccProcessorImpl = this;
        synchronized (mvccProcessorImpl) {
            this.activeTxs.remove(txCntr);
            if (increaseCommittedCntr) {
                this.committedCntr.setIfGreater(txCntr);
            }
        }
        GridFutureAdapter fut = this.waitTxFuts.remove(txCntr);
        if (fut != null) {
            fut.onDone();
        }
    }

    private void onQueryDone(UUID nodeId, Long mvccCntr) {
        this.activeQueries.onQueryDone(nodeId, mvccCntr);
    }

    private MvccAckRequestTx createTxAckMessage(long futId, MvccVersion updateVer, MvccSnapshot readSnapshot, long qryTrackerId) {
        if (readSnapshot == null) {
            return new MvccAckRequestTx(futId, updateVer.counter());
        }
        if (readSnapshot.coordinatorVersion() == updateVer.coordinatorVersion()) {
            return new MvccAckRequestTxAndQueryCntr(futId, updateVer.counter(), this.queryTrackCounter(readSnapshot));
        }
        return new MvccAckRequestTxAndQueryId(futId, updateVer.counter(), qryTrackerId);
    }

    private long queryTrackCounter(MvccSnapshot mvccVer) {
        long trackCntr = mvccVer.counter();
        MvccLongList txs = mvccVer.activeTransactions();
        int size = txs.size();
        for (int i = 0; i < size; ++i) {
            long txVer = txs.get(i);
            if (txVer >= trackCntr) continue;
            trackCntr = txVer;
        }
        return trackCntr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startVacuumWorkers() {
        if (!this.ctx.clientNode()) {
            Object object = this.mux;
            synchronized (object) {
                if (this.vacuumWorkers == null) {
                    assert (this.cleanupQueue == null);
                    this.cleanupQueue = new LinkedBlockingQueue<VacuumTask>();
                    this.vacuumWorkers = new ArrayList<GridWorker>(this.ctx.config().getMvccVacuumThreadCount() + 1);
                    this.vacuumWorkers.add(new VacuumScheduler(this.ctx, this.log, this));
                    for (int i = 0; i < this.ctx.config().getMvccVacuumThreadCount(); ++i) {
                        this.vacuumWorkers.add(new VacuumWorker(this.ctx, this.log, this.cleanupQueue));
                    }
                    for (GridWorker worker : this.vacuumWorkers) {
                        new IgniteThread(worker).start();
                    }
                    return;
                }
            }
            U.warn(this.log, "Attempting to start active vacuum.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopVacuumWorkers() {
        if (!this.ctx.clientNode()) {
            BlockingQueue<VacuumTask> queue;
            List<GridWorker> workers;
            Object object = this.mux;
            synchronized (object) {
                workers = this.vacuumWorkers;
                queue = this.cleanupQueue;
                this.vacuumWorkers = null;
                this.cleanupQueue = null;
            }
            if (workers == null) {
                if (this.log.isDebugEnabled() && this.mvccEnabled()) {
                    this.log.debug("Attempting to stop inactive vacuum.");
                }
                return;
            }
            assert (queue != null);
            U.cancel(workers);
            U.join(workers, this.log);
            if (!queue.isEmpty()) {
                IgniteCheckedException ex = this.vacuumCancelledException();
                for (VacuumTask task : queue) {
                    task.onDone(ex);
                }
            }
        }
    }

    IgniteInternalFuture<VacuumMetrics> runVacuum() {
        MvccSnapshot snapshot;
        assert (!this.ctx.clientNode());
        MvccCoordinator crd0 = this.currentCoordinator();
        if (Thread.currentThread().isInterrupted() || crd0 == null || this.crdVer == 0L && this.ctx.localNodeId().equals(crd0.nodeId())) {
            return new GridFinishedFuture<VacuumMetrics>(new VacuumMetrics());
        }
        final GridFutureAdapter<VacuumMetrics> res = new GridFutureAdapter<VacuumMetrics>();
        try {
            snapshot = this.tryRequestSnapshotLocal(DUMMY_TX);
        }
        catch (ClusterTopologyCheckedException e) {
            throw new AssertionError((Object)e);
        }
        if (snapshot != null) {
            this.continueRunVacuum(res, snapshot);
        } else {
            this.requestSnapshotAsync(DUMMY_TX, new MvccSnapshotResponseListener(){

                @Override
                public void onResponse(MvccSnapshot s) {
                    MvccProcessorImpl.this.continueRunVacuum(res, s);
                }

                @Override
                public void onError(IgniteCheckedException e) {
                    if (!(e instanceof ClusterTopologyCheckedException)) {
                        MvccProcessorImpl.this.completeWithException(res, e);
                    } else {
                        if (MvccProcessorImpl.this.log.isDebugEnabled()) {
                            MvccProcessorImpl.this.log.debug("Vacuum failed to receive an Mvcc snapshot. Need to retry on the stable topology. " + e.getMessage());
                        }
                        res.onDone(new VacuumMetrics());
                    }
                }
            });
        }
        return res;
    }

    private void continueRunVacuum(final GridFutureAdapter<VacuumMetrics> res, final MvccSnapshot snapshot) {
        this.ackTxCommit(snapshot).listen((IgniteInClosure<IgniteInternalFuture<Void>>)new IgniteInClosure<IgniteInternalFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(IgniteInternalFuture fut) {
                Throwable err = fut.error();
                if (err != null) {
                    U.error(MvccProcessorImpl.this.log, "Vacuum error.", err);
                    res.onDone(err);
                } else if (snapshot.cleanupVersion() <= 0L) {
                    res.onDone(new VacuumMetrics());
                } else {
                    try {
                        if (MvccProcessorImpl.this.log.isDebugEnabled()) {
                            MvccProcessorImpl.this.log.debug("Started vacuum with cleanup version=" + snapshot.cleanupVersion() + '.');
                        }
                        Object object = MvccProcessorImpl.this.mux;
                        synchronized (object) {
                            if (MvccProcessorImpl.this.cleanupQueue == null) {
                                res.onDone(MvccProcessorImpl.this.vacuumCancelledException());
                                return;
                            }
                            GridCompoundIdentityFuture<VacuumMetrics> res0 = new GridCompoundIdentityFuture<VacuumMetrics>((IgniteReducer)new VacuumMetricsReducer()){

                                @Override
                                protected void logError(IgniteLogger log, String msg, Throwable e) {
                                }

                                @Override
                                protected void logDebug(IgniteLogger log, String msg) {
                                }
                            };
                            for (CacheGroupContext grp : MvccProcessorImpl.this.ctx.cache().cacheGroups()) {
                                if (!grp.mvccEnabled()) continue;
                                grp.topology().readLock();
                                try {
                                    for (GridDhtLocalPartition part : grp.topology().localPartitions()) {
                                        VacuumTask task = new VacuumTask(snapshot, part);
                                        MvccProcessorImpl.this.cleanupQueue.offer(task);
                                        res0.add(task);
                                    }
                                }
                                finally {
                                    grp.topology().readUnlock();
                                }
                            }
                            res0.markInitialized();
                            res0.listen(future -> {
                                VacuumMetrics metrics = null;
                                GridClosureException ex = null;
                                try {
                                    metrics = (VacuumMetrics)future.get();
                                    if (U.assertionsEnabled()) {
                                        MvccCoordinator crd = MvccProcessorImpl.this.currentCoordinator();
                                        assert (crd != null && crd.coordinatorVersion() >= snapshot.coordinatorVersion());
                                        for (TxKey key : MvccProcessorImpl.this.waitMap.keySet()) {
                                            if (key.major() == snapshot.coordinatorVersion() && key.minor() > snapshot.cleanupVersion() || key.major() > snapshot.coordinatorVersion()) continue;
                                            byte state = MvccProcessorImpl.this.state(key.major(), key.minor());
                                            assert (state == 2) : "tx state=" + state;
                                        }
                                    }
                                    MvccProcessorImpl.this.txLog.removeUntil(snapshot.coordinatorVersion(), snapshot.cleanupVersion());
                                    if (MvccProcessorImpl.this.log.isDebugEnabled()) {
                                        MvccProcessorImpl.this.log.debug("Vacuum completed. " + metrics);
                                    }
                                }
                                catch (Throwable e) {
                                    if (X.hasCause(e, NodeStoppingException.class)) {
                                        if (MvccProcessorImpl.this.log.isDebugEnabled()) {
                                            MvccProcessorImpl.this.log.debug("Cannot complete vacuum (node is stopping).");
                                        }
                                        metrics = new VacuumMetrics();
                                    }
                                    ex = new GridClosureException(e);
                                }
                                res.onDone(metrics, ex);
                            });
                        }
                    }
                    catch (Throwable e) {
                        MvccProcessorImpl.this.completeWithException(res, e);
                    }
                }
            }
        });
    }

    private void completeWithException(GridFutureAdapter fut, Throwable e) {
        fut.onDone(e);
        if (e instanceof Error) {
            throw (Error)e;
        }
    }

    @NotNull
    private IgniteCheckedException vacuumCancelledException() {
        return new NodeStoppingException("Operation has been cancelled (node is stopping).");
    }

    private void sendFutureResponse(UUID nodeId, MvccWaitTxsRequest msg) {
        try {
            this.sendMessage(nodeId, new MvccFutureResponse(msg.futureId()));
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send tx ack response, node left [msg=" + msg + ", node=" + nodeId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send tx ack response [msg=" + msg + ", node=" + nodeId + ']', e);
        }
    }

    @NotNull
    private IgniteInternalFuture<Void> sendTxCommit(MvccCoordinator crd, MvccAckRequestTx msg) {
        WaitAckFuture fut;
        block4: {
            fut = new WaitAckFuture(msg.futureId(), crd.nodeId(), true);
            this.ackFuts.put(fut.id, fut);
            try {
                this.sendMessage(crd.nodeId(), msg);
            }
            catch (IgniteCheckedException e) {
                if (this.ackFuts.remove(fut.id) == null) break block4;
                if (e instanceof ClusterTopologyCheckedException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to send tx ack, node left [crd=" + crd + ", msg=" + msg + ']');
                    }
                    fut.onDone();
                }
                fut.onDone(e);
            }
        }
        return fut;
    }

    private boolean sendQueryDone(MvccCoordinator crd, Message msg) {
        if (crd == null) {
            return true;
        }
        try {
            this.sendMessage(crd.nodeId(), msg);
            return true;
        }
        catch (ClusterTopologyCheckedException e) {
            MvccCoordinator crd0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send query ack, node left [crd=" + crd + ", msg=" + msg + ']');
            }
            return (crd0 = this.currentCoordinator()) == null || crd.coordinatorVersion() == crd0.coordinatorVersion();
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send query ack [crd=" + crd + ", msg=" + msg + ']', e);
            return true;
        }
    }

    private void sendMessage(UUID nodeId, Message msg) throws IgniteCheckedException {
        this.ctx.io().sendToGridTopic(nodeId, GridTopic.TOPIC_CACHE_COORDINATOR, msg, (byte)2);
    }

    private void processCoordinatorTxSnapshotRequest(UUID nodeId, MvccTxSnapshotRequest msg) {
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignore tx snapshot request processing, node left [msg=" + msg + ", node=" + nodeId + ']');
            }
            return;
        }
        MvccSnapshotResponse res = this.assignTxSnapshot(msg.futureId(), nodeId, node.isClient());
        boolean finishFailed = true;
        try {
            this.sendMessage(node.id(), res);
            finishFailed = false;
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send tx snapshot response, node left [msg=" + msg + ", node=" + nodeId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send tx snapshot response [msg=" + msg + ", node=" + nodeId + ']', e);
        }
        if (finishFailed) {
            this.onTxDone(res.counter(), false);
        }
    }

    private void processCoordinatorQuerySnapshotRequest(UUID nodeId, MvccQuerySnapshotRequest msg) {
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignore query counter request processing, node left [msg=" + msg + ", node=" + nodeId + ']');
            }
            return;
        }
        MvccSnapshotResponse res = this.activeQueries.assignQueryCounter(nodeId, msg.futureId());
        try {
            this.sendMessage(node.id(), res);
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send query counter response, node left [msg=" + msg + ", node=" + nodeId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            this.onQueryDone(nodeId, res.tracking());
            U.error(this.log, "Failed to send query counter response [msg=" + msg + ", node=" + nodeId + ']', e);
        }
    }

    private void processCoordinatorSnapshotResponse(UUID nodeId, MvccSnapshotResponse msg) {
        MvccSnapshotResponseListener lsnr;
        Map<Long, MvccSnapshotResponseListener> map = this.snapLsnrs.get(nodeId);
        if (map != null && (lsnr = map.remove(msg.futureId())) != null) {
            lsnr.onResponse(msg);
        } else if (this.ctx.discovery().alive(nodeId)) {
            U.warn(this.log, "Failed to find query version future [node=" + nodeId + ", msg=" + msg + ']');
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to find query version future [node=" + nodeId + ", msg=" + msg + ']');
        }
    }

    private void processCoordinatorQueryAckRequest(UUID nodeId, MvccAckRequestQueryCntr msg) {
        this.onQueryDone(nodeId, msg.counter());
    }

    private void processNewCoordinatorQueryAckRequest(UUID nodeId, MvccAckRequestQueryId msg) {
        this.prevCrdQueries.onQueryDone(nodeId, msg.queryTrackerId());
    }

    private void processCoordinatorTxAckRequest(UUID nodeId, MvccAckRequestTx msg) {
        this.onTxDone(msg.txCounter(), msg.futureId() >= 0L);
        if (msg.queryCounter() != 0L) {
            this.onQueryDone(nodeId, msg.queryCounter());
        } else if (msg.queryTrackerId() != -1L) {
            this.prevCrdQueries.onQueryDone(nodeId, msg.queryTrackerId());
        }
        if (!msg.skipResponse()) {
            try {
                this.sendMessage(nodeId, new MvccFutureResponse(msg.futureId()));
            }
            catch (ClusterTopologyCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send tx ack response, node left [msg=" + msg + ", node=" + nodeId + ']');
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send tx ack response [msg=" + msg + ", node=" + nodeId + ']', e);
            }
        }
    }

    private void processCoordinatorAckResponse(UUID nodeId, MvccFutureResponse msg) {
        WaitAckFuture fut = this.ackFuts.remove(msg.futureId());
        if (fut != null) {
            fut.onResponse();
        } else if (this.ctx.discovery().alive(nodeId)) {
            U.warn(this.log, "Failed to find tx ack future [node=" + nodeId + ", msg=" + msg + ']');
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to find tx ack future [node=" + nodeId + ", msg=" + msg + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCoordinatorWaitTxsRequest(final UUID nodeId, final MvccWaitTxsRequest msg) {
        GridLongList txs = msg.transactions();
        GridCompoundFuture resFut = null;
        for (int i = 0; i < txs.size(); ++i) {
            boolean isDone;
            GridFutureAdapter old;
            Long txId = txs.get(i);
            GridFutureAdapter fut = this.waitTxFuts.get(txId);
            if (fut == null && (old = this.waitTxFuts.putIfAbsent(txId, fut = new GridFutureAdapter())) != null) {
                fut = old;
            }
            MvccProcessorImpl mvccProcessorImpl = this;
            synchronized (mvccProcessorImpl) {
                isDone = !this.activeTxs.containsKey(txId);
            }
            if (isDone) {
                fut.onDone();
            }
            if (fut.isDone()) continue;
            if (resFut == null) {
                resFut = new GridCompoundFuture();
            }
            resFut.add(fut);
        }
        if (resFut != null) {
            resFut.markInitialized();
        }
        if (resFut == null || resFut.isDone()) {
            this.sendFutureResponse(nodeId, msg);
        } else {
            resFut.listen(new IgniteInClosure<IgniteInternalFuture>(){

                @Override
                public void apply(IgniteInternalFuture fut) {
                    MvccProcessorImpl.this.sendFutureResponse(nodeId, msg);
                }
            });
        }
    }

    private void processCoordinatorActiveQueriesMessage(UUID nodeId, MvccActiveQueriesMessage msg) {
        this.prevCrdQueries.addNodeActiveQueries(nodeId, msg.activeQueries());
    }

    private void processRecoveryFinishedMessage(UUID nodeId, MvccRecoveryFinishedMessage msg) {
        UUID nearNodeId = msg.nearNodeId();
        RecoveryBallotBox ballotBox = this.recoveryBallotBoxes.computeIfAbsent(nearNodeId, uuid -> new RecoveryBallotBox());
        ballotBox.vote(nodeId);
        this.tryFinishRecoveryVoting(nearNodeId, ballotBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryFinishRecoveryVoting(UUID nearNodeId, RecoveryBallotBox ballotBox) {
        if (ballotBox.isVotingDone()) {
            List<Long> recoveredTxs;
            MvccProcessorImpl mvccProcessorImpl = this;
            synchronized (mvccProcessorImpl) {
                recoveredTxs = this.activeTxs.entrySet().stream().filter(e -> ((ActiveTx)e.getValue()).nearNodeId.equals(nearNodeId)).map(Map.Entry::getKey).collect(Collectors.toList());
            }
            recoveredTxs.forEach(txCntr -> this.onTxDone((Long)txCntr, true));
            this.recoveryBallotBoxes.remove(nearNodeId);
        }
    }

    private static class ActiveServerTx
    extends ActiveTx {
        private ActiveServerTx(long tracking, UUID nearNodeId) {
            super(tracking, nearNodeId);
        }
    }

    private static class ActiveTx {
        private final long tracking;
        private final UUID nearNodeId;

        private ActiveTx(long tracking, UUID nearNodeId) {
            this.tracking = tracking;
            this.nearNodeId = nearNodeId;
        }
    }

    private static class VacuumWorker
    extends GridWorker {
        private final BlockingQueue<VacuumTask> cleanupQueue;

        VacuumWorker(GridKernalContext ctx, IgniteLogger log, BlockingQueue<VacuumTask> cleanupQueue) {
            super(ctx.igniteInstanceName(), "vacuum-cleaner", log);
            this.cleanupQueue = cleanupQueue;
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            while (!this.isCancelled()) {
                VacuumTask task = this.cleanupQueue.take();
                try {
                    switch (task.part().state()) {
                        case EVICTED: 
                        case RENTING: {
                            task.onDone(new VacuumMetrics());
                            break;
                        }
                        case MOVING: {
                            task.part().group().preloader().rebalanceFuture().listen(f -> this.cleanupQueue.add(task));
                            break;
                        }
                        case OWNING: {
                            task.onDone(this.processPartition(task));
                            break;
                        }
                        case LOST: {
                            task.onDone(new IgniteCheckedException("Partition is lost."));
                        }
                    }
                }
                catch (IgniteInterruptedCheckedException e) {
                    task.onDone(e);
                    throw e;
                }
                catch (Throwable e) {
                    task.onDone(e);
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VacuumMetrics processPartition(VacuumTask task) throws IgniteCheckedException {
            long startNanoTime = System.nanoTime();
            GridDhtLocalPartition part = task.part();
            VacuumMetrics metrics = new VacuumMetrics();
            if (!part.reserve()) {
                return metrics;
            }
            int curCacheId = 0;
            try {
                GridCursor<? extends CacheDataRow> cursor = part.dataStore().cursor((Object)CacheDataRowAdapter.RowData.KEY_ONLY);
                KeyCacheObject prevKey = null;
                Object rest = null;
                List<MvccLinkAwareSearchRow> cleanupRows = null;
                MvccSnapshot snapshot = task.snapshot();
                GridCacheContext cctx = null;
                boolean shared = part.group().sharedGroup();
                if (!shared && (cctx = F.first(part.group().caches())) == null) {
                    VacuumMetrics vacuumMetrics = metrics;
                    return vacuumMetrics;
                }
                while (cursor.next()) {
                    if (this.isCancelled()) {
                        throw new IgniteInterruptedCheckedException("Operation has been cancelled.");
                    }
                    MvccDataRow row = (MvccDataRow)cursor.get();
                    if (prevKey == null) {
                        prevKey = row.key();
                    }
                    if (cctx == null) {
                        curCacheId = row.cacheId();
                        cctx = part.group().shared().cacheContext(curCacheId);
                        if (cctx == null) {
                            VacuumMetrics vacuumMetrics = metrics;
                            return vacuumMetrics;
                        }
                    }
                    if (!prevKey.equals(row.key()) || shared && curCacheId != row.cacheId()) {
                        if (rest != null || !F.isEmpty(cleanupRows)) {
                            this.cleanup(part, prevKey, cleanupRows, rest, cctx, metrics);
                        }
                        cleanupRows = null;
                        rest = null;
                        if (shared && curCacheId != row.cacheId()) {
                            curCacheId = row.cacheId();
                            cctx = part.group().shared().cacheContext(curCacheId);
                            if (cctx == null) {
                                VacuumMetrics vacuumMetrics = metrics;
                                return vacuumMetrics;
                            }
                        }
                        prevKey = row.key();
                    }
                    if (this.canClean(row, snapshot, cctx)) {
                        cleanupRows = this.addRow(cleanupRows, row);
                    } else if (this.actualize(cctx, row, snapshot)) {
                        rest = this.addRest(rest, row);
                    }
                    metrics.addScannedRowsCount(1L);
                }
                if (rest != null || !F.isEmpty(cleanupRows)) {
                    this.cleanup(part, prevKey, cleanupRows, rest, cctx, metrics);
                }
                metrics.addSearchNanoTime(System.nanoTime() - startNanoTime - metrics.cleanupNanoTime());
                VacuumMetrics vacuumMetrics = metrics;
                return vacuumMetrics;
            }
            finally {
                part.release();
            }
        }

        @NotNull
        private Object addRest(@Nullable Object rest, MvccDataRow row) {
            if (rest == null) {
                rest = row;
            } else if (rest.getClass() == ArrayList.class) {
                ((List)rest).add(row);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(rest);
                list.add(row);
                rest = list;
            }
            return rest;
        }

        @NotNull
        private List<MvccLinkAwareSearchRow> addRow(@Nullable List<MvccLinkAwareSearchRow> rows, MvccDataRow row) {
            if (rows == null) {
                rows = new ArrayList<MvccLinkAwareSearchRow>();
            }
            rows.add(new MvccLinkAwareSearchRow(row.cacheId(), row.key(), row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter(), row.link()));
            return rows;
        }

        private boolean canClean(MvccDataRow row, MvccSnapshot snapshot, GridCacheContext cctx) throws IgniteCheckedException {
            return MvccUtils.compare(row, snapshot.coordinatorVersion(), snapshot.cleanupVersion()) <= 0 && MvccUtils.hasNewVersion(row) && MvccUtils.compareNewVersion(row, snapshot.coordinatorVersion(), snapshot.cleanupVersion()) <= 0 && MvccUtils.state(cctx, row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter() | row.newMvccTxState() << 30) == 3 || MvccUtils.state(cctx, row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter() | row.mvccTxState() << 30) == 2;
        }

        private boolean actualize(GridCacheContext cctx, MvccDataRow row, MvccSnapshot snapshot) throws IgniteCheckedException {
            return MvccUtils.isVisible(cctx, snapshot, row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter(), false) && (row.mvccTxState() == 0 || row.newMvccCoordinatorVersion() != 0L && row.newMvccTxState() == 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup(GridDhtLocalPartition part, KeyCacheObject key, List<MvccLinkAwareSearchRow> cleanupRows, Object rest, GridCacheContext cctx, VacuumMetrics metrics) throws IgniteCheckedException {
            assert (!(key == null || cctx == null || F.isEmpty(cleanupRows) && rest == null));
            cctx.gate().enter();
            try {
                long cleanupStartNanoTime = System.nanoTime();
                GridCacheEntryEx entry = cctx.cache().entryEx(key);
                while (true) {
                    entry.lockEntry();
                    if (!entry.obsolete()) break;
                    entry.unlockEntry();
                    entry = cctx.cache().entryEx(key);
                }
                int cleaned = 0;
                try {
                    cctx.shared().database().checkpointReadLock();
                    try {
                        if (cleanupRows != null) {
                            cleaned = part.dataStore().cleanup(cctx, cleanupRows);
                        }
                        if (rest != null) {
                            if (rest.getClass() == ArrayList.class) {
                                for (MvccDataRow row : (List)rest) {
                                    part.dataStore().updateTxState(cctx, row);
                                }
                            } else {
                                part.dataStore().updateTxState(cctx, (MvccDataRow)rest);
                            }
                        }
                    }
                    finally {
                        cctx.shared().database().checkpointReadUnlock();
                    }
                }
                finally {
                    entry.unlockEntry();
                    cctx.evicts().touch(entry, AffinityTopologyVersion.NONE);
                    metrics.addCleanupNanoTime(System.nanoTime() - cleanupStartNanoTime);
                    metrics.addCleanupRowsCnt(cleaned);
                }
            }
            finally {
                cctx.gate().leave();
            }
        }
    }

    private static class VacuumScheduler
    extends GridWorker {
        private static final long VACUUM_TIMEOUT = 60000L;
        private final long interval;
        private final MvccProcessorImpl prc;

        VacuumScheduler(GridKernalContext ctx, IgniteLogger log, MvccProcessorImpl prc) {
            super(ctx.igniteInstanceName(), "vacuum-scheduler", log);
            this.interval = ctx.config().getMvccVacuumFrequency();
            this.prc = prc;
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            U.sleep(this.interval);
            while (!this.isCancelled()) {
                long delay;
                long nextScheduledTime = U.currentTimeMillis() + this.interval;
                try {
                    IgniteInternalFuture<VacuumMetrics> fut = this.prc.runVacuum();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Vacuum started by scheduler.");
                    }
                    while (true) {
                        try {
                            fut.get(60000L);
                        }
                        catch (IgniteFutureTimeoutCheckedException e) {
                            U.warn(this.log, "Failed to wait for vacuum complete. Consider increasing vacuum workers count.");
                            continue;
                        }
                        break;
                    }
                }
                catch (IgniteInterruptedCheckedException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    U.error(this.log, "Vacuum error.", e);
                }
                if ((delay = nextScheduledTime - U.currentTimeMillis()) <= 0L) continue;
                U.sleep(delay);
            }
        }
    }

    private static class CompoundWaiterNoLocal
    extends CompoundWaiter {
        private CompoundWaiterNoLocal(Waiter first, Waiter second) {
            super(first, second);
        }

        @Override
        public Waiter concat(Waiter other) {
            return new CompoundWaiterNoLocal((Waiter)this, other);
        }

        @Override
        public boolean hasLocalTransaction() {
            return false;
        }
    }

    private static class CompoundWaiter
    implements Waiter {
        private final Object inner;

        private CompoundWaiter(Waiter waiter) {
            this.inner = waiter.compound() ? ((CompoundWaiter)waiter).inner : waiter;
        }

        private CompoundWaiter(Waiter first, Waiter second) {
            ArrayList<Waiter> list = new ArrayList<Waiter>();
            this.add(list, first);
            this.add(list, second);
            this.inner = list;
        }

        private void add(List<Waiter> to, Waiter waiter) {
            if (!waiter.compound()) {
                to.add(waiter);
            } else if (((CompoundWaiter)waiter).inner.getClass() == ArrayList.class) {
                to.addAll((List)((CompoundWaiter)waiter).inner);
            } else {
                to.add((Waiter)((CompoundWaiter)waiter).inner);
            }
        }

        @Override
        public void run(GridKernalContext ctx) {
            if (this.inner.getClass() == ArrayList.class) {
                for (Waiter waiter : (List)this.inner) {
                    waiter.run(ctx);
                }
            } else {
                ((Waiter)this.inner).run(ctx);
            }
        }

        @Override
        public Waiter concat(Waiter other) {
            return new CompoundWaiter((Waiter)this, other);
        }

        @Override
        public boolean hasLocalTransaction() {
            return true;
        }

        @Override
        public boolean compound() {
            return true;
        }
    }

    private static class LocalTransactionMarker
    implements Waiter {
        private LocalTransactionMarker() {
        }

        @Override
        public void run(GridKernalContext ctx) {
        }

        @Override
        public Waiter concat(Waiter other) {
            return new CompoundWaiter(other);
        }

        @Override
        public boolean hasLocalTransaction() {
            return true;
        }

        @Override
        public boolean compound() {
            return false;
        }
    }

    private static class LockFuture
    extends GridFutureAdapter<Void>
    implements Waiter,
    Runnable {
        private final byte plc;

        LockFuture(byte plc) {
            this.plc = plc;
        }

        @Override
        public void run() {
            this.onDone();
        }

        @Override
        public void run(GridKernalContext ctx) {
            try {
                ctx.pools().poolForPolicy(this.plc).execute(this);
            }
            catch (IgniteCheckedException e) {
                U.error(ctx.log(LockFuture.class), e);
            }
        }

        @Override
        public Waiter concat(Waiter other) {
            return new CompoundWaiterNoLocal(this, other);
        }

        @Override
        public boolean hasLocalTransaction() {
            return false;
        }

        @Override
        public boolean compound() {
            return false;
        }
    }

    private static interface Waiter {
        public void run(GridKernalContext var1);

        public Waiter concat(Waiter var1);

        public boolean hasLocalTransaction();

        public boolean compound();
    }

    private static class RecoveryBallotBox {
        private List<UUID> voters;
        private final Set<UUID> ballots = new HashSet<UUID>();

        private RecoveryBallotBox() {
        }

        private synchronized void voters(List<UUID> voters) {
            this.voters = voters;
        }

        private synchronized void vote(UUID nodeId) {
            this.ballots.add(nodeId);
        }

        private synchronized boolean isVotingDone() {
            if (this.voters == null) {
                return false;
            }
            return this.ballots.containsAll(this.voters);
        }
    }

    private class CoordinatorMessageListener
    implements GridMessageListener {
        private CoordinatorMessageListener() {
        }

        @Override
        public void onMessage(final UUID nodeId, final Object msg, byte plc) {
            MvccMessage msg0 = (MvccMessage)msg;
            if (msg0.waitForCoordinatorInit() && !MvccProcessorImpl.this.initFut.isDone()) {
                MvccProcessorImpl.this.initFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Void> future) {
                        assert (MvccProcessorImpl.this.crdVer != 0L);
                        CoordinatorMessageListener.this.processMessage(nodeId, msg);
                    }
                });
            } else {
                this.processMessage(nodeId, msg);
            }
        }

        private void processMessage(UUID nodeId, Object msg) {
            if (msg instanceof MvccTxSnapshotRequest) {
                MvccProcessorImpl.this.processCoordinatorTxSnapshotRequest(nodeId, (MvccTxSnapshotRequest)msg);
            } else if (msg instanceof MvccAckRequestTx) {
                MvccProcessorImpl.this.processCoordinatorTxAckRequest(nodeId, (MvccAckRequestTx)msg);
            } else if (msg instanceof MvccFutureResponse) {
                MvccProcessorImpl.this.processCoordinatorAckResponse(nodeId, (MvccFutureResponse)msg);
            } else if (msg instanceof MvccAckRequestQueryCntr) {
                MvccProcessorImpl.this.processCoordinatorQueryAckRequest(nodeId, (MvccAckRequestQueryCntr)msg);
            } else if (msg instanceof MvccQuerySnapshotRequest) {
                MvccProcessorImpl.this.processCoordinatorQuerySnapshotRequest(nodeId, (MvccQuerySnapshotRequest)msg);
            } else if (msg instanceof MvccSnapshotResponse) {
                MvccProcessorImpl.this.processCoordinatorSnapshotResponse(nodeId, (MvccSnapshotResponse)msg);
            } else if (msg instanceof MvccWaitTxsRequest) {
                MvccProcessorImpl.this.processCoordinatorWaitTxsRequest(nodeId, (MvccWaitTxsRequest)msg);
            } else if (msg instanceof MvccAckRequestQueryId) {
                MvccProcessorImpl.this.processNewCoordinatorQueryAckRequest(nodeId, (MvccAckRequestQueryId)msg);
            } else if (msg instanceof MvccActiveQueriesMessage) {
                MvccProcessorImpl.this.processCoordinatorActiveQueriesMessage(nodeId, (MvccActiveQueriesMessage)msg);
            } else if (msg instanceof MvccRecoveryFinishedMessage) {
                MvccProcessorImpl.this.processRecoveryFinishedMessage(nodeId, (MvccRecoveryFinishedMessage)msg);
            } else {
                U.warn(MvccProcessorImpl.this.log, "Unexpected message received [node=" + nodeId + ", msg=" + msg + ']');
            }
        }

        public String toString() {
            return "CoordinatorMessageListener[]";
        }
    }

    private class CacheCoordinatorNodeFailListener
    implements GridLocalEventListener {
        private CacheCoordinatorNodeFailListener() {
        }

        @Override
        public void onEvent(Event evt) {
            assert (evt instanceof DiscoveryEvent) : evt;
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            UUID nodeId = discoEvt.eventNode().id();
            Map map = (Map)MvccProcessorImpl.this.snapLsnrs.remove(nodeId);
            if (map != null) {
                ClusterTopologyCheckedException ex = new ClusterTopologyCheckedException("Failed to request mvcc version, coordinator failed: " + nodeId);
                for (Long id : map.keySet()) {
                    MvccSnapshotResponseListener lsnr = (MvccSnapshotResponseListener)map.remove(id);
                    if (lsnr == null) continue;
                    lsnr.onError(ex);
                }
            }
            for (WaitAckFuture fut : MvccProcessorImpl.this.ackFuts.values()) {
                fut.onNodeLeft(nodeId);
            }
            MvccProcessorImpl.this.activeQueries.onNodeFailed(nodeId);
            MvccProcessorImpl.this.prevCrdQueries.onNodeFailed(nodeId);
            MvccProcessorImpl.this.recoveryBallotBoxes.forEach((nearNodeId, ballotBox) -> {
                ((RecoveryBallotBox)ballotBox).vote(nodeId);
                MvccProcessorImpl.this.tryFinishRecoveryVoting(nearNodeId, ballotBox);
            });
            if (discoEvt.eventNode().isClient()) {
                RecoveryBallotBox ballotBox2 = MvccProcessorImpl.this.recoveryBallotBoxes.computeIfAbsent(nodeId, uuid -> new RecoveryBallotBox());
                ballotBox2.voters(discoEvt.topologyNodes().stream().map(ClusterNode::id).collect(Collectors.toList()));
                MvccProcessorImpl.this.tryFinishRecoveryVoting(nodeId, ballotBox2);
            }
        }

        public String toString() {
            return "CacheCoordinatorDiscoveryListener[]";
        }
    }

    private class WaitAckFuture
    extends MvccFuture<Void> {
        private final long id;
        final boolean ackTx;

        WaitAckFuture(long id, UUID nodeId, boolean ackTx) {
            super(nodeId);
            this.id = id;
            this.ackTx = ackTx;
        }

        void onResponse() {
            this.onDone();
        }

        void onNodeLeft(UUID nodeId) {
            if (this.crdId.equals(nodeId) && MvccProcessorImpl.this.ackFuts.remove(this.id) != null) {
                this.onDone();
            }
        }

        @Override
        public String toString() {
            return S.toString(WaitAckFuture.class, this, super.toString());
        }
    }

    private class ActiveQueries {
        private final Map<UUID, TreeMap<Long, AtomicInteger>> activeQueries = new HashMap<UUID, TreeMap<Long, AtomicInteger>>();
        private Long minQry;

        private ActiveQueries() {
        }

        private synchronized long minimalQueryCounter() {
            return this.minQry == null ? -1L : this.minQry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized MvccSnapshotResponse assignQueryCounter(UUID nodeId, long futId) {
            long tracking;
            long ver;
            MvccSnapshotResponse res = new MvccSnapshotResponse();
            MvccProcessorImpl mvccProcessorImpl = MvccProcessorImpl.this;
            synchronized (mvccProcessorImpl) {
                tracking = ver = MvccProcessorImpl.this.committedCntr.get();
                for (Long txVer : MvccProcessorImpl.this.activeTxs.keySet()) {
                    if (txVer >= ver) continue;
                    tracking = Math.min(txVer, tracking);
                    res.addTx(txVer);
                }
            }
            TreeMap<Long, AtomicInteger> nodeMap = this.activeQueries.get(nodeId);
            if (nodeMap == null) {
                nodeMap = new TreeMap();
                this.activeQueries.put(nodeId, nodeMap);
                nodeMap.put(tracking, new AtomicInteger(1));
            } else {
                AtomicInteger cntr = nodeMap.get(tracking);
                if (cntr == null) {
                    nodeMap.put(tracking, new AtomicInteger(1));
                } else {
                    cntr.incrementAndGet();
                }
            }
            if (this.minQry == null) {
                this.minQry = tracking;
            }
            res.init(futId, MvccProcessorImpl.this.crdVer, ver, 0x3FFFFFFF, 0L, tracking);
            return res;
        }

        private synchronized void onQueryDone(UUID nodeId, Long ver) {
            TreeMap<Long, AtomicInteger> nodeMap = this.activeQueries.get(nodeId);
            if (nodeMap == null) {
                return;
            }
            assert (this.minQry != null);
            AtomicInteger cntr = nodeMap.get(ver);
            assert (cntr != null && cntr.get() > 0) : "onQueryDone ver=" + ver;
            if (cntr.decrementAndGet() == 0) {
                nodeMap.remove(ver);
                if (nodeMap.isEmpty()) {
                    this.activeQueries.remove(nodeId);
                }
                if (ver.equals(this.minQry)) {
                    this.minQry = this.activeMinimal();
                }
            }
        }

        private synchronized void onNodeFailed(UUID nodeId) {
            this.activeQueries.remove(nodeId);
            this.minQry = this.activeMinimal();
        }

        private Long activeMinimal() {
            Long min = null;
            for (TreeMap<Long, AtomicInteger> s : this.activeQueries.values()) {
                Long first = s.firstKey();
                if (min != null && first >= min) continue;
                min = first;
            }
            return min;
        }
    }
}

