/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.CompoundLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxSelectForUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearTxAbstractEnlistFuture<T>
extends GridCacheCompoundIdentityFuture<T>
implements GridCacheVersionedFuture<T> {
    private static final AtomicIntegerFieldUpdater<GridNearTxAbstractEnlistFuture> DONE_UPD = AtomicIntegerFieldUpdater.newUpdater(GridNearTxAbstractEnlistFuture.class, "done");
    private static final AtomicReferenceFieldUpdater<GridNearTxAbstractEnlistFuture, Throwable> EX_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxAbstractEnlistFuture.class, Throwable.class, "ex");
    @GridToStringExclude
    protected final GridCacheContext<?, ?> cctx;
    protected final GridNearTxLocal tx;
    protected AffinityTopologyVersion topVer;
    protected MvccSnapshot mvccSnapshot;
    @GridToStringExclude
    protected final IgniteLogger log;
    protected long timeout;
    protected final long threadId;
    protected final IgniteUuid futId;
    protected final GridCacheVersion lockVer;
    @GridToStringExclude
    private GridDhtTxAbstractEnlistFuture localEnlistFuture;
    @GridToStringExclude
    protected volatile Throwable ex;
    @GridToStringExclude
    private volatile int done;
    @GridToStringExclude
    protected LockTimeoutObject timeoutObj;

    public GridNearTxAbstractEnlistFuture(GridCacheContext<?, ?> cctx, GridNearTxLocal tx, long timeout, @Nullable IgniteReducer<T, T> rdc) {
        super(rdc);
        assert (cctx != null);
        assert (tx != null);
        this.cctx = cctx;
        this.tx = tx;
        this.timeout = timeout;
        this.threadId = tx.threadId();
        this.lockVer = tx.xidVersion();
        this.futId = IgniteUuid.randomUuid();
        this.mvccSnapshot = tx.mvccSnapshot();
        assert (this.mvccSnapshot != null);
        this.log = cctx.logger(this.getClass());
    }

    public void init() {
        if (this.timeout < 0L) {
            this.onDone(this.timeoutException());
            return;
        }
        if (this.timeout > 0L) {
            this.timeoutObj = new LockTimeoutObject();
        }
        do {
            IgniteInternalFuture<?> fut;
            if ((fut = this.tx.lockFuture()) == GridDhtTxLocalAdapter.ROLLBACK_FUT) {
                this.onDone(this.tx.timedOut() ? this.tx.timeoutException() : this.tx.rollbackException());
                return;
            }
            if (fut == null) continue;
            assert (fut instanceof GridNearTxAbstractEnlistFuture || fut instanceof GridDhtTxAbstractEnlistFuture || fut instanceof CompoundLockFuture || fut instanceof GridNearTxSelectForUpdateFuture) : fut;
            if (!fut.isDone()) {
                fut.listen(new IgniteInClosure<IgniteInternalFuture>(){

                    @Override
                    public void apply(IgniteInternalFuture fut) {
                        if (fut.error() != null) {
                            GridNearTxAbstractEnlistFuture.this.onDone(fut.error());
                        }
                    }
                });
            } else if (fut.error() != null) {
                this.onDone(fut.error());
            }
            break;
        } while (!this.tx.updateLockFuture(null, this));
        boolean added = this.cctx.mvcc().addFuture(this);
        assert (added) : this;
        if (this.isDone()) {
            this.cctx.mvcc().removeFuture(this.futId);
            return;
        }
        try {
            this.tx.addActiveCache(this.cctx, false);
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
            return;
        }
        if (this.timeoutObj != null) {
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.cctx.mvcc().lastExplicitLockTopologyVersion(threadId);
        if (topVer == null && this.tx.system()) {
            topVer = this.cctx.tm().lockedTopologyVersion(threadId, this.tx);
        }
        if (topVer != null) {
            this.tx.topologyVersion(topVer);
        }
        if (topVer == null) {
            topVer = this.tx.topologyVersionSnapshot();
        }
        if (topVer != null) {
            for (GridDhtTopologyFuture gridDhtTopologyFuture : this.cctx.shared().exchange().exchangeFutures()) {
                if (!gridDhtTopologyFuture.exchangeDone() || !gridDhtTopologyFuture.topologyVersion().equals(topVer)) continue;
                Throwable err = gridDhtTopologyFuture.validateCache(this.cctx, false, false, null, null);
                if (err == null) break;
                this.onDone(err);
                return;
            }
            if (this.topVer == null) {
                this.topVer = topVer;
            }
            this.map(true);
            return;
        }
        this.mapOnTopology();
    }

    protected synchronized void updateMappings(ClusterNode node) throws IgniteCheckedException {
        this.checkCompleted();
        IgniteTxMappings m = this.tx.mappings();
        GridDistributedTxMapping mapping = m.get(node.id());
        if (mapping == null) {
            mapping = new GridDistributedTxMapping(node);
            m.put(mapping);
        }
        mapping.markQueryUpdate();
        if (node.isLocal()) {
            this.tx.colocatedLocallyMapped(true);
        }
    }

    protected synchronized void updateLocalFuture(GridDhtTxAbstractEnlistFuture fut) throws IgniteCheckedException {
        this.checkCompleted();
        assert (this.localEnlistFuture == null);
        this.localEnlistFuture = fut;
    }

    protected synchronized void clearLocalFuture(GridDhtTxAbstractEnlistFuture fut) throws IgniteCheckedException {
        this.checkCompleted();
        if (this.localEnlistFuture == fut) {
            this.localEnlistFuture = null;
        }
    }

    protected void checkCompleted() throws IgniteCheckedException {
        if (this.isDone()) {
            throw new IgniteCheckedException("Future is done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapOnTopology() {
        this.cctx.topology().readLock();
        try {
            if (this.cctx.topology().stopping()) {
                this.onDone(new CacheStoppedException(this.cctx.name()));
                return;
            }
            GridDhtTopologyFuture fut = this.cctx.topologyVersionFuture();
            if (fut.isDone()) {
                Throwable err = fut.validateCache(this.cctx, false, false, null, null);
                if (err != null) {
                    this.onDone(err);
                    return;
                }
                AffinityTopologyVersion topVer = fut.topologyVersion();
                if (this.tx != null) {
                    this.tx.topologyVersion(topVer);
                }
                if (this.topVer == null) {
                    this.topVer = topVer;
                }
                this.map(false);
            } else {
                this.cctx.time().waitAsync(fut, this.tx.remainingTime(), (e, timedOut) -> {
                    try {
                        if (e != null || timedOut.booleanValue()) {
                            this.onDone(timedOut != false ? this.tx.timeoutException() : e);
                        } else {
                            this.mapOnTopology();
                        }
                    }
                    finally {
                        this.cctx.shared().txContextReset();
                    }
                });
            }
        }
        finally {
            if (this.cctx.topology().holdsLock()) {
                this.cctx.topology().readUnlock();
            }
        }
    }

    @Override
    protected boolean processFailure(Throwable err, IgniteInternalFuture<T> fut) {
        if (this.ex != null || !EX_UPD.compareAndSet(this, null, err)) {
            this.ex.addSuppressed(err);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(@Nullable T res, @Nullable Throwable err, boolean cancelled) {
        if (!DONE_UPD.compareAndSet(this, 0, 1)) {
            return false;
        }
        if (this.cctx.topology().holdsLock()) {
            this.cctx.topology().readUnlock();
        }
        this.cctx.tm().txContext(this.tx);
        Throwable ex0 = this.ex;
        if (ex0 != null) {
            if (err != null) {
                ex0.addSuppressed(err);
            }
            err = ex0;
        }
        if (!cancelled && err == null) {
            this.tx.clearLockFuture(this);
        } else {
            this.tx.setRollbackOnly();
        }
        GridNearTxAbstractEnlistFuture gridNearTxAbstractEnlistFuture = this;
        synchronized (gridNearTxAbstractEnlistFuture) {
            boolean done = super.onDone(res, err, cancelled);
            assert (done);
            GridDhtTxAbstractEnlistFuture localFuture0 = this.localEnlistFuture;
            if (localFuture0 != null && (err != null || cancelled)) {
                localFuture0.onDone(cancelled ? new IgniteFutureCancelledCheckedException("Future was cancelled: " + localFuture0) : err);
            }
            this.cctx.mvcc().removeVersionedFuture(this);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
            return true;
        }
    }

    @Override
    protected void logError(IgniteLogger log, String msg, Throwable e) {
    }

    @Override
    protected void logDebug(IgniteLogger log, String msg) {
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    public GridCacheVersion version() {
        return this.lockVer;
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        return false;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    protected long remainingTime() throws IgniteTxTimeoutCheckedException {
        if (this.timeout <= 0L) {
            return 0L;
        }
        long timeLeft = this.timeout - (U.currentTimeMillis() - this.startTime());
        if (timeLeft <= 0L) {
            throw this.timeoutException();
        }
        return timeLeft;
    }

    @NotNull
    protected IgniteTxTimeoutCheckedException timeoutException() {
        return new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.timeout + ", tx=" + this.tx + ']');
    }

    protected abstract void map(boolean var1);

    private class LockTimeoutObject
    extends GridTimeoutObjectAdapter {
        LockTimeoutObject() {
            super(GridNearTxAbstractEnlistFuture.this.timeout);
        }

        @Override
        public void onTimeout() {
            if (GridNearTxAbstractEnlistFuture.this.log.isDebugEnabled()) {
                GridNearTxAbstractEnlistFuture.this.log.debug("Timed out waiting for lock response: " + this);
            }
            GridNearTxAbstractEnlistFuture.this.onDone(GridNearTxAbstractEnlistFuture.this.timeoutException());
        }

        public String toString() {
            return S.toString(LockTimeoutObject.class, this);
        }
    }
}

