/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.typedef.CIX1;

public class AckCoordinatorOnRollback
extends CIX1<IgniteInternalFuture<IgniteInternalTx>> {
    private static final long serialVersionUID = 8172699207968328284L;
    private final GridNearTxLocal tx;

    public AckCoordinatorOnRollback(GridNearTxLocal tx) {
        this.tx = tx;
    }

    @Override
    public void applyx(IgniteInternalFuture<IgniteInternalTx> fut) throws IgniteCheckedException {
        assert (fut.isDone());
        MvccQueryTracker tracker = this.tx.mvccQueryTracker();
        MvccSnapshot mvccSnapshot = this.tx.mvccSnapshot();
        if (tracker != null) {
            tracker.onDone(this.tx, false);
        } else if (mvccSnapshot != null) {
            this.tx.context().coordinators().ackTxRollback(mvccSnapshot);
        }
    }
}

