/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtPartitionSupplyMessage
extends GridCacheGroupIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private long rebalanceId;
    private AffinityTopologyVersion topVer;
    @GridDirectMap(keyType=int.class, valueType=long.class)
    private Map<Integer, Long> last;
    @GridToStringInclude
    @GridDirectCollection(value=int.class)
    private Collection<Integer> missed;
    @GridToStringInclude
    @GridDirectCollection(value=int.class)
    private Collection<Integer> clean;
    @GridDirectMap(keyType=int.class, valueType=CacheEntryInfoCollection.class)
    private Map<Integer, CacheEntryInfoCollection> infos;
    private int msgSize;
    private long estimatedKeysCnt = -1L;
    @GridDirectMap(keyType=int.class, valueType=long.class)
    private Map<Integer, Long> keysPerCache;

    GridDhtPartitionSupplyMessage(long rebalanceId, int grpId, AffinityTopologyVersion topVer, boolean addDepInfo) {
        this.grpId = grpId;
        this.rebalanceId = rebalanceId;
        this.topVer = topVer;
        this.addDepInfo = addDepInfo;
    }

    public GridDhtPartitionSupplyMessage() {
    }

    @Override
    public boolean ignoreClassErrors() {
        return true;
    }

    long rebalanceId() {
        return this.rebalanceId;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    Map<Integer, Long> last() {
        return this.last == null ? Collections.emptyMap() : this.last;
    }

    void last(int p, long cntr) {
        if (this.last == null) {
            this.last = new HashMap<Integer, Long>();
        }
        if (this.last.put(p, cntr) == null) {
            this.msgSize += 12;
            if (!this.infos().containsKey(p)) {
                CacheEntryInfoCollection infoCol = new CacheEntryInfoCollection();
                infoCol.init();
                this.infos().put(p, infoCol);
            }
        }
    }

    void clean(int p) {
        if (this.clean == null) {
            this.clean = new HashSet<Integer>();
        }
        if (this.clean.add(p)) {
            this.msgSize += 4;
        }
    }

    boolean isClean(int p) {
        return this.clean != null && this.clean.contains(p);
    }

    void missed(int p) {
        if (this.missed == null) {
            this.missed = new HashSet<Integer>();
        }
        if (this.missed.add(p)) {
            this.msgSize += 4;
        }
    }

    Collection<Integer> missed() {
        return this.missed == null ? Collections.emptySet() : this.missed;
    }

    Map<Integer, CacheEntryInfoCollection> infos() {
        if (this.infos == null) {
            this.infos = new HashMap<Integer, CacheEntryInfoCollection>();
        }
        return this.infos;
    }

    int messageSize() {
        return this.msgSize;
    }

    void addEntry0(int p, boolean historical, GridCacheEntryInfo info, GridCacheSharedContext ctx, CacheObjectContext cacheObjCtx) throws IgniteCheckedException {
        assert (info != null);
        assert (info.key() != null) : info;
        assert (info.value() != null || historical) : info;
        this.marshalInfo(info, ctx, cacheObjCtx);
        this.msgSize += info.marshalledSize(cacheObjCtx);
        CacheEntryInfoCollection infoCol = this.infos().get(p);
        if (infoCol == null) {
            this.msgSize += 4;
            infoCol = new CacheEntryInfoCollection();
            this.infos().put(p, infoCol);
            infoCol.init();
        }
        infoCol.add(info);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        CacheGroupContext grp = ctx.cache().cacheGroup(this.grpId);
        for (CacheEntryInfoCollection col : this.infos().values()) {
            List<GridCacheEntryInfo> entries = col.infos();
            for (int i = 0; i < entries.size(); ++i) {
                entries.get(i).unmarshal(grp.cacheObjectContext(), ldr);
            }
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    public int size() {
        return this.infos().size();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeCollection("clean", this.clean, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("estimatedKeysCnt", this.estimatedKeysCnt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMap("infos", this.infos, MessageCollectionItemType.INT, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMap("keysPerCache", this.keysPerCache, MessageCollectionItemType.INT, MessageCollectionItemType.LONG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMap("last", this.last, MessageCollectionItemType.INT, MessageCollectionItemType.LONG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeCollection("missed", this.missed, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeInt("msgSize", this.msgSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeLong("updateSeq", this.rebalanceId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.clean = reader.readCollection("clean", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.estimatedKeysCnt = reader.readLong("estimatedKeysCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.infos = reader.readMap("infos", MessageCollectionItemType.INT, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.keysPerCache = reader.readMap("keysPerCache", MessageCollectionItemType.INT, MessageCollectionItemType.LONG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.last = reader.readMap("last", MessageCollectionItemType.INT, MessageCollectionItemType.LONG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.missed = reader.readCollection("missed", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.msgSize = reader.readInt("msgSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.rebalanceId = reader.readLong("updateSeq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionSupplyMessage.class);
    }

    @Override
    public short directType() {
        return 114;
    }

    @Override
    public byte fieldsCount() {
        return 12;
    }

    public long estimatedKeysCount() {
        return -1L;
    }

    public void addEstimatedKeysCount(long cnt) {
        this.estimatedKeysCnt += cnt;
    }

    public long keysForCache(int cacheId) {
        return -1L;
    }

    public void addKeysForCache(int cacheId, long cnt) {
        Long cnt0;
        assert (cacheId != 0 && cnt >= 0L);
        if (this.keysPerCache == null) {
            this.keysPerCache = new HashMap<Integer, Long>();
        }
        if ((cnt0 = this.keysPerCache.get(cacheId)) == null) {
            this.keysPerCache.put(cacheId, cnt);
            this.msgSize += 12;
        } else {
            this.keysPerCache.put(cacheId, cnt0 + cnt);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionSupplyMessage.class, this, "size", (Object)this.size(), "parts", this.infos().keySet(), "super", super.toString());
    }
}

