/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheMappedVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.DhtLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridDhtTxLocal
extends GridDhtTxLocalAdapter
implements GridCacheMappedVersion {
    private static final long serialVersionUID = 0L;
    private UUID nearNodeId;
    private IgniteUuid nearFutId;
    private int nearMiniId;
    private IgniteUuid nearFinFutId;
    private int nearFinMiniId;
    private GridCacheVersion nearXidVer;
    private static final AtomicReferenceFieldUpdater<GridDhtTxLocal, GridDhtTxPrepareFuture> PREP_FUT_UPD = AtomicReferenceFieldUpdater.newUpdater(GridDhtTxLocal.class, GridDhtTxPrepareFuture.class, "prepFut");
    @GridToStringExclude
    private volatile GridDhtTxPrepareFuture prepFut;

    public GridDhtTxLocal() {
    }

    public GridDhtTxLocal(GridCacheSharedContext cctx, AffinityTopologyVersion topVer, UUID nearNodeId, GridCacheVersion nearXidVer, IgniteUuid nearFutId, int nearMiniId, long nearThreadId, boolean implicit, boolean implicitSingle, boolean sys, boolean explicitLock, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean invalidate, boolean storeEnabled, boolean onePhaseCommit, int txSize, Map<UUID, Collection<UUID>> txNodes, UUID subjId, int taskNameHash) {
        super(cctx, cctx.versions().onReceivedAndNext(nearNodeId, nearXidVer), implicit, implicitSingle, sys, explicitLock, plc, concurrency, isolation, timeout, invalidate, storeEnabled, onePhaseCommit, txSize, subjId, taskNameHash);
        assert (nearNodeId != null);
        assert (nearFutId != null);
        assert (nearXidVer != null);
        this.nearNodeId = nearNodeId;
        this.nearXidVer = nearXidVer;
        this.nearFutId = nearFutId;
        this.nearMiniId = nearMiniId;
        this.txNodes = txNodes;
        this.threadId = nearThreadId;
        assert (!F.eq(this.xidVer, nearXidVer));
        this.initResult();
        assert (topVer != null && topVer.topologyVersion() > 0L) : topVer;
        this.topologyVersion(topVer);
    }

    @Override
    public UUID eventNodeId() {
        return this.nearNodeId;
    }

    @Override
    public Collection<UUID> masterNodeIds() {
        assert (this.nearNodeId != null);
        return Collections.singleton(this.nearNodeId);
    }

    @Override
    public UUID otherNodeId() {
        assert (this.nearNodeId != null);
        return this.nearNodeId;
    }

    @Override
    public UUID originatingNodeId() {
        return this.nearNodeId;
    }

    @Override
    protected UUID nearNodeId() {
        return this.nearNodeId;
    }

    @Override
    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    @Override
    public GridCacheVersion mappedVersion() {
        return this.nearXidVer;
    }

    @Override
    protected IgniteUuid nearFutureId() {
        return this.nearFutId;
    }

    public void nearFutureId(IgniteUuid nearFutId) {
        this.nearFutId = nearFutId;
    }

    @Override
    public boolean dht() {
        return true;
    }

    protected boolean updateNearCache(GridCacheContext cacheCtx, KeyCacheObject key, AffinityTopologyVersion topVer) {
        return cacheCtx.isDht() && GridCacheUtils.isNearEnabled(cacheCtx) && !this.cctx.localNodeId().equals(this.nearNodeId());
    }

    public IgniteUuid nearFinishFutureId() {
        return this.nearFinFutId;
    }

    public void nearFinishFutureId(IgniteUuid nearFinFutId) {
        this.nearFinFutId = nearFinFutId;
    }

    public void nearFinishMiniId(int nearFinMiniId) {
        this.nearFinMiniId = nearFinMiniId;
    }

    @Override
    @Nullable
    protected IgniteInternalFuture<Boolean> addReader(long msgId, GridDhtCacheEntry cached, IgniteTxEntry entry, AffinityTopologyVersion topVer) {
        if (entry.addReader() && !this.cctx.localNodeId().equals(this.nearNodeId)) {
            GridCacheContext cacheCtx = cached.context();
            while (true) {
                try {
                    return cached.addReader(this.nearNodeId, msgId, topVer);
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (log.isDebugEnabled()) {
                        log.debug("Got removed entry when adding to DHT local transaction: " + cached);
                    }
                    cached = cacheCtx.dht().entryExx(entry.key(), topVer);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    @Override
    protected void updateExplicitVersion(IgniteTxEntry txEntry, GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
    }

    @Override
    public IgniteInternalFuture<?> salvageTx() {
        this.systemInvalidate(true);
        this.state(TransactionState.PREPARED);
        if (this.state() == TransactionState.PREPARING) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring transaction in PREPARING state as it is currently handled by another thread: " + this);
            }
            return null;
        }
        this.setRollbackOnly();
        return this.rollbackDhtLocalAsync();
    }

    public final IgniteInternalFuture<GridNearTxPrepareResponse> prepareAsync(GridNearTxPrepareRequest req) {
        GridDhtTxPrepareFuture fut = this.prepFut;
        long timeout = this.remainingTime();
        if (fut == null) {
            this.init();
            fut = new GridDhtTxPrepareFuture(this.cctx, this, timeout, req.miniId(), req.dhtVersions(), req.last(), this.needReturnValue());
            if (!PREP_FUT_UPD.compareAndSet(this, null, fut)) {
                GridDhtTxPrepareFuture f = this.prepFut;
                assert (f.nearMiniId() == req.miniId()) : "Wrong near mini id on existing future [futMiniId=" + f.nearMiniId() + ", miniId=" + req.miniId() + ", fut=" + f + ']';
                if (timeout == -1L) {
                    f.onError(this.timeoutException());
                }
                return this.chainOnePhasePrepare(f);
            }
        } else {
            assert (fut.nearMiniId() == req.miniId()) : "Wrong near mini id on existing future [futMiniId=" + fut.nearMiniId() + ", miniId=" + req.miniId() + ", fut=" + fut + ']';
            return this.chainOnePhasePrepare(fut);
        }
        if (this.state() != TransactionState.PREPARING && !this.state(TransactionState.PREPARING)) {
            if (this.state() == TransactionState.PREPARED && this.isSystemInvalidate()) {
                fut.complete();
            }
            if (this.setRollbackOnly()) {
                if (timeout == -1L) {
                    fut.onError(new IgniteTxTimeoutCheckedException("Transaction timed out and was rolled back: " + this));
                } else {
                    fut.onError(new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']'));
                }
            } else {
                fut.onError(new IgniteTxRollbackCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']'));
            }
            return fut;
        }
        try {
            if (req.reads() != null) {
                for (IgniteTxEntry e : req.reads()) {
                    this.addEntry(req.messageId(), e);
                }
            }
            if (req.writes() != null) {
                for (IgniteTxEntry e : req.writes()) {
                    this.addEntry(req.messageId(), e);
                }
            }
            this.userPrepare(null);
            this.cctx.mvcc().addFuture(fut);
            if (this.isSystemInvalidate()) {
                fut.complete();
            } else {
                fut.prepare(req);
            }
        }
        catch (IgniteTxOptimisticCheckedException | IgniteTxRollbackCheckedException | IgniteTxTimeoutCheckedException e) {
            fut.onError(e);
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            fut.onError(new IgniteTxRollbackCheckedException("Failed to prepare transaction: " + CU.txString(this), e));
        }
        return this.chainOnePhasePrepare(fut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTx(boolean commit, @Nullable IgniteInternalFuture prepFut, final GridDhtTxFinishFuture fut) {
        IgniteInternalFuture<?> lockFut;
        assert (prepFut == null || prepFut.isDone());
        boolean primarySync = this.syncMode() == CacheWriteSynchronizationMode.PRIMARY_SYNC;
        IgniteCheckedException err = null;
        if (!commit && (lockFut = this.tryRollbackAsync()) != null) {
            if (lockFut instanceof DhtLockFuture) {
                ((DhtLockFuture)lockFut).onError(this.rollbackException());
            } else if (!lockFut.isDone()) {
                final IgniteInternalFuture finalPrepFut = prepFut;
                lockFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> ignored) {
                        GridDhtTxLocal.this.finishTx(false, finalPrepFut, fut);
                    }
                });
                return;
            }
        }
        if (!commit && prepFut != null) {
            try {
                prepFut.get();
            }
            catch (IgniteCheckedException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to prepare transaction [tx=" + this + ", e=" + e + ']');
                }
            }
            finally {
                prepFut = null;
            }
        }
        try {
            boolean finished;
            if (prepFut != null) {
                prepFut.get();
            }
            if (!(finished = this.localFinish(commit, false))) {
                err = new IgniteCheckedException("Failed to finish transaction [commit=" + commit + ", tx=" + CU.txString(this) + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to finish transaction [commit=" + commit + ", tx=" + this + ']', e);
            err = e;
        }
        catch (Throwable t) {
            fut.onDone(t);
            throw t;
        }
        if (primarySync) {
            this.sendFinishReply(err);
        }
        if (err != null) {
            fut.rollbackOnError(err);
        } else {
            fut.finish(commit);
        }
    }

    public IgniteInternalFuture<IgniteInternalTx> commitDhtLocalAsync() {
        if (log.isDebugEnabled()) {
            log.debug("Committing dht local tx: " + this);
        }
        final GridDhtTxFinishFuture fut = new GridDhtTxFinishFuture(this.cctx, this, true);
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        GridDhtTxPrepareFuture prep = this.prepFut;
        if (prep != null) {
            if (prep.isDone()) {
                this.finishTx(true, prep, fut);
            } else {
                prep.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        GridDhtTxLocal.this.finishTx(true, f, fut);
                    }
                });
            }
        } else {
            assert (this.optimistic());
            this.finishTx(true, null, fut);
        }
        return fut;
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> commitAsync() {
        return this.commitDhtLocalAsync();
    }

    @Override
    protected void clearPrepareFuture(GridDhtTxPrepareFuture fut) {
        assert (this.optimistic());
        PREP_FUT_UPD.compareAndSet(this, fut, null);
    }

    public void rollbackDhtLocal() throws IgniteCheckedException {
        this.rollbackDhtLocalAsync().get();
    }

    public IgniteInternalFuture<IgniteInternalTx> rollbackDhtLocalAsync() {
        final GridDhtTxFinishFuture fut = new GridDhtTxFinishFuture(this.cctx, this, false);
        this.rollbackFuture(fut);
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        GridDhtTxPrepareFuture prepFut = this.prepFut;
        if (prepFut != null) {
            prepFut.complete();
            prepFut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f) {
                    GridDhtTxLocal.this.finishTx(false, f, fut);
                }
            });
        } else {
            this.finishTx(false, null, fut);
        }
        return fut;
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> rollbackAsync() {
        return this.rollbackDhtLocalAsync();
    }

    @Override
    public boolean localFinish(boolean commit, boolean clearThreadMap) throws IgniteCheckedException {
        assert (this.nearFinFutId != null || this.isInvalidate() || !commit || this.isSystemInvalidate() || this.onePhaseCommit() || this.state() == TransactionState.PREPARED) : "Invalid state [nearFinFutId=" + this.nearFinFutId + ", isInvalidate=" + this.isInvalidate() + ", commit=" + commit + ", sysInvalidate=" + this.isSystemInvalidate() + ", state=" + (Object)((Object)this.state()) + ']';
        assert (this.nearMiniId != 0);
        return super.localFinish(commit, clearThreadMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void sendFinishReply(@Nullable Throwable err) {
        if (this.nearFinFutId != null) {
            if (this.nearNodeId.equals(this.cctx.localNodeId())) {
                if (!log.isDebugEnabled()) return;
                log.debug("Skipping response sending to local node: " + this);
                return;
            }
            GridNearTxFinishResponse res = new GridNearTxFinishResponse(-1, this.nearXidVer, this.threadId, this.nearFinFutId, this.nearFinMiniId, err);
            try {
                this.cctx.io().send(this.nearNodeId, (GridCacheMessage)res, this.ioPolicy());
                if (!this.cctx.txFinishMessageLogger().isDebugEnabled()) return;
                this.cctx.txFinishMessageLogger().debug("Sent near finish response [txId=" + this.nearXidVersion() + ", dhtTxId=" + this.xidVersion() + ", node=" + this.nearNodeId + ']');
                return;
            }
            catch (ClusterTopologyCheckedException ignored) {
                if (!this.cctx.txFinishMessageLogger().isDebugEnabled()) return;
                this.cctx.txFinishMessageLogger().debug("Failed to send near finish response, node left [txId=" + this.nearXidVersion() + ", dhtTxId=" + this.xidVersion() + ", node=" + this.nearNodeId() + ']');
                return;
            }
            catch (Throwable ex) {
                U.error(log, "Failed to send finish response to node [txId=" + this.nearXidVersion() + ", txState=" + (Object)((Object)this.state()) + ", dhtTxId=" + this.xidVersion() + ", node=" + this.nearNodeId + ", res=" + res + ']', ex);
                if (!(ex instanceof Error)) return;
                throw (Error)ex;
            }
        } else {
            if (!this.cctx.txFinishMessageLogger().isDebugEnabled()) return;
            this.cctx.txFinishMessageLogger().debug("Will not send finish reply because sender node has not sent finish request yet [txId=" + this.nearXidVersion() + ", dhtTxId=" + this.xidVersion() + ", node=" + this.nearNodeId() + ']');
        }
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> currentPrepareFuture() {
        return this.prepFut;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDhtTxLocal.class, this, "super", super.toString());
    }
}

