/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class ExchangeContext {
    public static final String IGNITE_EXCHANGE_COMPATIBILITY_VER_1 = "IGNITE_EXCHANGE_COMPATIBILITY_VER_1";
    private Set<Integer> requestGrpsAffOnJoin;
    private boolean fetchAffOnJoin;
    private final boolean merge;
    private final ExchangeDiscoveryEvents evts;
    private final boolean compatibilityNode = IgniteSystemProperties.getBoolean("IGNITE_EXCHANGE_COMPATIBILITY_VER_1", false);
    private final boolean newMvccCrd;
    private Map<UUID, GridLongList> activeQueries;

    public ExchangeContext(boolean crd, boolean newMvccCrd, GridDhtPartitionsExchangeFuture fut) {
        this.newMvccCrd = newMvccCrd;
        int protocolVer = GridCachePartitionExchangeManager.exchangeProtocolVersion(fut.firstEventCache().minimumNodeVersion());
        if (this.compatibilityNode || crd && fut.localJoinExchange()) {
            this.fetchAffOnJoin = true;
            this.merge = false;
        } else {
            boolean startCaches = fut.exchangeId().isJoined() && fut.sharedContext().cache().hasCachesReceivedFromJoin(fut.exchangeId().eventNode());
            this.fetchAffOnJoin = protocolVer == 1;
            this.merge = !startCaches && protocolVer > 1 && fut.firstEvent().type() != 18;
        }
        this.evts = new ExchangeDiscoveryEvents(fut);
    }

    boolean supportsMergeExchanges(ClusterNode node) {
        return !this.compatibilityNode && GridCachePartitionExchangeManager.exchangeProtocolVersion(node.version()) > 1;
    }

    public ExchangeDiscoveryEvents events() {
        return this.evts;
    }

    public boolean fetchAffinityOnJoin() {
        return this.fetchAffOnJoin;
    }

    void addGroupAffinityRequestOnJoin(Integer grpId) {
        if (this.requestGrpsAffOnJoin == null) {
            this.requestGrpsAffOnJoin = new HashSet<Integer>();
        }
        this.requestGrpsAffOnJoin.add(grpId);
    }

    @Nullable
    public Set<Integer> groupsAffinityRequestOnJoin() {
        return this.requestGrpsAffOnJoin;
    }

    public boolean mergeExchanges() {
        return this.merge;
    }

    public boolean newMvccCoordinator() {
        return this.newMvccCrd;
    }

    public Map<UUID, GridLongList> activeQueries() {
        return this.activeQueries;
    }

    public void addActiveQueries(UUID nodeId, @Nullable GridLongList nodeQueries) {
        if (nodeQueries == null) {
            return;
        }
        if (this.activeQueries == null) {
            this.activeQueries = new HashMap<UUID, GridLongList>();
        }
        this.activeQueries.put(nodeId, nodeQueries);
    }

    public String toString() {
        return S.toString(ExchangeContext.class, this);
    }
}

