/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageMvccUpdateNewTxStateHintRecord
extends PageDeltaRecord {
    private int itemId;
    private byte txState;

    public DataPageMvccUpdateNewTxStateHintRecord(int grpId, long pageId, int itemId, byte txState) {
        super(grpId, pageId);
        this.itemId = itemId;
        this.txState = txState;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        DataPageIO io = (DataPageIO)PageIO.getPageIO(pageAddr);
        io.updateNewTxState(pageAddr, this.itemId, pageMem.realPageSize(this.groupId()), this.txState);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.MVCC_DATA_PAGE_NEW_TX_STATE_HINT_UPDATED_RECORD;
    }

    public int itemId() {
        return this.itemId;
    }

    public byte txState() {
        return this.txState;
    }

    @Override
    public String toString() {
        return S.toString(DataPageMvccUpdateNewTxStateHintRecord.class, this, "super", super.toString());
    }
}

