/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.client.GridClientCacheFlag;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientData;
import org.apache.ignite.internal.client.GridClientDataAffinity;
import org.apache.ignite.internal.client.GridClientDataMetrics;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientFutureListener;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.impl.GridClientAbstractProjection;
import org.apache.ignite.internal.client.impl.GridClientFutureAdapter;
import org.apache.ignite.internal.client.impl.GridClientImpl;
import org.apache.ignite.internal.client.impl.connection.GridClientConnection;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.util.typedef.internal.A;

public class GridClientDataImpl
extends GridClientAbstractProjection<GridClientDataImpl>
implements GridClientData {
    private final boolean cacheMetrics;
    private String cacheName;
    private volatile GridClientDataMetrics metrics;
    private final Set<GridClientCacheFlag> flags;

    GridClientDataImpl(String cacheName, GridClientImpl client, Collection<GridClientNode> nodes, GridClientPredicate<? super GridClientNode> filter, GridClientLoadBalancer balancer, Set<GridClientCacheFlag> flags, boolean cacheMetrics) {
        super(client, nodes, filter, balancer);
        this.cacheName = cacheName;
        this.cacheMetrics = cacheMetrics;
        this.flags = flags == null ? Collections.emptySet() : Collections.unmodifiableSet(flags);
    }

    @Override
    public String cacheName() {
        return this.cacheName;
    }

    @Override
    public GridClientData pinNodes(GridClientNode node, GridClientNode ... nodes) throws GridClientException {
        ArrayList<GridClientNode> pinnedNodes = new ArrayList<GridClientNode>(nodes != null ? nodes.length + 1 : 1);
        if (node != null) {
            pinnedNodes.add(node);
        }
        if (nodes != null && nodes.length != 0) {
            pinnedNodes.addAll(Arrays.asList(nodes));
        }
        return this.createProjection(pinnedNodes.isEmpty() ? null : pinnedNodes, null, null, new GridClientDataFactory(this.flags));
    }

    @Override
    public Collection<GridClientNode> pinnedNodes() {
        return this.nodes;
    }

    @Override
    public <K, V> boolean put(K key, V val) throws GridClientException {
        return this.putAsync(key, val).get();
    }

    @Override
    public <K, V> GridClientFuture<Boolean> putAsync(final K key, final V val) {
        A.notNull(key, "key");
        A.notNull(val, "val");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cachePut(GridClientDataImpl.this.cacheName, key, val, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K, V> void putAll(Map<K, V> entries) throws GridClientException {
        this.putAllAsync(entries).get();
    }

    @Override
    public <K, V> GridClientFuture<?> putAllAsync(final Map<K, V> entries) {
        A.notNull(entries, "entries");
        if (entries.isEmpty()) {
            return new GridClientFutureAdapter<Boolean>(false);
        }
        K key = GridClientUtils.first(entries.keySet());
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cachePutAll(GridClientDataImpl.this.cacheName, entries, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K, V> V get(K key) throws GridClientException {
        return this.getAsync(key).get();
    }

    @Override
    public <K, V> GridClientFuture<V> getAsync(final K key) {
        A.notNull(key, "key");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<V>(){

            @Override
            public GridClientFuture<V> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheGet(GridClientDataImpl.this.cacheName, key, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K, V> Map<K, V> getAll(Collection<K> keys) throws GridClientException {
        return this.getAllAsync(keys).get();
    }

    @Override
    public <K, V> GridClientFuture<Map<K, V>> getAllAsync(final Collection<K> keys) {
        A.notNull(keys, "keys");
        if (keys.isEmpty()) {
            return new GridClientFutureAdapter(Collections.emptyMap());
        }
        K key = GridClientUtils.first(keys);
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Map<K, V>>(){

            @Override
            public GridClientFuture<Map<K, V>> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheGetAll(GridClientDataImpl.this.cacheName, keys, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K> boolean remove(K key) throws GridClientException {
        return this.removeAsync(key).get();
    }

    @Override
    public <K> GridClientFuture<Boolean> removeAsync(final K key) {
        A.notNull(key, "key");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheRemove(GridClientDataImpl.this.cacheName, key, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K> void removeAll(Collection<K> keys) throws GridClientException {
        this.removeAllAsync(keys).get();
    }

    @Override
    public <K> GridClientFuture<?> removeAllAsync(final Collection<K> keys) {
        A.notNull(keys, "keys");
        if (keys.isEmpty()) {
            return new GridClientFutureAdapter<Boolean>(false);
        }
        K key = GridClientUtils.first(keys);
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheRemoveAll(GridClientDataImpl.this.cacheName, keys, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K, V> boolean replace(K key, V val) throws GridClientException {
        return this.replaceAsync(key, val).get();
    }

    @Override
    public <K, V> GridClientFuture<Boolean> replaceAsync(final K key, final V val) {
        A.notNull(key, "key");
        A.notNull(val, "val");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheReplace(GridClientDataImpl.this.cacheName, key, val, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K, V> boolean cas(K key, V val1, V val2) throws GridClientException {
        return this.casAsync(key, val1, val2).get();
    }

    @Override
    public <K, V> GridClientFuture<Boolean> casAsync(final K key, final V val1, final V val2) {
        A.notNull(key, "key");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheCompareAndSet(GridClientDataImpl.this.cacheName, key, val1, val2, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K> UUID affinity(K key) throws GridClientException {
        A.notNull(key, "key");
        GridClientDataAffinity affinity = this.client.affinity(this.cacheName);
        if (affinity == null) {
            return null;
        }
        Collection prj = this.projectionNodes();
        if (prj.isEmpty()) {
            throw new GridClientException("Failed to get affinity node (projection node set for cache is empty): " + this.cacheName());
        }
        GridClientNode node = affinity.node(key, prj);
        assert (node != null);
        return node.nodeId();
    }

    @Override
    public GridClientDataMetrics metrics() throws GridClientException {
        return this.metricsAsync().get();
    }

    @Override
    public GridClientFuture<GridClientDataMetrics> metricsAsync() {
        GridClientFuture<GridClientDataMetrics> fut = this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<GridClientDataMetrics>(){

            @Override
            public GridClientFuture<GridClientDataMetrics> apply(GridClientConnection conn, UUID affinityNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheMetrics(GridClientDataImpl.this.cacheName, affinityNodeId);
            }
        });
        if (this.cacheMetrics) {
            fut.listen(new GridClientFutureListener<GridClientDataMetrics>(){

                @Override
                public void onDone(GridClientFuture<GridClientDataMetrics> fut) {
                    try {
                        GridClientDataImpl.this.metrics = fut.get();
                    }
                    catch (GridClientException gridClientException) {
                        // empty catch block
                    }
                }
            });
        }
        return fut;
    }

    @Override
    public GridClientDataMetrics cachedMetrics() throws GridClientException {
        return this.metrics;
    }

    @Override
    public <K, V> boolean append(K key, V val) throws GridClientException {
        return this.appendAsync(key, val).get();
    }

    @Override
    public <K, V> GridClientFuture<Boolean> appendAsync(final K key, final V val) throws GridClientException {
        A.notNull(key, "key");
        A.notNull(val, "val");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cacheAppend(GridClientDataImpl.this.cacheName, key, val, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public <K, V> boolean prepend(K key, V val) throws GridClientException {
        return this.prependAsync(key, val).get();
    }

    @Override
    public <K, V> GridClientFuture<Boolean> prependAsync(final K key, final V val) throws GridClientException {
        A.notNull(key, "key");
        A.notNull(val, "val");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<Boolean>(){

            @Override
            public GridClientFuture<Boolean> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.cachePrepend(GridClientDataImpl.this.cacheName, key, val, GridClientDataImpl.this.flags, destNodeId);
            }
        }, this.cacheName, key);
    }

    @Override
    public Set<GridClientCacheFlag> flags() {
        return this.flags;
    }

    @Override
    public GridClientData flagsOn(GridClientCacheFlag ... flags) throws GridClientException {
        if (flags == null || flags.length == 0) {
            return this;
        }
        EnumSet<GridClientCacheFlag> flagSet = this.flags == null || this.flags.isEmpty() ? EnumSet.noneOf(GridClientCacheFlag.class) : EnumSet.copyOf(this.flags);
        flagSet.addAll(Arrays.asList(flags));
        return this.createProjection(this.nodes, this.filter, this.balancer, new GridClientDataFactory(flagSet));
    }

    @Override
    public GridClientData flagsOff(GridClientCacheFlag ... flags) throws GridClientException {
        if (flags == null || flags.length == 0 || this.flags == null || this.flags.isEmpty()) {
            return this;
        }
        EnumSet<GridClientCacheFlag> flagSet = EnumSet.copyOf(this.flags);
        flagSet.removeAll(Arrays.asList(flags));
        return this.createProjection(this.nodes, this.filter, this.balancer, new GridClientDataFactory(flagSet));
    }

    private class GridClientDataFactory
    implements GridClientAbstractProjection.ProjectionFactory<GridClientDataImpl> {
        private Set<GridClientCacheFlag> flags;

        GridClientDataFactory(Set<GridClientCacheFlag> flags) {
            this.flags = flags;
        }

        @Override
        public GridClientDataImpl create(Collection<GridClientNode> nodes, GridClientPredicate<? super GridClientNode> filter, GridClientLoadBalancer balancer) {
            return new GridClientDataImpl(GridClientDataImpl.this.cacheName, GridClientDataImpl.this.client, nodes, filter, balancer, this.flags, GridClientDataImpl.this.cacheMetrics);
        }
    }
}

