/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.util.ArrayList;
import java.util.List;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractPollableSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGeneratorSource
extends AbstractPollableSource
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SequenceGeneratorSource.class);
    private long sequence = 0L;
    private int batchSize;
    private SourceCounter sourceCounter;
    private List<Event> batchArrayList;
    private long totalEvents;
    private long eventsSent = 0L;

    @Override
    protected void doConfigure(Context context) throws FlumeException {
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(1));
        if (this.batchSize > 1) {
            this.batchArrayList = new ArrayList<Event>(this.batchSize);
        }
        this.totalEvents = context.getLong("totalEvents", Long.valueOf(Long.MAX_VALUE));
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @Override
    protected PollableSource.Status doProcess() throws EventDeliveryException {
        PollableSource.Status status = PollableSource.Status.READY;
        int i = 0;
        try {
            if (this.batchSize <= 1) {
                if (this.eventsSent < this.totalEvents) {
                    this.getChannelProcessor().processEvent(EventBuilder.withBody((byte[])String.valueOf(this.sequence++).getBytes()));
                    this.sourceCounter.incrementEventAcceptedCount();
                    ++this.eventsSent;
                } else {
                    status = PollableSource.Status.BACKOFF;
                }
            } else {
                this.batchArrayList.clear();
                for (i = 0; i < this.batchSize; ++i) {
                    if (this.eventsSent < this.totalEvents) {
                        this.batchArrayList.add(i, EventBuilder.withBody((byte[])String.valueOf(this.sequence++).getBytes()));
                        ++this.eventsSent;
                        continue;
                    }
                    status = PollableSource.Status.BACKOFF;
                }
                if (!this.batchArrayList.isEmpty()) {
                    this.getChannelProcessor().processEventBatch(this.batchArrayList);
                    this.sourceCounter.incrementAppendBatchAcceptedCount();
                    this.sourceCounter.addToEventAcceptedCount(this.batchArrayList.size());
                }
            }
        }
        catch (ChannelException ex) {
            this.eventsSent -= (long)i;
            logger.error(this.getName() + " source could not write to channel.", (Throwable)ex);
        }
        return status;
    }

    @Override
    protected void doStart() throws FlumeException {
        logger.info("Sequence generator source do starting");
        this.sourceCounter.start();
        logger.debug("Sequence generator source do started");
    }

    @Override
    protected void doStop() throws FlumeException {
        logger.info("Sequence generator source do stopping");
        this.sourceCounter.stop();
        logger.info("Sequence generator source do stopped. Metrics:{}", (Object)this.getName(), (Object)this.sourceCounter);
    }
}

